/*
 * Decompiled with CFR 0.152.
 */
package to.etc.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.function.FunctionEx;
import to.etc.util.FileTool;
import to.etc.util.WrappedException;

public final class DirectoryInventory
implements Serializable {
    private static final long serialVersionUID = 42328462L;
    private int m_numFiles;
    private int m_numDirectories;
    private long m_totalBytes;
    @Nonnull
    private InvEntry m_root;
    private long m_creationTime;
    private static final Comparator<InvEntry> C_ORDER = new Comparator<InvEntry>(){

        @Override
        public int compare(InvEntry a, InvEntry b) {
            int res = a.getName().compareTo(b.getName());
            if (res != 0) {
                return res;
            }
            return DirectoryInventory.compareArrays(a.getMd5hash(), b.getMd5hash());
        }
    };

    private DirectoryInventory(long currentTimeMillis) {
        this.m_creationTime = currentTimeMillis;
    }

    @Nonnull
    public static DirectoryInventory createEmpty() {
        DirectoryInventory de = new DirectoryInventory(System.currentTimeMillis());
        de.m_root = new InvEntry("", 0, 0L, new byte[16], new InvEntry[0]);
        return de;
    }

    @Nonnull
    public static DirectoryInventory create(@Nonnull File src) throws Exception {
        if (!src.exists()) {
            throw new IOException(src + ": directory does not exist");
        }
        if (!src.isDirectory()) {
            throw new IOException(src + ": is not a directory");
        }
        long ts = System.nanoTime();
        DirectoryInventory de = new DirectoryInventory(System.currentTimeMillis());
        de.m_root = de.scanDirectory(src);
        ts = System.nanoTime() - ts;
        return de;
    }

    public static int compareArrays(@Nonnull byte[] aa, @Nonnull byte[] ba) {
        int ct = Math.min(aa.length, ba.length);
        while (--ct >= 0) {
            int r = aa[ct] - ba[ct];
            if (r == 0) continue;
            return r;
        }
        return aa.length - ba.length;
    }

    @Nonnull
    private InvEntry scanDirectory(@Nonnull File src) throws Exception {
        File[] far = src.listFiles();
        if (null == far) {
            throw new IllegalStateException("No results from " + src);
        }
        ArrayList<InvEntry> list = new ArrayList<InvEntry>(far.length);
        for (File f : far) {
            if (f.isDirectory()) {
                InvEntry ie = this.scanDirectory(f);
                list.add(ie);
                ++this.m_numDirectories;
                continue;
            }
            byte[] hash = FileTool.hashFile(f);
            InvEntry ie = new InvEntry(f.getName(), (int)f.length(), f.lastModified(), hash);
            list.add(ie);
            ++this.m_numFiles;
        }
        InvEntry[] ar = list.toArray(new InvEntry[list.size()]);
        Arrays.sort(ar, C_ORDER);
        MessageDigest dig = MessageDigest.getInstance("md5");
        for (int i = 0; i < ar.length; ++i) {
            InvEntry ie = ar[i];
            dig.update(ie.getName().getBytes("UTF-8"));
            dig.update(ie.getMd5hash());
        }
        byte[] dirhash = dig.digest();
        return new InvEntry(src.getName(), 0, 0L, dirhash, ar);
    }

    @Nonnull
    public static DirectoryInventory load(@Nonnull File src) throws Exception {
        DirectoryInventory directoryInventory;
        if (!src.exists()) {
            throw new FileNotFoundException(src + ": not found");
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(src));
            directoryInventory = (DirectoryInventory)ois.readObject();
        }
        catch (Throwable throwable) {
            FileTool.closeAll(ois);
            throw throwable;
        }
        FileTool.closeAll(ois);
        return directoryInventory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@Nonnull File src) {
        boolean ok = false;
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(src));
            oos.writeObject(this);
            oos.close();
            oos = null;
            ok = true;
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (!ok) {
                    src.delete();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void compareTo(@Nonnull DirectoryInventory other, @Nonnull IDeltaListener listener) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.handleCompare(sb, listener, this.m_root, other.m_root);
    }

    @Nonnull
    public List<DeltaRecord> compareTo(@Nonnull DirectoryInventory other) {
        try {
            final ArrayList<DeltaRecord> result = new ArrayList<DeltaRecord>();
            this.compareTo(other, new IDeltaListener(){

                @Override
                public void fileModified(String path, long srcLastModified, long dstLastModified, byte[] srchash, byte[] dsthash) throws Exception {
                    result.add(new DeltaRecord(DeltaType.fileModified, path));
                }

                @Override
                public void fileDeleted(String path, long lastModified, byte[] md5hash) throws Exception {
                    result.add(new DeltaRecord(DeltaType.fileDeleted, path));
                }

                @Override
                public void fileAdded(String path, long lastModified, byte[] md5hash) throws Exception {
                    result.add(new DeltaRecord(DeltaType.fileAdded, path));
                }

                @Override
                public void directoryDeleted(String path) throws Exception {
                    result.add(new DeltaRecord(DeltaType.directoryDeleted, path));
                }

                @Override
                public void directoryAdded(String path) throws Exception {
                    result.add(new DeltaRecord(DeltaType.directoryAdded, path));
                }
            });
            return result;
        }
        catch (Exception x) {
            throw WrappedException.wrap(x);
        }
    }

    private void handleCompare(@Nonnull StringBuilder sb, @Nonnull IDeltaListener listener, @Nonnull InvEntry src, @Nonnull InvEntry dst) throws Exception {
        if (Arrays.equals(src.getMd5hash(), dst.getMd5hash())) {
            return;
        }
        int len = sb.length();
        if (len > 0) {
            sb.append('/');
            ++len;
        }
        HashMap<String, InvEntry> dstmap = new HashMap<String, InvEntry>();
        for (InvEntry de : dst.getChildren()) {
            dstmap.put(de.getName(), de);
        }
        for (InvEntry se : src.getChildren()) {
            sb.setLength(len);
            sb.append(se.getName());
            String path = sb.toString();
            InvEntry de = (InvEntry)dstmap.remove(se.getName());
            if (null != de) {
                this.compareEntries(sb, se, de, listener);
                continue;
            }
            if (!se.isDirectory()) {
                listener.fileDeleted(path, se.getLastModified(), se.getMd5hash());
                continue;
            }
            this.handleTreeDelete(listener, sb, se.getChildren());
        }
        for (InvEntry ie : dstmap.values()) {
            sb.setLength(len);
            sb.append(ie.getName());
            String path = sb.toString();
            if (ie.isDirectory()) {
                this.handleTreeAdd(listener, sb, ie.getChildren());
                continue;
            }
            listener.fileAdded(path, ie.getLastModified(), ie.getMd5hash());
        }
    }

    private void handleTreeAdd(IDeltaListener listener, StringBuilder sb, InvEntry[] children) throws Exception {
        listener.directoryAdded(sb.toString());
        int len = sb.length();
        if (len > 0) {
            sb.append('/');
            ++len;
        }
        for (InvEntry ie : children) {
            sb.setLength(len);
            sb.append(ie.getName());
            if (ie.isDirectory()) {
                this.handleTreeAdd(listener, sb, ie.getChildren());
                continue;
            }
            listener.fileAdded(sb.toString(), ie.getLastModified(), ie.getMd5hash());
        }
    }

    private void handleTreeDelete(IDeltaListener listener, StringBuilder sb, InvEntry[] children) throws Exception {
        String name = sb.toString();
        int len = sb.length();
        if (len > 0) {
            sb.append('/');
            ++len;
        }
        for (InvEntry ie : children) {
            sb.setLength(len);
            sb.append(ie.getName());
            if (ie.isDirectory()) {
                this.handleTreeDelete(listener, sb, ie.getChildren());
                continue;
            }
            listener.fileDeleted(sb.toString(), ie.getLastModified(), ie.getMd5hash());
        }
        listener.directoryDeleted(name);
    }

    private void compareEntries(@Nonnull StringBuilder sb, @Nonnull InvEntry src, @Nonnull InvEntry dst, @Nonnull IDeltaListener listener) throws Exception {
        if (src.isDirectory() && dst.isDirectory()) {
            this.handleCompare(sb, listener, src, dst);
        } else if (src.isDirectory()) {
            this.handleTreeDelete(listener, sb, src.getChildren());
            listener.fileAdded(sb.toString(), dst.getLastModified(), dst.getMd5hash());
        } else if (dst.isDirectory()) {
            listener.fileDeleted(sb.toString(), src.getLastModified(), src.getMd5hash());
            this.handleTreeAdd(listener, sb, dst.getChildren());
        } else if (!Arrays.equals(src.getMd5hash(), dst.getMd5hash())) {
            listener.fileModified(sb.toString(), src.getLastModified(), dst.getLastModified(), src.getMd5hash(), dst.getMd5hash());
        }
    }

    @Nullable
    public <R> R visit(@Nonnull FunctionEx<InvEntry, R> consumer) throws Exception {
        return this.m_root.visit(consumer);
    }

    public static void main(@Nonnull String[] args) throws Exception {
        DirectoryInventory a = DirectoryInventory.create(new File("/home/jal/bzr/puzzler-split/domui/to.etc.domui/src"));
        DirectoryInventory b = DirectoryInventory.create(new File("/home/jal/bzr/puzzler-split/domui/to.etc.domui/src"));
        List<DeltaRecord> res = a.compareTo(b);
        System.out.println("We have " + res.size() + " changes");
        DirectoryInventory c = DirectoryInventory.create(new File("/home/jal/bzr/domui-form/to.etc.domui/src"));
        res = a.compareTo(c);
        System.out.println("We have " + res.size() + " changes");
        for (DeltaRecord dr : res) {
            System.out.println((Object)((Object)dr.getType()) + ": " + dr.getPath());
        }
    }

    public int getNumFiles() {
        return this.m_numFiles;
    }

    public int getNumDirectories() {
        return this.m_numDirectories;
    }

    public long getCreationTime() {
        return this.m_creationTime;
    }

    public static class DeltaRecord {
        @Nonnull
        private final DeltaType m_type;
        @Nonnull
        private final String m_path;

        public DeltaRecord(@Nonnull DeltaType type, @Nonnull String path) {
            this.m_type = type;
            this.m_path = path;
        }

        @Nonnull
        public DeltaType getType() {
            return this.m_type;
        }

        @Nonnull
        public String getPath() {
            return this.m_path;
        }
    }

    public static enum DeltaType {
        fileDeleted,
        fileAdded,
        fileModified,
        directoryAdded,
        directoryDeleted;

    }

    public static interface IDeltaListener {
        public void fileDeleted(@Nonnull String var1, long var2, @Nonnull byte[] var4) throws Exception;

        public void directoryDeleted(@Nonnull String var1) throws Exception;

        public void directoryAdded(@Nonnull String var1) throws Exception;

        public void fileAdded(@Nonnull String var1, long var2, @Nonnull byte[] var4) throws Exception;

        public void fileModified(@Nonnull String var1, long var2, long var4, @Nonnull byte[] var6, @Nonnull byte[] var7) throws Exception;
    }

    public static final class InvEntry
    implements Serializable {
        private static final long serialVersionUID = 423284312L;
        @Nonnull
        private final String m_name;
        private final long m_lastModified;
        private final int m_size;
        @Nonnull
        private final byte[] m_md5hash;
        @Nullable
        private final InvEntry[] m_children;

        public InvEntry(@Nonnull String name, int size, long lastModified, @Nonnull byte[] md5hash) {
            this.m_name = name;
            this.m_size = size;
            this.m_lastModified = lastModified;
            this.m_md5hash = md5hash;
            this.m_children = null;
        }

        public InvEntry(@Nonnull String name, int size, long lastModified, @Nonnull byte[] md5hash, @Nonnull InvEntry[] children) {
            this.m_name = name;
            this.m_size = size;
            this.m_lastModified = lastModified;
            this.m_md5hash = md5hash;
            this.m_children = children;
        }

        public boolean isDirectory() {
            return null != this.getChildren();
        }

        @Nonnull
        public String getName() {
            return this.m_name;
        }

        public long getLastModified() {
            return this.m_lastModified;
        }

        public int getSize() {
            return this.m_size;
        }

        @Nonnull
        public byte[] getMd5hash() {
            return this.m_md5hash;
        }

        @Nullable
        public InvEntry[] getChildren() {
            return this.m_children;
        }

        @Nullable
        public <R> R visit(@Nonnull FunctionEx<InvEntry, R> consumer) throws Exception {
            R val = consumer.apply(this);
            if (null != val) {
                return val;
            }
            InvEntry[] children = this.m_children;
            if (null != children) {
                for (InvEntry child : children) {
                    val = child.visit(consumer);
                    if (null == val) continue;
                    return val;
                }
            }
            return null;
        }
    }
}

