/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.json.IJsonTypeFactory;
import to.etc.json.ITypeMapping;
import to.etc.json.JsonParseException;
import to.etc.json.JsonReader;
import to.etc.json.JsonTypeRegistry;
import to.etc.json.JsonWriter;

public class JsonBooleanFactory
implements IJsonTypeFactory {
    @Override
    public ITypeMapping createMapper(@Nonnull JsonTypeRegistry registry, @Nonnull Class<?> typeClass, @Nullable Type type) {
        if (typeClass == Boolean.class || typeClass == Boolean.TYPE) {
            return new ITypeMapping(){

                @Override
                public void render(@Nonnull JsonWriter w, @Nonnull Object instance) throws Exception {
                    Boolean n = (Boolean)instance;
                    w.write(n.toString());
                }

                @Override
                public Object parse(@Nonnull JsonReader reader) throws Exception {
                    boolean value;
                    if (reader.getLastToken() == -5) {
                        value = Boolean.parseBoolean(reader.getCopied());
                    } else if (reader.getLastToken() == -3) {
                        value = Long.parseLong(reader.getCopied()) != 0L;
                    } else {
                        throw new JsonParseException(reader, this, "Expecting a boolean value but got " + reader.getTokenString());
                    }
                    reader.nextToken();
                    return value;
                }
            };
        }
        return null;
    }
}

