/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.json.IJsonTypeFactory;
import to.etc.json.ITypeMapping;
import to.etc.json.JsonParseException;
import to.etc.json.JsonReader;
import to.etc.json.JsonTypeRegistry;
import to.etc.json.JsonWriter;

public class JsonIntFactory
implements IJsonTypeFactory {
    @Override
    public ITypeMapping createMapper(@Nonnull JsonTypeRegistry registry, @Nonnull Class<?> typeClass, @Nullable Type type) {
        if (typeClass == Integer.class || typeClass == Integer.TYPE) {
            return new ITypeMapping(){

                @Override
                public void render(@Nonnull JsonWriter w, @Nonnull Object instance) throws Exception {
                    Number n = (Number)instance;
                    w.writeNumber(n);
                }

                @Override
                public Object parse(@Nonnull JsonReader reader) throws Exception {
                    if (reader.getLastToken() != -3) {
                        throw new JsonParseException(reader, this, "Expecting an integer but got " + reader.getTokenString());
                    }
                    Integer res = Integer.decode(reader.getCopied());
                    reader.nextToken();
                    return res;
                }
            };
        }
        return null;
    }
}

