/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.json.IJsonTypeFactory;
import to.etc.json.ITypeMapping;
import to.etc.json.JsonCollectionType;
import to.etc.json.JsonTypeRegistry;
import to.etc.util.ClassUtil;

public class JsonSetFactory
implements IJsonTypeFactory {
    @Override
    public ITypeMapping createMapper(@Nonnull JsonTypeRegistry registry, @Nonnull Class<?> typeClass, @Nullable Type type) {
        if (!Set.class.isAssignableFrom(typeClass) || type == null) {
            return null;
        }
        Class<?> memberType = ClassUtil.findCollectionType(type);
        if (null == memberType || Object.class == memberType) {
            return null;
        }
        int mod = memberType.getModifiers();
        if (Modifier.isAbstract(mod) || Modifier.isInterface(mod) || !Modifier.isPublic(mod)) {
            return null;
        }
        ITypeMapping memberMapping = registry.createMapping(memberType, null);
        if (null == memberMapping) {
            return null;
        }
        Class def = SortedSet.class.isAssignableFrom(typeClass) ? TreeSet.class : HashSet.class;
        return new JsonCollectionType(memberMapping, JsonCollectionType.getImplementationClass(typeClass, def));
    }
}

