/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.json.IJsonTypeFactory;
import to.etc.json.ITypeMapping;
import to.etc.json.JsonParseException;
import to.etc.json.JsonReader;
import to.etc.json.JsonTypeRegistry;
import to.etc.json.JsonWriter;
import to.etc.util.StringTool;

public class JsonStringFactory
implements IJsonTypeFactory {
    @Override
    public ITypeMapping createMapper(@Nonnull JsonTypeRegistry registry, @Nonnull Class<?> typeClass, @Nullable Type type) {
        if (String.class == typeClass) {
            return new ITypeMapping(){

                @Override
                public void render(@Nonnull JsonWriter w, @Nonnull Object instance) throws Exception {
                    w.writeString((String)instance);
                }

                @Override
                public Object parse(@Nonnull JsonReader reader) throws Exception {
                    if (reader.getLastToken() != -2) {
                        throw new JsonParseException(reader, this, "Expecting a string but got " + reader.getTokenString());
                    }
                    String res = StringTool.strUnquote(reader.getCopied());
                    reader.nextToken();
                    return res;
                }
            };
        }
        return null;
    }
}

