/*
 * Decompiled with CFR 0.152.
 */
package to.etc.lexer;

import to.etc.lexer.ReaderScannerBase;

public class SourceLocation {
    private Object m_src;
    private int m_line;
    private int m_col;

    public SourceLocation(Object src, int line, int col) {
        this.m_src = src;
        this.m_line = line;
        this.m_col = col;
    }

    public SourceLocation(ReaderScannerBase rt) {
        this.m_src = rt.getSource();
        this.m_line = rt.getTokenLine();
        this.m_col = rt.getTokenColumn();
    }

    public int getCol() {
        return this.m_col;
    }

    public int getLine() {
        return this.m_line;
    }

    public Object getSrc() {
        return this.m_src;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.m_src != null) {
            sb.append(this.m_src.toString());
            sb.append('(');
        } else {
            sb.append("Line ");
        }
        sb.append(this.m_line);
        if (this.m_col >= 0) {
            sb.append(':');
            sb.append(this.m_col + 1);
        }
        if (this.m_src != null) {
            sb.append(')');
        }
        return sb.toString();
    }
}

