/*
 * Decompiled with CFR 0.152.
 */
package to.etc.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import to.etc.net.HttpCallException;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.xml.DomTools;

public final class NetTools {
    private NetTools() {
    }

    public static void getHostURL(StringBuffer sb, HttpServletRequest req) {
        sb.append(req.getScheme());
        sb.append("://");
        sb.append(NetTools.getHostName(req));
        int port = NetTools.getHostPort(req);
        if (port != 80) {
            sb.append(':');
            sb.append(port);
        }
        sb.append('/');
    }

    public static String getHostURL(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(64);
        NetTools.getHostURL(sb, req);
        return sb.toString();
    }

    public static String getHostName(HttpServletRequest req) {
        String hostname = req.getHeader("Host");
        if (hostname != null) {
            int i = hostname.lastIndexOf(58);
            if (i != -1) {
                hostname = hostname.substring(0, i);
            }
            return hostname;
        }
        hostname = req.getServerName();
        if (hostname == null) {
            throw new IllegalStateException("Unable to get host name from request!?");
        }
        return hostname;
    }

    public static int getHostPort(HttpServletRequest req) {
        int i;
        String hostname = req.getHeader("Host");
        if (hostname != null && (i = hostname.lastIndexOf(58)) != -1) {
            try {
                return Integer.parseInt(hostname.substring(i + 1).trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return req.getServerPort();
    }

    public static String getInputPath(HttpServletRequest req) {
        String rurl = req.getRequestURI();
        int pos = rurl.indexOf("://");
        if (pos != -1) {
            int dp = rurl.indexOf(47, pos + 3);
            if (dp == -1) {
                return "";
            }
            rurl = rurl.substring(dp + 1);
        } else if (rurl.startsWith("/")) {
            rurl = rurl.substring(1);
        }
        return StringTool.decodeURLEncoded(rurl);
    }

    @Nonnull
    public static String getApplicationURL(@Nonnull HttpServletRequest req) {
        String hu = NetTools.getHostURL(req);
        String ctx = req.getContextPath();
        if (ctx.length() == 0) {
            return hu;
        }
        if (ctx.startsWith("/")) {
            return hu + ctx.substring(1) + "/";
        }
        return hu + ctx + "/";
    }

    public static String getApplicationContext(HttpServletRequest req) {
        String s = req.getContextPath();
        if (s == null || s.length() == 0) {
            return "";
        }
        if (s.startsWith("/") && s.endsWith("/")) {
            return s.substring(1, s.length() - 1);
        }
        if (s.startsWith("/")) {
            return s.substring(1);
        }
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static void appendRootRelativeURL(Appendable a, HttpServletRequest req, String rurl) throws IOException {
        String s = req.getContextPath();
        if (s == null || s.length() == 0 || s.equals("/")) {
            a.append('/');
            s = "";
        } else if (s.startsWith("/")) {
            a.append(s);
        } else {
            a.append('/');
            a.append(s);
        }
        if (!s.endsWith("/")) {
            a.append('/');
        }
        if (rurl == null || rurl.length() == 0) {
            return;
        }
        if (rurl.startsWith("/")) {
            a.append(rurl, 1, rurl.length());
        } else {
            a.append(rurl);
        }
    }

    public static String getRootRelativeURL(HttpServletRequest req, String rurl) {
        StringBuilder sb = new StringBuilder();
        try {
            NetTools.appendRootRelativeURL(sb, req, rurl);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document httpGetXMLDocument(String url, int timeout, boolean namespaceaware) throws Exception {
        URL u = new URL(url);
        if (!u.getProtocol().equals("http") && !u.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalStateException("This call can only accept http(s):// connections.");
        }
        HttpURLConnection huc = (HttpURLConnection)u.openConnection();
        InputStream is = null;
        Reader r = null;
        try {
            Document doc;
            huc.setReadTimeout(timeout);
            huc.setAllowUserInteraction(false);
            huc.setDoOutput(false);
            huc.connect();
            int code = huc.getResponseCode();
            if (code != 200) {
                throw NetTools.handleHttpError(url, huc);
            }
            String encoding = huc.getContentEncoding();
            if (encoding == null || encoding.length() == 0) {
                encoding = "UTF-8";
            }
            is = huc.getInputStream();
            r = new InputStreamReader(is, encoding);
            Document document = doc = DomTools.getDocument(r, url, namespaceaware);
            return document;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (huc != null) {
                    huc.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream httpGetStream(String url, int timeout) throws Exception {
        URL u = new URL(url);
        if (!u.getProtocol().equals("http") && !u.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalStateException("This call can only accept http(s):// connections.");
        }
        HttpURLConnection huc = (HttpURLConnection)u.openConnection();
        try {
            huc.setReadTimeout(timeout);
            huc.setAllowUserInteraction(false);
            huc.setDoOutput(false);
            huc.connect();
            int code = huc.getResponseCode();
            if (code != 200) {
                throw NetTools.handleHttpError(url, huc);
            }
            HttpInputStream his = new HttpInputStream(huc, huc.getInputStream(), huc.getContentEncoding());
            huc = null;
            HttpInputStream httpInputStream = his;
            return httpInputStream;
        }
        finally {
            try {
                if (huc != null) {
                    huc.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGetString(String url, int timeout) throws Exception {
        URL u = new URL(url);
        if (!u.getProtocol().equals("http") && !u.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalStateException("This call can only accept http(s):// connections.");
        }
        HttpURLConnection huc = (HttpURLConnection)u.openConnection();
        Reader r = null;
        try {
            String res;
            huc.setReadTimeout(timeout);
            huc.setAllowUserInteraction(false);
            huc.setDoOutput(false);
            huc.connect();
            int code = huc.getResponseCode();
            if (code != 200) {
                throw NetTools.handleHttpError(url, huc);
            }
            String encoding = huc.getContentEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            r = new InputStreamReader(huc.getInputStream(), encoding);
            String string = res = FileTool.readStreamAsString(r);
            return string;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (huc != null) {
                    huc.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static HttpCallException handleHttpError(String url, HttpURLConnection huc) throws Exception {
        HttpCallException hcx = new HttpCallException(url, huc.getResponseCode(), huc.getResponseMessage());
        return hcx;
    }

    public static class HttpInputStream
    extends InputStream {
        private InputStream m_is;
        private String m_encoding;
        private HttpURLConnection m_connection;

        public HttpInputStream(HttpURLConnection conn, InputStream is, String encoding) {
            this.m_is = is;
            this.m_encoding = encoding;
            this.m_connection = conn;
        }

        public String getEncoding() {
            return this.m_encoding;
        }

        @Override
        public int available() throws IOException {
            return this.m_is.available();
        }

        @Override
        public void close() throws IOException {
            this.m_is.close();
            try {
                this.m_connection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void mark(int readlimit) {
            this.m_is.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this.m_is.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.m_is.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.m_is.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.m_is.read(b);
        }

        @Override
        public void reset() throws IOException {
            this.m_is.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.m_is.skip(n);
        }
    }
}

