/*
 * Decompiled with CFR 0.152.
 */
package to.etc.sjit;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import to.etc.sjit.GifHandlerBase;
import to.etc.sjit.GifImaMeta;
import to.etc.sjit.GifIndexedHandler;

public class AnimGifDecoder {
    private InputStream m_is;
    private boolean m_has_header;
    public byte[] m_h_sig;
    public String m_h_version;
    private BufferedImage m_bi;
    public int m_h_lw;
    public int m_h_lh;
    private GifImaMeta m_im;
    private GifHandlerBase m_h;
    private int m_bc = 0;
    private byte[] m_gc_reds;
    private byte[] m_gc_blus;
    private byte[] m_gc_grns;
    public int m_n_gc_colors;
    public boolean m_h_sorted;
    public int m_h_sz_global_ct;
    public boolean m_h_has_global_ct;
    public int m_h_color_res;
    public byte m_h_pxaspect;
    public byte m_h_bgindex;
    private int m_out;
    private int m_initcodesize;
    private byte[] m_block;
    private int m_blocklen;
    private int m_block_ix;
    private int m_32bits;
    private int m_bitpos;
    private boolean m_lastblock;
    private int m_clearcode;
    private int m_eofcode;
    private int m_codesize;
    private int m_codemask;
    private int m_codeend;

    public AnimGifDecoder(InputStream is) {
        this.m_is = is;
    }

    private void readBytes(byte[] ar, int ln) throws IOException {
        if (this.m_is.read(ar, 0, ln) != ln) {
            throw new IOException("Input stream expected more data");
        }
    }

    private void dbg(String s) {
        if (this.m_bc != 0) {
            System.out.println("");
            this.m_bc = 0;
        }
        System.out.println("DBG: " + s);
    }

    private void skipBytes(int sz) throws IOException {
        this.m_is.skip(sz);
    }

    private byte rdByte() throws IOException {
        byte b = (byte)this.m_is.read();
        return b;
    }

    private int rdUByte() throws IOException {
        int v = this.m_is.read() & 0xFF;
        return v;
    }

    private int rdUShort() throws IOException {
        int rv = this.rdByte() & 0xFF;
        return rv |= this.rdByte() << 8 & 0xFF00;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canAccept() throws IOException {
        byte[] ar = new byte[6];
        try {
            this.m_is.mark(10);
            if (this.m_is.read(ar) != 6) {
                boolean bl = false;
                return bl;
            }
            if (ar[0] == 71 && ar[1] == 73 && ar[2] == 70 && ar[3] == 56 && (ar[4] == 55 || ar[4] == 57) && ar[5] == 97) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.m_is.reset();
            }
            catch (Exception exception) {}
        }
    }

    private void readMainHeader() throws IOException {
        if (this.m_has_header) {
            return;
        }
        byte[] ar = new byte[6];
        this.readBytes(ar, 6);
        if (ar[0] != 71 || ar[1] != 73 || ar[2] != 70 || ar[3] != 56 || ar[4] != 55 && ar[4] != 57 || ar[5] != 97) {
            throw new IOException("File not recognised as a GIF image");
        }
        this.m_h_sig = ar;
        StringBuffer sb = new StringBuffer(3);
        sb.append((char)this.m_h_sig[3]);
        sb.append((char)this.m_h_sig[4]);
        sb.append((char)this.m_h_sig[5]);
        this.m_h_version = sb.toString();
        this.m_h_lw = this.rdUShort();
        this.m_h_lh = this.rdUShort();
        byte f = this.rdByte();
        this.m_h_bgindex = this.rdByte();
        this.m_h_pxaspect = this.rdByte();
        this.m_h_has_global_ct = (f & 0x80) != 0;
        this.m_h_color_res = f >> 4 & 7;
        this.m_h_sorted = (f & 8) != 0;
        this.m_h_sz_global_ct = f & 7;
        this.m_n_gc_colors = 2 << this.m_h_sz_global_ct;
        if (this.m_h_has_global_ct) {
            byte[] gct = new byte[this.m_n_gc_colors * 3];
            this.readBytes(gct, this.m_n_gc_colors * 3);
            this.m_gc_reds = new byte[this.m_n_gc_colors];
            this.m_gc_grns = new byte[this.m_n_gc_colors];
            this.m_gc_blus = new byte[this.m_n_gc_colors];
            int j = 0;
            for (int i = 0; i < this.m_n_gc_colors; ++i) {
                this.m_gc_reds[i] = gct[j++];
                this.m_gc_grns[i] = gct[j++];
                this.m_gc_blus[i] = gct[j++];
            }
        }
        this.m_has_header = true;
    }

    private void cleanupRead() {
        this.m_h = null;
    }

    public BufferedImage read(int bufimatype) throws IOException {
        try {
            this.readMainHeader();
            this.readImageMeta();
            this.createHandler(bufimatype);
            this.runDecompressor();
            BufferedImage bufferedImage = this.m_bi;
            return bufferedImage;
        }
        catch (IOException x) {
            this.m_bi = null;
            this.m_im = null;
            throw x;
        }
        finally {
            this.cleanupRead();
        }
    }

    private void createHandler(int bufimatype) throws IOException {
        switch (bufimatype) {
            default: {
                throw new IllegalArgumentException("Unsupported buffered image type");
            }
            case 13: 
        }
        this.m_h = new GifIndexedHandler(this, this.m_im, bufimatype);
        this.m_bi = this.m_h.prepare();
        if (this.m_bi == null) {
            throw new IOException("Unexpected format of recognised BufferedImage type!?");
        }
    }

    private void readImageMeta() throws IOException {
        this.m_im = new GifImaMeta();
        while (true) {
            int blocktype = this.rdUByte();
            switch (blocktype) {
                default: {
                    throw new IOException("AnimGifDecoder: unexpected block type " + Integer.toString(blocktype, 16));
                }
                case 44: {
                    this.readImageDescriptor();
                    return;
                }
                case 33: 
            }
            this.readExtensionBlock();
        }
    }

    private void readImageDescriptor() throws IOException {
        this.m_im.m_bx = this.rdUShort();
        this.m_im.m_by = this.rdUShort();
        this.m_im.m_w = this.rdUShort();
        this.m_im.m_h = this.rdUShort();
        int pf = this.rdUByte();
        this.m_im.m_haslocalcolortable = (pf & 0x80) != 0;
        this.m_im.m_interlaced = (pf & 0x40) != 0;
        this.m_im.m_sorted = (pf & 0x20) != 0;
        this.m_im.m_bits_colortable = pf & 7;
        if (this.m_im.m_haslocalcolortable) {
            int nb = this.m_im.m_bits_colortable + 1;
            this.m_im.m_sz_colortable = 1 << nb;
            byte[] gct = new byte[3 * this.m_im.m_sz_colortable];
            this.readBytes(gct, this.m_im.m_sz_colortable * 3);
            this.m_im.m_reds = new byte[this.m_im.m_sz_colortable];
            this.m_im.m_grns = new byte[this.m_im.m_sz_colortable];
            this.m_im.m_blus = new byte[this.m_im.m_sz_colortable];
            int j = 0;
            for (int i = 0; i < this.m_im.m_sz_colortable; ++i) {
                this.m_im.m_reds[i] = gct[j++];
                this.m_im.m_grns[i] = gct[j++];
                this.m_im.m_blus[i] = gct[j++];
            }
        } else {
            this.m_im.m_sz_colortable = this.m_n_gc_colors;
            this.m_im.m_reds = this.m_gc_reds;
            this.m_im.m_blus = this.m_gc_blus;
            this.m_im.m_grns = this.m_gc_grns;
            this.m_im.m_bits_colortable = this.m_h_sz_global_ct + 1;
        }
    }

    private void readExtensionBlock() throws IOException {
        int len = 0;
        int label = this.rdUByte();
        switch (label) {
            default: {
                this.dbg("Skip unknown extension label=" + Integer.toString(label, 16));
                do {
                    len = this.rdUByte();
                    this.skipBytes(len);
                } while (len > 0);
                return;
            }
            case 249: 
        }
        len = this.rdUByte();
        int pf = this.rdUByte();
        this.m_im.m_disposalmethod = pf >> 2 & 3;
        this.m_im.m_userinputflag = (pf & 2) != 0;
        this.m_im.m_transparant = (pf & 1) != 0;
        this.m_im.m_delaytime = this.rdUShort();
        this.m_im.m_transparant_ix = this.rdUByte();
        this.rdUByte();
    }

    private void pixels(byte[] ar, int len) throws IOException {
        this.m_h.pixels(ar, len);
        this.m_out += len;
    }

    private void imageEof() {
        int x = this.m_im.m_h * this.m_im.m_w;
        if (x == this.m_out) {
            return;
        }
        System.out.println("Total bytes output is " + this.m_out);
        System.out.println("Total bytes expected was " + this.m_im.m_h * this.m_im.m_w);
    }

    private void runDecompressor() throws IOException {
        this.m_out = 0;
        this.m_initcodesize = this.rdUByte();
        this.m_block = new byte[255];
        this.m_blocklen = this.rdUByte();
        this.readBytes(this.m_block, this.m_blocklen);
        this.m_lastblock = false;
        this.m_bitpos = 0;
        this.init32Bits();
        this.m_clearcode = 1 << this.m_initcodesize;
        this.m_eofcode = this.m_clearcode + 1;
        int oldcode = 0;
        int[] prefix = new int[4096];
        byte[] suffix = new byte[4096];
        byte[] initial = new byte[4096];
        int[] length = new int[4096];
        byte[] buf = new byte[4096];
        this.initStringTable(prefix, suffix, initial, length);
        int tableix = (1 << this.m_initcodesize) + 2;
        this.m_codesize = this.m_initcodesize + 1;
        this.m_codeend = 1 << this.m_codesize;
        this.m_codemask = this.m_codeend - 1;
        while (true) {
            int code;
            if ((code = this.getCode()) == this.m_clearcode) {
                this.initStringTable(prefix, suffix, initial, length);
                tableix = (1 << this.m_initcodesize) + 2;
                this.m_codesize = this.m_initcodesize + 1;
                this.m_codeend = 1 << this.m_codesize;
                this.m_codemask = this.m_codeend - 1;
                code = this.getCode();
                if (code == this.m_eofcode) {
                    this.imageEof();
                    return;
                }
            } else {
                int newsufindex;
                if (code == this.m_eofcode) {
                    this.imageEof();
                    return;
                }
                if (code < tableix) {
                    newsufindex = code;
                } else {
                    newsufindex = oldcode;
                    if (code != tableix) {
                        this.dbg("Out-of-sequence code");
                    }
                }
                prefix[tableix] = oldcode;
                suffix[tableix] = initial[newsufindex];
                initial[tableix] = initial[oldcode];
                length[tableix] = length[oldcode] + 1;
                if (++tableix == this.m_codeend && tableix < 4096) {
                    ++this.m_codesize;
                    this.m_codeend = 1 << this.m_codesize;
                    this.m_codemask = this.m_codeend - 1;
                }
            }
            int c = code;
            int len = length[c];
            for (int i = len - 1; i >= 0; --i) {
                buf[i] = suffix[c];
                c = prefix[c];
            }
            this.pixels(buf, len);
            oldcode = code;
        }
    }

    private int getCode() throws IOException {
        if (this.m_bitpos + this.m_codesize > 32) {
            return this.m_eofcode;
        }
        int code = this.m_32bits >> this.m_bitpos & this.m_codemask;
        this.m_bitpos += this.m_codesize;
        while (this.m_bitpos >= 8 && !this.m_lastblock) {
            this.m_32bits >>>= 8;
            this.m_bitpos -= 8;
            if (this.m_block_ix >= this.m_blocklen) {
                this.m_blocklen = this.rdUByte();
                if (this.m_blocklen == 0) {
                    this.m_lastblock = true;
                    return code;
                }
                this.readBytes(this.m_block, this.m_blocklen);
                this.m_block_ix = 0;
            }
            this.m_32bits |= this.m_block[this.m_block_ix++] << 24;
        }
        return code;
    }

    private void initStringTable(int[] prefix, byte[] suffix, byte[] init, int[] length) {
        int i;
        int numentries = 1 << this.m_initcodesize;
        for (i = 0; i < numentries; ++i) {
            prefix[i] = -1;
            suffix[i] = (byte)i;
            init[i] = (byte)i;
            length[i] = 1;
        }
        for (i = numentries; i < 4096; ++i) {
            prefix[i] = -1;
            length[i] = 1;
        }
    }

    private void init32Bits() {
        this.m_32bits = this.m_block[0] & 0xFF;
        this.m_32bits |= (this.m_block[1] & 0xFF) << 8;
        this.m_32bits |= (this.m_block[2] & 0xFF) << 16;
        this.m_32bits |= this.m_block[3] << 24;
        this.m_block_ix = 4;
    }
}

