/*
 * Decompiled with CFR 0.152.
 */
package to.etc.sjit;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import to.etc.sjit.AnIma;
import to.etc.sjit.TooManyColorsException;

public class AnimGifEncoder {
    private boolean m_default_interlace = false;
    private int m_default_delay = 100;
    private boolean m_loop = true;
    private OutputStream m_os;
    private List<AnIma> m_ima_ar;
    private int m_w;
    private int m_h;
    private Canvas m_cv;
    private short m_transparant_ix = (short)-1;
    private short m_color_ix;
    private int m_color_bits;
    public boolean m_no_opt;
    private static final int CHSIZE = 1023;
    private int[] m_ccolor_ar;
    private short[] m_cindex_ar;
    private byte[] m_curr_pixels;
    private int m_px_ix;
    private int m_px_endix;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int m_n_bits;
    int m_maxbits = 12;
    int m_maxcode;
    int m_maxmaxcode = 4096;
    int[] m_htab;
    int[] m_codetab;
    int m_hsize = 5003;
    int m_free_ent = 0;
    boolean m_clear_flg = false;
    int m_g_init_bits;
    int m_clearCode;
    int m_eofCode;
    int cur_accum = 0;
    int cur_bits = 0;
    static int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum;

    public AnimGifEncoder(OutputStream os) {
        this.m_os = os;
    }

    public AnimGifEncoder(OutputStream os, boolean interlace) {
        this.m_os = os;
        this.m_default_interlace = interlace;
    }

    public void setLoop(boolean loop) {
        this.m_loop = loop;
    }

    public void flush() {
        this.m_ccolor_ar = null;
        this.m_cindex_ar = null;
        this.m_cv = null;
        this.m_ima_ar = null;
        this.m_curr_pixels = null;
        this.m_htab = null;
        this.m_codetab = null;
        this.accum = null;
    }

    public void add(Image ima, int delaytime, boolean interlace, int px, int py) throws IOException {
        AnIma ai = new AnIma();
        ai.m_delay = delaytime;
        ai.m_interlace = interlace;
        ai.m_x = px;
        ai.m_y = py;
        if (this.m_ima_ar == null) {
            this.m_ccolor_ar = new int[1023];
            this.m_cindex_ar = new short[1023];
            this.m_ima_ar = new ArrayList<AnIma>(10);
            this.m_cv = new Canvas();
        }
        this.m_ima_ar.add(ai);
        if (!this.m_no_opt) {
            this.preCode(ai, ima);
        } else {
            this.precodeImage(ai, ima);
        }
    }

    public void add(Image ima) throws IOException {
        this.add(ima, this.m_ima_ar == null ? 0 : this.m_default_delay, this.m_default_interlace, 0, 0);
    }

    public void add(Image ima, int delay) throws IOException {
        this.add(ima, delay, this.m_default_interlace, 0, 0);
    }

    private void utStr(String str) throws IOException {
        byte[] buf = str.getBytes();
        this.m_os.write(buf);
    }

    private void utWord(int val) throws IOException {
        this.utByte((byte)(val & 0xFF));
        this.utByte((byte)(val >> 8 & 0xFF));
    }

    private void utByte(byte b) throws IOException {
        this.m_os.write(b);
    }

    public void encode() throws IOException {
        if (this.m_ima_ar == null || this.m_ima_ar.size() == 0) {
            throw new IOException("No images added.");
        }
        this.m_htab = new int[5003];
        this.m_codetab = new int[5003];
        this.accum = new byte[256];
        this.genHeader();
        for (int i = 0; i < this.m_ima_ar.size(); ++i) {
            AnIma ai = this.m_ima_ar.get(i);
            this.genImage(ai);
            ai.m_rgb = null;
        }
        this.genTrailer();
        this.flush();
    }

    private short findColorIndex(int color) throws IOException {
        int i = (color & Integer.MAX_VALUE) % 1023;
        if (this.m_ccolor_ar[i] == color) {
            return this.m_cindex_ar[i];
        }
        if (this.m_ccolor_ar[i] != 0) {
            int disp = 1023 - i;
            if (i == 0) {
                disp = 1;
            }
            do {
                if ((i -= disp) < 0) {
                    i += 1023;
                }
                if (this.m_ccolor_ar[i] != color) continue;
                return this.m_cindex_ar[i];
            } while (this.m_ccolor_ar[i] != 0);
        }
        if (this.m_color_ix >= 256) {
            throw new TooManyColorsException();
        }
        this.m_ccolor_ar[i] = color;
        this.m_cindex_ar[i] = this.m_color_ix;
        short s = this.m_color_ix;
        this.m_color_ix = (short)(s + 1);
        return s;
    }

    private void checkTotalSize(AnIma ai) {
        int t = ai.m_w + ai.m_x;
        if (t > this.m_w) {
            this.m_w = t;
        }
        if ((t = ai.m_h + ai.m_y) > this.m_h) {
            this.m_h = t;
        }
    }

    private void preCode(AnIma ai, Image ima) throws IOException {
        if (ima instanceof BufferedImage) {
            this.precodeBuffered(ai, (BufferedImage)ima);
        } else {
            this.precodeImage(ai, ima);
        }
    }

    private void precodeBuffered(AnIma ai, BufferedImage bi) throws IOException {
        ai.m_w = bi.getWidth();
        ai.m_h = bi.getHeight();
        if (ai.m_h == 0 || ai.m_w == 0) {
            return;
        }
        this.checkTotalSize(ai);
        boolean done = false;
        int bt = bi.getType();
        switch (bt) {
            case 13: {
                done = this.precodeByteIndexed(ai, bi);
                break;
            }
            case 4: {
                done = this.precodeIntPacked(ai, bi);
                break;
            }
            case 2: {
                done = this.precodeIntPacked(ai, bi);
                break;
            }
            case 9: {
                done = this.precodeShortPacked(ai, bi);
                break;
            }
            case 8: {
                done = this.precodeShortPacked(ai, bi);
                break;
            }
            case 1: {
                done = this.precodeIntPacked(ai, bi);
            }
        }
        if (done) {
            return;
        }
        this.precodeImage(ai, bi);
    }

    private int getBiOffset(Raster ras, PixelInterleavedSampleModel sm, int x, int y) {
        return (y - ras.getSampleModelTranslateY()) * sm.getScanlineStride() + x - ras.getSampleModelTranslateX();
    }

    private int getBiOffset(Raster ras, SinglePixelPackedSampleModel sm, int x, int y) {
        return (y - ras.getSampleModelTranslateY()) * sm.getScanlineStride() + x - ras.getSampleModelTranslateX();
    }

    private boolean precodeByteIndexed(AnIma ai, BufferedImage bi) throws IOException {
        ColorModel tcm = bi.getColorModel();
        if (!(tcm instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel cm = (IndexColorModel)tcm;
        WritableRaster ras = bi.getRaster();
        SampleModel tsm = ras.getSampleModel();
        if (!(tsm instanceof PixelInterleavedSampleModel)) {
            return false;
        }
        PixelInterleavedSampleModel sm = (PixelInterleavedSampleModel)tsm;
        DataBuffer dbt = ras.getDataBuffer();
        if (dbt.getDataType() != 0) {
            return false;
        }
        if (dbt.getNumBanks() != 1) {
            return false;
        }
        DataBufferByte db = (DataBufferByte)dbt;
        short[] map = new short[256];
        for (int i = 0; i < 256; ++i) {
            map[i] = -1;
        }
        int endoff = ai.m_w * ai.m_h;
        byte[] par = new byte[endoff];
        int doff = 0;
        byte[] px = db.getData(0);
        int esoff = this.getBiOffset((Raster)ras, sm, ai.m_w - 1, ai.m_h - 1);
        int iw = sm.getScanlineStride();
        for (int soff = this.getBiOffset((Raster)ras, sm, 0, 0); soff < esoff; soff += iw - ai.m_w) {
            int xe = soff + ai.m_w;
            while (soff < xe) {
                int rs = soff;
                byte rcolor = px[soff++];
                while (soff < xe && px[soff] == rcolor) {
                    ++soff;
                }
                short ii = map[rcolor + 128];
                if (ii == -1) {
                    int rix = rcolor & 0xFF;
                    int rgb = cm.getRGB(rix);
                    if (rgb >= 0) {
                        if (this.m_transparant_ix < 0) {
                            if (rgb == 0) {
                                rgb = 1;
                            }
                            this.m_transparant_ix = this.findColorIndex(rgb);
                        }
                        ii = this.m_transparant_ix;
                    } else {
                        ii = this.findColorIndex(rgb);
                    }
                    map[rcolor + 128] = ii;
                }
                int dep = doff + (soff - rs);
                byte idx = (byte)ii;
                while (doff < dep) {
                    par[doff++] = idx;
                }
            }
        }
        ai.m_rgb = par;
        return true;
    }

    private boolean precodeIntPacked(AnIma ai, BufferedImage bi) throws IOException {
        ColorModel cm = bi.getColorModel();
        WritableRaster ras = bi.getRaster();
        SampleModel tsm = ras.getSampleModel();
        if (!(tsm instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)tsm;
        DataBuffer dbt = ras.getDataBuffer();
        if (dbt.getDataType() != 3) {
            return false;
        }
        if (dbt.getNumBanks() != 1) {
            return false;
        }
        DataBufferInt db = (DataBufferInt)dbt;
        int endoff = ai.m_w * ai.m_h;
        byte[] par = new byte[endoff];
        int doff = 0;
        int[] px = db.getData(0);
        int esoff = this.getBiOffset((Raster)ras, sm, ai.m_w - 1, ai.m_h - 1);
        int iw = sm.getScanlineStride();
        for (int soff = this.getBiOffset((Raster)ras, sm, 0, 0); soff < esoff; soff += iw - ai.m_w) {
            int xe = soff + ai.m_w;
            while (soff < xe) {
                byte ii;
                int rs = soff;
                int rcolor = px[soff++];
                while (soff < xe && px[soff] == rcolor) {
                    ++soff;
                }
                int rgb = cm.getRGB(rcolor);
                if (rgb >= 0) {
                    if (this.m_transparant_ix < 0) {
                        if (rgb == 0) {
                            rgb = 1;
                        }
                        this.m_transparant_ix = this.findColorIndex(rgb);
                    }
                    ii = (byte)this.m_transparant_ix;
                } else {
                    ii = (byte)this.findColorIndex(rgb);
                }
                int dep = doff + (soff - rs);
                while (doff < dep) {
                    par[doff++] = ii;
                }
            }
        }
        ai.m_rgb = par;
        return true;
    }

    private boolean precodeShortPacked(AnIma ai, BufferedImage bi) throws IOException {
        ColorModel cm = bi.getColorModel();
        WritableRaster ras = bi.getRaster();
        SampleModel tsm = ras.getSampleModel();
        if (!(tsm instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)tsm;
        DataBuffer dbt = ras.getDataBuffer();
        if (dbt.getDataType() != 2) {
            return false;
        }
        if (dbt.getNumBanks() != 1) {
            return false;
        }
        DataBufferShort db = (DataBufferShort)dbt;
        int endoff = ai.m_w * ai.m_h;
        byte[] par = new byte[endoff];
        int doff = 0;
        short[] px = db.getData(0);
        int esoff = this.getBiOffset((Raster)ras, sm, ai.m_w - 1, ai.m_h - 1);
        int iw = sm.getScanlineStride();
        for (int soff = this.getBiOffset((Raster)ras, sm, 0, 0); soff < esoff; soff += iw - ai.m_w) {
            int xe = soff + ai.m_w;
            while (soff < xe) {
                byte ii;
                int rs = soff;
                short rcolor = px[soff++];
                while (soff < xe && px[soff] == rcolor) {
                    ++soff;
                }
                int rgb = cm.getRGB(rcolor);
                if (rgb >= 0) {
                    if (this.m_transparant_ix < 0) {
                        if (rgb == 0) {
                            rgb = 1;
                        }
                        this.m_transparant_ix = this.findColorIndex(rgb);
                    }
                    ii = (byte)this.m_transparant_ix;
                } else {
                    ii = (byte)this.findColorIndex(rgb);
                }
                int dep = doff + (soff - rs);
                while (doff < dep) {
                    par[doff++] = ii;
                }
            }
        }
        ai.m_rgb = par;
        return true;
    }

    private void precodeImage(AnIma ai, Image ima) throws IOException {
        MediaTracker mt = new MediaTracker(this.m_cv);
        mt.addImage(ima, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException x) {
            throw new IOException("Interrupted load of image");
        }
        mt.removeImage(ima, 0);
        mt = null;
        ai.m_w = ima.getWidth(this.m_cv);
        ai.m_h = ima.getHeight(this.m_cv);
        if (ai.m_h == 0 || ai.m_w == 0) {
            return;
        }
        this.checkTotalSize(ai);
        PixelGrabber pg = new PixelGrabber(ima, 0, 0, ai.m_w, ai.m_h, true);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException x) {
            throw new IOException("Interrupted load of image");
        }
        int[] px = (int[])pg.getPixels();
        if (px == null) {
            System.out.println("???? NULLED???");
        }
        this.translateColorsByArray(ai, px);
    }

    private void translateColorsByArray(AnIma a, int[] px) throws IOException {
        int endoff = a.m_w * a.m_h;
        byte[] par = new byte[endoff];
        int off = 0;
        while (off < endoff) {
            byte newc;
            int rstart = off;
            int rcolor = px[off++];
            while (off < endoff && px[off] == rcolor) {
                ++off;
            }
            if (rcolor >= 0) {
                if (this.m_transparant_ix < 0) {
                    if (rcolor == 0) {
                        rcolor = 1;
                    }
                    this.m_transparant_ix = this.findColorIndex(rcolor);
                }
                newc = (byte)this.m_transparant_ix;
            } else {
                int i = (rcolor & Integer.MAX_VALUE) % 1023;
                newc = this.m_ccolor_ar[i] == rcolor ? (byte)this.m_cindex_ar[i] : (byte)this.findColorIndex(rcolor);
            }
            while (rstart < off) {
                par[rstart++] = newc;
            }
        }
        a.m_rgb = par;
    }

    private void genColorTable() throws IOException {
        int nelem = 1 << this.m_color_bits;
        byte[] reds = new byte[nelem];
        byte[] grns = new byte[nelem];
        byte[] blus = new byte[nelem];
        int i = 1023;
        while (--i >= 0) {
            if (this.m_ccolor_ar[i] == 0) continue;
            reds[this.m_cindex_ar[i]] = (byte)(this.m_ccolor_ar[i] >> 16 & 0xFF);
            grns[this.m_cindex_ar[i]] = (byte)(this.m_ccolor_ar[i] >> 8 & 0xFF);
            blus[this.m_cindex_ar[i]] = (byte)(this.m_ccolor_ar[i] & 0xFF);
        }
        for (i = 0; i < nelem; ++i) {
            this.utByte(reds[i]);
            this.utByte(grns[i]);
            this.utByte(blus[i]);
        }
    }

    private void genHeader() throws IOException {
        this.m_color_bits = this.m_color_ix <= 2 ? 1 : (this.m_color_ix <= 4 ? 2 : (this.m_color_ix <= 8 ? 3 : (this.m_color_ix <= 16 ? 4 : 8)));
        this.utStr("GIF89a");
        this.utWord(this.m_w);
        this.utWord(this.m_h);
        byte b = (byte)(0xF0 | this.m_color_bits - 1);
        this.utByte(b);
        this.utByte((byte)0);
        this.utByte((byte)0);
        this.genColorTable();
        if (this.m_loop && this.m_ima_ar.size() > 1) {
            this.utByte((byte)33);
            this.utByte((byte)-1);
            this.utByte((byte)11);
            this.utStr("NETSCAPE2.0");
            this.utByte((byte)3);
            this.utByte((byte)1);
            this.utWord(0);
            this.utByte((byte)0);
        }
    }

    private void genTrailer() throws IOException {
        this.utByte((byte)59);
    }

    private void genImage(AnIma ai) throws IOException {
        if (this.m_transparant_ix != -1 || this.m_ima_ar.size() > 1) {
            byte transpar;
            this.utByte((byte)33);
            this.utByte((byte)-7);
            this.utByte((byte)4);
            if (this.m_transparant_ix >= 0) {
                this.utByte((byte)1);
                transpar = (byte)this.m_transparant_ix;
            } else {
                this.utByte((byte)0);
                transpar = 0;
            }
            this.utWord(ai.m_delay);
            this.utByte(transpar);
            this.utByte((byte)0);
        }
        this.utByte((byte)44);
        this.utWord(ai.m_x);
        this.utWord(ai.m_y);
        this.utWord(ai.m_w);
        this.utWord(ai.m_h);
        this.utByte((byte)(ai.m_interlace ? 64 : 0));
        int initcodesz = this.m_color_bits <= 1 ? 2 : this.m_color_bits;
        this.utByte((byte)initcodesz);
        this.genCompressed(ai, initcodesz + 1);
        this.utByte((byte)0);
    }

    private void genCompressed(AnIma a, int initcodesz) throws IOException {
        int fcode;
        this.m_curr_pixels = a.m_rgb;
        this.m_px_ix = 0;
        this.m_px_endix = a.m_w * a.m_h;
        this.cur_accum = 0;
        this.cur_bits = 0;
        this.m_free_ent = 0;
        this.m_clear_flg = false;
        this.m_maxbits = 12;
        this.m_maxmaxcode = 4096;
        this.a_count = 0;
        this.m_g_init_bits = initcodesz;
        this.m_clear_flg = false;
        this.m_n_bits = this.m_g_init_bits;
        this.m_maxcode = this.MAXCODE(this.m_n_bits);
        this.m_clearCode = 1 << initcodesz - 1;
        this.m_eofCode = this.m_clearCode + 1;
        this.m_free_ent = this.m_clearCode + 2;
        this.char_init();
        int hshift = 0;
        for (fcode = this.m_hsize; fcode < 65536; fcode *= 2) {
            ++hshift;
        }
        hshift = 8 - hshift;
        int hsize_reg = this.m_hsize;
        this.cl_hash(hsize_reg);
        this.output(this.m_clearCode);
        int ent = this.m_curr_pixels[this.m_px_ix++];
        block1: while (this.m_px_ix < this.m_px_endix) {
            int c = this.m_curr_pixels[this.m_px_ix++] & 0xFF;
            fcode = (c << this.m_maxbits) + ent;
            int i = c << hshift ^ ent;
            if (i >= this.m_htab.length || i < 0) {
                System.out.println("SHIT!");
            }
            if (this.m_htab[i] == fcode) {
                ent = this.m_codetab[i];
                continue;
            }
            if (this.m_htab[i] >= 0) {
                int disp = hsize_reg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsize_reg;
                    }
                    if (this.m_htab[i] != fcode) continue;
                    ent = this.m_codetab[i];
                    continue block1;
                } while (this.m_htab[i] >= 0);
            }
            this.output(ent);
            ent = c;
            if (this.m_free_ent < this.m_maxmaxcode) {
                ++this.m_free_ent;
                this.m_htab[i] = fcode;
                continue;
            }
            this.cl_block();
        }
        this.output(ent);
        this.outputEOF();
    }

    final int MAXCODE(int n_bits) {
        return (1 << n_bits) - 1;
    }

    void output(int code) throws IOException {
        this.cur_accum |= code << this.cur_bits;
        this.cur_bits += this.m_n_bits;
        while (this.cur_bits >= 8) {
            this.accum[this.a_count++] = (byte)this.cur_accum;
            if (this.a_count >= 254) {
                this.flush_char();
            }
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.m_clear_flg) {
            this.m_n_bits = this.m_g_init_bits;
            this.m_maxcode = this.MAXCODE(this.m_n_bits);
            this.m_clear_flg = false;
        } else if (this.m_free_ent > this.m_maxcode) {
            ++this.m_n_bits;
            this.m_maxcode = this.m_n_bits == this.m_maxbits ? this.m_maxmaxcode : this.MAXCODE(this.m_n_bits);
        }
    }

    private void outputEOF() throws IOException {
        this.output(this.m_eofCode);
        while (this.cur_bits > 0) {
            this.accum[this.a_count++] = (byte)this.cur_accum;
            if (this.a_count >= 254) {
                this.flush_char();
            }
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        this.flush_char();
    }

    void cl_block() throws IOException {
        this.cl_hash(this.m_hsize);
        this.m_free_ent = this.m_clearCode + 2;
        this.m_clear_flg = true;
        this.output(this.m_clearCode);
    }

    void cl_hash(int hsize) {
        int i = hsize;
        while (--i >= 0) {
            this.m_htab[i] = -1;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte c) throws IOException {
        this.accum[this.a_count++] = c;
        if (this.a_count >= 254) {
            this.flush_char();
        }
    }

    void flush_char() throws IOException {
        if (this.a_count > 0) {
            this.m_os.write(this.a_count);
            this.m_os.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

