/*
 * Decompiled with CFR 0.152.
 */
package to.etc.sjit;

import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import to.etc.sjit.ContribList;
import to.etc.sjit.ImaTool;
import to.etc.sjit.ResamplerFilter;

public class ImageSubsampler {
    private static final int IMAT = 1;

    private ImageSubsampler() {
    }

    private static int getBiOffset(Raster ras, SinglePixelPackedSampleModel sm, int x, int y) {
        return (y - ras.getSampleModelTranslateY()) * sm.getScanlineStride() + x - ras.getSampleModelTranslateX();
    }

    private static ContribList[] getRowContrib(ResamplerFilter f, int sw, int ow) {
        float fwidth = f.getWidth();
        float xscale = (float)(ow - 1) / (float)(sw - 1);
        ContribList[] contrib = new ContribList[ow];
        if (xscale < 1.0f) {
            float width = fwidth / xscale;
            float fscale = 1.0f / xscale;
            for (int i = 0; i < ow; ++i) {
                ContribList cl;
                contrib[i] = cl = new ContribList((int)(width * 2.0f + 1.0f));
                float center = (float)i / xscale;
                int left = (int)Math.floor(center - width);
                int right = (int)Math.ceil(center + width);
                for (int j = left; j <= right; ++j) {
                    float weight = f.filter((center - (float)j) / fscale) / fscale;
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= sw ? sw - j + sw - 1 : j);
                    ++cl.m_n;
                    cl.m_ar[k].m_pixel = n;
                    cl.m_ar[k].m_weight = weight;
                }
            }
        } else {
            for (int i = 0; i < ow; ++i) {
                ContribList cl;
                contrib[i] = cl = new ContribList((int)(fwidth * 2.0f + 1.0f));
                float center = (float)i / xscale;
                int left = (int)Math.floor(center - fwidth);
                int right = (int)Math.ceil(center + fwidth);
                for (int j = left; j <= right; ++j) {
                    float weight = f.filter(center - (float)j);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= sw ? sw - j + sw - 1 : j);
                    ++cl.m_n;
                    cl.m_ar[k].m_pixel = n;
                    cl.m_ar[k].m_weight = weight;
                }
            }
        }
        return contrib;
    }

    private static ContribList[] getColContrib(ResamplerFilter f, int sh, int oh) {
        float fwidth = f.getWidth();
        float yscale = (float)(oh - 1) / (float)(sh - 1);
        ContribList[] contrib = new ContribList[oh];
        if (yscale < 1.0f) {
            float fscale = 1.0f / yscale;
            float width = fwidth / yscale;
            for (int i = 0; i < oh; ++i) {
                ContribList cl;
                contrib[i] = cl = new ContribList((int)((double)width * 2.0 + 1.0));
                float center = (float)i / yscale;
                int loy = (int)Math.floor(center - width);
                int hiy = (int)Math.ceil(center + width);
                for (int j = loy; j <= hiy; ++j) {
                    float weight = f.filter((center - (float)j) / fscale) / fscale;
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= sh ? sh - j + sh - 1 : j);
                    ++cl.m_n;
                    cl.m_ar[k].m_pixel = n;
                    cl.m_ar[k].m_weight = weight;
                }
            }
        } else {
            for (int i = 0; i < oh; ++i) {
                ContribList cl;
                contrib[i] = cl = new ContribList((int)((double)fwidth * 2.0 + 1.0));
                float center = (float)i / yscale;
                int loy = (int)Math.floor(center - fwidth);
                int hiy = (int)Math.ceil(center + fwidth);
                for (int j = loy; j <= hiy; ++j) {
                    float weight = f.filter(center - (float)j);
                    if (weight == 0.0f) continue;
                    int n = j < 0 ? -j : (j >= sh ? sh - j + sh - 1 : j);
                    ++cl.m_n;
                    cl.m_ar[k].m_pixel = n;
                    cl.m_ar[k].m_weight = weight;
                }
            }
        }
        return contrib;
    }

    private static BufferedImage resampleRowRGB(BufferedImage srci, ContribList[] contrib, int sw, int sh, int ow, int oh) {
        WritableRaster sras = srci.getRaster();
        SampleModel stsm = sras.getSampleModel();
        if (!(stsm instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalStateException("?? TYPE_INT_RGB doesn't have SinglePixelPackedSampleModel??");
        }
        SinglePixelPackedSampleModel ssm = (SinglePixelPackedSampleModel)stsm;
        DataBuffer sdbt = sras.getDataBuffer();
        if (sdbt.getDataType() != 3) {
            throw new IllegalStateException("?? TYPE_INT_RGB doesn't have TYPE_INT databuffer!?");
        }
        if (sdbt.getNumBanks() != 1) {
            throw new IllegalStateException("?? TYPE_INT_RGB having != 1 banks!?");
        }
        DataBufferInt sdb = (DataBufferInt)sdbt;
        BufferedImage worki = new BufferedImage(ow, sh, 1);
        WritableRaster dras = worki.getRaster();
        SampleModel dtsm = dras.getSampleModel();
        if (!(dtsm instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalStateException("?? TYPE_INT_RGB doesn't have SinglePixelPackedSampleModel??");
        }
        SinglePixelPackedSampleModel dsm = (SinglePixelPackedSampleModel)dtsm;
        DataBuffer ddbt = dras.getDataBuffer();
        if (ddbt.getDataType() != 3) {
            throw new IllegalStateException("?? TYPE_INT_RGB doesn't have TYPE_INT databuffer!?");
        }
        if (ddbt.getNumBanks() != 1) {
            throw new IllegalStateException("?? TYPE_INT_RGB having != 1 banks!?");
        }
        DataBufferInt ddb = (DataBufferInt)ddbt;
        int soff = ImageSubsampler.getBiOffset(sras, ssm, 0, 0);
        int[] spx = sdb.getData(0);
        int sofe = ImageSubsampler.getBiOffset(sras, ssm, sw - 1, sh - 1);
        int siw = ssm.getScanlineStride();
        int doff = ImageSubsampler.getBiOffset(dras, dsm, 0, 0);
        int[] dpx = ddb.getData(0);
        int diw = dsm.getScanlineStride();
        while (soff <= sofe) {
            for (int i = 0; i < ow; ++i) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                ContribList cl = contrib[i];
                for (int j = 0; j < cl.m_n; ++j) {
                    int argb = spx[soff + cl.m_ar[j].m_pixel];
                    float weight = cl.m_ar[j].m_weight;
                    if (weight == 0.0f) continue;
                    r += weight * (float)(argb >> 16 & 0xFF);
                    g += weight * (float)(argb >> 8 & 0xFF);
                    b += weight * (float)(argb & 0xFF);
                }
                int br = r > 255.0f ? 255 : (r < 0.0f ? 0 : (int)r);
                int bg = g > 255.0f ? 255 : (g < 0.0f ? 0 : (int)g);
                int bb = b > 255.0f ? 255 : (b < 0.0f ? 0 : (int)b);
                dpx[doff++] = br << 16 | bg << 8 | bb;
            }
            soff += siw;
            doff += diw - ow;
        }
        return worki;
    }

    private static BufferedImage resampleRowGeneric(BufferedImage srci, ContribList[] contrib, int sw, int sh, int ow, int oh) {
        BufferedImage worki = new BufferedImage(ow, sh, 2);
        for (int k = 0; k < sh; ++k) {
            for (int i = 0; i < ow; ++i) {
                float a = 0.0f;
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                ContribList cl = contrib[i];
                for (int j = 0; j < cl.m_n; ++j) {
                    int argb = srci.getRGB(cl.m_ar[j].m_pixel, k);
                    float weight = cl.m_ar[j].m_weight;
                    if (weight == 0.0f) continue;
                    r += weight * (float)(argb >> 16 & 0xFF);
                    g += weight * (float)(argb >> 8 & 0xFF);
                    b += weight * (float)(argb & 0xFF);
                    a += weight * (float)(argb >> 24 & 0xFF);
                }
                int ba = a > 255.0f ? 255 : (a < 0.0f ? 0 : (int)a);
                int br = r > 255.0f ? 255 : (r < 0.0f ? 0 : (int)r);
                int bg = g > 255.0f ? 255 : (g < 0.0f ? 0 : (int)g);
                int bb = b > 255.0f ? 255 : (b < 0.0f ? 0 : (int)b);
                worki.setRGB(i, k, ba << 24 | br << 16 | bg << 8 | bb);
            }
        }
        return worki;
    }

    private static BufferedImage resampleColRGB(BufferedImage srci, ContribList[] contrib, int sw, int sh, int ow, int oh) {
        WritableRaster sras = srci.getRaster();
        SampleModel stsm = sras.getSampleModel();
        if (!(stsm instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalStateException("?? TYPE_INT_RGB doesn't have SinglePixelPackedSampleModel??");
        }
        SinglePixelPackedSampleModel ssm = (SinglePixelPackedSampleModel)stsm;
        DataBuffer sdbt = sras.getDataBuffer();
        if (sdbt.getDataType() != 3) {
            throw new IllegalStateException("?? TYPE_INT_RGB doesn't have TYPE_INT databuffer!?");
        }
        if (sdbt.getNumBanks() != 1) {
            throw new IllegalStateException("?? TYPE_INT_RGB having != 1 banks!?");
        }
        DataBufferInt sdb = (DataBufferInt)sdbt;
        BufferedImage worki = new BufferedImage(ow, oh, 1);
        WritableRaster dras = worki.getRaster();
        SampleModel dtsm = dras.getSampleModel();
        if (!(dtsm instanceof SinglePixelPackedSampleModel)) {
            throw new IllegalStateException("?? TYPE_INT_RGB doesn't have SinglePixelPackedSampleModel??");
        }
        SinglePixelPackedSampleModel dsm = (SinglePixelPackedSampleModel)dtsm;
        DataBuffer ddbt = dras.getDataBuffer();
        if (ddbt.getDataType() != 3) {
            throw new IllegalStateException("?? TYPE_INT_RGB doesn't have TYPE_INT databuffer!?");
        }
        if (ddbt.getNumBanks() != 1) {
            throw new IllegalStateException("?? TYPE_INT_RGB having != 1 banks!?");
        }
        DataBufferInt ddb = (DataBufferInt)ddbt;
        int soff = ImageSubsampler.getBiOffset(sras, ssm, 0, 0);
        int[] spx = sdb.getData(0);
        int siw = ssm.getScanlineStride();
        int doff = ImageSubsampler.getBiOffset(dras, dsm, 0, 0);
        int[] dpx = ddb.getData(0);
        int diw = dsm.getScanlineStride();
        for (int k = 0; k < ow; ++k) {
            int dpo = doff;
            for (int i = 0; i < oh; ++i) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                ContribList cl = contrib[i];
                for (int j = 0; j < cl.m_n; ++j) {
                    int argb = spx[soff + cl.m_ar[j].m_pixel * siw];
                    float weight = cl.m_ar[j].m_weight;
                    if (weight == 0.0f) continue;
                    r += weight * (float)(argb >> 16 & 0xFF);
                    g += weight * (float)(argb >> 8 & 0xFF);
                    b += weight * (float)(argb & 0xFF);
                }
                int br = r > 255.0f ? 255 : (r < 0.0f ? 0 : (int)r);
                int bg = g > 255.0f ? 255 : (g < 0.0f ? 0 : (int)g);
                int bb = b > 255.0f ? 255 : (b < 0.0f ? 0 : (int)b);
                dpx[dpo] = br << 16 | bg << 8 | bb;
                dpo += diw;
            }
            ++soff;
            ++doff;
        }
        return worki;
    }

    public static BufferedImage resample(BufferedImage srci, ResamplerFilter f, int ow, int oh) {
        int sw = srci.getWidth(null);
        int sh = srci.getHeight(null);
        if (sw < 2 || sh < 2) {
            throw new IllegalArgumentException("Source is too small, you silly m/v");
        }
        ContribList[] contrib = ImageSubsampler.getRowContrib(f, sw, ow);
        BufferedImage worki = srci.getType() == 1 ? ImageSubsampler.resampleRowRGB(srci, contrib, sw, sh, ow, oh) : ImageSubsampler.resampleRowGeneric(srci, contrib, sw, sh, ow, oh);
        contrib = ImageSubsampler.getColContrib(f, sh, oh);
        return ImageSubsampler.resampleColRGB(worki, contrib, sw, sh, ow, oh);
    }

    private static void saveImage(BufferedImage bi, String name) throws Exception {
        ImaTool.saveJPEG(bi, new File(name), 0.5);
    }

    private static ResamplerFilter loadFilter(String name) {
        try {
            Class<?> cl = ImageSubsampler.class.getClassLoader().loadClass(name);
            if (!ResamplerFilter.class.isAssignableFrom(cl)) {
                throw new IllegalArgumentException(name + ": not a resampler filter class!");
            }
            return (ResamplerFilter)cl.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static BufferedImage loadImage(File srcf) throws Exception {
        Toolkit t = Toolkit.getDefaultToolkit();
        Canvas f = new Canvas();
        MediaTracker mt = new MediaTracker(f);
        Image ima = t.getImage(srcf.toString());
        mt.addImage(ima, 0);
        mt.waitForAll();
        mt.removeImage(ima, 0);
        BufferedImage bi = new BufferedImage(ima.getWidth(f), ima.getHeight(f), 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.drawImage(ima, 0, 0, f);
        return bi;
    }

    public static Point resizeWithAspect(int w, int h, int iw, int ih) {
        double fx = (double)iw / (double)w;
        double fy = (double)ih / (double)h;
        double f = fx / fy;
        if (f >= 1.0) {
            h = (int)((double)ih / fx);
        } else {
            w = (int)((double)iw / fy);
        }
        return new Point(w, h);
    }

    private static ResamplerFilter getFilterByName(String fname) throws Exception {
        ResamplerFilter filter = ImageSubsampler.loadFilter(fname);
        if (filter == null) {
            filter = ImageSubsampler.loadFilter(fname + "Filter");
        }
        if (filter == null) {
            filter = ImageSubsampler.loadFilter("to.etc.sjit." + fname);
        }
        if (filter == null) {
            filter = ImageSubsampler.loadFilter("to.etc.sjit." + fname + "Filter");
        }
        if (filter == null) {
            throw new Exception("Unknown filter. Make sure the name starts with an uppercase letter...");
        }
        return filter;
    }

    private static void saveWithFilter(BufferedImage bi, String fname, Point p) throws Exception {
        ResamplerFilter filter = ImageSubsampler.getFilterByName(fname);
        String fn = filter.getClass().getName();
        int dot = fn.lastIndexOf(46);
        if (dot != -1) {
            fn = fn.substring(dot + 1);
        }
        if (fn.endsWith("Filter")) {
            fn = fn.substring(0, fn.length() - 6);
        }
        System.out.print("Resampling with " + fn + " filter, ");
        long t = System.currentTimeMillis();
        BufferedImage obi = ImageSubsampler.resample(bi, filter, p.x, p.y);
        t = System.currentTimeMillis() - t;
        System.out.print("save, ");
        ImageSubsampler.saveImage(obi, "s-" + Integer.toString(p.x) + "x" + Integer.toString(p.y) + "-" + fn + ".jpg");
        System.out.println("Done in " + t + " millis");
    }

    private static void perfFilter(BufferedImage bi, String fname, Point p) throws Exception {
        ResamplerFilter filter = ImageSubsampler.getFilterByName(fname);
        String fn = filter.getClass().getName();
        int dot = fn.lastIndexOf(46);
        if (dot != -1) {
            fn = fn.substring(dot + 1);
        }
        if (fn.endsWith("Filter")) {
            fn = fn.substring(0, fn.length() - 6);
        }
        System.out.print("Performance of " + fn + "-preload,");
        ImageSubsampler.resample(bi, filter, p.x, p.y);
        ImageSubsampler.resample(bi, filter, p.x, p.y);
        System.gc();
        System.out.print("measure,");
        long t = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            ImageSubsampler.resample(bi, filter, p.x, p.y);
        }
        t = System.currentTimeMillis() - t;
        System.out.println(t + " millis");
    }

    private static void pl(PrintWriter pw, String f, Point p) {
        pw.println("<br><br>");
        pw.println("<table><tr><td><img src=\"s-" + Integer.toString(p.x) + "x" + Integer.toString(p.y) + "-" + f + ".jpg\"></td></tr>");
        pw.println("<tr><td>The " + f + " filter.</td></tr></table>");
    }

    public static void main(String[] args) {
        int h;
        int w;
        if (args.length != 4 && args.length != 2) {
            System.out.println("Usage: ImageSubsampler <filename> <FilterClass> <maxwid> <maxhig>");
            System.out.println("Filters I know of are: Bell, Box, Hermite, Lanczos3, Mitchell,");
            System.out.println("Spline and Triangle. You can also specify ALL to get an output image for EACH filter..");
            System.exit(10);
        }
        if (args.length == 2) {
            w = 100;
            h = 100;
        } else {
            w = Integer.parseInt(args[2]);
            h = Integer.parseInt(args[3]);
        }
        File f = new File(args[0]);
        try {
            BufferedImage bi = ImageSubsampler.loadImage(f);
            Point p = ImageSubsampler.resizeWithAspect(w, h, bi.getWidth(), bi.getHeight());
            if (args[1].equalsIgnoreCase("all")) {
                ImageSubsampler.saveWithFilter(bi, "Bell", p);
                ImageSubsampler.saveWithFilter(bi, "Hermite", p);
                ImageSubsampler.saveWithFilter(bi, "Lanczos3", p);
                ImageSubsampler.saveWithFilter(bi, "Mitchell", p);
                ImageSubsampler.saveWithFilter(bi, "Spline", p);
                ImageSubsampler.saveWithFilter(bi, "Triangle", p);
                PrintWriter pw = new PrintWriter(new FileWriter("s-" + Integer.toString(p.x) + "x" + Integer.toString(p.y) + ".html"));
                pw.println("<html><head><title>Output of rescaling filter set</title></head>");
                pw.println("<body><h1>Generated for output size " + Integer.toString(p.x) + "x" + Integer.toString(p.y) + "</h1>");
                ImageSubsampler.pl(pw, "Bell", p);
                ImageSubsampler.pl(pw, "Hermite", p);
                ImageSubsampler.pl(pw, "Lanczos3", p);
                ImageSubsampler.pl(pw, "Mitchell", p);
                ImageSubsampler.pl(pw, "Spline", p);
                ImageSubsampler.pl(pw, "Triangle", p);
                pw.close();
            } else if (args[1].equalsIgnoreCase("perf")) {
                ImageSubsampler.perfFilter(bi, "Bell", p);
            } else {
                ImageSubsampler.saveWithFilter(bi, args[1], p);
            }
            System.out.println("Done");
        }
        catch (Throwable t) {
            System.out.println("FATAL: " + t.toString());
            t.printStackTrace();
        }
        System.exit(10);
    }
}

