/*
 * Decompiled with CFR 0.152.
 */
package to.etc.sjit;

import to.etc.sjit.ResamplerFilter;

public class Lanczos3Filter
extends ResamplerFilter {
    @Override
    public String getName() {
        return "Lanczos3";
    }

    private float sinC(float value) {
        if (value == 0.0f) {
            return 1.0f;
        }
        value = (float)((double)value * Math.PI);
        return (float)Math.sin(value) / value;
    }

    @Override
    public float filter(float value) {
        if (value < 0.0f) {
            value = -value;
        }
        if (value < 3.0f) {
            return this.sinC(value) * this.sinC(value / 3.0f);
        }
        return 0.0f;
    }

    @Override
    public float getWidth() {
        return 3.0f;
    }
}

