/*
 * Decompiled with CFR 0.152.
 */
package to.etc.sjit;

import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import to.etc.sjit.ImaTool;
import to.etc.sjit.ResamplerFilter;
import to.etc.sjit.SContribList;

@Deprecated
public class SlowSampler {
    private static final int IMAT = 1;

    private SlowSampler() {
    }

    public static BufferedImage resample(BufferedImage srci, ResamplerFilter f, int ow, int oh) {
        int n;
        int j;
        float weight;
        int j2;
        float center;
        SContribList cl;
        int i;
        int sw = srci.getWidth(null);
        int sh = srci.getHeight(null);
        float fwidth = f.getWidth();
        if (sw < 2 || sh < 2) {
            throw new IllegalArgumentException("Source is too small, you silly m/v");
        }
        BufferedImage worki = new BufferedImage(ow, sh, 1);
        float xscale = (float)(ow - 1) / (float)(sw - 1);
        float yscale = (float)(oh - 1) / (float)(sh - 1);
        SContribList[] contrib = new SContribList[ow];
        if (xscale < 1.0f) {
            float width = fwidth / xscale;
            float fscale = 1.0f / xscale;
            for (i = 0; i < ow; ++i) {
                contrib[i] = cl = new SContribList((int)(width * 2.0f + 1.0f));
                center = (float)i / xscale;
                int left = (int)Math.floor(center - width);
                int right = (int)Math.ceil(center + width);
                for (j2 = left; j2 <= right; ++j2) {
                    weight = f.filter((center - (float)j2) / fscale) / fscale;
                    if (weight == 0.0f) continue;
                    int n2 = j2 < 0 ? -j2 : (j2 >= sw ? sw - j2 + sw - 1 : j2);
                    ++cl.m_n;
                    cl.m_ar[k].m_pixel = n2;
                    cl.m_ar[k].m_weight = weight;
                }
            }
        } else {
            for (int i2 = 0; i2 < ow; ++i2) {
                SContribList cl2;
                contrib[i2] = cl2 = new SContribList((int)(fwidth * 2.0f + 1.0f));
                float center2 = (float)i2 / xscale;
                int left = (int)Math.floor(center2 - fwidth);
                int right = (int)Math.ceil(center2 + fwidth);
                for (j = left; j <= right; ++j) {
                    float weight2 = f.filter(center2 - (float)j);
                    if (weight2 == 0.0f) continue;
                    n = j < 0 ? -j : (j >= sw ? sw - j + sw - 1 : j);
                    ++cl2.m_n;
                    cl2.m_ar[k].m_pixel = n;
                    cl2.m_ar[k].m_weight = weight2;
                }
            }
        }
        for (int k = 0; k < sh; ++k) {
            for (int i3 = 0; i3 < ow; ++i3) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                SContribList cl3 = contrib[i3];
                for (j = 0; j < cl3.m_n; ++j) {
                    int argb = srci.getRGB(cl3.m_ar[j].m_pixel, k);
                    float weight3 = cl3.m_ar[j].m_weight;
                    if (weight3 == 0.0f) continue;
                    r += weight3 * (float)(argb >> 16 & 0xFF);
                    g += weight3 * (float)(argb >> 8 & 0xFF);
                    b += weight3 * (float)(argb & 0xFF);
                }
                int br = r > 255.0f ? 255 : (r < 0.0f ? 0 : (int)r);
                int bg = g > 255.0f ? 255 : (g < 0.0f ? 0 : (int)g);
                int bb = b > 255.0f ? 255 : (b < 0.0f ? 0 : (int)b);
                worki.setRGB(i3, k, br << 16 | bg << 8 | bb);
            }
        }
        contrib = new SContribList[oh];
        if (yscale < 1.0f) {
            float fscale = 1.0f / yscale;
            float width = fwidth / yscale;
            for (i = 0; i < oh; ++i) {
                contrib[i] = cl = new SContribList((int)((double)width * 2.0 + 1.0));
                center = (float)i / yscale;
                int loy = (int)Math.floor(center - width);
                int hiy = (int)Math.ceil(center + width);
                for (j2 = loy; j2 <= hiy; ++j2) {
                    weight = f.filter((center - (float)j2) / fscale) / fscale;
                    if (weight == 0.0f) continue;
                    int n3 = j2 < 0 ? -j2 : (j2 >= sh ? sh - j2 + sh - 1 : j2);
                    ++cl.m_n;
                    cl.m_ar[k].m_pixel = n3;
                    cl.m_ar[k].m_weight = weight;
                }
            }
        } else {
            for (int i4 = 0; i4 < oh; ++i4) {
                SContribList cl4;
                contrib[i4] = cl4 = new SContribList((int)((double)fwidth * 2.0 + 1.0));
                float center3 = (float)i4 / yscale;
                int loy = (int)Math.floor(center3 - fwidth);
                int hiy = (int)Math.ceil(center3 + fwidth);
                for (j = loy; j <= hiy; ++j) {
                    float weight4 = f.filter(center3 - (float)j);
                    if (weight4 == 0.0f) continue;
                    n = j < 0 ? -j : (j >= sh ? sh - j + sh - 1 : j);
                    ++cl4.m_n;
                    cl4.m_ar[k].m_pixel = n;
                    cl4.m_ar[k].m_weight = weight4;
                }
            }
        }
        BufferedImage obi = new BufferedImage(ow, oh, 1);
        for (int k = 0; k < ow; ++k) {
            for (i = 0; i < oh; ++i) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                SContribList cl5 = contrib[i];
                for (int j3 = 0; j3 < cl5.m_n; ++j3) {
                    int argb = worki.getRGB(k, cl5.m_ar[j3].m_pixel);
                    float weight5 = cl5.m_ar[j3].m_weight;
                    if (weight5 == 0.0f) continue;
                    r += weight5 * (float)(argb >> 16 & 0xFF);
                    g += weight5 * (float)(argb >> 8 & 0xFF);
                    b += weight5 * (float)(argb & 0xFF);
                }
                int br = r > 255.0f ? 255 : (r < 0.0f ? 0 : (int)r);
                int bg = g > 255.0f ? 255 : (g < 0.0f ? 0 : (int)g);
                int bb = b > 255.0f ? 255 : (b < 0.0f ? 0 : (int)b);
                obi.setRGB(k, i, br << 16 | bg << 8 | bb);
            }
        }
        return obi;
    }

    private static ResamplerFilter loadFilter(String name) {
        try {
            Class<?> cl = SlowSampler.class.getClassLoader().loadClass(name);
            if (!ResamplerFilter.class.isAssignableFrom(cl)) {
                throw new IllegalArgumentException(name + ": not a resampler filter class!");
            }
            return (ResamplerFilter)cl.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static BufferedImage loadImage(File srcf) throws Exception {
        Toolkit t = Toolkit.getDefaultToolkit();
        Canvas f = new Canvas();
        MediaTracker mt = new MediaTracker(f);
        Image ima = t.getImage(srcf.toString());
        mt.addImage(ima, 0);
        mt.waitForAll();
        mt.removeImage(ima, 0);
        BufferedImage bi = new BufferedImage(ima.getWidth(f), ima.getHeight(f), 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.drawImage(ima, 0, 0, f);
        return bi;
    }

    public static Point resizeWithAspect(int w, int h, int iw, int ih) {
        double fx = (double)iw / (double)w;
        double fy = (double)ih / (double)h;
        double f = fx / fy;
        if (f >= 1.0) {
            h = (int)((double)ih / fx);
        } else {
            w = (int)((double)iw / fy);
        }
        return new Point(w, h);
    }

    private static ResamplerFilter getFilterByName(String fname) throws Exception {
        ResamplerFilter filter = SlowSampler.loadFilter(fname);
        if (filter == null) {
            filter = SlowSampler.loadFilter(fname + "Filter");
        }
        if (filter == null) {
            filter = SlowSampler.loadFilter("to.etc.sjit." + fname);
        }
        if (filter == null) {
            filter = SlowSampler.loadFilter("to.etc.sjit." + fname + "Filter");
        }
        if (filter == null) {
            throw new Exception("Unknown filter. Make sure the name starts with an uppercase letter...");
        }
        return filter;
    }

    private static void saveWithFilter(BufferedImage bi, String fname, Point p) throws Exception {
        ResamplerFilter filter = SlowSampler.getFilterByName(fname);
        String fn = filter.getClass().getName();
        int dot = fn.lastIndexOf(46);
        if (dot != -1) {
            fn = fn.substring(dot + 1);
        }
        if (fn.endsWith("Filter")) {
            fn = fn.substring(0, fn.length() - 6);
        }
        System.out.print("Resampling with " + fn + " filter, ");
        long t = System.currentTimeMillis();
        BufferedImage obi = SlowSampler.resample(bi, filter, p.x, p.y);
        t = System.currentTimeMillis() - t;
        System.out.print("save, ");
        ImaTool.saveJPEG(obi, new File("s-" + Integer.toString(p.x) + "x" + Integer.toString(p.y) + "-" + fn + ".jpg"), 0.7);
        System.out.println("Done in " + t + " millis");
    }

    private static void perfFilter(BufferedImage bi, String fname, Point p) throws Exception {
        ResamplerFilter filter = SlowSampler.getFilterByName(fname);
        String fn = filter.getClass().getName();
        int dot = fn.lastIndexOf(46);
        if (dot != -1) {
            fn = fn.substring(dot + 1);
        }
        if (fn.endsWith("Filter")) {
            fn = fn.substring(0, fn.length() - 6);
        }
        System.out.print("Performance of " + fn + "-preload,");
        SlowSampler.resample(bi, filter, p.x, p.y);
        SlowSampler.resample(bi, filter, p.x, p.y);
        System.gc();
        System.out.print("measure,");
        long t = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            SlowSampler.resample(bi, filter, p.x, p.y);
        }
        t = System.currentTimeMillis() - t;
        System.out.println(t + " millis");
    }

    private static void pl(PrintWriter pw, String f, Point p) {
        pw.println("<br><br>");
        pw.println("<table><tr><td><img src=\"s-" + Integer.toString(p.x) + "x" + Integer.toString(p.y) + "-" + f + ".jpg\"></td></tr>");
        pw.println("<tr><td>The " + f + " filter.</td></tr></table>");
    }

    public static void main(String[] args) {
        int h;
        int w;
        if (args.length != 4 && args.length != 2) {
            System.out.println("Usage: ImageSubsampler <filename> <FilterClass> <maxwid> <maxhig>");
            System.out.println("Filters I know of are: Bell, Box, Hermite, Lanczos3, Mitchell,");
            System.out.println("Spline and Triangle. You can also specify ALL to get an output image for EACH filter..");
            System.exit(10);
        }
        if (args.length == 2) {
            w = 100;
            h = 100;
        } else {
            w = Integer.parseInt(args[2]);
            h = Integer.parseInt(args[3]);
        }
        File f = new File(args[0]);
        try {
            BufferedImage bi = SlowSampler.loadImage(f);
            Point p = SlowSampler.resizeWithAspect(w, h, bi.getWidth(), bi.getHeight());
            if (args[1].equalsIgnoreCase("all")) {
                SlowSampler.saveWithFilter(bi, "Bell", p);
                SlowSampler.saveWithFilter(bi, "Hermite", p);
                SlowSampler.saveWithFilter(bi, "Lanczos3", p);
                SlowSampler.saveWithFilter(bi, "Mitchell", p);
                SlowSampler.saveWithFilter(bi, "Spline", p);
                SlowSampler.saveWithFilter(bi, "Triangle", p);
                PrintWriter pw = new PrintWriter(new FileWriter("s-" + Integer.toString(p.x) + "x" + Integer.toString(p.y) + ".html"));
                pw.println("<html><head><title>Output of rescaling filter set</title></head>");
                pw.println("<body><h1>Generated for output size " + Integer.toString(p.x) + "x" + Integer.toString(p.y) + "</h1>");
                SlowSampler.pl(pw, "Bell", p);
                SlowSampler.pl(pw, "Hermite", p);
                SlowSampler.pl(pw, "Lanczos3", p);
                SlowSampler.pl(pw, "Mitchell", p);
                SlowSampler.pl(pw, "Spline", p);
                SlowSampler.pl(pw, "Triangle", p);
                pw.close();
            } else if (args[1].equalsIgnoreCase("perf")) {
                SlowSampler.perfFilter(bi, "Bell", p);
            } else {
                SlowSampler.saveWithFilter(bi, args[1], p);
            }
            System.out.println("Done");
        }
        catch (Throwable t) {
            System.out.println("FATAL: " + t.toString());
            t.printStackTrace();
        }
        System.exit(10);
    }
}

