/*
 * Decompiled with CFR 0.152.
 */
package to.etc.smtp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.Base64OutputStream;
import to.etc.util.StringTool;

public class MimeWriter {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHDASH = new byte[]{45, 45};
    @Nullable
    private final MimeWriter m_dad;
    @Nonnull
    private final OutputStream m_os;
    private String m_currentEncoding = "UTF-8";
    private byte[] m_boundary;
    private String m_boundaryString;
    private MimeWriter m_currentSub;
    private int m_boundaryCount;
    private static final long m_sysStartTime = System.currentTimeMillis() / 1000L;
    private static long m_lastOutTime;
    private OutputStream m_part_os;
    private Writer m_part_w;
    private boolean m_inpart;
    private boolean m_part_base64;

    protected MimeWriter(@Nonnull OutputStream os) {
        this.m_os = os;
        this.m_dad = null;
    }

    protected MimeWriter(@Nonnull MimeWriter dad, @Nonnull OutputStream os) {
        this.m_os = os;
        this.m_dad = dad;
    }

    protected byte[] getBoundary() {
        if (this.m_boundary == null) {
            MimeWriter root = this;
            while (root.m_dad != null) {
                root = root.m_dad;
            }
            this.m_boundaryString = "----bou-n-dar-y-=_" + StringTool.generateGUID() + "nr" + root.m_boundaryCount++;
            this.m_boundaryString = this.m_boundaryString.replace('$', 'X');
            try {
                this.m_boundary = this.m_boundaryString.getBytes("iso-8859-1");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_boundary;
    }

    protected String getBoundaryString() {
        if (this.m_boundary == null) {
            this.getBoundary();
        }
        return this.m_boundaryString;
    }

    public void write(byte[] data, int off, int len) throws IOException {
        this.m_os.write(data, off, len);
    }

    public final void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(String s) throws IOException {
        byte[] data = s.getBytes(this.m_currentEncoding);
        this.write(data);
    }

    protected void rawHeader(String name, String value) throws IOException {
        this.write(name);
        this.write(": ");
        this.write(value);
        this.write("\r\n");
    }

    protected void writeOpenBoundary() throws IOException {
        this.write(CRLF);
        this.write(DASHDASH);
        this.write(this.getBoundary());
        this.write(CRLF);
    }

    protected void writeCRLF() throws IOException {
        this.write(CRLF);
    }

    private void flush() throws IOException {
        if (this.m_currentSub != null) {
            this.m_currentSub.close();
            this.m_currentSub = null;
        }
        if (this.m_part_os != null) {
            this.m_part_os.close();
            this.m_part_os = null;
        }
    }

    public void close() throws IOException {
        this.flush();
        this.write(CRLF);
        this.write(DASHDASH);
        this.write(this.getBoundary());
        this.write(DASHDASH);
        this.write(CRLF);
        if (this.m_dad != null) {
            this.m_dad.m_currentSub = null;
        }
    }

    private void writeVersion() throws IOException {
        this.rawHeader("Mime-Version", "1.0");
    }

    public void writeHeader(@Nonnull String name, @Nonnull String primevalue, String ... subheaders) throws IOException {
        this.writeHeader(false, name, primevalue, subheaders);
    }

    public void writeHeader(boolean includeboundary, @Nonnull String name, @Nonnull String primevalue, String ... subheaders) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(primevalue);
        if (includeboundary) {
            sb.append(";boundary=");
            sb.append(this.headerquote(this.getBoundaryString()));
        }
        for (int i = 0; i < subheaders.length; i += 2) {
            String sname = subheaders[i];
            String sval = subheaders[i + 1];
            sb.append(";");
            sb.append(sname);
            sb.append('=');
            sb.append(this.headerquote(sval));
        }
        this.rawHeader(name, sb.toString());
    }

    @Nonnull
    private String headerquote(@Nonnull String in) {
        return "\"" + in + "\"";
    }

    @Nonnull
    public static synchronized String generateContentID() {
        long cts = System.currentTimeMillis();
        if (m_lastOutTime != 0L && cts == m_lastOutTime) {
            ++cts;
        }
        m_lastOutTime = cts;
        return m_sysStartTime + "." + cts + "@example.com";
    }

    @Nonnull
    public static MimeWriter createMimeWriter(@Nonnull OutputStream os, @Nonnull String contentType, String ... subpairs) throws IOException {
        if (!contentType.startsWith("multipart/")) {
            throw new IllegalStateException("Expecting a 'multipart/' type");
        }
        MimeWriter w = new MimeWriter(os);
        w.writeVersion();
        w.writeHeader(true, "Content-Type", contentType, subpairs);
        w.writeHeader("Content-Transfer-Encoding", "8bit", new String[0]);
        return w;
    }

    public void partStart(boolean base64, String contenttype, String ... subpairs) throws IOException {
        this.flush();
        this.writeOpenBoundary();
        this.writeHeader("Content-Type", contenttype, subpairs);
        this.rawHeader("Content-Transfer-Encoding", base64 ? "base64" : "8bit");
        this.m_part_base64 = base64;
        this.m_inpart = true;
    }

    private void checkInPart() {
        if (!this.m_inpart) {
            throw new IllegalStateException("Only valid when writing a mime part - call partStart() first");
        }
    }

    private void checkInPartHeaders() {
        this.checkInPart();
        if (this.m_part_os != null) {
            throw new IllegalStateException("Headers can only be written before the MIME part's output stream is allocated");
        }
    }

    public void partHeader(String name, String value) throws IOException {
        this.checkInPartHeaders();
        this.rawHeader(name, value);
    }

    public OutputStream partStream() throws IOException {
        this.checkInPart();
        if (this.m_currentSub != null) {
            throw new IllegalStateException("I am writing an embedded mime body - close it before continuing");
        }
        if (this.m_part_os == null) {
            this.writeCRLF();
            this.m_part_os = this.m_part_base64 ? new Base64OutputStream(this.m_os, false) : this.m_os;
        }
        return this.m_part_os;
    }

    public Writer partWriter(String encoding) throws IOException {
        if (this.m_part_w == null) {
            OutputStream os = this.partStream();
            this.m_part_w = new OutputStreamWriter(os, encoding);
        }
        return this.m_part_w;
    }

    public MimeWriter createSubMime(String contenttype, String ... rest) throws IOException {
        this.flush();
        this.writeOpenBoundary();
        MimeWriter sub = new MimeWriter(this, this.m_os);
        sub.writeHeader(true, "Content-Type", contenttype, rest);
        sub.writeHeader("Content-Transfer-Encoding", "8bit", new String[0]);
        this.m_currentSub = sub;
        return sub;
    }
}

