/*
 * Decompiled with CFR 0.152.
 */
package to.etc.smtp;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import javax.annotation.DefaultNonNull;
import to.etc.smtp.Address;
import to.etc.smtp.EmailOutputStream;
import to.etc.smtp.IMailAttachment;
import to.etc.smtp.MailBuilder;
import to.etc.smtp.MailException;
import to.etc.smtp.Message;
import to.etc.smtp.MimeWriter;
import to.etc.util.DeveloperOptions;
import to.etc.util.FileTool;
import to.etc.util.StringTool;

@DefaultNonNull
public class SmtpTransport {
    private static boolean DEBUG = DeveloperOptions.getBool("smtp.debug", false);
    private String m_myhostname;
    private final InetAddress m_server;
    private int m_port = 25;
    private Address m_from;

    public SmtpTransport(InetAddress a, int port) {
        this.m_server = a;
        this.m_port = port;
    }

    public SmtpTransport(InetAddress a) {
        this.m_server = a;
    }

    public SmtpTransport(String host) throws UnknownHostException {
        this.m_server = InetAddress.getByName(host);
    }

    public SmtpTransport(String host, String myhostname) throws UnknownHostException {
        this.m_server = InetAddress.getByName(host);
        this.m_myhostname = myhostname;
    }

    public SmtpTransport(String host, int port) throws UnknownHostException {
        this.m_server = InetAddress.getByName(host);
        this.m_port = port;
    }

    public synchronized void setMyHostName(String hn) {
        this.m_myhostname = hn;
    }

    public synchronized void setFrom(Address a) {
        this.m_from = a;
    }

    private synchronized String getMyHost() {
        if (this.m_myhostname == null) {
            try {
                this.m_myhostname = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException x) {
                return "localhost";
            }
        }
        return this.m_myhostname;
    }

    public void send(Message msg) throws Exception {
        this.send(msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message msg, InputStream bodyStream) throws Exception {
        Address from = msg.getFrom();
        if (from == null && (from = this.m_from) == null) {
            throw new MailException("Missing 'from' address in message");
        }
        if (msg.getTo() == null || msg.getTo().size() == 0) {
            throw new MailException("Missing 'to' address in message");
        }
        if (msg.getSubject() == null || msg.getSubject().trim().length() == 0) {
            throw new MailException("The 'subject' is empty in message");
        }
        if (DeveloperOptions.isDeveloperWorkstation()) {
            String overrideTo = DeveloperOptions.getString("email.debug");
            if (!StringTool.isBlank(overrideTo)) {
                msg.getTo().clear();
                msg.getTo().add(new Address(overrideTo, "email.debug"));
            } else {
                System.out.println("warning: You are sending emails from Developer Workstation, please consider setting email.debug in your .developer.properties !");
            }
        }
        Socket s = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            String res;
            boolean more;
            s = new Socket(this.m_server, this.m_port);
            s.setSoTimeout(30000);
            is = s.getInputStream();
            os = s.getOutputStream();
            String cr = this.readLine(is);
            if (!cr.startsWith("2")) {
                throw new MailException("SMTP server failed to send proper response after connect: '" + cr + "'");
            }
            SmtpTransport.write(os, "EHLO " + this.getMyHost() + "\r\n");
            boolean accepted = false;
            do {
                if ((res = this.readLine(is)).length() < 3) {
                    throw new MailException("SMTP error: empty response");
                }
                String code = res.substring(0, 3);
                more = res.length() > 3 ? res.charAt(3) == '-' : false;
                char c = code.charAt(0);
                if (c != '2') {
                    accepted = false;
                    break;
                }
                accepted = true;
            } while (more);
            if (!accepted) {
                SmtpTransport.write(os, "HELO " + this.getMyHost() + "\r\n");
                accepted = false;
                res = this.readLine(is);
                if (!res.startsWith("250")) {
                    throw new MailException("Host " + this.m_server + " does not accept HELO nor EHLO command.");
                }
                accepted = true;
            }
            if (!accepted) {
                throw new MailException(this.m_server + " does not accept my HELO/EHLO..");
            }
            SmtpTransport.write(os, "MAIL FROM: ");
            SmtpTransport.write(os, "<" + from.getEmail() + ">\r\n");
            cr = this.readLine(is);
            if (!cr.startsWith("250")) {
                throw new MailException(this.m_server + ": the server did not accept the 'from' address '" + msg.getFrom().getEmail() + "'");
            }
            this.sendAddressList(is, os, "RCPT TO:", msg.getTo());
            this.sendAddressList(is, os, "RCPT TO:", msg.getBcc());
            this.sendAddressList(is, os, "RCPT TO:", msg.getCc());
            SmtpTransport.write(os, "DATA\r\n");
            cr = this.readLine(is);
            if (!cr.startsWith("354") && !cr.startsWith("250")) {
                throw new MailException(this.m_server + ": did not accept the 'DATA' command, it mumbled " + cr);
            }
            SmtpTransport.write(os, "From: ");
            this.writeAddress(os, msg.getFrom());
            SmtpTransport.write(os, "\r\n");
            this.writeAddressList(os, "To: ", msg.getTo());
            this.writeAddressList(os, "CC: ", msg.getCc());
            SmtpTransport.write(os, "Reply-To: ");
            this.writeAddress(os, msg.getReplyTo() == null ? from : msg.getReplyTo());
            SmtpTransport.write(os, "\r\n");
            SmtpTransport.write(os, "Subject: " + msg.getSubject() + "\r\n");
            if (null != bodyStream) {
                FileTool.copyFile(os, bodyStream);
            } else {
                boolean ismime;
                boolean bl = ismime = msg.getAttachmentList().size() > 0 || msg.getHtmlBody() != null;
                if (ismime) {
                    SmtpTransport.writeMime(os, msg);
                } else {
                    SmtpTransport.writeText(os, msg);
                }
            }
            cr = this.readLine(is);
            if (!cr.startsWith("250")) {
                throw new MailException(this.m_server + ": did not accept the DATA message, it answered: " + cr);
            }
            SmtpTransport.write(os, "QUIT\r\n");
            cr = this.readLine(is);
        }
        catch (Throwable throwable) {
            FileTool.closeAll(os, is, s);
            throw throwable;
        }
        FileTool.closeAll(os, is, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMime(OutputStream os, Message msg) throws Exception {
        EmailOutputStream eos = new EmailOutputStream(os);
        MimeWriter w = MimeWriter.createMimeWriter(eos, "multipart/alternative", new String[0]);
        w.partStart(false, "text/plain", "charset", "UTF-8");
        Writer pw = w.partWriter("UTF-8");
        pw.append(msg.getBody());
        pw.close();
        boolean hdrc = true;
        MimeWriter hw = null;
        if (null != msg.getHtmlBody()) {
            String cid = MimeWriter.generateContentID();
            if (null == hw) {
                hw = w.createSubMime("multipart/related", "start", cid, "type", "text/html");
            }
            hw.partStart(false, "text/html", "charset", "UTF-8");
            hw.partHeader("Content-id", "<" + cid + ">");
            pw = hw.partWriter("UTF-8");
            pw.append(msg.getHtmlBody());
            pw.close();
        }
        if (msg.getAttachmentList().size() > 0) {
            if (hw == null) {
                hw = w.createSubMime("multipart/related", new String[0]);
            }
            for (IMailAttachment ma : msg.getAttachmentList()) {
                hw.partStart(true, ma.getMime(), new String[0]);
                hw.partHeader("Content-Location", "CID:blarf.net");
                hw.partHeader("Content-ID", "<" + ma.getIdent() + ">");
                hw.partHeader("Content-Disposition", "attachment; filename=\"" + ma.getIdent() + "\"");
                InputStream is = ma.getInputStream();
                OutputStream ios = hw.partStream();
                try {
                    FileTool.copyFile(ios, is);
                }
                catch (Throwable throwable) {
                    FileTool.closeAll(is, ios);
                    throw throwable;
                }
                FileTool.closeAll(is, ios);
            }
        }
        if (null != hw) {
            hw.close();
        }
        w.close();
        eos.flush();
        os.write(".\r\n".getBytes());
    }

    public static void writeText(OutputStream os, Message msg) throws Exception {
        String str = msg.getBody();
        if (str != null && str.length() > 0) {
            int ix = 0;
            int len = str.length();
            while (ix < len) {
                int pos = str.indexOf(10, ix);
                if (pos == -1) {
                    SmtpTransport.sendLine(os, str.substring(ix));
                    break;
                }
                String ss = str.substring(ix, pos);
                SmtpTransport.sendLine(os, ss);
                ix = pos + 1;
            }
        }
        SmtpTransport.write(os, ".\r\n");
    }

    private static void sendLine(OutputStream os, String line) throws Exception {
        if (line.startsWith(".")) {
            SmtpTransport.write(os, "." + line + "\r\n");
        } else {
            SmtpTransport.write(os, line + "\r\n");
        }
    }

    private void writeAddressList(OutputStream os, String hdr, List<Address> al) throws Exception {
        if (al == null || al.size() == 0) {
            return;
        }
        SmtpTransport.write(os, hdr);
        boolean first = true;
        for (Address a : al) {
            if (first) {
                first = false;
            } else {
                SmtpTransport.write(os, ", ");
            }
            this.writeAddress(os, a);
        }
        SmtpTransport.write(os, "\r\n");
    }

    private void writeAddress(OutputStream os, Address a) throws Exception {
        if (!StringTool.isBlank(a.getName())) {
            SmtpTransport.write(os, "\"" + a.getName() + "\" ");
        }
        SmtpTransport.write(os, "<" + a.getEmail() + ">");
    }

    private void sendAddressList(InputStream is, OutputStream os, String hdr, List<Address> al) throws Exception {
        if (al == null) {
            return;
        }
        for (Address a : al) {
            SmtpTransport.write(os, hdr + "<" + a.getEmail() + ">\r\n");
            String res = this.readLine(is);
            if (res.startsWith("250")) continue;
            throw new MailException(this.m_server + ": refused the recipient '" + a.getEmail() + "': " + res);
        }
    }

    private static void write(OutputStream os, String s) throws Exception {
        byte[] b = s.getBytes("US-ASCII");
        os.write(b);
        if (DEBUG) {
            System.out.println("[write] " + s);
        }
    }

    private String readLine(InputStream is) throws Exception {
        byte[] buf = new byte[128];
        int ix = 0;
        int lch = 0;
        while (true) {
            int ch;
            if ((ch = is.read()) == 10) {
                if (lch == 13) {
                    --ix;
                }
                String s = new String(buf, 0, ix, "US-ASCII");
                if (DEBUG) {
                    System.out.println("[read] " + s);
                }
                return s;
            }
            lch = ch;
            if (ix >= buf.length) {
                byte[] a = new byte[ix + 128];
                System.arraycopy(buf, 0, a, 0, ix);
                buf = a;
            }
            buf[ix++] = (byte)ch;
        }
    }

    public Message createMessage() {
        return new Message(this);
    }

    public static void main(String[] args) {
        String mailTo = "yourmail@itris.nl";
        String imagePath = "/home/path";
        try {
            MailBuilder mb = new MailBuilder();
            mb.initialize("Run mailBuilder");
            mb.appendText("Hello, this is the mailBuilder (4)");
            mb.appendHTML("<p>This is <b>HTML</b> text</p>");
            mb.image("image.jpg", new File(imagePath), "image/jpeg");
            mb.send(new SmtpTransport("localhost"), new Address("itris@info.nl", "itris@info.nl"), new Address(mailTo, mailTo));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

