/*
 * Decompiled with CFR 0.152.
 */
package to.etc.telnet;

import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import to.etc.telnet.ITelnetCommandHandler;
import to.etc.telnet.TelnetPrintWriter;
import to.etc.telnet.TelnetSession;
import to.etc.telnet.TelnetStateThing;
import to.etc.telnet.TelnetSysoutMirrorStream;
import to.etc.util.CmdStringDecoder;

public class TelnetServer
extends TelnetStateThing
implements Runnable {
    private int m_port;
    private ServerSocket m_server_socket;
    private Thread m_thread;
    private int m_error_count;
    private List<TelnetSession> m_sessions = new ArrayList<TelnetSession>();
    private List<ITelnetCommandHandler> m_command_v;
    private LinkedList<String> m_string_cache = new LinkedList();
    private static TelnetServer m_telnet_server;
    private static PrintStream m_orig_stdout;
    private static PrintStream m_orig_stderr;
    private static boolean m_capturing_stdout;

    private TelnetServer(int port) {
        this.m_port = port;
    }

    public static TelnetServer createServer(int port) throws Exception {
        TelnetServer ts = new TelnetServer(port);
        try {
            ts.init();
        }
        finally {
            if (!ts.inState(1) && !ts.inState(4)) {
                ts.releaseResources();
            }
        }
        return ts;
    }

    private void init() throws Exception {
        this.setState(4);
        this.m_command_v = new ArrayList<ITelnetCommandHandler>();
        this.m_server_socket = new ServerSocket(this.m_port, 10);
        this.m_thread = new Thread(this);
        this.m_thread.setDaemon(true);
        this.m_thread.setName("Telnet@" + this.m_port);
        this.m_thread.start();
    }

    private void releaseResources() {
        this.setState(3);
        try {
            if (this.m_server_socket != null) {
                this.m_server_socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_server_socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandHandler(ITelnetCommandHandler tch) {
        List<ITelnetCommandHandler> list = this.m_command_v;
        synchronized (list) {
            this.m_command_v.add(tch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTelnetCommand(TelnetPrintWriter tpw, String command) {
        ITelnetCommandHandler[] ar;
        CmdStringDecoder csd = new CmdStringDecoder(command);
        if (csd.currIs("bye") || csd.currIs("close")) {
            tpw.println("Closing telnet session. Bye and thanks for all the fish!");
            TelnetSession ts = tpw.getSession();
            ts.close();
            return;
        }
        if (csd.currIs("stdout")) {
            if (csd.hasMore()) {
                String n = csd.getNext();
                if ("on".equalsIgnoreCase(n) || "true".equalsIgnoreCase(n) || "capture".equals(n)) {
                    TelnetServer.setCapture(true);
                } else {
                    TelnetServer.setCapture(false);
                }
            }
            tpw.println("Stdout state is: " + (m_capturing_stdout ? "capturing stdout" : "not capturing stdout"));
            return;
        }
        List<ITelnetCommandHandler> list = this.m_command_v;
        synchronized (list) {
            ar = this.m_command_v.toArray(new ITelnetCommandHandler[this.m_command_v.size()]);
        }
        boolean handled = false;
        for (int i = 0; i < ar.length; ++i) {
            if (!this.executeTelnetCommand(tpw, ar[i], csd)) continue;
            handled = true;
        }
        if (!handled) {
            tpw.write("TS: Unrecognized command " + command + "\r\n");
        }
    }

    private boolean executeTelnetCommand(TelnetPrintWriter tpw, ITelnetCommandHandler tch, CmdStringDecoder cmd) {
        try {
            cmd.reset();
            return tch.executeTelnetCommand(tpw, cmd);
        }
        catch (Exception x) {
            tpw.println("Exception in command: " + x.toString());
            x.printStackTrace(tpw);
            return false;
        }
    }

    @Override
    public void run() {
        System.out.println("TelnetServer: listener thread started OK.");
        this.setState(1);
        try {
            this.m_error_count = 0;
            while (this.m_error_count < 10) {
                this.acceptListen();
            }
            System.out.println("TelnetServer: listener died due to excessive errors");
        }
        catch (Exception x) {
            System.out.println("TelnetServer: listener fatal exception.");
            x.printStackTrace();
        }
        finally {
            this.setState(3);
        }
        System.out.println("TelnetServer: terminated.");
    }

    private void acceptListen() throws Exception {
        if (!this.inState(1)) {
            throw new Exception("TelnetServer is not in RUN state: cannot accept connections");
        }
        Socket s = null;
        try {
            s = this.m_server_socket.accept();
            this.createSession(s);
            s = null;
            this.m_error_count = 0;
        }
        catch (Exception x) {
            x.printStackTrace();
            ++this.m_error_count;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSession(Socket s) throws Exception {
        TelnetSession ts = new TelnetSession(this, s);
        ts.init();
        TelnetServer telnetServer = this;
        synchronized (telnetServer) {
            this.m_sessions.add(ts);
        }
        this.pumpShit(ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionClosed(TelnetSession ts) {
        TelnetServer telnetServer = this;
        synchronized (telnetServer) {
            this.m_sessions.remove(ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToCache(String v) {
        LinkedList<String> linkedList = this.m_string_cache;
        synchronized (linkedList) {
            this.m_string_cache.addLast(v);
            if (this.m_string_cache.size() > 200) {
                this.m_string_cache.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pumpShit(TelnetSession ts) {
        try {
            LinkedList<String> linkedList = this.m_string_cache;
            synchronized (linkedList) {
                for (String v : this.m_string_cache) {
                    ts.write(v);
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wall(String msg) {
        TelnetSession[] ar;
        this.appendToCache(msg);
        TelnetServer telnetServer = this;
        synchronized (telnetServer) {
            int ns = this.m_sessions.size();
            if (ns == 0) {
                return;
            }
            ar = this.m_sessions.toArray(new TelnetSession[ns]);
        }
        for (int i = 0; i < ar.length; ++i) {
            try {
                ar[i].write(msg);
                continue;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public void _write(int ch) {
        char[] c = new char[]{(char)ch};
        this.wall(new String(c));
    }

    public void _write(byte[] ar, int off, int len) {
        String s = new String(ar, off, len);
        this.wall(s);
    }

    public static void main(String[] args) {
        try {
            TelnetServer t = TelnetServer.createServer(7171);
            int ct = 0;
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(2000L);
                        t.wall("Testing, one, two.." + ct + "\n\r");
                        ++ct;
                        Runtime.getRuntime().gc();
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
        catch (Exception x) {
            System.out.println("EXCEPTION: " + x.toString());
            x.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCapture(boolean on) {
        if (m_capturing_stdout == on) {
            return;
        }
        Class<System> clazz = System.class;
        synchronized (System.class) {
            if (on) {
                TelnetSysoutMirrorStream tsms = new TelnetSysoutMirrorStream(m_telnet_server, System.out);
                PrintStream ps = new PrintStream(tsms);
                System.setOut(ps);
                System.setErr(ps);
            } else {
                System.setOut(m_orig_stdout);
                System.setErr(m_orig_stderr);
            }
            m_capturing_stdout = on;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startTelnetServer(int port) {
        Class<TelnetServer> clazz = TelnetServer.class;
        synchronized (TelnetServer.class) {
            if (m_telnet_server != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            System.out.println("Starting telnet thingy on port " + port);
            try {
                m_telnet_server = TelnetServer.createServer(port);
                m_orig_stdout = System.out;
                m_orig_stderr = System.err;
                m_capturing_stdout = true;
                TelnetSysoutMirrorStream tsms = new TelnetSysoutMirrorStream(m_telnet_server, System.out);
                PrintStream ps = new PrintStream(tsms);
                System.setOut(ps);
                System.setErr(ps);
            }
            catch (Exception x) {
                System.err.println("LogMaster: startTelnet failed, " + x.toString());
                x.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerTelnetCommand(ITelnetCommandHandler tch) {
        Class<TelnetServer> clazz = TelnetServer.class;
        synchronized (TelnetServer.class) {
            if (m_telnet_server == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            m_telnet_server.addCommandHandler(tch);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

