/*
 * Decompiled with CFR 0.152.
 */
package to.etc.template;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import to.etc.template.ExpReader;
import to.etc.template.TplCallback;
import to.etc.template.TplDummy;
import to.etc.template.TplException;
import to.etc.util.StringTool;

@Deprecated
public class TplExpander {
    protected TplCallback m_cb;
    private Map<String, Object> m_ht = new HashMap<String, Object>(15);
    private String m_buf;
    private PrintWriter m_ps;
    boolean m_html = true;
    protected String m_servlet_basepath;
    protected String m_servlet_fullpath;
    protected String m_hosturl;
    protected String m_hostname;
    protected int m_hostport;
    private int m_v_ix;
    private int m_v_ct;
    private String[] m_v;

    public TplExpander(TplCallback cb) {
        this.m_cb = cb;
    }

    public TplExpander(TplCallback cb, boolean html) {
        this.m_cb = cb;
        this.m_html = html;
    }

    protected String slconc(String s1, String s2) {
        boolean b2;
        if (s1.length() == 0) {
            return s2;
        }
        if (s2.length() == 0) {
            return s1;
        }
        boolean b1 = s1.endsWith("/");
        boolean bl = b2 = s2.charAt(0) == '/';
        if (b1 && b2) {
            return s1 + s2.substring(1);
        }
        if (!b1 && !b2) {
            return s1 + "/" + s2;
        }
        return s1 + s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(InputStream is, PrintWriter pw) throws Exception {
        try {
            int bl;
            this.m_ps = pw;
            StringBuffer sb = new StringBuffer(8192);
            char[] buf = new char[512];
            InputStreamReader r = new InputStreamReader(is);
            while ((bl = r.read(buf)) > 0) {
                sb.append(buf, 0, bl);
            }
            this.m_buf = sb.toString();
            this.expandPart(this.m_buf);
        }
        finally {
            this.m_ps = null;
            this.m_buf = null;
        }
    }

    public void expand(String input, PrintWriter output) throws Exception {
        this.m_buf = input;
        this.m_ps = output;
        this.expandPart(input);
    }

    public String expand(String input) throws Exception {
        PrintWriter pw;
        this.m_buf = input;
        StringWriter sw = new StringWriter();
        this.m_ps = pw = new PrintWriter(sw);
        this.expandPart(input);
        return sw.toString();
    }

    private void expandPart(String s) throws TplException {
        ExpReader r = new ExpReader(s);
        while (true) {
            int tc = r.nextToken();
            switch (tc) {
                case -1: {
                    return;
                }
                case 1: {
                    this.m_ps.print(r.getValue());
                    break;
                }
                case 4: {
                    throw new TplException("/endloop tag found without /loop.");
                }
                case 2: {
                    this.expandVar(r.getValue());
                    break;
                }
                case 3: {
                    this.expandLoop(r);
                    break;
                }
                case 7: {
                    this.expandIf(r, false);
                    break;
                }
                case 5: {
                    this.expandIf(r, true);
                }
            }
        }
    }

    private void expandVar(String expr) throws TplException {
        if (expr.startsWith("*")) {
            Object s = this.evalExpr(expr.substring(1));
            this.m_ps.print(s.toString());
            return;
        }
        Object s = this.evalExpr(expr);
        if (this.m_html) {
            this.m_ps.print(StringTool.htmlStringize(s.toString()));
        } else {
            this.m_ps.print(s.toString());
        }
    }

    public Object findName(String name) {
        return null;
    }

    protected Object findPredef(String name) {
        return null;
    }

    protected Object locateName(String name) throws TplException {
        Object o = this.m_ht.get(name);
        if (o != null) {
            return o;
        }
        o = this.m_cb.getValue(name);
        if (o != null) {
            return o;
        }
        o = this.findName(name);
        if (o != null) {
            return o;
        }
        o = this.findPredef(name);
        return o;
    }

    private Object evalExpr(String ins) throws TplException {
        Object v = this.m_cb.getValue(ins);
        if (v != null) {
            return v;
        }
        try {
            String tok;
            StringTokenizer st = new StringTokenizer(ins, ".", true);
            String[] ar = new String[20];
            int ix = 0;
            do {
                if (ix >= ar.length) {
                    throw new TplException("Too many dots in name..");
                }
                if (!st.hasMoreTokens()) {
                    throw new TplException("Missing name in variable.");
                }
                ar[ix] = tok = st.nextToken().trim();
                ++ix;
                tok = null;
            } while (st.hasMoreTokens() && (tok = st.nextToken()).equals("."));
            Object o = this.evalNameList(ar, ix);
            return o;
        }
        catch (TplException x) {
            x.printStackTrace();
            throw new TplException(ins + ": error- " + x.toString());
        }
    }

    private String getNonSpaceToken(StringTokenizer st) {
        String v;
        do {
            if (st.hasMoreTokens()) continue;
            return null;
        } while ((v = st.nextToken()).equals(" "));
        return v;
    }

    private int scanIntoArray(String[] ar, StringTokenizer st) throws TplException {
        String tok;
        int ix = 0;
        do {
            if (ix >= ar.length) {
                throw new TplException("Too many dots in name..");
            }
            tok = this.getNonSpaceToken(st);
            if (tok == null) {
                throw new TplException("Missing name in variable.");
            }
            ar[ix] = tok;
            ++ix;
        } while ((tok = this.getNonSpaceToken(st)) != null && tok.equals("."));
        return ix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evalNameList(String[] ar, int ct) throws TplException {
        try {
            this.m_v_ix = 1;
            this.m_v_ct = ct;
            this.m_v = ar;
            Object o = this.locateName(ar[0]);
            if (o == null) {
                if (ct > 1) {
                    o = this.locateName(ar[0] + "." + ar[1]);
                }
                if (o == null) {
                    throw new TplException(ar[0] + ": variable not found.");
                }
                this.m_v_ix = 2;
            }
            while (this.m_v_ix < this.m_v_ct) {
                o = this.evalReference(o);
            }
            Object object = o;
            return object;
        }
        finally {
            this.m_v = null;
        }
    }

    private Object evalReference(Object root_o) throws TplException {
        Object o = null;
        o = this.tryResultSet(root_o);
        if (o != null) {
            return o;
        }
        o = this.tryBasic(root_o);
        if (o != null) {
            return o;
        }
        o = this.tryGetOnly(root_o);
        if (o != null) {
            return o;
        }
        throw new TplException("Name/method " + this.m_v[this.m_v_ix] + "not found in class " + root_o.getClass().getName());
    }

    private Object tryResultSet(Object root_o) throws TplException {
        if (!(root_o instanceof ResultSet)) {
            return null;
        }
        String name = this.m_v[this.m_v_ix++];
        ResultSet rs = (ResultSet)root_o;
        try {
            String v = rs.getString(name);
            if (rs.wasNull()) {
                return "";
            }
            if (v == null) {
                return "(field " + name + " not in result set)";
            }
            return v;
        }
        catch (SQLException x) {
            return "SQLException " + x.toString();
        }
    }

    private Object tryGetOnly(Object root_o) throws TplException {
        Method m;
        String n = "get";
        Class[] args = new Class[]{n.getClass()};
        try {
            m = root_o.getClass().getMethod(n, args);
        }
        catch (Exception x) {
            return null;
        }
        String[] aa = new String[]{this.m_v[this.m_v_ix++]};
        try {
            return m.invoke(root_o, (Object[])aa);
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    private Object tryBasic(Object root_o) throws TplException {
        String name = this.m_v[this.m_v_ix];
        String aname = "get" + name;
        Method[] mar = root_o.getClass().getMethods();
        try {
            for (int i = 0; i < mar.length; ++i) {
                Method m = mar[i];
                if (!m.getName().equalsIgnoreCase(name) && !m.getName().equalsIgnoreCase(aname)) continue;
                Class<?>[] par = m.getParameterTypes();
                if (par.length == 0) {
                    Object o = m.invoke(root_o, (Object[])null);
                    if (o == null) {
                        throw new TplException(m.getName() + ": Method call returned null");
                    }
                    ++this.m_v_ix;
                    return o;
                }
                if (par.length != 1 || par[0] != name.getClass() || this.m_v_ix + 1 >= this.m_v_ct) continue;
                Object[] aar = new Object[]{this.m_v[this.m_v_ix + 1]};
                Object o = m.invoke(root_o, aar);
                if (o == null) {
                    throw new TplException(m.getName() + ": Method call returned null");
                }
                this.m_v_ix += 2;
                return o;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new TplException("Exception in METHOD call- " + x.toString());
        }
        return null;
    }

    private void expandLoop(ExpReader org_r) throws TplException {
        String loopsect;
        StringTokenizer st = new StringTokenizer(org_r.getValue(), " \t.", true);
        String name = this.getNonSpaceToken(st);
        if (name == null) {
            throw new TplException("loop: missing parameters.");
        }
        if (!st.hasMoreTokens()) {
            throw new TplException("loop: missing loop expression or bad separator between loop iterator and expression");
        }
        if (!st.nextToken().equals(" ")) {
            throw new TplException("loop: missing loop expression or bad separator between loop iterator and expression");
        }
        String[] ar = new String[20];
        int ix = this.scanIntoArray(ar, st);
        Object o = this.evalNameList(ar, ix);
        if (this.tryArrayLoop(o, name, loopsect = this.findLoopEnd(org_r))) {
            return;
        }
        if (this.tryIsEnum(o, name, loopsect)) {
            return;
        }
        if (this.tryHasEnum(o, name, loopsect)) {
            return;
        }
    }

    private String findLoopEnd(ExpReader org_r) throws TplException {
        int spos = org_r.getPos();
        int depth = 0;
        while (true) {
            int epos = org_r.getPos();
            int tc = org_r.nextToken();
            if (tc == -1) {
                throw new TplException("loop: missing /loop tag.");
            }
            if (tc == 3) {
                ++depth;
                continue;
            }
            if (tc != 4) continue;
            if (depth == 0) {
                return this.m_buf.substring(spos, epos);
            }
            --depth;
        }
    }

    private void expandLoopSection(String ivar, Object ival, String loopsect) throws TplException {
        if (ival == null) {
            ival = "";
        }
        this.m_ht.put(ivar, ival);
        this.expandPart(loopsect);
        this.m_ht.remove(ivar);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryArrayLoop(Object o, String ivar, String loopsect) throws TplException {
        Class<?> acl = o.getClass();
        if (!acl.isArray()) {
            return false;
        }
        Class<?> cl = acl.getComponentType();
        int len = Array.getLength(o);
        for (int ix = 0; ix < len; ++ix) {
            Object ival = null;
            if (cl.isPrimitive()) {
                if (cl == Integer.TYPE) {
                    int i = Array.getInt(o, ix);
                    ival = new Integer(i);
                } else {
                    if (cl != Long.TYPE) throw new TplException("Unsupported 'primitive' type in loop array");
                    ival = new Long(Array.getLong(o, ix));
                }
            } else {
                ival = Array.get(o, ix);
            }
            this.expandLoopSection(ivar, ival, loopsect);
        }
        return true;
    }

    private boolean doesImpl(Class<?> cl, String ifname) {
        Class<?>[] ar = cl.getInterfaces();
        for (int i = 0; i < ar.length; ++i) {
            Class<?> ic = ar[i];
            if (!ic.getName().equals(ifname)) continue;
            return true;
        }
        return false;
    }

    private boolean tryIsEnum(Object o, String ivar, String loopsect) throws TplException {
        Class<?> acl = o.getClass();
        if (!this.doesImpl(acl, "java.util.Enumeration")) {
            return false;
        }
        Enumeration e = (Enumeration)o;
        while (e.hasMoreElements()) {
            Object ival = e.nextElement();
            this.expandLoopSection(ivar, ival, loopsect);
        }
        return true;
    }

    private static Method findMethod(Class<?> cl, String name, int nparm) {
        Method[] ar = cl.getMethods();
        for (int i = 0; i < ar.length; ++i) {
            if (!ar[i].getName().equals(name) || ar[i].getParameterTypes().length != nparm) continue;
            return ar[i];
        }
        return null;
    }

    private boolean tryHasEnum(Object o, String ivar, String loopsect) throws TplException {
        Class<?> acl = o.getClass();
        Method m = TplExpander.findMethod(acl, "elements", 0);
        if (this.tryEnumMethod(o, ivar, loopsect, m)) {
            return true;
        }
        m = TplExpander.findMethod(acl, "values", 0);
        return this.tryEnumMethod(o, ivar, loopsect, m);
    }

    private boolean tryEnumMethod(Object o, String ivar, String loopsect, Method m) throws TplException {
        Enumeration e;
        if (m == null) {
            return false;
        }
        try {
            e = (Enumeration)m.invoke(o, (Object[])null);
        }
        catch (Exception x) {
            throw new TplException("Exception in method invocation " + m.getName() + ": " + x.toString());
        }
        while (e.hasMoreElements()) {
            Object ival = e.nextElement();
            this.expandLoopSection(ivar, ival, loopsect);
        }
        return true;
    }

    private void expandIf(ExpReader org_r, boolean isnot) throws TplException {
        Object o = this.evalExpr(org_r.getValue());
        String ifsect = isnot ? this.findIfEnd(org_r, 5, 6) : this.findIfEnd(org_r, 7, 8);
        boolean cond = false;
        if (o != null) {
            cond = o instanceof Boolean ? (Boolean)o : (o instanceof Integer ? (Integer)o != 0 : true);
        }
        if (isnot) {
            boolean bl = cond = !cond;
        }
        if (cond) {
            this.expandPart(ifsect);
        }
    }

    private String findIfEnd(ExpReader org_r, int starttoken, int endtoken) throws TplException {
        int spos = org_r.getPos();
        int depth = 0;
        while (true) {
            int epos = org_r.getPos();
            int tc = org_r.nextToken();
            if (tc == -1) {
                throw new TplException("loop: missing end (/) tag for if.");
            }
            if (tc == starttoken) {
                ++depth;
                continue;
            }
            if (tc != endtoken) continue;
            if (depth == 0) {
                return this.m_buf.substring(spos, epos);
            }
            --depth;
        }
    }

    public void putGetter(String name, Object o) {
        this.m_ht.put(name, o);
    }

    public void putDummy(String name) {
        this.m_ht.put(name, TplDummy.m_dummy);
    }
}

