/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.math.BigDecimal;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.servlet.jsp.el.ELException;

public class CalculationUtil {
    private static final Locale LOC = new Locale("nl", "NL");
    private static final DateFormatSymbols SYMS = new DateFormatSymbols(LOC);
    private static final String[] SHORTNAMES = SYMS.getShortMonths();
    private static final String[] LONGNAMES = SYMS.getMonths();

    private CalculationUtil() {
    }

    public static final String[] getDutchMonthShorts() {
        return SHORTNAMES;
    }

    public static int ageOn(Date today, Date birthdate) {
        if (today == null || birthdate == null) {
            return 0;
        }
        if (today.before(birthdate)) {
            Date t = birthdate;
            birthdate = today;
            today = t;
        }
        GregorianCalendar ccal = new GregorianCalendar();
        ccal.setTime(today);
        int cyear = ccal.get(1);
        GregorianCalendar bcal = new GregorianCalendar();
        bcal.setTime(birthdate);
        int byear = bcal.get(1);
        int age = cyear - byear;
        bcal.set(1, cyear);
        if (ccal.before(bcal)) {
            --age;
        }
        return age;
    }

    public static int age(Date d) {
        return CalculationUtil.ageOn(d, new Date());
    }

    public static Date date(String str) throws Exception {
        char c;
        char c2;
        char c3;
        int ix;
        str = str.trim();
        int len = str.length();
        int spos = ix = 0;
        int n1 = 0;
        while (ix < len && Character.isDigit(c3 = str.charAt(ix))) {
            ++ix;
            n1 = n1 * 10 + (c3 - 48);
        }
        if (spos == ix) {
            CalculationUtil.wrongDateFormatError(str);
        }
        while (ix < len && !Character.isDigit(str.charAt(ix))) {
            ++ix;
        }
        int n2 = 0;
        spos = ix;
        while (ix < len && Character.isDigit(c2 = str.charAt(ix))) {
            ++ix;
            n2 = n2 * 10 + (c2 - 48);
        }
        if (spos == ix) {
            CalculationUtil.wrongDateFormatError(str);
        }
        while (ix < len && !Character.isDigit(str.charAt(ix))) {
            ++ix;
        }
        int n3 = 0;
        spos = ix;
        while (ix < len && Character.isDigit(c = str.charAt(ix))) {
            ++ix;
            n3 = n3 * 10 + (c - 48);
        }
        if (spos == ix || ix != len) {
            CalculationUtil.wrongDateFormatError(str);
        }
        return CalculationUtil.makeDate(n1, n2, n3);
    }

    public static Date dutchDate(String s) throws Exception {
        Date d = CalculationUtil.dutchDateRAW(s);
        if (d == null) {
            CalculationUtil.wrongDateFormatError(s);
        }
        return d;
    }

    public static Date dutchDateAndTime(String s) throws ELException {
        String date = s.split(" ")[0];
        String time = s.split(" ")[1];
        Date d = CalculationUtil.dutchDateRAW(date);
        if (d == null) {
            CalculationUtil.wrongDateTimeFormatError(s);
        }
        if (!CalculationUtil.validateTime(time)) {
            CalculationUtil.wrongDateTimeFormatError(s);
        }
        CalculationUtil.addTimeToDate(d, time);
        return d;
    }

    private static void addTimeToDate(Date d, String time) {
        int hour = Integer.parseInt(time.split(":")[0]);
        int minutes = Integer.parseInt(time.split(":")[1]);
        d.setHours(hour);
        d.setMinutes(minutes);
    }

    private static boolean validateTime(String t) {
        String time = t.trim();
        int hour = -1;
        int minutes = -1;
        try {
            hour = Integer.parseInt(time.split(":")[0]);
            minutes = Integer.parseInt(time.split(":")[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (hour < 0 || hour > 23) {
            return false;
        }
        return minutes >= 0 && minutes <= 59;
    }

    public static Date dutchDateRAW(String s) {
        char c;
        char c2;
        int ix;
        int len = s.length();
        for (ix = 0; ix < len && Character.isWhitespace(s.charAt(ix)); ++ix) {
        }
        int n1 = 0;
        int nch = 0;
        while (ix < len && Character.isDigit(c2 = s.charAt(ix))) {
            ++nch;
            n1 = n1 * 10 + (c2 - 48);
            ++ix;
        }
        if (nch == 0 || ix >= len || n1 < 1 || n1 > 31) {
            return null;
        }
        int spos = ix = CalculationUtil.skippy(s, len, ix);
        int n2 = 0;
        while (ix < len) {
            char c3 = s.charAt(ix);
            if (Character.isDigit(c3)) {
                if (n2 == -1) {
                    return null;
                }
                n2 = n2 * 10 + (c3 - 48);
            } else {
                if (!Character.isLetter(c3)) break;
                n2 = -1;
            }
            ++ix;
        }
        if (ix == spos || ix >= len) {
            return null;
        }
        String ms = n2 == -1 ? s.substring(spos, ix) : null;
        nch = 0;
        int n3 = 0;
        for (ix = CalculationUtil.skippy(s, len, ix); ix < len && Character.isDigit(c = s.charAt(ix)); ++ix) {
            ++nch;
            n3 = n3 * 10 + (c - 48);
        }
        if (nch == 2) {
            n3 += 2000;
        }
        if ((ix = CalculationUtil.skippy(s, len, ix)) < len || n3 > 2200 || nch == 0) {
            return null;
        }
        if (ms != null) {
            n2 = -1;
            for (int i = 0; i < SHORTNAMES.length; ++i) {
                if (!SHORTNAMES[i].equalsIgnoreCase(ms) && !LONGNAMES[i].equalsIgnoreCase(ms)) continue;
                n2 = i + 1;
                break;
            }
        }
        if (n2 < 1 || n2 > 12 || n3 < 1800) {
            return null;
        }
        return CalculationUtil.makeDateRAW(n3, n2, n1);
    }

    public static Date makeDate(int year, int month, int day) throws Exception {
        Date d = CalculationUtil.makeDateRAW(year, month, day);
        if (d == null) {
            throw new ELException("The date " + year + "/" + month + "/" + day + " (yyyy/mm/dd) is invalid.");
        }
        return d;
    }

    public static Date makeDateRAW(int year, int month, int day) {
        GregorianCalendar cal;
        if (year >= 1800 && year <= 2200 && month >= 1 && month <= 12 && day >= 1 && day <= 31 && (cal = new GregorianCalendar(year, month - 1, day, 0, 0, 0)).get(5) == day) {
            return cal.getTime();
        }
        return null;
    }

    private static final void wrongDateFormatError(String str) throws ELException {
        throw new ELException("The date '" + str + "' is invalid. Use format yyyy mm dd");
    }

    private static final void wrongDateTimeFormatError(String str) throws ELException {
        throw new ELException("The date '" + str + "' is invalid. Use format dd-mm-yyyy hh-mm ");
    }

    private static int skippy(String s, int len, int ix) {
        while (ix < len) {
            char c = s.charAt(ix);
            if (Character.isDigit(c) || Character.isLetter(c)) {
                return ix;
            }
            ++ix;
        }
        return ix;
    }

    public static boolean isFutureDate(Date a) {
        return a.after(new Date());
    }

    public static BigDecimal convertToMoney(Locale loc, String s) throws ELException {
        int ix;
        s = s.trim();
        DecimalFormatSymbols df = new DecimalFormatSymbols(loc);
        char dp = df.getMonetaryDecimalSeparator();
        char thou = df.getGroupingSeparator();
        StringBuilder sb = new StringBuilder(20);
        char c = '\u0000';
        int len = s.length();
        for (ix = 0; ix < len && (c = s.charAt(ix)) != '+' && c != '-' && !Character.isDigit(c); ++ix) {
        }
        if (ix >= len) {
            return null;
        }
        sb.append(' ');
        boolean minus = false;
        if (c == '-') {
            minus = true;
            ++ix;
        }
        int lastthou = 0;
        long val = 0L;
        long pval = 0L;
        int opos = ix;
        while (ix < len) {
            c = s.charAt(ix);
            if (Character.isDigit(c)) {
                if ((val = val * 10L + (long)(c - 48)) < pval) {
                    return null;
                }
                pval = val;
                sb.append(c);
            } else {
                if (c == dp) {
                    if (lastthou <= 0 || ix - lastthou == 4) break;
                    return null;
                }
                if (c != thou) break;
                if (lastthou == 0) {
                    lastthou = ix;
                } else {
                    if (ix - lastthou != 4) {
                        return null;
                    }
                    lastthou = ix;
                }
            }
            ++ix;
        }
        if (ix == opos) {
            return null;
        }
        long frac = 0L;
        int fracfac = 1;
        if (ix < len) {
            if (c == dp) {
                opos = ++ix;
                while (ix < len && Character.isDigit(c = s.charAt(ix))) {
                    frac = frac * 10L + (long)(c - 48);
                    fracfac *= 10;
                    if (ix == opos) {
                        sb.append('.');
                    }
                    sb.append(c);
                    ++ix;
                }
                int ndec = df.getCurrency().getDefaultFractionDigits();
                if (ix - opos > ndec) {
                    return null;
                }
            }
            while (ix < len) {
                c = s.charAt(ix);
                if (Character.isDigit(c)) {
                    return null;
                }
                if (c == '-') {
                    minus = true;
                }
                ++ix;
            }
        }
        if (minus) {
            sb.setCharAt(0, '-');
            return new BigDecimal(sb.toString());
        }
        return new BigDecimal(sb.substring(1));
    }

    public static String convertToMoneyString(Locale loc, BigDecimal n, boolean dofraction, boolean addmonetary) {
        char c;
        DecimalFormatSymbols df = new DecimalFormatSymbols(loc);
        NumberFormat nf = addmonetary ? NumberFormat.getCurrencyInstance(loc) : NumberFormat.getNumberInstance(loc);
        String s = nf.format(n);
        int len = s.length();
        int dpos = s.indexOf(df.getMonetaryDecimalSeparator());
        if (dpos == -1) {
            dpos = len;
        }
        StringBuilder sb = new StringBuilder(s.length() + 4);
        sb.append(s, 0, dpos);
        if (!dofraction) {
            ++dpos;
            while (dpos < len && Character.isDigit(s.charAt(dpos))) {
                ++dpos;
            }
            if (dpos < len) {
                sb.append(s, dpos, len);
            }
            return sb.toString();
        }
        sb.append(df.getMonetaryDecimalSeparator());
        ++dpos;
        int nfd = 0;
        while (dpos < len && Character.isDigit(c = s.charAt(dpos))) {
            ++dpos;
            sb.append(c);
            ++nfd;
        }
        while (nfd++ < df.getCurrency().getDefaultFractionDigits()) {
            sb.append('0');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        BigDecimal bd = new BigDecimal("12345678.12");
        System.out.println("Money for " + bd + " is " + CalculationUtil.convertToMoneyString(LOC, bd, true, true));
        bd = new BigDecimal("1000");
        System.out.println("Money for " + bd + " is " + CalculationUtil.convertToMoneyString(LOC, bd, true, true));
        System.out.println("Money for " + bd + " is " + CalculationUtil.convertToMoneyString(LOC, bd, true, false));
        System.out.println("Money for " + bd + " is " + CalculationUtil.convertToMoneyString(LOC, bd, false, false));
        bd = new BigDecimal("12312");
        System.out.println("Money for " + bd + " is " + CalculationUtil.convertToMoneyString(LOC, bd, true, true));
        System.out.println("Money for " + bd + " is " + CalculationUtil.convertToMoneyString(LOC, bd, true, false));
        System.out.println("Money for " + bd + " is " + CalculationUtil.convertToMoneyString(LOC, bd, false, false));
    }
}

