/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.StringTool;

public class ClassPathScanner {
    private static ClassPathScanner m_instance;
    private List<ClassLoader> m_classLoaders = new ArrayList<ClassLoader>();
    private List<URL> m_urls = new ArrayList<URL>();
    @Nonnull
    private List<IPathEntry> m_entryList = new ArrayList<IPathEntry>();
    @Nonnull
    private List<IClassFileEntry> m_classFileEntryList = new ArrayList<IClassFileEntry>();
    @Nonnull
    private List<IClassEntry> m_classEntryList = new ArrayList<IClassEntry>();
    private int m_nentries;
    private int m_nclasses;

    @Nonnull
    public static synchronized ClassPathScanner getInstance() {
        ClassPathScanner cs = m_instance;
        if (null == cs) {
            cs = m_instance = new ClassPathScanner();
            cs.addClassloader(cs.getClass().getClassLoader());
        }
        return cs;
    }

    public void addListener(@Nonnull IPathEntry pe) {
        this.m_entryList.add(pe);
    }

    public void addListener(@Nonnull IClassFileEntry pe) {
        this.m_classFileEntryList.add(pe);
    }

    public void addListener(@Nonnull IClassEntry pe) {
        this.m_classEntryList.add(pe);
    }

    public void addClassloader(@Nonnull ClassLoader classLoader) {
        ClassLoader npc;
        ClassLoader pc = classLoader;
        do {
            if (this.m_classLoaders.contains(classLoader)) {
                return;
            }
            this.m_classLoaders.add(classLoader);
        } while ((npc = classLoader.getParent()) != null && npc != pc);
    }

    public void addUrl(@Nonnull URL url) {
        this.m_urls.add(url);
    }

    @Nonnull
    private List<File> findEntriesFor(@Nonnull ClassLoader cl) throws Exception {
        if (!(cl instanceof URLClassLoader)) {
            return Collections.EMPTY_LIST;
        }
        URLClassLoader ucl = (URLClassLoader)cl;
        URL[] ar = ucl.getURLs();
        ArrayList<File> res = new ArrayList<File>();
        for (URL u : ar) {
            File f = new File(u.toURI());
            if (!f.exists()) continue;
            res.add(f);
        }
        return res;
    }

    public void scan() throws Exception {
        long ts = System.nanoTime();
        HashSet<String> allset = new HashSet<String>();
        for (ClassLoader cl : this.m_classLoaders) {
            List<File> flist = this.findEntriesFor(cl);
            for (File pathEntry : flist) {
                String fpn = pathEntry.getAbsolutePath();
                if (!allset.add(fpn)) continue;
                this.scanPathEntry(pathEntry, cl);
            }
        }
        for (URL u : this.m_urls) {
            String fpn;
            File f = new File(u.toURI());
            if (!f.exists()) continue;
            URLClassLoader cl = null;
            if (this.m_classEntryList.size() > 0) {
                cl = new URLClassLoader(new URL[]{f.toURI().toURL()});
            }
            if (!allset.add(fpn = f.getAbsolutePath())) continue;
            this.scanPathEntry(f, cl);
        }
        ts = System.nanoTime() - ts;
        System.out.println("classpath: scanned " + this.m_nentries + " entries containing " + this.m_nclasses + " classes in " + StringTool.strNanoTime(ts));
    }

    private void scanPathEntry(@Nonnull File pathEntry, @Nullable ClassLoader loader) throws Exception {
        for (IPathEntry pe : this.m_entryList) {
            pe.foundPathEntry(pathEntry);
        }
        if (this.m_classEntryList.size() > 0 || this.m_classFileEntryList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            try {
                ++this.m_nentries;
                if (pathEntry.isDirectory()) {
                    this.scanDir(sb, pathEntry, pathEntry, loader);
                } else {
                    this.scanJar(pathEntry, loader);
                }
            }
            catch (Exception x) {
                System.err.println("classpathScanner: While scanning " + pathEntry + ": " + x);
                throw x;
            }
        }
    }

    private void scanDir(@Nonnull StringBuilder sb, @Nonnull File directory, @Nonnull File classPathDirectory, @Nullable ClassLoader loader) throws Exception {
        int len = sb.length();
        for (File f : directory.listFiles()) {
            sb.setLength(len);
            if (len > 0) {
                sb.append('/');
            }
            sb.append(f.getName());
            if (f.isDirectory()) {
                this.scanDir(sb, f, classPathDirectory, loader);
                continue;
            }
            this.scanFileEntry(loader, classPathDirectory, f, sb.toString());
        }
    }

    private void scanFileEntry(@Nullable ClassLoader loader, @Nonnull File classPathDirectory, @Nonnull File f, @Nonnull String name) throws Exception {
        for (IClassFileEntry fe : this.m_classFileEntryList) {
            fe.foundFile(classPathDirectory, f, name);
        }
        ++this.m_nclasses;
        if (null != loader) {
            this.scanClass(loader, classPathDirectory, name);
        }
    }

    private void scanJarEntry(@Nullable ClassLoader loader, @Nonnull File jar, @Nonnull String name, @Nonnull ZipInputStream zis) throws Exception {
        for (IClassFileEntry fe : this.m_classFileEntryList) {
            fe.foundJarEntry(jar, name, zis);
        }
        ++this.m_nclasses;
        if (null != loader) {
            this.scanClass(loader, jar, name);
        }
    }

    private void scanClass(@Nonnull ClassLoader loader, @Nonnull File classPathDirectory, @Nonnull String name) throws Exception {
        Class<?> clz;
        if (!name.endsWith(".class")) {
            return;
        }
        name = name.substring(0, name.length() - 6);
        name = name.replace('/', '.');
        try {
            clz = loader.loadClass(name);
        }
        catch (Exception x) {
            return;
        }
        catch (Error x) {
            return;
        }
        for (IClassEntry ce : this.m_classEntryList) {
            ce.foundClass(classPathDirectory, clz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJar(@Nonnull File jar, @Nullable ClassLoader loader) throws Exception {
        FileInputStream fis = new FileInputStream(jar);
        ZipInputStream zis = null;
        try {
            ZipEntry ze;
            zis = new ZipInputStream(fis);
            while (null != (ze = zis.getNextEntry())) {
                if (ze.isDirectory()) continue;
                this.scanJarEntry(loader, jar, ze.getName(), zis);
            }
        }
        finally {
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Exception exception) {}
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    public static interface IClassEntry {
        public void foundClass(@Nonnull File var1, @Nonnull Class<?> var2) throws Exception;
    }

    public static interface IClassFileEntry {
        public void foundFile(@Nonnull File var1, @Nonnull File var2, @Nonnull String var3) throws Exception;

        public void foundJarEntry(@Nonnull File var1, @Nonnull String var2, @Nonnull ZipInputStream var3) throws Exception;
    }

    public static interface IPathEntry {
        public void foundPathEntry(@Nonnull File var1) throws Exception;
    }
}

