/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.util.ArrayList;
import java.util.List;

public class CmdStringDecoder {
    private String m_cmd;
    private List<String> m_argv;
    private int m_ix;
    private int m_sl;
    private int m_curr_ix;

    public CmdStringDecoder(String cmd) {
        this.decode(cmd);
    }

    private String getWord() {
        char c;
        char c2;
        while (this.m_ix < this.m_sl && ((c2 = this.m_cmd.charAt(this.m_ix)) == ' ' || c2 == '\t')) {
            ++this.m_ix;
        }
        char sc = this.m_cmd.charAt(this.m_ix);
        if (sc == '\"' || sc == '\'') {
            ++this.m_ix;
            int sp = this.m_ix;
            while (this.m_ix < this.m_sl && this.m_cmd.charAt(this.m_ix) != sc) {
                ++this.m_ix;
            }
            String rv = this.m_cmd.substring(sp, this.m_ix);
            ++this.m_ix;
            return rv;
        }
        int sp = this.m_ix;
        while (this.m_ix < this.m_sl && (c = this.m_cmd.charAt(this.m_ix)) != ' ' && c != '\t') {
            ++this.m_ix;
        }
        return this.m_cmd.substring(sp, this.m_ix);
    }

    private void initSlicer(String cmd) {
        this.m_cmd = cmd;
        this.m_ix = 0;
        this.m_sl = cmd.length();
    }

    private void decode(String cmd) {
        this.m_argv = new ArrayList<String>();
        this.initSlicer(cmd);
        while (this.m_ix < this.m_sl) {
            String c = this.getWord();
            this.m_argv.add(c.trim());
        }
    }

    public boolean hasMore() {
        return this.m_curr_ix < this.m_argv.size();
    }

    public void reset() {
        this.m_curr_ix = 0;
    }

    public String getCurr() {
        if (!this.hasMore()) {
            return "";
        }
        return this.m_argv.get(this.m_curr_ix);
    }

    public String getNext() {
        if (!this.hasMore()) {
            return "";
        }
        String v = this.getCurr();
        ++this.m_curr_ix;
        return v;
    }

    public boolean currIs(String txt) {
        if (!this.hasMore()) {
            return false;
        }
        int ix = 0;
        int len = txt.length();
        while (ix < len) {
            String name;
            int pos = txt.indexOf(124, ix);
            if (pos == -1) {
                name = txt.substring(ix);
                ix = len;
            } else {
                name = txt.substring(ix, pos);
                ix = pos + 1;
            }
            String a = this.getCurr();
            if (name.endsWith("*")) {
                String m = name.substring(0, name.length() - 1);
                if (a.length() > m.length()) {
                    a = a.substring(0, m.length());
                }
                if (a.equalsIgnoreCase(m)) {
                    ++this.m_curr_ix;
                    return true;
                }
            }
            if (!name.equalsIgnoreCase(a)) continue;
            ++this.m_curr_ix;
            return true;
        }
        return false;
    }

    public int currInt() {
        if (!this.hasMore()) {
            throw new IllegalArgumentException("Missing integer argument");
        }
        try {
            return Integer.parseInt(this.getCurr().trim());
        }
        catch (Exception x) {
            throw new IllegalArgumentException("Missing or bad integer argument");
        }
    }

    public boolean currIsInt() {
        if (!this.hasMore()) {
            return false;
        }
        try {
            Integer.parseInt(this.getCurr().trim());
            return true;
        }
        catch (Exception x) {
            return false;
        }
    }
}

