/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.IOException;
import java.io.InputStream;

public class CompoundInputStream
extends InputStream {
    private final InputStream[] m_sourceList;
    private InputStream m_is;
    private int m_currentIndex;
    private boolean m_eof;

    public CompoundInputStream(InputStream ... isar) {
        this.m_sourceList = isar;
        if (isar.length == 0) {
            this.m_eof = true;
        } else {
            this.m_is = isar[0];
        }
    }

    @Override
    public int read() throws IOException {
        while (!this.atEof()) {
            int val = this.m_is.read();
            if (val != -1) {
                return val;
            }
            ++this.m_currentIndex;
            if (this.m_currentIndex >= this.m_sourceList.length) {
                this.m_eof = true;
                return -1;
            }
            this.m_is = this.m_sourceList[this.m_currentIndex];
        }
        return -1;
    }

    private boolean atEof() {
        return this.m_eof;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int szleft = len;
        int read = 0;
        while (szleft > 0) {
            if (this.atEof()) {
                return read > 0 ? read : -1;
            }
            int szread = this.m_is.read(b, off, szleft);
            if (szread > 0) {
                off += szread;
                szleft -= szread;
                read += szread;
                continue;
            }
            ++this.m_currentIndex;
            if (this.m_currentIndex >= this.m_sourceList.length) {
                this.m_eof = true;
                continue;
            }
            this.m_is = this.m_sourceList[this.m_currentIndex];
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Unsupported");
    }

    @Override
    public void close() throws IOException {
        for (InputStream is : this.m_sourceList) {
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new IllegalStateException("Unsupported");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("Unsupported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

