/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DeveloperOptions {
    private static boolean m_isdeveloper;
    @Nullable
    private static Properties m_p;
    @Nonnull
    private static Set<String> m_warnedSet;

    private DeveloperOptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initialize() {
        String s = System.getProperty("user.home");
        if (s == null) {
            System.out.println("DeveloperOptions: user.home is not set??");
        } else {
            String prevent = System.getProperty("developer.properties");
            if ("false".equalsIgnoreCase(prevent)) {
                return;
            }
            File f = new File(new File(s), ".developer.properties");
            if (!f.exists()) {
                return;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                Properties p = new Properties();
                p.load(is);
                m_p = p;
                System.out.println("WARNING: " + f + " used for DEVELOPMENT-TIME OPTIONS!!");
                m_isdeveloper = DeveloperOptions.getBool("developer.workstation", true);
            }
            catch (Exception x) {
                System.out.println("DeveloperOptions: exception while reading " + f + ": " + x);
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public static synchronized boolean isDeveloperWorkstation() {
        return m_isdeveloper;
    }

    @Nullable
    public static synchronized String getString(@Nonnull String name) {
        return DeveloperOptions.internalGetString(name);
    }

    @Nonnull
    public static synchronized String getString(@Nonnull String name, @Nonnull String def) {
        String s = DeveloperOptions.internalGetString(name);
        return s == null ? def : s;
    }

    public static synchronized boolean getBool(@Nonnull String name, boolean def) {
        String s = DeveloperOptions.internalGetString(name);
        if (null == s) {
            return def;
        }
        return (s = s.toLowerCase()).startsWith("t") || s.startsWith("y");
    }

    public static synchronized int getInt(@Nonnull String name, int def) {
        String s = DeveloperOptions.internalGetString(name);
        if (null == s) {
            return def;
        }
        return Integer.decode(s.trim());
    }

    @Nullable
    private static synchronized String internalGetString(@Nonnull String name) {
        Properties p = m_p;
        if (null == p) {
            return null;
        }
        String value = p.getProperty(name);
        if (null == value) {
            return null;
        }
        if (m_warnedSet.add(name)) {
            System.out.println("WARNING: Development-time option " + name + " changed to " + value);
        }
        return value;
    }

    public static boolean isBackGroundDisabled() {
        return !DeveloperOptions.getBool("domui.background", true);
    }

    static {
        m_warnedSet = new HashSet<String>();
        DeveloperOptions.initialize();
    }
}

