/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.DefaultNonNull;

@DefaultNonNull
public class FileIterator
implements Iterator<Entry>,
Iterable<Entry> {
    private final File m_root;
    private StringBuilder m_pathSb = new StringBuilder();
    private final List<Level> m_levelStack = new ArrayList<Level>();
    private boolean m_lastPopped;

    public FileIterator(File root) {
        this.m_root = root;
        File[] files = root.listFiles();
        if (files != null && files.length != 0) {
            this.m_levelStack.add(new Level(files, ""));
        }
    }

    private Level getCurrentLevel() {
        return this.m_levelStack.get(this.m_levelStack.size() - 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("I do not like it that you remove files, yet.");
    }

    @Override
    public boolean hasNext() {
        return this.m_levelStack.size() > 0;
    }

    @Override
    public Entry next() {
        if (this.m_levelStack.size() == 0) {
            throw new IllegalStateException("No (more) entries");
        }
        Level l = this.getCurrentLevel();
        File file = l.current();
        Type type = file.isDirectory() ? (this.m_lastPopped ? Type.DirectoryAfter : Type.DirectoryBefore) : Type.File;
        Entry entry = new Entry(type, file, this.makePath(l.getRelativePath(), file.getName()));
        this.moveToNext();
        return entry;
    }

    private void moveToNext() {
        Level l = this.getCurrentLevel();
        if (l.eof()) {
            return;
        }
        File file = l.current();
        if (!this.m_lastPopped && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files.length > 0) {
                Level nl = new Level(files, this.makePath(l.getRelativePath(), file.getName()));
                this.m_levelStack.add(nl);
            } else {
                this.m_lastPopped = true;
            }
            return;
        }
        this.m_lastPopped = false;
        l.next();
        if (!l.eof()) {
            return;
        }
        this.m_levelStack.remove(this.m_levelStack.size() - 1);
        this.m_lastPopped = true;
    }

    private String makePath(String a, String b) {
        this.m_pathSb.setLength(0);
        this.m_pathSb.append(a);
        if (a.length() != 0) {
            this.m_pathSb.append(File.separatorChar);
        }
        this.m_pathSb.append(b);
        return this.m_pathSb.toString();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this;
    }

    public static void main(String[] args) throws Exception {
        File f = new File("/tmp");
        int count = 0;
        for (Entry e : new FileIterator(f)) {
            System.out.println((Object)((Object)e.getType()) + " " + e.getRelativePath());
            if (e.getType() != Type.File) continue;
            ++count;
        }
        System.out.println("Got " + count + " files");
    }

    private static class Level {
        private final File[] m_files;
        private final String m_relativePath;
        private int m_index;

        public Level(File[] files, String relativePath) {
            this.m_files = files;
            this.m_relativePath = relativePath;
        }

        private boolean eof() {
            return this.m_index >= this.m_files.length;
        }

        public int getIndex() {
            return this.m_index;
        }

        public void next() {
            ++this.m_index;
        }

        public File current() {
            if (this.eof()) {
                throw new IllegalStateException();
            }
            return this.m_files[this.m_index];
        }

        public String getRelativePath() {
            return this.m_relativePath;
        }
    }

    public static final class Entry {
        private final File m_entry;
        private final String m_relativePath;
        private final Type m_type;

        public Entry(Type type, File entry, String relativePath) {
            this.m_type = type;
            this.m_entry = entry;
            this.m_relativePath = relativePath;
        }

        public Type getType() {
            return this.m_type;
        }

        public File getEntry() {
            return this.m_entry;
        }

        public String getRelativePath() {
            return this.m_relativePath;
        }
    }

    public static enum Type {
        DirectoryBefore,
        DirectoryAfter,
        File;

    }
}

