/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import to.etc.util.ClassUtil;
import to.etc.util.IDirectoryDelta;
import to.etc.util.ILogSink;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;
import to.etc.xml.DomTools;

public class FileTool {
    private static final Logger LOG = LoggerFactory.getLogger(FileTool.class);
    private static long m_seed_ts = System.currentTimeMillis();
    private static long m_index;

    private FileTool() {
    }

    @Nonnull
    public static synchronized File getLogRoot(@Nonnull String appVar) {
        String name = appVar.toUpperCase().replace(".", "").replace("-", "");
        String s = System.getProperty(appVar);
        File logRoot = FileTool.checkLogDir(s, "The java system property '" + appVar + "'");
        if (null == logRoot) {
            s = System.getenv(name);
            FileTool.checkLogDir(s, "The environment variable '" + name + "'");
        }
        if (null == logRoot) {
            s = System.getProperty("java.io.tmpdir");
            logRoot = FileTool.checkLogDir(s, "Java's tmpdir location");
        }
        if (null == logRoot) {
            s = System.getenv("TMP");
            logRoot = FileTool.checkLogDir(s, "The environment variable 'TMP'");
        }
        if (null == logRoot) {
            s = System.getenv("TEMP");
            logRoot = FileTool.checkLogDir(s, "The environment variable 'TEMP'");
        }
        if (null == logRoot) {
            logRoot = FileTool.checkLogDir("/tmp", "The system /tmp directory");
        }
        if (null == logRoot) {
            throw new RuntimeException("None of the log directories can be found!! Please specify a proper one using " + appVar + " property, " + name + " envvar or normal UNIX conventions");
        }
        return logRoot.getAbsoluteFile();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static File checkLogDir(@Nonnull String s, @Nonnull String source) {
        if (null == s) return null;
        if (s.trim().length() <= 0) return null;
        File f = new File(s);
        if (f.exists()) {
            if (f.isDirectory()) return f;
            System.out.println("init: " + source + " is set to '" + s + "', but that is not a directory. Ignoring the parameter...");
            return null;
        }
        if (!f.mkdirs()) {
            System.out.println("init: " + source + " is set to '" + s + "', but that directory does not exist and I cannot create it. Ignoring the parameter...");
            return null;
        }
        System.out.println("init: " + source + " is set to '" + s + "', but the directory was not present. I created it, please check it's permissions.");
        return f;
    }

    public static File getTmpDir() {
        File tmp;
        String v = System.getenv("java.io.tmpdir");
        if (v == null) {
            v = "/tmp";
        }
        if (!(tmp = new File(v)).exists() || !tmp.isDirectory()) {
            throw new IllegalStateException("The 'java.io.tmpdir' variable does not point to an existing directory (" + tmp + ")");
        }
        return tmp;
    }

    public static synchronized File newDir(File root) {
        String fn;
        File of;
        while ((of = new File(root, fn = FileTool.makeName("td"))).exists()) {
        }
        of.mkdirs();
        return of;
    }

    public static synchronized File makeTempFile(File root) {
        String fn;
        File of;
        while ((of = new File(root, fn = FileTool.makeName("tf"))).exists()) {
        }
        try {
            of.createNewFile();
        }
        catch (Exception x) {
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new WrappedException(x);
        }
        return of;
    }

    private static String makeName(String type) {
        StringBuffer sb = new StringBuffer(32);
        sb.append(type);
        FileTool.add36(sb, m_seed_ts);
        sb.append('-');
        FileTool.add36(sb, m_index++);
        return sb.toString();
    }

    private static void add36(StringBuffer sb, long v) {
        if (v > 36L) {
            FileTool.add36(sb, v / 36L);
        }
        if ((v %= 36L) < 10L) {
            sb.append((char)(v + 48L));
        } else {
            sb.append((char)(v - 10L + 97L));
        }
    }

    public static boolean dirEmpty(File dirf) {
        return FileTool.dirEmpty(dirf, null);
    }

    public static void deleteDir(File f) {
        FileTool.dirEmpty(f);
        f.delete();
    }

    public static void prepareDir(File dir) throws Exception {
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                return;
            }
            throw new Exception("unable to create directory: " + dir.getPath());
        }
        if (!FileTool.dirEmpty(dir)) {
            throw new Exception("unable to empty the directory: " + dir.getPath());
        }
    }

    @Deprecated
    public static boolean dirEmpty(File dirf, Vector<Object> elogb) {
        boolean hase = false;
        File[] ar = dirf.listFiles();
        if (ar == null) {
            return true;
        }
        for (int i = 0; i < ar.length; ++i) {
            String name = ar[i].getName();
            if (name.equals(".") || name.equals("..")) continue;
            try {
                if (ar[i].isDirectory()) {
                    FileTool.dirEmpty(ar[i], elogb);
                }
                if (ar[i].delete()) continue;
                throw new IOException("Delete failed?");
            }
            catch (IOException x) {
                if (elogb != null) {
                    elogb.add(dirf);
                    elogb.add(x);
                }
                hase = true;
            }
        }
        return !hase;
    }

    @Nonnull
    public static String getFileExtension(String fn) {
        int p;
        int s1 = fn.lastIndexOf(47);
        int s2 = fn.lastIndexOf(92);
        if (s2 > s1) {
            s1 = s2;
        }
        if (s1 == -1) {
            s1 = 0;
        }
        if ((p = fn.lastIndexOf(46)) < s1) {
            return "";
        }
        return fn.substring(p + 1);
    }

    public static int findFilenameExtension(String fn) {
        int dp;
        int slp = fn.lastIndexOf(47);
        int t = fn.lastIndexOf(92);
        if (t > slp) {
            slp = t;
        }
        if ((dp = fn.lastIndexOf(46)) < t) {
            return -1;
        }
        return dp;
    }

    @Nonnull
    public static String fileNameSansExtension(String fn) {
        int dp;
        int slp = fn.lastIndexOf(47);
        int t = fn.lastIndexOf(92);
        if (t > slp) {
            slp = t;
        }
        if ((dp = fn.lastIndexOf(46)) < t) {
            return fn;
        }
        return fn.substring(0, dp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File destf, File srcf) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(srcf);
            os = new FileOutputStream(destf);
            FileTool.copyFile(os, is);
            destf.setLastModified(srcf.lastModified());
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void copyFile(OutputStream os, InputStream is) throws IOException {
        int sz;
        byte[] buf = new byte[8192];
        while (0 < (sz = is.read(buf))) {
            os.write(buf, 0, sz);
        }
    }

    public static void copyFile(Writer w, Reader r) throws IOException {
        int sz;
        char[] buf = new char[8192];
        while (0 < (sz = r.read(buf))) {
            w.write(buf, 0, sz);
        }
    }

    public static void copyDir(File destd, File srcd) throws IOException {
        File[] ar;
        if (!srcd.exists()) {
            return;
        }
        if (srcd.isFile()) {
            FileTool.copyFile(destd, srcd);
            return;
        }
        if (destd.exists() && destd.isFile()) {
            destd.delete();
        }
        destd.mkdirs();
        for (File sf : ar = srcd.listFiles()) {
            File df = new File(destd, sf.getName());
            if (sf.isFile()) {
                if (df.isDirectory()) {
                    FileTool.deleteDir(df);
                }
                FileTool.copyFile(df, sf);
                continue;
            }
            if (!sf.isDirectory()) continue;
            if (df.isFile()) {
                df.delete();
            }
            FileTool.copyDir(df, sf);
        }
    }

    public static void copyHardlinked(@Nonnull File targetDir, @Nonnull File sourceDir, String ... ignorePaths) throws IOException {
        if (!sourceDir.exists()) {
            return;
        }
        if (targetDir.exists()) {
            if (targetDir.isFile()) {
                targetDir.delete();
            } else {
                FileTool.dirEmpty(targetDir);
            }
        }
        if (sourceDir.isFile()) {
            FileTool.hardlinkFile(new File(targetDir, sourceDir.getName()), sourceDir);
            return;
        }
        HashSet<String> ignoreSet = new HashSet<String>();
        for (String s : ignorePaths) {
            ignoreSet.add(s);
        }
        targetDir.mkdirs();
        StringBuilder sb = new StringBuilder();
        FileTool.internalCopyHardDir(targetDir, sourceDir, sb, ignoreSet);
    }

    private static void internalCopyHardDir(@Nonnull File targetDir, @Nonnull File sourceDir, @Nonnull StringBuilder sb, @Nonnull Set<String> ignoreSet) throws IOException {
        File[] ar = sourceDir.listFiles();
        if (null == ar) {
            return;
        }
        int len = sb.length();
        for (File f : ar) {
            File destf = new File(targetDir, f.getName());
            sb.setLength(len);
            if (len > 0) {
                sb.append("/");
            }
            sb.append(f.getName());
            if (ignoreSet.contains(sb.toString())) continue;
            if (f.isFile()) {
                FileTool.hardlinkFile(destf, f);
                continue;
            }
            destf.mkdirs();
            FileTool.internalCopyHardDir(destf, f, sb, ignoreSet);
        }
    }

    private static void hardlinkFile(@Nonnull File destf, @Nonnull File srcf) throws IOException {
        Files.createLink(destf.toPath(), srcf.toPath());
    }

    public static String readFileAsString(File f) throws Exception {
        StringBuilder sb = new StringBuilder((int)f.length() + 20);
        FileTool.readFileAsString(sb, f);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileAsByteArray(@Nonnull File file) throws IOException {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            int intSize = FileTool.getIntSizeOfFile(file);
            byte[] data = new byte[intSize];
            in.read(data);
            byArray = data;
        }
        catch (Throwable throwable) {
            FileTool.closeAll(in);
            throw throwable;
        }
        FileTool.closeAll(in);
        return byArray;
    }

    @Nonnull
    public static byte[] readByteArray(@Nonnull InputStream is) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileTool.copyFile(baos, is);
        baos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static byte[] readResourceAsByteArray(@Nonnull Class<?> clz, @Nonnull String name) throws IOException {
        byte[] byArray;
        InputStream is = clz.getResourceAsStream(name);
        if (null == is) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileTool.copyFile(baos, is);
            baos.close();
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            FileTool.closeAll(is);
            throw throwable;
        }
        FileTool.closeAll(is);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFileAsString(Appendable o, File f) throws Exception {
        try (LineNumberReader lr = new LineNumberReader(new FileReader(f));){
            String line;
            while (null != (line = lr.readLine())) {
                o.append(line);
                o.append("\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File f, String encoding) throws Exception {
        try (FileInputStream is = null;){
            is = new FileInputStream(f);
            String string = FileTool.readStreamAsString(is, encoding);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readHeadAndTail(StringBuffer sb, File f, int headsize, int tailsize) throws Exception {
        BufferedReader lr = null;
        String[] ring = null;
        int ringix = 0;
        int linecount = 0;
        try {
            String line;
            lr = new LineNumberReader(new FileReader(f));
            while (null != (line = ((LineNumberReader)lr).readLine())) {
                ++linecount;
                if (ring != null) {
                    if (ringix == tailsize) {
                        ringix = 0;
                    }
                    ring[ringix++] = line;
                    continue;
                }
                sb.append(line);
                sb.append('\n');
                if (linecount <= headsize) continue;
                ring = new String[tailsize];
            }
            if (ring != null) {
                if (linecount > headsize + tailsize) {
                    sb.append("\n ...\n ...\n ...");
                    sb.append(linecount - headsize - tailsize);
                    sb.append(" lines were skipped ...\n ...\n ...\n");
                }
                if (ringix == tailsize) {
                    ringix = 0;
                }
                if (ring[ringix] == null) {
                    for (int ix = 0; ix < ringix - 1; ++ix) {
                        sb.append(ring[ix]);
                        sb.append('\n');
                    }
                } else {
                    for (int ct = 0; ct < tailsize; ++ct) {
                        sb.append(ring[ringix++]);
                        sb.append('\n');
                        if (ringix != tailsize) continue;
                        ringix = 0;
                    }
                }
            }
        }
        finally {
            try {
                if (lr != null) {
                    lr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static File copyStreamToTmpFile(InputStream is, String name) throws Exception {
        File file = new File(FileTool.getTmpDir(), name);
        return FileTool.copyStreamToFile(is, file);
    }

    public static File copyStreamToTmpFile(InputStream is) throws Exception {
        File file = FileTool.makeTempFile(FileTool.getTmpDir());
        return FileTool.copyStreamToFile(is, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyStreamToFile(InputStream is, File file) throws FileNotFoundException, IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            FileTool.copyFile(os, is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception exception) {}
        }
        return file;
    }

    public static String readStreamAsString(InputStream is, String enc) throws Exception {
        StringBuilder sb = new StringBuilder(128);
        FileTool.readStreamAsString(sb, is, enc);
        return sb.toString();
    }

    public static void readStreamAsString(Appendable o, InputStream f, String enc) throws Exception {
        InputStreamReader r = new InputStreamReader(f, enc);
        FileTool.readStreamAsString(o, r);
    }

    public static void readStreamAsString(Appendable o, Reader r) throws Exception {
        int ct;
        char[] buf = new char[4096];
        while ((ct = r.read(buf)) >= 0) {
            o.append(new String(buf, 0, ct));
        }
    }

    public static String readStreamAsString(Reader r) throws Exception {
        StringBuilder sb = new StringBuilder(128);
        FileTool.readStreamAsString(sb, r);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileFromString(File f, String v, String enc) throws Exception {
        try (FileOutputStream os = new FileOutputStream(f);){
            FileTool.writeFileFromString(os, v, enc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileFromString(OutputStream os, String v, String enc) throws Exception {
        try (OutputStreamWriter w = new OutputStreamWriter(os, enc == null ? "UTF8" : enc);){
            w.write(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static final String readResourceAsString(Class<?> base, String name, String encoding) throws Exception {
        InputStream is = base.getResourceAsStream(name);
        if (null == is) {
            throw new IllegalStateException(base + ":" + name + " resource not found");
        }
        try {
            String string = FileTool.readStreamAsString(is, encoding);
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static byte[] hashFile(File f) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            byte[] byArray = FileTool.hashFile(is);
            return byArray;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Nonnull
    public static byte[] hashBuffers(byte[][] data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException x) {
            throw new RuntimeException("MISSING MANDATORY SECURITY DIGEST PROVIDER MD5: " + x.getMessage());
        }
        for (byte[] b : data) {
            md.update(b);
        }
        return md.digest();
    }

    @Nonnull
    public static String hashBuffersHex(byte[][] data) {
        return StringTool.toHex(FileTool.hashBuffers(data));
    }

    @Nonnull
    public static byte[] hashFile(InputStream is) throws IOException {
        int szrd;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException x) {
            throw new RuntimeException("MISSING MANDATORY SECURITY DIGEST PROVIDER MD5: " + x.getMessage());
        }
        byte[] buf = new byte[8192];
        while (0 <= (szrd = is.read(buf))) {
            md.update(buf, 0, szrd);
        }
        return md.digest();
    }

    @Nonnull
    public static String hashFileHex(File f) throws IOException {
        return StringTool.toHex(FileTool.hashFile(f));
    }

    @Nonnull
    public static String hashFileHex(InputStream is) throws IOException {
        return StringTool.toHex(FileTool.hashFile(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String hashTextFile(@Nonnull File f) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            String string = StringTool.toHex(FileTool.hashTextFile(is));
            return string;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Nonnull
    public static byte[] hashTextFile(@Nonnull InputStream is) throws IOException {
        int szrd;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException x) {
            throw new RuntimeException("MISSING MANDATORY SECURITY DIGEST PROVIDER MD5: " + x.getMessage());
        }
        byte[] buf = new byte[8192];
        while (0 <= (szrd = is.read(buf))) {
            int six = 0;
            int oix = 0;
            while (six < szrd) {
                byte c;
                if ((c = buf[six++]) == 13) continue;
                buf[oix++] = c;
            }
            md.update(buf, 0, oix);
        }
        return md.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Properties loadProperties(File f) throws Exception {
        try (FileInputStream is = new FileInputStream(f);){
            Properties p = new Properties();
            p.load(is);
            Properties properties = p;
            return properties;
        }
    }

    public static void saveProperties(File f, Properties p) throws Exception {
        try (FileOutputStream os = null;){
            os = new FileOutputStream(f);
            p.store(os, "# No comment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFromZip(File f, String name) throws Exception {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(f);
            Properties properties = FileTool.loadPropertiesFromZip(is, name);
            return properties;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFromZip(InputStream is, String name) throws Exception {
        ZipInputStream zis = null;
        OutputStream os = null;
        try {
            ZipEntry ze;
            zis = new ZipInputStream(is);
            while ((ze = zis.getNextEntry()) != null) {
                String n = ze.getName();
                if (n.equalsIgnoreCase(name)) {
                    Properties p = new Properties();
                    p.load(zis);
                    Properties properties = p;
                    return properties;
                }
                zis.closeEntry();
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadXmlFromZip(File f, String name, boolean nsaware) throws Exception {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(f);
            Document document = FileTool.loadXmlFromZip(is, f + "!" + name, name, nsaware);
            return document;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadXmlFromZip(InputStream is, String ident, String name, boolean nsaware) throws Exception {
        ZipInputStream zis = null;
        OutputStream os = null;
        try {
            ZipEntry ze;
            zis = new ZipInputStream(is);
            while ((ze = zis.getNextEntry()) != null) {
                String n = ze.getName();
                if (n.equalsIgnoreCase(name)) {
                    Document document = DomTools.getDocument(zis, ident, nsaware);
                    return document;
                }
                zis.closeEntry();
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static ClassLoader makeJarLoader(File f) throws MalformedURLException {
        URL u = f.toURI().toURL();
        URLClassLoader uc = URLClassLoader.newInstance(new URL[]{u});
        return uc;
    }

    public static ClassLoader makeJarLoader(File f, ClassLoader parent) throws MalformedURLException {
        URL u = f.toURI().toURL();
        URLClassLoader uc = URLClassLoader.newInstance(new URL[]{u}, parent);
        return uc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(Writer w, Class<?> cl, String rid) throws Exception {
        try (Reader r = null;){
            InputStream is = cl.getResourceAsStream(rid);
            if (is == null) {
                throw new IllegalStateException("Missing resource '" + rid + "' at class=" + cl.getName());
            }
            r = new InputStreamReader(is, "utf-8");
            FileTool.copyFile(w, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(File zipfile, File dir) throws Exception {
        if (zipfile.exists() && !zipfile.delete()) {
            throw new IOException("Unable to delete zipfile: " + zipfile);
        }
        ZipOutputStream zos = null;
        InputStream is = null;
        byte[] buf = new byte[8192];
        try {
            zos = new ZipOutputStream(new FileOutputStream(zipfile));
            if (dir.isFile()) {
                FileTool.zipFile(zos, "", dir, buf);
            } else {
                FileTool.zipDir(zos, "", dir, buf);
            }
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void zipDir(ZipOutputStream zos, String base, File f, byte[] buf) throws IOException {
        if (!f.isDirectory()) {
            throw new IllegalStateException("Must be a directory");
        }
        if (base.length() > 0) {
            ZipEntry ze = new ZipEntry(base);
            zos.putNextEntry(ze);
            ze.setTime(f.lastModified());
        }
        File[] far = f.listFiles();
        for (int i = 0; i < far.length; ++i) {
            f = far[i];
            if (f.isFile()) {
                FileTool.zipFile(zos, base, f, buf);
                continue;
            }
            FileTool.zipDir(zos, base + f.getName() + "/", f, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(ZipOutputStream zos, String base, File f, byte[] buf) throws IOException {
        if (!f.isFile()) {
            throw new IllegalStateException(f + ": must be file");
        }
        InputStream is = null;
        try {
            int sz;
            ZipEntry ze = new ZipEntry(base + f.getName());
            ze.setTime(f.lastModified());
            zos.putNextEntry(ze);
            is = new FileInputStream(f);
            while (0 <= (sz = is.read(buf))) {
                zos.write(buf, 0, sz);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void zipAppend(ZipOutputStream zos, String fileName, File f) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            ZipEntry ze = new ZipEntry(fileName);
            ze.setTime(f.lastModified());
            zos.putNextEntry(ze);
            FileTool.copyFile(zos, is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File dest, InputStream is) throws Exception {
        dest.mkdirs();
        ZipInputStream zis = null;
        OutputStream os = null;
        byte[] buf = new byte[8192];
        try {
            ZipEntry ze;
            zis = new ZipInputStream(is);
            while (null != (ze = zis.getNextEntry())) {
                File of = new File(dest, ze.getName());
                if (ze.isDirectory()) {
                    of.mkdirs();
                } else {
                    int sz;
                    File dir = of.getParentFile();
                    dir.mkdirs();
                    os = new FileOutputStream(of);
                    while (0 < (sz = zis.read(buf))) {
                        os.write(buf, 0, sz);
                    }
                    os.close();
                    os = null;
                }
                zis.closeEntry();
            }
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Exception exception) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File dest, File zipfile) throws Exception {
        if (zipfile.length() < 1L) {
            return;
        }
        FileInputStream is = new FileInputStream(zipfile);
        try {
            FileTool.unzip(dest, is);
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static List<String> getZipDirectory(@Nonnull File in) throws Exception {
        ZipInputStream zis = null;
        ArrayList<String> res = new ArrayList<String>();
        try {
            ZipEntry ze;
            zis = new ZipInputStream(new FileInputStream(in));
            while (null != (ze = zis.getNextEntry())) {
                res.add(ze.getName());
                zis.closeEntry();
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        finally {
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static InputStream getZipContent(File src, String name) throws IOException {
        InputStream inputStream;
        block3: {
            FileInputStream is = new FileInputStream(src);
            boolean ok = false;
            try {
                InputStream ris = FileTool.getZipContent(is, name);
                ok = true;
                inputStream = ris;
                if (ok) break block3;
            }
            catch (Throwable throwable) {
                if (!ok) {
                    FileTool.closeAll(is);
                }
                throw throwable;
            }
            FileTool.closeAll(is);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static InputStream getZipContent(final @Nonnull InputStream zipis, @Nonnull String name) throws IOException {
        ZipInputStream zis = null;
        try {
            ZipEntry ze;
            zis = new ZipInputStream(zipis);
            while ((ze = zis.getNextEntry()) != null) {
                String n = ze.getName();
                if (n.equalsIgnoreCase(name)) {
                    final ZipInputStream z = zis;
                    zis = null;
                    InputStream inputStream = new InputStream(){

                        @Override
                        public long skip(long size) throws IOException {
                            return z.skip(size);
                        }

                        @Override
                        public synchronized void reset() throws IOException {
                            z.reset();
                        }

                        @Override
                        public int read(byte[] b) throws IOException {
                            return z.read(b);
                        }

                        @Override
                        public int read(byte[] b, int off, int len) throws IOException {
                            return z.read(b, off, len);
                        }

                        @Override
                        public int read() throws IOException {
                            return z.read();
                        }

                        @Override
                        public void close() throws IOException {
                            z.close();
                            zipis.close();
                            super.close();
                        }

                        @Override
                        public int available() throws IOException {
                            return z.available();
                        }
                    };
                    return inputStream;
                }
                zis.closeEntry();
            }
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Nonnull
    public static byte[][] loadByteBuffers(@Nonnull InputStream is) throws IOException {
        ArrayList<byte[]> al = new ArrayList<byte[]>();
        byte[] buf = new byte[8192];
        int off = 0;
        while (true) {
            int max;
            int sz;
            if ((sz = is.read(buf, off, max = buf.length - off)) == -1) {
                if (off <= 0) break;
                byte[] newbuf = new byte[off];
                System.arraycopy(buf, 0, newbuf, 0, off);
                al.add(newbuf);
                break;
            }
            if ((off += sz) < buf.length) continue;
            al.add(buf);
            off = 0;
            buf = new byte[8192];
        }
        return (byte[][])al.toArray((T[])new byte[al.size()][]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[][] loadByteBuffers(File in) throws IOException {
        FileInputStream is = new FileInputStream(in);
        try {
            byte[][] byArray = FileTool.loadByteBuffers(is);
            return byArray;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File of, byte[][] data) throws IOException {
        FileOutputStream os = new FileOutputStream(of);
        try {
            FileTool.save(os, data);
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            catch (Exception exception) {}
        }
    }

    public static void save(OutputStream os, byte[][] data) throws IOException {
        for (byte[] b : data) {
            os.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static byte[] loadArray(@Nonnull File src) throws IOException {
        byte[] byArray;
        long sz = src.length();
        if (sz > Integer.MAX_VALUE) {
            throw new IOException("File too large (> 2GB)");
        }
        byte[] data = new byte[(int)sz];
        FileInputStream is = new FileInputStream(src);
        try {
            int len = ((InputStream)is).read(data);
            if (len != data.length) {
                throw new IOException("Unexpected end of file after reading " + len + " of " + data.length + " bytes");
            }
            byArray = data;
        }
        catch (Throwable throwable) {
            FileTool.closeAll(is);
            throw throwable;
        }
        FileTool.closeAll(is);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File of, byte[] data) throws IOException {
        FileOutputStream os = new FileOutputStream(of);
        try {
            ((OutputStream)os).write(data);
        }
        finally {
            try {
                ((OutputStream)os).close();
            }
            catch (Exception exception) {}
        }
    }

    public static void writeInt(OutputStream os, int val) throws IOException {
        os.write(val >> 24 & 0xFF);
        os.write(val >> 16 & 0xFF);
        os.write(val >> 8 & 0xFF);
        os.write(val & 0xFF);
    }

    public static void writeLong(OutputStream os, long val) throws IOException {
        FileTool.writeInt(os, (int)(val >> 32));
        FileTool.writeInt(os, (int)(val & 0xFFFFFFFFFFFFFFFFL));
    }

    public static void writeString(OutputStream os, String s) throws IOException {
        if (s == null) {
            s = "";
        }
        byte[] data = s.getBytes("UTF-8");
        FileTool.writeInt(os, data.length);
        os.write(data);
    }

    public static int readInt(InputStream is) throws IOException {
        int v1 = is.read();
        int v2 = is.read();
        int v3 = is.read();
        int v4 = is.read();
        return v1 << 24 | v2 << 16 | v3 << 8 | v4;
    }

    public static long readLong(InputStream is) throws IOException {
        int v1 = FileTool.readInt(is);
        int v2 = FileTool.readInt(is);
        return (long)v1 << 32 | (long)v2 & 0xFFFFFFFFFFFFFFFFL;
    }

    public static String readString(InputStream is) throws IOException {
        int sl = FileTool.readInt(is);
        if (sl < 0) {
            return null;
        }
        byte[] data = new byte[sl];
        if (is.read(data) != sl) {
            throw new IOException("String could not be fully read");
        }
        return new String(data, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream wrapInputStream(InputStream rawStream, ILogSink s, int maxinmemory) throws Exception {
        int szleft;
        File tempfile = null;
        byte[] buf = new byte[maxinmemory];
        InputStream is = rawStream;
        int off = 0;
        while ((szleft = buf.length - off) != 0) {
            int szread = is.read(buf, off, szleft);
            if (szread == -1) {
                StringBuilder sb = new StringBuilder(off * 4);
                sb.append("Raw INPUT dump of the input stream:\n");
                for (int doff = 0; doff < off; doff += 32) {
                    StringTool.arrayToDumpLine(sb, buf, doff, 32);
                    sb.append("\n");
                }
                sb.append("Total size of the input stream is " + off + " bytes\n");
                s.log(sb.toString());
                return new ByteArrayInputStream(buf, 0, off);
            }
            off += szread;
        }
        OutputStream os = null;
        try {
            int szread;
            tempfile = File.createTempFile("soapin", ".bin");
            os = new FileOutputStream(tempfile);
            os.write(buf);
            StringBuilder sb = new StringBuilder(off * 4);
            sb.append("Raw INPUT dump of the input stream:\n");
            for (int doff = 0; doff < buf.length; doff += 32) {
                StringTool.arrayToDumpLine(sb, buf, doff, 32);
                sb.append("\n");
            }
            while ((szread = is.read(buf)) > 0) {
                os.write(buf, 0, szread);
                for (int rlen = 0; rlen < szread; rlen += 32) {
                    StringTool.arrayToDumpLine(sb, buf, rlen, 32);
                    sb.append("\n");
                    doff += 32;
                }
                off += szread;
            }
            os.close();
            os = null;
            sb.append("Total size of the input stream is " + off + " bytes\n");
            s.log(sb.toString());
            final FileInputStream tis = new FileInputStream(tempfile);
            final File del = tempfile;
            tempfile = null;
            InputStream inputStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return tis.read();
                }

                @Override
                public int read(byte[] b, int xoff, int len) throws IOException {
                    return tis.read(b, xoff, len);
                }

                @Override
                public void close() throws IOException {
                    tis.close();
                    del.delete();
                }
            };
            return inputStream;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (tempfile != null) {
                    tempfile.delete();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static InputStream copyAndDumpStream(StringBuilder tgt, InputStream in, String encoding) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
        FileTool.copyFile(bos, in);
        bos.close();
        byte[] data = bos.toByteArray();
        tgt.append(new String(data, encoding));
        return new ByteArrayInputStream(data);
    }

    public static void saveSerialized(@WillClose OutputStream os, Serializable obj) throws IOException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(obj);
            oos.close();
            os = null;
        }
        catch (Throwable throwable) {
            FileTool.closeAll(os);
            throw throwable;
        }
        FileTool.closeAll(os);
    }

    public static void saveSerialized(File f, Serializable obj) throws IOException {
        FileOutputStream os = new FileOutputStream(f);
        try {
            FileTool.saveSerialized(os, obj);
            ((OutputStream)os).close();
            os = null;
        }
        catch (Throwable throwable) {
            FileTool.closeAll(os);
            throw throwable;
        }
        FileTool.closeAll(os);
    }

    @Nullable
    public static Object loadSerialized(@WillNotClose InputStream is) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream iis = null;
        try {
            iis = new ObjectInputStream(is);
            object = iis.readObject();
        }
        catch (Throwable throwable) {
            FileTool.closeAll(iis);
            throw throwable;
        }
        FileTool.closeAll(iis);
        return object;
    }

    @Nullable
    public static Object loadSerialized(File f) throws IOException, ClassNotFoundException {
        Object object;
        FileInputStream is = new FileInputStream(f);
        try {
            object = FileTool.loadSerialized(is);
        }
        catch (Throwable throwable) {
            FileTool.closeAll(is);
            throw throwable;
        }
        FileTool.closeAll(is);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Object loadSerializedNullOnError(@WillNotClose InputStream is) {
        Object object;
        ObjectInputStream iis = null;
        try {
            iis = new ObjectInputStream(is);
            object = iis.readObject();
        }
        catch (Exception x) {
            Object var3_4;
            try {
                var3_4 = null;
            }
            catch (Throwable throwable) {
                FileTool.closeAll(iis);
                throw throwable;
            }
            FileTool.closeAll(iis);
            return var3_4;
        }
        FileTool.closeAll(iis);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Object loadSerializedNullOnError(File f) throws IOException, ClassNotFoundException {
        Object object;
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            object = FileTool.loadSerialized(is);
        }
        catch (Exception x) {
            Object var3_4;
            try {
                var3_4 = null;
            }
            catch (Throwable throwable) {
                FileTool.closeAll(is);
                throw throwable;
            }
            FileTool.closeAll(is);
            return var3_4;
        }
        FileTool.closeAll(is);
        return object;
    }

    public static void closeAll(Object ... list) {
        int i;
        int tox = 0;
        for (Object v : list) {
            try {
                if (v instanceof Closeable) {
                    ((Closeable)v).close();
                    continue;
                }
                if (v instanceof ResultSet) {
                    ((ResultSet)v).close();
                    continue;
                }
                if (v instanceof File) {
                    File f = (File)v;
                    if (f.isFile()) {
                        f.delete();
                        continue;
                    }
                    FileTool.deleteDir(f);
                    continue;
                }
                if (v == null) continue;
                list[tox++] = v;
            }
            catch (Exception x) {
                if (v == null) continue;
                LOG.trace("Cannot close resource " + v + " (a " + v.getClass() + "): " + x, (Throwable)x);
            }
        }
        int len = tox;
        tox = 0;
        for (i = 0; i < len; ++i) {
            Object v = list[i];
            try {
                if (v instanceof Statement) {
                    ((Statement)v).close();
                    continue;
                }
                list[tox++] = v;
                continue;
            }
            catch (Exception x) {
                LOG.trace("Cannot close resource " + v + " (a " + v.getClass() + "): " + x, (Throwable)x);
            }
        }
        len = tox;
        tox = 0;
        for (i = 0; i < len; ++i) {
            Object v;
            block18: {
                v = list[i];
                try {
                    if (v instanceof Connection) {
                        ((Connection)v).close();
                        v = null;
                    } else {
                        Method m = ClassUtil.findMethod(v.getClass(), "close", new Class[0]);
                        if (m == null) {
                            m = ClassUtil.findMethod(v.getClass(), "release", new Class[0]);
                        }
                        if (m != null) {
                            m.invoke(v, new Object[0]);
                            v = null;
                        }
                    }
                }
                catch (Exception x) {
                    if (v == null) break block18;
                    LOG.trace("Cannot close resource " + v + " (a " + v.getClass() + "): " + x, (Throwable)x);
                }
            }
            if (v == null) continue;
            StringTool.dumpErrorLocation(LOG, "UNKNOWN RESOURCE OF TYPE " + v.getClass() + " TO CLOSE PASSED TO FileTool.closeAll()!!!!\nFIX THIS IMMEDIATELY!!!!!!");
        }
    }

    public static void compareDirectories(IDirectoryDelta delta, File a, File b) throws Exception {
        StringBuilder sb = new StringBuilder();
        FileTool.compare(delta, sb, a, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compare(IDirectoryDelta delta, StringBuilder sb, File a, File b) throws Exception {
        int clen = sb.length();
        try {
            if (clen != 0) {
                sb.append(File.separator);
            }
            sb.append(a.getName());
            String relpath = sb.toString();
            if (!a.exists()) {
                if (!b.exists()) {
                    return;
                }
                if (b.isFile()) {
                    delta.fileAdded(b, a, relpath);
                } else if (delta.directoryAdded(b, a, relpath)) {
                    FileTool.addDirectoryContents(delta, sb, a, b);
                }
            } else if (!b.exists()) {
                if (a.isFile()) {
                    delta.fileDeleted(b, a, relpath);
                } else if (delta.directoryDeleted(b, a, relpath)) {
                    FileTool.deleteDirectoryContents(delta, sb, a, b);
                }
            } else if (a.isFile()) {
                if (b.isDirectory()) {
                    delta.fileDeleted(b, a, relpath);
                    if (delta.directoryAdded(b, a, relpath)) {
                        FileTool.addDirectoryContents(delta, sb, a, b);
                    }
                } else {
                    delta.compareFiles(b, a, relpath);
                }
            } else if (b.isFile()) {
                if (delta.directoryDeleted(b, a, relpath)) {
                    FileTool.deleteDirectoryContents(delta, sb, a, b);
                }
                delta.fileAdded(b, a, relpath);
            } else {
                FileTool.compareDirectories(delta, sb, a, b);
            }
        }
        finally {
            sb.setLength(clen);
        }
    }

    private static void compareDirectories(IDirectoryDelta delta, StringBuilder sb, File a, File b) throws Exception {
        File[] aar = a.listFiles();
        File[] bar = b.listFiles();
        HashSet<String> bset = new HashSet<String>();
        for (File bf : bar) {
            bset.add(bf.getName());
        }
        for (File af : aar) {
            File bf = new File(b, af.getName());
            bset.remove(af.getName());
            FileTool.compare(delta, sb, af, bf);
        }
        for (String name : bset) {
            File af;
            File bf = new File(b, name);
            af = new File(a, name);
            FileTool.compare(delta, sb, af, bf);
        }
    }

    private static void deleteDirectoryContents(IDirectoryDelta delta, StringBuilder sb, File a, File b) throws Exception {
        File[] aar = a.listFiles();
        int clen = sb.length();
        for (File af : aar) {
            File bf = new File(b, af.getName());
            if (clen == 0) {
                sb.append(File.separator);
            }
            sb.append(af.getName());
            String relpath = sb.toString();
            if (bf.isFile()) {
                delta.fileDeleted(bf, af, relpath);
            } else if (delta.directoryDeleted(bf, af, relpath)) {
                FileTool.deleteDirectoryContents(delta, sb, af, bf);
            }
            sb.setLength(clen);
        }
    }

    private static void addDirectoryContents(IDirectoryDelta delta, StringBuilder sb, File a, File b) throws Exception {
        File[] bar = b.listFiles();
        int clen = sb.length();
        for (File bf : bar) {
            File af = new File(a, bf.getName());
            if (clen == 0) {
                sb.append(File.separator);
            }
            sb.append(bf.getName());
            String relpath = sb.toString();
            if (bf.isFile()) {
                delta.fileAdded(bf, af, relpath);
            } else if (delta.directoryAdded(bf, af, relpath)) {
                FileTool.addDirectoryContents(delta, sb, af, bf);
            }
            sb.setLength(clen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBlob(@Nonnull File out, @Nonnull Blob in) throws Exception {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = in.getBinaryStream();
            os = new FileOutputStream(out);
            FileTool.copyFile(os, is);
            ((OutputStream)os).close();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static int getIntSizeOfFile(@Nonnull File file) {
        long size = file.length();
        if (size > Integer.MAX_VALUE) {
            throw new IllegalStateException("We do not allow file sizes > " + StringTool.strSize(Integer.MAX_VALUE) + ", found file size:" + StringTool.strSize(size));
        }
        return (int)size;
    }

    @Nonnull
    public static File createTmpDir() throws IOException {
        File f = File.createTempFile("work", ".dir");
        f.delete();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumberOfLines(@Nonnull File file) throws IOException {
        int n;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            int lines = 0;
            while (reader.readLine() != null) {
                ++lines;
            }
            n = lines;
        }
        catch (Throwable throwable) {
            FileTool.closeAll(reader);
            throw throwable;
        }
        FileTool.closeAll(reader);
        return n;
    }

    @Nullable
    public static String getRelativePath(@Nonnull File root, @Nonnull File other) {
        try {
            String modroot = root.toString().replace('\\', '/');
            String inroot = other.toString().replace('\\', '/');
            if (modroot.equals(inroot)) {
                return "";
            }
            if (!inroot.startsWith(modroot + "/")) {
                return null;
            }
            return inroot.substring(modroot.length() + 1);
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    @Nonnull
    public static Reader getResourceReader(@Nonnull Class<?> root, @Nullable String name) {
        InputStream is = root.getResourceAsStream(name);
        if (null == is) {
            throw new IllegalStateException("JUnit test: missing test resource with base=" + root + " and name " + name);
        }
        try {
            return new InputStreamReader(is, "utf-8");
        }
        catch (UnsupportedEncodingException x) {
            throw WrappedException.wrap(x);
        }
    }

    @Nonnull
    public static String readAsString(@Nonnull Clob data) throws IOException, SQLException {
        try (Reader reader = data.getCharacterStream();){
            int len;
            char[] buf = new char[8192];
            StringBuilder sb = new StringBuilder();
            while ((len = reader.read(buf)) > 0) {
                sb.append(buf, 0, len);
            }
            String string = sb.toString();
            return string;
        }
    }
}

