/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FutureImpl<T>
implements Future<T> {
    private final String m_description;
    private boolean m_cancelled;
    private boolean m_done;
    private T m_result;
    private Exception m_exception;

    public FutureImpl() {
        this.m_description = null;
    }

    public FutureImpl(@Nullable String description) {
        this.m_description = description;
    }

    public FutureImpl(@Nullable T result) {
        this.m_done = true;
        this.m_result = result;
        this.m_description = null;
    }

    public FutureImpl(@Nullable String description, @Nullable T result) {
        this.m_done = true;
        this.m_result = result;
        this.m_description = description;
    }

    public FutureImpl(@Nonnull Exception error) {
        this.m_exception = error;
        this.m_done = true;
        this.m_description = null;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        this.m_cancelled = true;
        return false;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.m_cancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.m_done;
    }

    @Override
    public synchronized T get() throws InterruptedException, ExecutionException {
        while (true) {
            if (this.m_done) {
                if (this.m_exception != null) {
                    throw new ExecutionException(this.m_exception);
                }
                return this.m_result;
            }
            this.wait();
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long ets = System.currentTimeMillis() + unit.toMillis(timeout);
        while (true) {
            if (this.m_done) {
                if (this.m_exception != null) {
                    throw new ExecutionException(this.m_exception);
                }
                return this.m_result;
            }
            long rest = ets - System.currentTimeMillis();
            if (rest <= 0L) {
                throw new TimeoutException();
            }
            this.wait(rest);
        }
    }

    public synchronized void set(@Nullable T value) {
        this.m_done = true;
        this.m_result = value;
        this.notifyAll();
    }

    public synchronized void set(@Nonnull Exception reason) {
        this.m_exception = reason;
        this.m_done = true;
        this.notifyAll();
    }

    public String toString() {
        return this.m_description == null ? super.toString() : this.m_description;
    }
}

