/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FutureValueNB<T>
implements Future<T> {
    private final String m_description;
    private boolean m_cancelled;
    private boolean m_done;
    private T m_result;
    private Exception m_exception;

    public FutureValueNB() {
        this.m_description = null;
    }

    public FutureValueNB(@Nullable String description) {
        this.m_description = description;
    }

    public FutureValueNB(@Nullable T result) {
        this.m_done = true;
        this.m_result = result;
        this.m_description = null;
    }

    public FutureValueNB(@Nullable String description, @Nullable T result) {
        this.m_done = true;
        this.m_result = result;
        this.m_description = description;
    }

    public FutureValueNB(@Nonnull Exception error) {
        this.m_exception = error;
        this.m_done = true;
        this.m_description = null;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        this.m_cancelled = true;
        return false;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.m_cancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.m_done;
    }

    @Override
    public synchronized T get() throws InterruptedException, ExecutionException {
        if (!this.m_done) {
            throw new IllegalStateException(this + ": value has not yet been set");
        }
        if (this.m_exception != null) {
            throw new ExecutionException(this.m_exception);
        }
        return this.m_result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get();
    }

    public synchronized void set(@Nullable T value) {
        this.m_done = true;
        this.m_result = value;
    }

    public synchronized void set(@Nonnull Exception reason) {
        this.m_exception = reason;
        this.m_done = true;
    }

    public String toString() {
        return this.m_description == null ? super.toString() : this.m_description;
    }
}

