/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class HtmlEntity {
    private static TreeMap<String, Integer> m_name_mp;
    private static TreeMap<Integer, String> m_val_mp;
    private static TreeMap<Integer, String> m_desc_mp;

    private static String _getToken(Reader pr) throws Exception {
        int c;
        do {
            if ((c = pr.read()) != -1) continue;
            return null;
        } while (Character.isWhitespace((char)c));
        StringBuffer sb = new StringBuffer();
        do {
            sb.append((char)c);
        } while ((c = pr.read()) != -1 && !Character.isWhitespace((char)c));
        return sb.toString();
    }

    private static String getToken(Reader pr) throws Exception {
        String t;
        while ((t = HtmlEntity._getToken(pr)) != null) {
            if (!t.equalsIgnoreCase("<!--")) {
                return t;
            }
            do {
                if ((t = HtmlEntity._getToken(pr)) != null) continue;
                throw new Exception("EOF in comment.");
            } while (!t.equalsIgnoreCase("-->"));
        }
        return t;
    }

    private static String getComment(Reader pr) throws Exception {
        int sl;
        int c;
        String s = HtmlEntity.getToken(pr);
        if (!s.equalsIgnoreCase("--")) {
            throw new Exception("Missing comment start for entity: found" + s);
        }
        StringBuffer sb = new StringBuffer();
        int spaces = 0;
        while (true) {
            if ((c = pr.read()) == 62) {
                sl = sb.length();
                if (sl > 2 && sb.charAt(sl - 1) == '-' && sb.charAt(sl - 2) == '-') {
                    break;
                }
            } else if (c == -1) {
                throw new IOException("Unexpected EOF.");
            }
            if (Character.isWhitespace((char)c)) {
                ++spaces;
                continue;
            }
            if (spaces > 0) {
                sb.append(' ');
                spaces = 0;
            }
            sb.append((char)c);
        }
        sb.setLength(sl - 2);
        String cmt = sb.toString().trim();
        int pos = cmt.indexOf("U+");
        if (pos >= 0) {
            cmt = cmt.substring(0, pos);
        }
        if ((pos = cmt.indexOf("u+")) >= 0) {
            cmt = cmt.substring(0, pos);
        }
        pos = cmt.length();
        while (pos > 0) {
            if ((c = (int)cmt.charAt(--pos)) == 32 || c == 9 || c == 44 || c == 59) continue;
            ++pos;
            break;
        }
        cmt = cmt.substring(0, pos);
        return cmt;
    }

    private static void decodeEntity(Reader pr) throws Exception {
        int val;
        String name = HtmlEntity.getToken(pr);
        if (name == null) {
            return;
        }
        String cn = HtmlEntity.getToken(pr);
        if (!cn.equalsIgnoreCase("CDATA")) {
            throw new Exception("expected token CDATA after " + name);
        }
        String str = HtmlEntity.getToken(pr);
        if (str.length() <= 4) {
            throw new Exception(name + ": data string too short " + str);
        }
        if (!str.startsWith("\"&#")) {
            throw new Exception(name + ": data string invalid start " + str);
        }
        if (!str.endsWith("\"")) {
            throw new Exception(name + ": data string invalid end quote " + str);
        }
        String cmt = HtmlEntity.getComment(pr);
        int ep = str.length();
        while (ep > 0) {
            if (str.charAt(--ep) == '\"' || str.charAt(ep) == ';') continue;
            ++ep;
            break;
        }
        String dv = str.substring(3, ep);
        try {
            val = dv.charAt(0) == 'X' || dv.charAt(0) == 'x' ? Integer.parseInt(dv.substring(1), 16) : Integer.parseInt(dv);
        }
        catch (Exception x) {
            throw new Exception(name + ": bad number " + dv);
        }
        Integer iv = new Integer(val);
        m_name_mp.put(name, iv);
        m_val_mp.put(iv, name);
        m_desc_mp.put(iv, cmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(File f) throws Exception {
        PrintWriter pw = new PrintWriter(new FileWriter(f));
        try {
            Object val;
            Map.Entry me;
            pw.println("/** Auto-generated by HtmlEntity on " + new Date() + " */");
            pw.println("package to.etc.util;\n");
            pw.println("public class HtmlEntityTables {");
            Iterator<Object> it = m_name_mp.keySet().iterator();
            pw.print("\n    static public final String[] m_nameStrTbl = {");
            it = m_name_mp.keySet().iterator();
            int cc = 999;
            int ct = 0;
            while (it.hasNext()) {
                String val2 = it.next();
                if (cc > 8) {
                    pw.print("\n        ");
                    cc = 0;
                }
                if (ct > 0) {
                    pw.print(',');
                }
                pw.print("\"" + val2 + "\"");
                ++ct;
                ++cc;
            }
            pw.println("\n    };\n");
            Vector<Map.Entry> namev = new Vector<Map.Entry>();
            pw.print("\n    static public final int[] m_nameCodeTbl = {");
            it = m_name_mp.entrySet().iterator();
            cc = 999;
            ct = 0;
            while (it.hasNext()) {
                me = (Map.Entry)it.next();
                namev.add(me);
                val = (Integer)me.getValue();
                if (cc > 8) {
                    pw.print("\n        ");
                    cc = 0;
                }
                if (ct > 0) {
                    pw.print(',');
                }
                pw.print(((Integer)val).toString());
                ++ct;
                ++cc;
            }
            pw.println("\n    };\n");
            pw.print("\n    static public final String[] m_codeStrTbl = {");
            it = m_val_mp.entrySet().iterator();
            cc = 999;
            ct = 0;
            while (it.hasNext()) {
                me = (Map.Entry)it.next();
                val = (String)me.getValue();
                if (cc > 8) {
                    pw.print("\n        ");
                    cc = 0;
                }
                if (ct > 0) {
                    pw.print(',');
                }
                pw.print("\"" + (String)val + "\"");
                ++ct;
                ++cc;
            }
            pw.println("\n    };\n");
            pw.print("\n    static public final String[] m_codeDescTbl = {");
            it = m_desc_mp.entrySet().iterator();
            cc = 999;
            ct = 0;
            while (it.hasNext()) {
                me = (Map.Entry)it.next();
                val = (String)me.getValue();
                if (cc > 8) {
                    pw.print("\n        ");
                    cc = 0;
                }
                if (ct > 0) {
                    pw.print(',');
                }
                pw.print("\"" + (String)val + "\"");
                ++ct;
                ++cc;
            }
            pw.println("\n    };\n");
            Vector<Map.Entry> valv = new Vector<Map.Entry>();
            pw.print("\n    static public final int[] m_codeCodeTbl = {");
            it = m_val_mp.entrySet().iterator();
            cc = 999;
            ct = 0;
            while (it.hasNext()) {
                Map.Entry me2 = (Map.Entry)it.next();
                valv.add(me2);
                Integer val3 = (Integer)me2.getKey();
                if (cc > 8) {
                    pw.print("\n        ");
                    cc = 0;
                }
                if (ct > 0) {
                    pw.print(',');
                }
                pw.print(val3.toString());
                ++ct;
                ++cc;
            }
            pw.println("\n    };\n");
            pw.println("    static public int findCode(String name) {");
            pw.println("        int rv;");
            HtmlEntity.mkNameFind(pw, namev, 4, 0, namev.size());
            pw.println("    }\n\n");
            pw.println("    static public String findName(int code) {");
            HtmlEntity.mkValFind(pw, valv, 4, 0, valv.size());
            pw.println("    }\n\n");
            pw.println("\n}\n");
        }
        finally {
            try {
                pw.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void w(PrintWriter pw, int ind, String s) {
        ind *= 2;
        while (ind-- > 0) {
            pw.print(' ');
        }
        pw.println(s);
    }

    private static void genNameUnknown(PrintWriter pw, int lvl) {
        HtmlEntity.w(pw, lvl, "return -1;");
    }

    private static void mkNameFind(PrintWriter pw, Vector v, int lvl, int low, int high) {
        if (low >= high) {
            HtmlEntity.genNameUnknown(pw, lvl);
            return;
        }
        if (high - low == 1) {
            Map.Entry me = (Map.Entry)v.elementAt(low);
            String name = (String)me.getKey();
            int val = (Integer)me.getValue();
            HtmlEntity.w(pw, lvl, "if(name.equals(\"" + name + "\"))");
            HtmlEntity.w(pw, lvl + 1, "return " + val + ";");
            HtmlEntity.w(pw, lvl, "else");
            HtmlEntity.genNameUnknown(pw, lvl + 1);
            return;
        }
        if (high - low == 2) {
            Map.Entry me = (Map.Entry)v.elementAt(low);
            String name = (String)me.getKey();
            int val = (Integer)me.getValue();
            HtmlEntity.w(pw, lvl, "if(name.equals(\"" + name + "\"))");
            HtmlEntity.w(pw, lvl + 1, "return " + val + ";");
            me = (Map.Entry)v.elementAt(low + 1);
            name = (String)me.getKey();
            val = (Integer)me.getValue();
            HtmlEntity.w(pw, lvl, "if(name.equals(\"" + name + "\"))");
            HtmlEntity.w(pw, lvl + 1, "return " + val + ";");
            HtmlEntity.genNameUnknown(pw, lvl);
            return;
        }
        int half = (low + high) / 2;
        Map.Entry me = (Map.Entry)v.elementAt(half);
        String name = (String)me.getKey();
        int val = (Integer)me.getValue();
        HtmlEntity.w(pw, lvl, "rv = name.compareTo(\"" + name + "\");");
        HtmlEntity.w(pw, lvl, "if(rv == 0)");
        HtmlEntity.w(pw, lvl + 1, "return " + val + ";");
        HtmlEntity.w(pw, lvl, "else if(rv < 0)");
        HtmlEntity.w(pw, lvl, "{");
        HtmlEntity.mkNameFind(pw, v, lvl + 1, low, half);
        HtmlEntity.w(pw, lvl, "}");
        HtmlEntity.w(pw, lvl, "else");
        HtmlEntity.w(pw, lvl, "{");
        HtmlEntity.mkNameFind(pw, v, lvl + 1, half + 1, high);
        HtmlEntity.w(pw, lvl, "}");
    }

    private static void genValUnknown(PrintWriter pw, int lvl) {
        HtmlEntity.w(pw, lvl, "return null;");
    }

    private static void mkValFind(PrintWriter pw, Vector v, int lvl, int low, int high) {
        if (low >= high) {
            HtmlEntity.genValUnknown(pw, lvl);
            return;
        }
        if (high - low == 1) {
            Map.Entry me = (Map.Entry)v.elementAt(low);
            String name = (String)me.getValue();
            int val = (Integer)me.getKey();
            HtmlEntity.w(pw, lvl, "if(code == " + val + ")");
            HtmlEntity.w(pw, lvl + 1, "return \"" + name + "\";");
            HtmlEntity.w(pw, lvl, "else");
            HtmlEntity.genValUnknown(pw, lvl + 1);
            return;
        }
        if (high - low == 2) {
            Map.Entry me = (Map.Entry)v.elementAt(low);
            String name = (String)me.getValue();
            int val = (Integer)me.getKey();
            HtmlEntity.w(pw, lvl, "if(code == " + val + ")");
            HtmlEntity.w(pw, lvl + 1, "return \"" + name + "\";");
            me = (Map.Entry)v.elementAt(low + 1);
            name = (String)me.getValue();
            val = (Integer)me.getKey();
            HtmlEntity.w(pw, lvl, "if(code == " + val + ")");
            HtmlEntity.w(pw, lvl + 1, "return \"" + name + "\";");
            HtmlEntity.genValUnknown(pw, lvl);
            return;
        }
        int half = (low + high) / 2;
        Map.Entry me = (Map.Entry)v.elementAt(half);
        String name = (String)me.getValue();
        int val = (Integer)me.getKey();
        HtmlEntity.w(pw, lvl, "if(code == " + val + ")");
        HtmlEntity.w(pw, lvl + 1, "return \"" + name + "\";");
        HtmlEntity.w(pw, lvl, "else if(code < " + val + ")");
        HtmlEntity.w(pw, lvl, "{");
        HtmlEntity.mkValFind(pw, v, lvl + 1, low, half);
        HtmlEntity.w(pw, lvl, "}");
        HtmlEntity.w(pw, lvl, "else");
        HtmlEntity.w(pw, lvl, "{");
        HtmlEntity.mkValFind(pw, v, lvl + 1, half + 1, high);
        HtmlEntity.w(pw, lvl, "}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanFile(File f) throws Exception {
        BufferedReader lr = new BufferedReader(new FileReader(f), 8192);
        try {
            String t;
            int cc = m_name_mp.size();
            while (null != (t = HtmlEntity.getToken(lr))) {
                if (!t.equalsIgnoreCase("<!ENTITY")) continue;
                HtmlEntity.decodeEntity(lr);
            }
            System.out.println(f + ": " + (m_name_mp.size() - cc) + " entities.");
        }
        finally {
            try {
                ((Reader)lr).close();
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                throw new Exception("Usage: HtmlEntity <directory> outputfile");
            }
            File f = new File(args[0]);
            File[] far = f.listFiles();
            m_name_mp = new TreeMap();
            m_val_mp = new TreeMap();
            m_desc_mp = new TreeMap();
            int count = 0;
            for (int i = 0; i < far.length; ++i) {
                String fn = far[i].getName().toLowerCase();
                if (!fn.endsWith(".ent")) continue;
                HtmlEntity.scanFile(far[i]);
                ++count;
            }
            if (count == 0) {
                throw new Exception("No files there.");
            }
            File of = new File(args[1]);
            HtmlEntity.write(of);
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
    }
}

