/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

public class HtmlEntityTables {
    public static final String[] m_nameStrTbl = new String[]{"AElig", "Aacute", "Acirc", "Agrave", "Alpha", "Aring", "Atilde", "Auml", "Beta", "Ccedil", "Chi", "Dagger", "Delta", "ETH", "Eacute", "Ecirc", "Egrave", "Epsilon", "Eta", "Euml", "Gamma", "Iacute", "Icirc", "Igrave", "Iota", "Iuml", "Kappa", "Lambda", "Mu", "Ntilde", "Nu", "OElig", "Oacute", "Ocirc", "Ograve", "Omega", "Omicron", "Oslash", "Otilde", "Ouml", "Phi", "Pi", "Prime", "Psi", "Rho", "Scaron", "Sigma", "THORN", "Tau", "Theta", "Uacute", "Ucirc", "Ugrave", "Upsilon", "Uuml", "Xi", "Yacute", "Yuml", "Zeta", "aacute", "acirc", "acute", "aelig", "agrave", "alefsym", "alpha", "amp", "and", "ang", "aring", "asymp", "atilde", "auml", "bdquo", "beta", "brvbar", "bull", "cap", "ccedil", "cedil", "cent", "chi", "circ", "clubs", "cong", "copy", "crarr", "cup", "curren", "dArr", "dagger", "darr", "deg", "delta", "diams", "divide", "eacute", "ecirc", "egrave", "empty", "emsp", "ensp", "epsilon", "equiv", "eta", "eth", "euml", "euro", "exist", "fnof", "forall", "frac12", "frac14", "frac34", "frasl", "gamma", "ge", "gt", "hArr", "harr", "hearts", "hellip", "iacute", "icirc", "iexcl", "igrave", "image", "infin", "int", "iota", "iquest", "isin", "iuml", "kappa", "lArr", "lambda", "lang", "laquo", "larr", "lceil", "ldquo", "le", "lfloor", "lowast", "loz", "lrm", "lsaquo", "lsquo", "lt", "macr", "mdash", "micro", "middot", "minus", "mu", "nabla", "nbsp", "ndash", "ne", "ni", "not", "notin", "nsub", "ntilde", "nu", "oacute", "ocirc", "oelig", "ograve", "oline", "omega", "omicron", "oplus", "or", "ordf", "ordm", "oslash", "otilde", "otimes", "ouml", "para", "part", "permil", "perp", "phi", "pi", "piv", "plusmn", "pound", "prime", "prod", "prop", "psi", "quot", "rArr", "radic", "rang", "raquo", "rarr", "rceil", "rdquo", "real", "reg", "rfloor", "rho", "rlm", "rsaquo", "rsquo", "sbquo", "scaron", "sdot", "sect", "shy", "sigma", "sigmaf", "sim", "spades", "sub", "sube", "sum", "sup", "sup1", "sup2", "sup3", "supe", "szlig", "tau", "there4", "theta", "thetasym", "thinsp", "thorn", "tilde", "times", "trade", "uArr", "uacute", "uarr", "ucirc", "ugrave", "uml", "upsih", "upsilon", "uuml", "weierp", "xi", "yacute", "yen", "yuml", "zeta", "zwj", "zwnj"};
    public static final int[] m_nameCodeTbl = new int[]{198, 193, 194, 192, 913, 197, 195, 196, 914, 199, 935, 8225, 916, 208, 201, 202, 200, 917, 919, 203, 915, 205, 206, 204, 921, 207, 922, 923, 924, 209, 925, 338, 211, 212, 210, 937, 927, 216, 213, 214, 934, 928, 8243, 936, 929, 352, 931, 222, 932, 920, 218, 219, 217, 933, 220, 926, 221, 376, 918, 225, 226, 180, 230, 224, 8501, 945, 38, 8743, 8736, 229, 8776, 227, 228, 8222, 946, 166, 8226, 8745, 231, 184, 162, 967, 710, 9827, 8773, 169, 8629, 8746, 164, 8659, 8224, 8595, 176, 948, 9830, 247, 233, 234, 232, 8709, 8195, 8194, 949, 8801, 951, 240, 235, 8364, 8707, 402, 8704, 189, 188, 190, 8260, 947, 8805, 62, 8660, 8596, 9829, 8230, 237, 238, 161, 236, 8465, 8734, 8747, 953, 191, 8712, 239, 954, 8656, 955, 9001, 171, 8592, 8968, 8220, 8804, 8970, 8727, 9674, 8206, 8249, 8216, 60, 175, 8212, 181, 183, 8722, 956, 8711, 160, 8211, 8800, 8715, 172, 8713, 8836, 241, 957, 243, 244, 339, 242, 8254, 969, 959, 8853, 8744, 170, 186, 248, 245, 8855, 246, 182, 8706, 8240, 8869, 966, 960, 982, 177, 163, 8242, 8719, 8733, 968, 34, 8658, 8730, 9002, 187, 8594, 8969, 8221, 8476, 174, 8971, 961, 8207, 8250, 8217, 8218, 353, 8901, 167, 173, 963, 962, 8764, 9824, 8834, 8838, 8721, 8835, 185, 178, 179, 8839, 223, 964, 8756, 952, 977, 8201, 254, 732, 215, 8482, 8657, 250, 8593, 251, 249, 168, 978, 965, 252, 8472, 958, 253, 165, 255, 950, 8205, 8204};
    public static final String[] m_codeStrTbl = new String[]{"quot", "amp", "lt", "gt", "nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml", "OElig", "oelig", "Scaron", "scaron", "Yuml", "fnof", "circ", "tilde", "Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron", "Pi", "Rho", "Sigma", "Tau", "Upsilon", "Phi", "Chi", "Psi", "Omega", "alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigmaf", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega", "thetasym", "upsih", "piv", "ensp", "emsp", "thinsp", "zwnj", "zwj", "lrm", "rlm", "ndash", "mdash", "lsquo", "rsquo", "sbquo", "ldquo", "rdquo", "bdquo", "dagger", "Dagger", "bull", "hellip", "permil", "prime", "Prime", "lsaquo", "rsaquo", "oline", "frasl", "euro", "image", "weierp", "real", "trade", "alefsym", "larr", "uarr", "rarr", "darr", "harr", "crarr", "lArr", "uArr", "rArr", "dArr", "hArr", "forall", "part", "exist", "empty", "nabla", "isin", "notin", "ni", "prod", "sum", "minus", "lowast", "radic", "prop", "infin", "ang", "and", "or", "cap", "cup", "int", "there4", "sim", "cong", "asymp", "ne", "equiv", "le", "ge", "sub", "sup", "nsub", "sube", "supe", "oplus", "otimes", "perp", "sdot", "lceil", "rceil", "lfloor", "rfloor", "lang", "rang", "loz", "spades", "clubs", "hearts", "diams"};
    public static final String[] m_codeDescTbl = new String[]{"quotation mark = APL quote", "ampersand", "less-than sign", "greater-than sign", "no-break space = non-breaking space", "inverted exclamation mark", "cent sign", "pound sign", "currency sign", "yen sign = yuan sign", "broken bar = broken vertical bar", "section sign", "diaeresis = spacing diaeresis", "copyright sign", "feminine ordinal indicator", "left-pointing double angle quotation mark = left pointing guillemet", "not sign", "soft hyphen = discretionary hyphen", "registered sign = registered trade mark sign", "macron = spacing macron = overline = APL overbar", "degree sign", "plus-minus sign = plus-or-minus sign", "superscript two = superscript digit two = squared", "superscript three = superscript digit three = cubed", "acute accent = spacing acute", "micro sign", "pilcrow sign = paragraph sign", "middle dot = Georgian comma = Greek middle dot", "cedilla = spacing cedilla", "superscript one = superscript digit one", "masculine ordinal indicator", "right-pointing double angle quotation mark = right pointing guillemet", "vulgar fraction one quarter = fraction one quarter", "vulgar fraction one half = fraction one half", "vulgar fraction three quarters = fraction three quarters", "inverted question mark = turned question mark", "latin capital letter A with grave = latin capital letter A grave", "latin capital letter A with acute", "latin capital letter A with circumflex", "latin capital letter A with tilde", "latin capital letter A with diaeresis", "latin capital letter A with ring above = latin capital letter A ring", "latin capital letter AE = latin capital ligature AE", "latin capital letter C with cedilla", "latin capital letter E with grave", "latin capital letter E with acute", "latin capital letter E with circumflex", "latin capital letter E with diaeresis", "latin capital letter I with grave", "latin capital letter I with acute", "latin capital letter I with circumflex", "latin capital letter I with diaeresis", "latin capital letter ETH", "latin capital letter N with tilde", "latin capital letter O with grave", "latin capital letter O with acute", "latin capital letter O with circumflex", "latin capital letter O with tilde", "latin capital letter O with diaeresis", "multiplication sign", "latin capital letter O with stroke = latin capital letter O slash", "latin capital letter U with grave", "latin capital letter U with acute", "latin capital letter U with circumflex", "latin capital letter U with diaeresis", "latin capital letter Y with acute", "latin capital letter THORN", "latin small letter sharp s = ess-zed", "latin small letter a with grave = latin small letter a grave", "latin small letter a with acute", "latin small letter a with circumflex", "latin small letter a with tilde", "latin small letter a with diaeresis", "latin small letter a with ring above = latin small letter a ring", "latin small letter ae = latin small ligature ae", "latin small letter c with cedilla", "latin small letter e with grave", "latin small letter e with acute", "latin small letter e with circumflex", "latin small letter e with diaeresis", "latin small letter i with grave", "latin small letter i with acute", "latin small letter i with circumflex", "latin small letter i with diaeresis", "latin small letter eth", "latin small letter n with tilde", "latin small letter o with grave", "latin small letter o with acute", "latin small letter o with circumflex", "latin small letter o with tilde", "latin small letter o with diaeresis", "division sign", "latin small letter o with stroke, = latin small letter o slash", "latin small letter u with grave", "latin small letter u with acute", "latin small letter u with circumflex", "latin small letter u with diaeresis", "latin small letter y with acute", "latin small letter thorn", "latin small letter y with diaeresis", "latin capital ligature OE", "latin small ligature oe", "latin capital letter S with caron", "latin small letter s with caron", "latin capital letter Y with diaeresis", "latin small f with hook = function = florin", "modifier letter circumflex accent", "small tilde", "greek capital letter alpha", "greek capital letter beta", "greek capital letter gamma", "greek capital letter delta", "greek capital letter epsilon", "greek capital letter zeta", "greek capital letter eta", "greek capital letter theta", "greek capital letter iota", "greek capital letter kappa", "greek capital letter lambda", "greek capital letter mu", "greek capital letter nu", "greek capital letter xi", "greek capital letter omicron", "greek capital letter pi", "greek capital letter rho", "greek capital letter sigma", "greek capital letter tau", "greek capital letter upsilon", "greek capital letter phi", "greek capital letter chi", "greek capital letter psi", "greek capital letter omega", "greek small letter alpha", "greek small letter beta", "greek small letter gamma", "greek small letter delta", "greek small letter epsilon", "greek small letter zeta", "greek small letter eta", "greek small letter theta", "greek small letter iota", "greek small letter kappa", "greek small letter lambda", "greek small letter mu", "greek small letter nu", "greek small letter xi", "greek small letter omicron", "greek small letter pi", "greek small letter rho", "greek small letter final sigma", "greek small letter sigma", "greek small letter tau", "greek small letter upsilon", "greek small letter phi", "greek small letter chi", "greek small letter psi", "greek small letter omega", "greek small letter theta symbol", "greek upsilon with hook symbol", "greek pi symbol", "en space", "em space", "thin space", "zero width non-joiner", "zero width joiner", "left-to-right mark", "right-to-left mark", "en dash", "em dash", "left single quotation mark", "right single quotation mark", "single low-9 quotation mark", "left double quotation mark", "right double quotation mark", "double low-9 quotation mark", "dagger", "double dagger", "bullet = black small circle", "horizontal ellipsis = three dot leader", "per mille sign", "prime = minutes = feet", "double prime = seconds = inches", "single left-pointing angle quotation mark", "single right-pointing angle quotation mark", "overline = spacing overscore", "fraction slash", "euro sign", "blackletter capital I = imaginary part", "script capital P = power set = Weierstrass p", "blackletter capital R = real part symbol", "trade mark sign", "alef symbol = first transfinite cardinal", "leftwards arrow", "upwards arrow", "rightwards arrow", "downwards arrow", "left right arrow", "downwards arrow with corner leftwards = carriage return", "leftwards double arrow", "upwards double arrow", "rightwards double arrow", "downwards double arrow", "left right double arrow", "for all", "partial differential", "there exists", "empty set = null set = diameter", "nabla = backward difference", "element of", "not an element of", "contains as member", "n-ary product = product sign", "n-ary sumation", "minus sign", "asterisk operator", "square root = radical sign", "proportional to", "infinity", "angle", "logical and = wedge", "logical or = vee", "intersection = cap", "union = cup", "integral", "therefore", "tilde operator = varies with = similar to", "approximately equal to", "almost equal to = asymptotic to", "not equal to", "identical to", "less-than or equal to", "greater-than or equal to", "subset of", "superset of", "not a subset of", "subset of or equal to", "superset of or equal to", "circled plus = direct sum", "circled times = vector product", "up tack = orthogonal to = perpendicular", "dot operator", "left ceiling = apl upstile", "right ceiling", "left floor = apl downstile", "right floor", "left-pointing angle bracket = bra", "right-pointing angle bracket = ket", "lozenge", "black spade suit", "black club suit = shamrock", "black heart suit = valentine", "black diamond suit"};
    public static final int[] m_codeCodeTbl = new int[]{34, 38, 60, 62, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 338, 339, 352, 353, 376, 402, 710, 732, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 977, 978, 982, 8194, 8195, 8201, 8204, 8205, 8206, 8207, 8211, 8212, 8216, 8217, 8218, 8220, 8221, 8222, 8224, 8225, 8226, 8230, 8240, 8242, 8243, 8249, 8250, 8254, 8260, 8364, 8465, 8472, 8476, 8482, 8501, 8592, 8593, 8594, 8595, 8596, 8629, 8656, 8657, 8658, 8659, 8660, 8704, 8706, 8707, 8709, 8711, 8712, 8713, 8715, 8719, 8721, 8722, 8727, 8730, 8733, 8734, 8736, 8743, 8744, 8745, 8746, 8747, 8756, 8764, 8773, 8776, 8800, 8801, 8804, 8805, 8834, 8835, 8836, 8838, 8839, 8853, 8855, 8869, 8901, 8968, 8969, 8970, 8971, 9001, 9002, 9674, 9824, 9827, 9829, 9830};

    public static int findCode(String name) {
        int rv = name.compareTo("image");
        if (rv == 0) {
            return 8465;
        }
        if (rv < 0) {
            rv = name.compareTo("agrave");
            if (rv == 0) {
                return 224;
            }
            if (rv < 0) {
                rv = name.compareTo("OElig");
                if (rv == 0) {
                    return 338;
                }
                if (rv < 0) {
                    rv = name.compareTo("Ecirc");
                    if (rv == 0) {
                        return 202;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("Auml");
                        if (rv == 0) {
                            return 196;
                        }
                        if (rv < 0) {
                            rv = name.compareTo("Agrave");
                            if (rv == 0) {
                                return 192;
                            }
                            if (rv < 0) {
                                rv = name.compareTo("Aacute");
                                if (rv == 0) {
                                    return 193;
                                }
                                if (rv < 0) {
                                    if (name.equals("AElig")) {
                                        return 198;
                                    }
                                    return -1;
                                }
                                if (name.equals("Acirc")) {
                                    return 194;
                                }
                                return -1;
                            }
                            rv = name.compareTo("Aring");
                            if (rv == 0) {
                                return 197;
                            }
                            if (rv < 0) {
                                if (name.equals("Alpha")) {
                                    return 913;
                                }
                                return -1;
                            }
                            if (name.equals("Atilde")) {
                                return 195;
                            }
                            return -1;
                        }
                        rv = name.compareTo("Dagger");
                        if (rv == 0) {
                            return 8225;
                        }
                        if (rv < 0) {
                            rv = name.compareTo("Ccedil");
                            if (rv == 0) {
                                return 199;
                            }
                            if (rv < 0) {
                                if (name.equals("Beta")) {
                                    return 914;
                                }
                                return -1;
                            }
                            if (name.equals("Chi")) {
                                return 935;
                            }
                            return -1;
                        }
                        rv = name.compareTo("ETH");
                        if (rv == 0) {
                            return 208;
                        }
                        if (rv < 0) {
                            if (name.equals("Delta")) {
                                return 916;
                            }
                            return -1;
                        }
                        if (name.equals("Eacute")) {
                            return 201;
                        }
                        return -1;
                    }
                    rv = name.compareTo("Igrave");
                    if (rv == 0) {
                        return 204;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("Euml");
                        if (rv == 0) {
                            return 203;
                        }
                        if (rv < 0) {
                            rv = name.compareTo("Epsilon");
                            if (rv == 0) {
                                return 917;
                            }
                            if (rv < 0) {
                                if (name.equals("Egrave")) {
                                    return 200;
                                }
                                return -1;
                            }
                            if (name.equals("Eta")) {
                                return 919;
                            }
                            return -1;
                        }
                        rv = name.compareTo("Iacute");
                        if (rv == 0) {
                            return 205;
                        }
                        if (rv < 0) {
                            if (name.equals("Gamma")) {
                                return 915;
                            }
                            return -1;
                        }
                        if (name.equals("Icirc")) {
                            return 206;
                        }
                        return -1;
                    }
                    rv = name.compareTo("Lambda");
                    if (rv == 0) {
                        return 923;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("Iuml");
                        if (rv == 0) {
                            return 207;
                        }
                        if (rv < 0) {
                            if (name.equals("Iota")) {
                                return 921;
                            }
                            return -1;
                        }
                        if (name.equals("Kappa")) {
                            return 922;
                        }
                        return -1;
                    }
                    rv = name.compareTo("Ntilde");
                    if (rv == 0) {
                        return 209;
                    }
                    if (rv < 0) {
                        if (name.equals("Mu")) {
                            return 924;
                        }
                        return -1;
                    }
                    if (name.equals("Nu")) {
                        return 925;
                    }
                    return -1;
                }
                rv = name.compareTo("THORN");
                if (rv == 0) {
                    return 222;
                }
                if (rv < 0) {
                    rv = name.compareTo("Ouml");
                    if (rv == 0) {
                        return 214;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("Omega");
                        if (rv == 0) {
                            return 937;
                        }
                        if (rv < 0) {
                            rv = name.compareTo("Ocirc");
                            if (rv == 0) {
                                return 212;
                            }
                            if (rv < 0) {
                                if (name.equals("Oacute")) {
                                    return 211;
                                }
                                return -1;
                            }
                            if (name.equals("Ograve")) {
                                return 210;
                            }
                            return -1;
                        }
                        rv = name.compareTo("Oslash");
                        if (rv == 0) {
                            return 216;
                        }
                        if (rv < 0) {
                            if (name.equals("Omicron")) {
                                return 927;
                            }
                            return -1;
                        }
                        if (name.equals("Otilde")) {
                            return 213;
                        }
                        return -1;
                    }
                    rv = name.compareTo("Psi");
                    if (rv == 0) {
                        return 936;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("Pi");
                        if (rv == 0) {
                            return 928;
                        }
                        if (rv < 0) {
                            if (name.equals("Phi")) {
                                return 934;
                            }
                            return -1;
                        }
                        if (name.equals("Prime")) {
                            return 8243;
                        }
                        return -1;
                    }
                    rv = name.compareTo("Scaron");
                    if (rv == 0) {
                        return 352;
                    }
                    if (rv < 0) {
                        if (name.equals("Rho")) {
                            return 929;
                        }
                        return -1;
                    }
                    if (name.equals("Sigma")) {
                        return 931;
                    }
                    return -1;
                }
                rv = name.compareTo("Xi");
                if (rv == 0) {
                    return 926;
                }
                if (rv < 0) {
                    rv = name.compareTo("Ucirc");
                    if (rv == 0) {
                        return 219;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("Theta");
                        if (rv == 0) {
                            return 920;
                        }
                        if (rv < 0) {
                            if (name.equals("Tau")) {
                                return 932;
                            }
                            return -1;
                        }
                        if (name.equals("Uacute")) {
                            return 218;
                        }
                        return -1;
                    }
                    rv = name.compareTo("Upsilon");
                    if (rv == 0) {
                        return 933;
                    }
                    if (rv < 0) {
                        if (name.equals("Ugrave")) {
                            return 217;
                        }
                        return -1;
                    }
                    if (name.equals("Uuml")) {
                        return 220;
                    }
                    return -1;
                }
                rv = name.compareTo("aacute");
                if (rv == 0) {
                    return 225;
                }
                if (rv < 0) {
                    rv = name.compareTo("Yuml");
                    if (rv == 0) {
                        return 376;
                    }
                    if (rv < 0) {
                        if (name.equals("Yacute")) {
                            return 221;
                        }
                        return -1;
                    }
                    if (name.equals("Zeta")) {
                        return 918;
                    }
                    return -1;
                }
                rv = name.compareTo("acute");
                if (rv == 0) {
                    return 180;
                }
                if (rv < 0) {
                    if (name.equals("acirc")) {
                        return 226;
                    }
                    return -1;
                }
                if (name.equals("aelig")) {
                    return 230;
                }
                return -1;
            }
            rv = name.compareTo("divide");
            if (rv == 0) {
                return 247;
            }
            if (rv < 0) {
                rv = name.compareTo("cedil");
                if (rv == 0) {
                    return 184;
                }
                if (rv < 0) {
                    rv = name.compareTo("atilde");
                    if (rv == 0) {
                        return 227;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("and");
                        if (rv == 0) {
                            return 8743;
                        }
                        if (rv < 0) {
                            rv = name.compareTo("alpha");
                            if (rv == 0) {
                                return 945;
                            }
                            if (rv < 0) {
                                if (name.equals("alefsym")) {
                                    return 8501;
                                }
                                return -1;
                            }
                            if (name.equals("amp")) {
                                return 38;
                            }
                            return -1;
                        }
                        rv = name.compareTo("aring");
                        if (rv == 0) {
                            return 229;
                        }
                        if (rv < 0) {
                            if (name.equals("ang")) {
                                return 8736;
                            }
                            return -1;
                        }
                        if (name.equals("asymp")) {
                            return 8776;
                        }
                        return -1;
                    }
                    rv = name.compareTo("brvbar");
                    if (rv == 0) {
                        return 166;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("bdquo");
                        if (rv == 0) {
                            return 8222;
                        }
                        if (rv < 0) {
                            if (name.equals("auml")) {
                                return 228;
                            }
                            return -1;
                        }
                        if (name.equals("beta")) {
                            return 946;
                        }
                        return -1;
                    }
                    rv = name.compareTo("cap");
                    if (rv == 0) {
                        return 8745;
                    }
                    if (rv < 0) {
                        if (name.equals("bull")) {
                            return 8226;
                        }
                        return -1;
                    }
                    if (name.equals("ccedil")) {
                        return 231;
                    }
                    return -1;
                }
                rv = name.compareTo("cup");
                if (rv == 0) {
                    return 8746;
                }
                if (rv < 0) {
                    rv = name.compareTo("clubs");
                    if (rv == 0) {
                        return 9827;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("chi");
                        if (rv == 0) {
                            return 967;
                        }
                        if (rv < 0) {
                            if (name.equals("cent")) {
                                return 162;
                            }
                            return -1;
                        }
                        if (name.equals("circ")) {
                            return 710;
                        }
                        return -1;
                    }
                    rv = name.compareTo("copy");
                    if (rv == 0) {
                        return 169;
                    }
                    if (rv < 0) {
                        if (name.equals("cong")) {
                            return 8773;
                        }
                        return -1;
                    }
                    if (name.equals("crarr")) {
                        return 8629;
                    }
                    return -1;
                }
                rv = name.compareTo("darr");
                if (rv == 0) {
                    return 8595;
                }
                if (rv < 0) {
                    rv = name.compareTo("dArr");
                    if (rv == 0) {
                        return 8659;
                    }
                    if (rv < 0) {
                        if (name.equals("curren")) {
                            return 164;
                        }
                        return -1;
                    }
                    if (name.equals("dagger")) {
                        return 8224;
                    }
                    return -1;
                }
                rv = name.compareTo("delta");
                if (rv == 0) {
                    return 948;
                }
                if (rv < 0) {
                    if (name.equals("deg")) {
                        return 176;
                    }
                    return -1;
                }
                if (name.equals("diams")) {
                    return 9830;
                }
                return -1;
            }
            rv = name.compareTo("frac12");
            if (rv == 0) {
                return 189;
            }
            if (rv < 0) {
                rv = name.compareTo("equiv");
                if (rv == 0) {
                    return 8801;
                }
                if (rv < 0) {
                    rv = name.compareTo("empty");
                    if (rv == 0) {
                        return 8709;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("ecirc");
                        if (rv == 0) {
                            return 234;
                        }
                        if (rv < 0) {
                            if (name.equals("eacute")) {
                                return 233;
                            }
                            return -1;
                        }
                        if (name.equals("egrave")) {
                            return 232;
                        }
                        return -1;
                    }
                    rv = name.compareTo("ensp");
                    if (rv == 0) {
                        return 8194;
                    }
                    if (rv < 0) {
                        if (name.equals("emsp")) {
                            return 8195;
                        }
                        return -1;
                    }
                    if (name.equals("epsilon")) {
                        return 949;
                    }
                    return -1;
                }
                rv = name.compareTo("euro");
                if (rv == 0) {
                    return 8364;
                }
                if (rv < 0) {
                    rv = name.compareTo("eth");
                    if (rv == 0) {
                        return 240;
                    }
                    if (rv < 0) {
                        if (name.equals("eta")) {
                            return 951;
                        }
                        return -1;
                    }
                    if (name.equals("euml")) {
                        return 235;
                    }
                    return -1;
                }
                rv = name.compareTo("fnof");
                if (rv == 0) {
                    return 402;
                }
                if (rv < 0) {
                    if (name.equals("exist")) {
                        return 8707;
                    }
                    return -1;
                }
                if (name.equals("forall")) {
                    return 8704;
                }
                return -1;
            }
            rv = name.compareTo("harr");
            if (rv == 0) {
                return 8596;
            }
            if (rv < 0) {
                rv = name.compareTo("gamma");
                if (rv == 0) {
                    return 947;
                }
                if (rv < 0) {
                    rv = name.compareTo("frac34");
                    if (rv == 0) {
                        return 190;
                    }
                    if (rv < 0) {
                        if (name.equals("frac14")) {
                            return 188;
                        }
                        return -1;
                    }
                    if (name.equals("frasl")) {
                        return 8260;
                    }
                    return -1;
                }
                rv = name.compareTo("gt");
                if (rv == 0) {
                    return 62;
                }
                if (rv < 0) {
                    if (name.equals("ge")) {
                        return 8805;
                    }
                    return -1;
                }
                if (name.equals("hArr")) {
                    return 8660;
                }
                return -1;
            }
            rv = name.compareTo("icirc");
            if (rv == 0) {
                return 238;
            }
            if (rv < 0) {
                rv = name.compareTo("hellip");
                if (rv == 0) {
                    return 8230;
                }
                if (rv < 0) {
                    if (name.equals("hearts")) {
                        return 9829;
                    }
                    return -1;
                }
                if (name.equals("iacute")) {
                    return 237;
                }
                return -1;
            }
            if (name.equals("iexcl")) {
                return 161;
            }
            if (name.equals("igrave")) {
                return 236;
            }
            return -1;
        }
        rv = name.compareTo("prime");
        if (rv == 0) {
            return 8242;
        }
        if (rv < 0) {
            rv = name.compareTo("ne");
            if (rv == 0) {
                return 8800;
            }
            if (rv < 0) {
                rv = name.compareTo("lfloor");
                if (rv == 0) {
                    return 8970;
                }
                if (rv < 0) {
                    rv = name.compareTo("lArr");
                    if (rv == 0) {
                        return 8656;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("iquest");
                        if (rv == 0) {
                            return 191;
                        }
                        if (rv < 0) {
                            rv = name.compareTo("int");
                            if (rv == 0) {
                                return 8747;
                            }
                            if (rv < 0) {
                                if (name.equals("infin")) {
                                    return 8734;
                                }
                                return -1;
                            }
                            if (name.equals("iota")) {
                                return 953;
                            }
                            return -1;
                        }
                        rv = name.compareTo("iuml");
                        if (rv == 0) {
                            return 239;
                        }
                        if (rv < 0) {
                            if (name.equals("isin")) {
                                return 8712;
                            }
                            return -1;
                        }
                        if (name.equals("kappa")) {
                            return 954;
                        }
                        return -1;
                    }
                    rv = name.compareTo("larr");
                    if (rv == 0) {
                        return 8592;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("lang");
                        if (rv == 0) {
                            return 9001;
                        }
                        if (rv < 0) {
                            if (name.equals("lambda")) {
                                return 955;
                            }
                            return -1;
                        }
                        if (name.equals("laquo")) {
                            return 171;
                        }
                        return -1;
                    }
                    rv = name.compareTo("ldquo");
                    if (rv == 0) {
                        return 8220;
                    }
                    if (rv < 0) {
                        if (name.equals("lceil")) {
                            return 8968;
                        }
                        return -1;
                    }
                    if (name.equals("le")) {
                        return 8804;
                    }
                    return -1;
                }
                rv = name.compareTo("mdash");
                if (rv == 0) {
                    return 8212;
                }
                if (rv < 0) {
                    rv = name.compareTo("lsaquo");
                    if (rv == 0) {
                        return 8249;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("loz");
                        if (rv == 0) {
                            return 9674;
                        }
                        if (rv < 0) {
                            if (name.equals("lowast")) {
                                return 8727;
                            }
                            return -1;
                        }
                        if (name.equals("lrm")) {
                            return 8206;
                        }
                        return -1;
                    }
                    rv = name.compareTo("lt");
                    if (rv == 0) {
                        return 60;
                    }
                    if (rv < 0) {
                        if (name.equals("lsquo")) {
                            return 8216;
                        }
                        return -1;
                    }
                    if (name.equals("macr")) {
                        return 175;
                    }
                    return -1;
                }
                rv = name.compareTo("mu");
                if (rv == 0) {
                    return 956;
                }
                if (rv < 0) {
                    rv = name.compareTo("middot");
                    if (rv == 0) {
                        return 183;
                    }
                    if (rv < 0) {
                        if (name.equals("micro")) {
                            return 181;
                        }
                        return -1;
                    }
                    if (name.equals("minus")) {
                        return 8722;
                    }
                    return -1;
                }
                rv = name.compareTo("nbsp");
                if (rv == 0) {
                    return 160;
                }
                if (rv < 0) {
                    if (name.equals("nabla")) {
                        return 8711;
                    }
                    return -1;
                }
                if (name.equals("ndash")) {
                    return 8211;
                }
                return -1;
            }
            rv = name.compareTo("ordf");
            if (rv == 0) {
                return 170;
            }
            if (rv < 0) {
                rv = name.compareTo("ocirc");
                if (rv == 0) {
                    return 244;
                }
                if (rv < 0) {
                    rv = name.compareTo("nsub");
                    if (rv == 0) {
                        return 8836;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("not");
                        if (rv == 0) {
                            return 172;
                        }
                        if (rv < 0) {
                            if (name.equals("ni")) {
                                return 8715;
                            }
                            return -1;
                        }
                        if (name.equals("notin")) {
                            return 8713;
                        }
                        return -1;
                    }
                    rv = name.compareTo("nu");
                    if (rv == 0) {
                        return 957;
                    }
                    if (rv < 0) {
                        if (name.equals("ntilde")) {
                            return 241;
                        }
                        return -1;
                    }
                    if (name.equals("oacute")) {
                        return 243;
                    }
                    return -1;
                }
                rv = name.compareTo("omega");
                if (rv == 0) {
                    return 969;
                }
                if (rv < 0) {
                    rv = name.compareTo("ograve");
                    if (rv == 0) {
                        return 242;
                    }
                    if (rv < 0) {
                        if (name.equals("oelig")) {
                            return 339;
                        }
                        return -1;
                    }
                    if (name.equals("oline")) {
                        return 8254;
                    }
                    return -1;
                }
                rv = name.compareTo("oplus");
                if (rv == 0) {
                    return 8853;
                }
                if (rv < 0) {
                    if (name.equals("omicron")) {
                        return 959;
                    }
                    return -1;
                }
                if (name.equals("or")) {
                    return 8744;
                }
                return -1;
            }
            rv = name.compareTo("permil");
            if (rv == 0) {
                return 8240;
            }
            if (rv < 0) {
                rv = name.compareTo("otimes");
                if (rv == 0) {
                    return 8855;
                }
                if (rv < 0) {
                    rv = name.compareTo("oslash");
                    if (rv == 0) {
                        return 248;
                    }
                    if (rv < 0) {
                        if (name.equals("ordm")) {
                            return 186;
                        }
                        return -1;
                    }
                    if (name.equals("otilde")) {
                        return 245;
                    }
                    return -1;
                }
                rv = name.compareTo("para");
                if (rv == 0) {
                    return 182;
                }
                if (rv < 0) {
                    if (name.equals("ouml")) {
                        return 246;
                    }
                    return -1;
                }
                if (name.equals("part")) {
                    return 8706;
                }
                return -1;
            }
            rv = name.compareTo("piv");
            if (rv == 0) {
                return 982;
            }
            if (rv < 0) {
                rv = name.compareTo("phi");
                if (rv == 0) {
                    return 966;
                }
                if (rv < 0) {
                    if (name.equals("perp")) {
                        return 8869;
                    }
                    return -1;
                }
                if (name.equals("pi")) {
                    return 960;
                }
                return -1;
            }
            if (name.equals("plusmn")) {
                return 177;
            }
            if (name.equals("pound")) {
                return 163;
            }
            return -1;
        }
        rv = name.compareTo("sup1");
        if (rv == 0) {
            return 185;
        }
        if (rv < 0) {
            rv = name.compareTo("rlm");
            if (rv == 0) {
                return 8207;
            }
            if (rv < 0) {
                rv = name.compareTo("raquo");
                if (rv == 0) {
                    return 187;
                }
                if (rv < 0) {
                    rv = name.compareTo("quot");
                    if (rv == 0) {
                        return 34;
                    }
                    if (rv < 0) {
                        rv = name.compareTo("prop");
                        if (rv == 0) {
                            return 8733;
                        }
                        if (rv < 0) {
                            if (name.equals("prod")) {
                                return 8719;
                            }
                            return -1;
                        }
                        if (name.equals("psi")) {
                            return 968;
                        }
                        return -1;
                    }
                    rv = name.compareTo("radic");
                    if (rv == 0) {
                        return 8730;
                    }
                    if (rv < 0) {
                        if (name.equals("rArr")) {
                            return 8658;
                        }
                        return -1;
                    }
                    if (name.equals("rang")) {
                        return 9002;
                    }
                    return -1;
                }
                rv = name.compareTo("real");
                if (rv == 0) {
                    return 8476;
                }
                if (rv < 0) {
                    rv = name.compareTo("rceil");
                    if (rv == 0) {
                        return 8969;
                    }
                    if (rv < 0) {
                        if (name.equals("rarr")) {
                            return 8594;
                        }
                        return -1;
                    }
                    if (name.equals("rdquo")) {
                        return 8221;
                    }
                    return -1;
                }
                rv = name.compareTo("rfloor");
                if (rv == 0) {
                    return 8971;
                }
                if (rv < 0) {
                    if (name.equals("reg")) {
                        return 174;
                    }
                    return -1;
                }
                if (name.equals("rho")) {
                    return 961;
                }
                return -1;
            }
            rv = name.compareTo("sigma");
            if (rv == 0) {
                return 963;
            }
            if (rv < 0) {
                rv = name.compareTo("scaron");
                if (rv == 0) {
                    return 353;
                }
                if (rv < 0) {
                    rv = name.compareTo("rsquo");
                    if (rv == 0) {
                        return 8217;
                    }
                    if (rv < 0) {
                        if (name.equals("rsaquo")) {
                            return 8250;
                        }
                        return -1;
                    }
                    if (name.equals("sbquo")) {
                        return 8218;
                    }
                    return -1;
                }
                rv = name.compareTo("sect");
                if (rv == 0) {
                    return 167;
                }
                if (rv < 0) {
                    if (name.equals("sdot")) {
                        return 8901;
                    }
                    return -1;
                }
                if (name.equals("shy")) {
                    return 173;
                }
                return -1;
            }
            rv = name.compareTo("sub");
            if (rv == 0) {
                return 8834;
            }
            if (rv < 0) {
                rv = name.compareTo("sim");
                if (rv == 0) {
                    return 8764;
                }
                if (rv < 0) {
                    if (name.equals("sigmaf")) {
                        return 962;
                    }
                    return -1;
                }
                if (name.equals("spades")) {
                    return 9824;
                }
                return -1;
            }
            rv = name.compareTo("sum");
            if (rv == 0) {
                return 8721;
            }
            if (rv < 0) {
                if (name.equals("sube")) {
                    return 8838;
                }
                return -1;
            }
            if (name.equals("sup")) {
                return 8835;
            }
            return -1;
        }
        rv = name.compareTo("uarr");
        if (rv == 0) {
            return 8593;
        }
        if (rv < 0) {
            rv = name.compareTo("thetasym");
            if (rv == 0) {
                return 977;
            }
            if (rv < 0) {
                rv = name.compareTo("szlig");
                if (rv == 0) {
                    return 223;
                }
                if (rv < 0) {
                    rv = name.compareTo("sup3");
                    if (rv == 0) {
                        return 179;
                    }
                    if (rv < 0) {
                        if (name.equals("sup2")) {
                            return 178;
                        }
                        return -1;
                    }
                    if (name.equals("supe")) {
                        return 8839;
                    }
                    return -1;
                }
                rv = name.compareTo("there4");
                if (rv == 0) {
                    return 8756;
                }
                if (rv < 0) {
                    if (name.equals("tau")) {
                        return 964;
                    }
                    return -1;
                }
                if (name.equals("theta")) {
                    return 952;
                }
                return -1;
            }
            rv = name.compareTo("times");
            if (rv == 0) {
                return 215;
            }
            if (rv < 0) {
                rv = name.compareTo("thorn");
                if (rv == 0) {
                    return 254;
                }
                if (rv < 0) {
                    if (name.equals("thinsp")) {
                        return 8201;
                    }
                    return -1;
                }
                if (name.equals("tilde")) {
                    return 732;
                }
                return -1;
            }
            rv = name.compareTo("uArr");
            if (rv == 0) {
                return 8657;
            }
            if (rv < 0) {
                if (name.equals("trade")) {
                    return 8482;
                }
                return -1;
            }
            if (name.equals("uacute")) {
                return 250;
            }
            return -1;
        }
        rv = name.compareTo("xi");
        if (rv == 0) {
            return 958;
        }
        if (rv < 0) {
            rv = name.compareTo("upsih");
            if (rv == 0) {
                return 978;
            }
            if (rv < 0) {
                rv = name.compareTo("ugrave");
                if (rv == 0) {
                    return 249;
                }
                if (rv < 0) {
                    if (name.equals("ucirc")) {
                        return 251;
                    }
                    return -1;
                }
                if (name.equals("uml")) {
                    return 168;
                }
                return -1;
            }
            rv = name.compareTo("uuml");
            if (rv == 0) {
                return 252;
            }
            if (rv < 0) {
                if (name.equals("upsilon")) {
                    return 965;
                }
                return -1;
            }
            if (name.equals("weierp")) {
                return 8472;
            }
            return -1;
        }
        rv = name.compareTo("zeta");
        if (rv == 0) {
            return 950;
        }
        if (rv < 0) {
            rv = name.compareTo("yen");
            if (rv == 0) {
                return 165;
            }
            if (rv < 0) {
                if (name.equals("yacute")) {
                    return 253;
                }
                return -1;
            }
            if (name.equals("yuml")) {
                return 255;
            }
            return -1;
        }
        if (name.equals("zwj")) {
            return 8205;
        }
        if (name.equals("zwnj")) {
            return 8204;
        }
        return -1;
    }

    public static String findName(int code) {
        if (code == 932) {
            return "Tau";
        }
        if (code < 932) {
            if (code == 219) {
                return "Ucirc";
            }
            if (code < 219) {
                if (code == 187) {
                    return "raquo";
                }
                if (code < 187) {
                    if (code == 171) {
                        return "laquo";
                    }
                    if (code < 171) {
                        if (code == 163) {
                            return "pound";
                        }
                        if (code < 163) {
                            if (code == 62) {
                                return "gt";
                            }
                            if (code < 62) {
                                if (code == 38) {
                                    return "amp";
                                }
                                if (code < 38) {
                                    if (code == 34) {
                                        return "quot";
                                    }
                                    return null;
                                }
                                if (code == 60) {
                                    return "lt";
                                }
                                return null;
                            }
                            if (code == 161) {
                                return "iexcl";
                            }
                            if (code < 161) {
                                if (code == 160) {
                                    return "nbsp";
                                }
                                return null;
                            }
                            if (code == 162) {
                                return "cent";
                            }
                            return null;
                        }
                        if (code == 167) {
                            return "sect";
                        }
                        if (code < 167) {
                            if (code == 165) {
                                return "yen";
                            }
                            if (code < 165) {
                                if (code == 164) {
                                    return "curren";
                                }
                                return null;
                            }
                            if (code == 166) {
                                return "brvbar";
                            }
                            return null;
                        }
                        if (code == 169) {
                            return "copy";
                        }
                        if (code < 169) {
                            if (code == 168) {
                                return "uml";
                            }
                            return null;
                        }
                        if (code == 170) {
                            return "ordf";
                        }
                        return null;
                    }
                    if (code == 179) {
                        return "sup3";
                    }
                    if (code < 179) {
                        if (code == 175) {
                            return "macr";
                        }
                        if (code < 175) {
                            if (code == 173) {
                                return "shy";
                            }
                            if (code < 173) {
                                if (code == 172) {
                                    return "not";
                                }
                                return null;
                            }
                            if (code == 174) {
                                return "reg";
                            }
                            return null;
                        }
                        if (code == 177) {
                            return "plusmn";
                        }
                        if (code < 177) {
                            if (code == 176) {
                                return "deg";
                            }
                            return null;
                        }
                        if (code == 178) {
                            return "sup2";
                        }
                        return null;
                    }
                    if (code == 183) {
                        return "middot";
                    }
                    if (code < 183) {
                        if (code == 181) {
                            return "micro";
                        }
                        if (code < 181) {
                            if (code == 180) {
                                return "acute";
                            }
                            return null;
                        }
                        if (code == 182) {
                            return "para";
                        }
                        return null;
                    }
                    if (code == 185) {
                        return "sup1";
                    }
                    if (code < 185) {
                        if (code == 184) {
                            return "cedil";
                        }
                        return null;
                    }
                    if (code == 186) {
                        return "ordm";
                    }
                    return null;
                }
                if (code == 203) {
                    return "Euml";
                }
                if (code < 203) {
                    if (code == 195) {
                        return "Atilde";
                    }
                    if (code < 195) {
                        if (code == 191) {
                            return "iquest";
                        }
                        if (code < 191) {
                            if (code == 189) {
                                return "frac12";
                            }
                            if (code < 189) {
                                if (code == 188) {
                                    return "frac14";
                                }
                                return null;
                            }
                            if (code == 190) {
                                return "frac34";
                            }
                            return null;
                        }
                        if (code == 193) {
                            return "Aacute";
                        }
                        if (code < 193) {
                            if (code == 192) {
                                return "Agrave";
                            }
                            return null;
                        }
                        if (code == 194) {
                            return "Acirc";
                        }
                        return null;
                    }
                    if (code == 199) {
                        return "Ccedil";
                    }
                    if (code < 199) {
                        if (code == 197) {
                            return "Aring";
                        }
                        if (code < 197) {
                            if (code == 196) {
                                return "Auml";
                            }
                            return null;
                        }
                        if (code == 198) {
                            return "AElig";
                        }
                        return null;
                    }
                    if (code == 201) {
                        return "Eacute";
                    }
                    if (code < 201) {
                        if (code == 200) {
                            return "Egrave";
                        }
                        return null;
                    }
                    if (code == 202) {
                        return "Ecirc";
                    }
                    return null;
                }
                if (code == 211) {
                    return "Oacute";
                }
                if (code < 211) {
                    if (code == 207) {
                        return "Iuml";
                    }
                    if (code < 207) {
                        if (code == 205) {
                            return "Iacute";
                        }
                        if (code < 205) {
                            if (code == 204) {
                                return "Igrave";
                            }
                            return null;
                        }
                        if (code == 206) {
                            return "Icirc";
                        }
                        return null;
                    }
                    if (code == 209) {
                        return "Ntilde";
                    }
                    if (code < 209) {
                        if (code == 208) {
                            return "ETH";
                        }
                        return null;
                    }
                    if (code == 210) {
                        return "Ograve";
                    }
                    return null;
                }
                if (code == 215) {
                    return "times";
                }
                if (code < 215) {
                    if (code == 213) {
                        return "Otilde";
                    }
                    if (code < 213) {
                        if (code == 212) {
                            return "Ocirc";
                        }
                        return null;
                    }
                    if (code == 214) {
                        return "Ouml";
                    }
                    return null;
                }
                if (code == 217) {
                    return "Ugrave";
                }
                if (code < 217) {
                    if (code == 216) {
                        return "Oslash";
                    }
                    return null;
                }
                if (code == 218) {
                    return "Uacute";
                }
                return null;
            }
            if (code == 251) {
                return "ucirc";
            }
            if (code < 251) {
                if (code == 235) {
                    return "euml";
                }
                if (code < 235) {
                    if (code == 227) {
                        return "atilde";
                    }
                    if (code < 227) {
                        if (code == 223) {
                            return "szlig";
                        }
                        if (code < 223) {
                            if (code == 221) {
                                return "Yacute";
                            }
                            if (code < 221) {
                                if (code == 220) {
                                    return "Uuml";
                                }
                                return null;
                            }
                            if (code == 222) {
                                return "THORN";
                            }
                            return null;
                        }
                        if (code == 225) {
                            return "aacute";
                        }
                        if (code < 225) {
                            if (code == 224) {
                                return "agrave";
                            }
                            return null;
                        }
                        if (code == 226) {
                            return "acirc";
                        }
                        return null;
                    }
                    if (code == 231) {
                        return "ccedil";
                    }
                    if (code < 231) {
                        if (code == 229) {
                            return "aring";
                        }
                        if (code < 229) {
                            if (code == 228) {
                                return "auml";
                            }
                            return null;
                        }
                        if (code == 230) {
                            return "aelig";
                        }
                        return null;
                    }
                    if (code == 233) {
                        return "eacute";
                    }
                    if (code < 233) {
                        if (code == 232) {
                            return "egrave";
                        }
                        return null;
                    }
                    if (code == 234) {
                        return "ecirc";
                    }
                    return null;
                }
                if (code == 243) {
                    return "oacute";
                }
                if (code < 243) {
                    if (code == 239) {
                        return "iuml";
                    }
                    if (code < 239) {
                        if (code == 237) {
                            return "iacute";
                        }
                        if (code < 237) {
                            if (code == 236) {
                                return "igrave";
                            }
                            return null;
                        }
                        if (code == 238) {
                            return "icirc";
                        }
                        return null;
                    }
                    if (code == 241) {
                        return "ntilde";
                    }
                    if (code < 241) {
                        if (code == 240) {
                            return "eth";
                        }
                        return null;
                    }
                    if (code == 242) {
                        return "ograve";
                    }
                    return null;
                }
                if (code == 247) {
                    return "divide";
                }
                if (code < 247) {
                    if (code == 245) {
                        return "otilde";
                    }
                    if (code < 245) {
                        if (code == 244) {
                            return "ocirc";
                        }
                        return null;
                    }
                    if (code == 246) {
                        return "ouml";
                    }
                    return null;
                }
                if (code == 249) {
                    return "ugrave";
                }
                if (code < 249) {
                    if (code == 248) {
                        return "oslash";
                    }
                    return null;
                }
                if (code == 250) {
                    return "uacute";
                }
                return null;
            }
            if (code == 916) {
                return "Delta";
            }
            if (code < 916) {
                if (code == 353) {
                    return "scaron";
                }
                if (code < 353) {
                    if (code == 255) {
                        return "yuml";
                    }
                    if (code < 255) {
                        if (code == 253) {
                            return "yacute";
                        }
                        if (code < 253) {
                            if (code == 252) {
                                return "uuml";
                            }
                            return null;
                        }
                        if (code == 254) {
                            return "thorn";
                        }
                        return null;
                    }
                    if (code == 339) {
                        return "oelig";
                    }
                    if (code < 339) {
                        if (code == 338) {
                            return "OElig";
                        }
                        return null;
                    }
                    if (code == 352) {
                        return "Scaron";
                    }
                    return null;
                }
                if (code == 732) {
                    return "tilde";
                }
                if (code < 732) {
                    if (code == 402) {
                        return "fnof";
                    }
                    if (code < 402) {
                        if (code == 376) {
                            return "Yuml";
                        }
                        return null;
                    }
                    if (code == 710) {
                        return "circ";
                    }
                    return null;
                }
                if (code == 914) {
                    return "Beta";
                }
                if (code < 914) {
                    if (code == 913) {
                        return "Alpha";
                    }
                    return null;
                }
                if (code == 915) {
                    return "Gamma";
                }
                return null;
            }
            if (code == 924) {
                return "Mu";
            }
            if (code < 924) {
                if (code == 920) {
                    return "Theta";
                }
                if (code < 920) {
                    if (code == 918) {
                        return "Zeta";
                    }
                    if (code < 918) {
                        if (code == 917) {
                            return "Epsilon";
                        }
                        return null;
                    }
                    if (code == 919) {
                        return "Eta";
                    }
                    return null;
                }
                if (code == 922) {
                    return "Kappa";
                }
                if (code < 922) {
                    if (code == 921) {
                        return "Iota";
                    }
                    return null;
                }
                if (code == 923) {
                    return "Lambda";
                }
                return null;
            }
            if (code == 928) {
                return "Pi";
            }
            if (code < 928) {
                if (code == 926) {
                    return "Xi";
                }
                if (code < 926) {
                    if (code == 925) {
                        return "Nu";
                    }
                    return null;
                }
                if (code == 927) {
                    return "Omicron";
                }
                return null;
            }
            if (code == 929) {
                return "Rho";
            }
            if (code == 931) {
                return "Sigma";
            }
            return null;
        }
        if (code == 8476) {
            return "real";
        }
        if (code < 8476) {
            if (code == 978) {
                return "upsih";
            }
            if (code < 978) {
                if (code == 955) {
                    return "lambda";
                }
                if (code < 955) {
                    if (code == 947) {
                        return "gamma";
                    }
                    if (code < 947) {
                        if (code == 936) {
                            return "Psi";
                        }
                        if (code < 936) {
                            if (code == 934) {
                                return "Phi";
                            }
                            if (code < 934) {
                                if (code == 933) {
                                    return "Upsilon";
                                }
                                return null;
                            }
                            if (code == 935) {
                                return "Chi";
                            }
                            return null;
                        }
                        if (code == 945) {
                            return "alpha";
                        }
                        if (code < 945) {
                            if (code == 937) {
                                return "Omega";
                            }
                            return null;
                        }
                        if (code == 946) {
                            return "beta";
                        }
                        return null;
                    }
                    if (code == 951) {
                        return "eta";
                    }
                    if (code < 951) {
                        if (code == 949) {
                            return "epsilon";
                        }
                        if (code < 949) {
                            if (code == 948) {
                                return "delta";
                            }
                            return null;
                        }
                        if (code == 950) {
                            return "zeta";
                        }
                        return null;
                    }
                    if (code == 953) {
                        return "iota";
                    }
                    if (code < 953) {
                        if (code == 952) {
                            return "theta";
                        }
                        return null;
                    }
                    if (code == 954) {
                        return "kappa";
                    }
                    return null;
                }
                if (code == 963) {
                    return "sigma";
                }
                if (code < 963) {
                    if (code == 959) {
                        return "omicron";
                    }
                    if (code < 959) {
                        if (code == 957) {
                            return "nu";
                        }
                        if (code < 957) {
                            if (code == 956) {
                                return "mu";
                            }
                            return null;
                        }
                        if (code == 958) {
                            return "xi";
                        }
                        return null;
                    }
                    if (code == 961) {
                        return "rho";
                    }
                    if (code < 961) {
                        if (code == 960) {
                            return "pi";
                        }
                        return null;
                    }
                    if (code == 962) {
                        return "sigmaf";
                    }
                    return null;
                }
                if (code == 967) {
                    return "chi";
                }
                if (code < 967) {
                    if (code == 965) {
                        return "upsilon";
                    }
                    if (code < 965) {
                        if (code == 964) {
                            return "tau";
                        }
                        return null;
                    }
                    if (code == 966) {
                        return "phi";
                    }
                    return null;
                }
                if (code == 969) {
                    return "omega";
                }
                if (code < 969) {
                    if (code == 968) {
                        return "psi";
                    }
                    return null;
                }
                if (code == 977) {
                    return "thetasym";
                }
                return null;
            }
            if (code == 8222) {
                return "bdquo";
            }
            if (code < 8222) {
                if (code == 8207) {
                    return "rlm";
                }
                if (code < 8207) {
                    if (code == 8201) {
                        return "thinsp";
                    }
                    if (code < 8201) {
                        if (code == 8194) {
                            return "ensp";
                        }
                        if (code < 8194) {
                            if (code == 982) {
                                return "piv";
                            }
                            return null;
                        }
                        if (code == 8195) {
                            return "emsp";
                        }
                        return null;
                    }
                    if (code == 8205) {
                        return "zwj";
                    }
                    if (code < 8205) {
                        if (code == 8204) {
                            return "zwnj";
                        }
                        return null;
                    }
                    if (code == 8206) {
                        return "lrm";
                    }
                    return null;
                }
                if (code == 8217) {
                    return "rsquo";
                }
                if (code < 8217) {
                    if (code == 8212) {
                        return "mdash";
                    }
                    if (code < 8212) {
                        if (code == 8211) {
                            return "ndash";
                        }
                        return null;
                    }
                    if (code == 8216) {
                        return "lsquo";
                    }
                    return null;
                }
                if (code == 8220) {
                    return "ldquo";
                }
                if (code < 8220) {
                    if (code == 8218) {
                        return "sbquo";
                    }
                    return null;
                }
                if (code == 8221) {
                    return "rdquo";
                }
                return null;
            }
            if (code == 8249) {
                return "lsaquo";
            }
            if (code < 8249) {
                if (code == 8230) {
                    return "hellip";
                }
                if (code < 8230) {
                    if (code == 8225) {
                        return "Dagger";
                    }
                    if (code < 8225) {
                        if (code == 8224) {
                            return "dagger";
                        }
                        return null;
                    }
                    if (code == 8226) {
                        return "bull";
                    }
                    return null;
                }
                if (code == 8242) {
                    return "prime";
                }
                if (code < 8242) {
                    if (code == 8240) {
                        return "permil";
                    }
                    return null;
                }
                if (code == 8243) {
                    return "Prime";
                }
                return null;
            }
            if (code == 8364) {
                return "euro";
            }
            if (code < 8364) {
                if (code == 8254) {
                    return "oline";
                }
                if (code < 8254) {
                    if (code == 8250) {
                        return "rsaquo";
                    }
                    return null;
                }
                if (code == 8260) {
                    return "frasl";
                }
                return null;
            }
            if (code == 8465) {
                return "image";
            }
            if (code == 8472) {
                return "weierp";
            }
            return null;
        }
        if (code == 8745) {
            return "cap";
        }
        if (code < 8745) {
            if (code == 8707) {
                return "exist";
            }
            if (code < 8707) {
                if (code == 8629) {
                    return "crarr";
                }
                if (code < 8629) {
                    if (code == 8593) {
                        return "uarr";
                    }
                    if (code < 8593) {
                        if (code == 8501) {
                            return "alefsym";
                        }
                        if (code < 8501) {
                            if (code == 8482) {
                                return "trade";
                            }
                            return null;
                        }
                        if (code == 8592) {
                            return "larr";
                        }
                        return null;
                    }
                    if (code == 8595) {
                        return "darr";
                    }
                    if (code < 8595) {
                        if (code == 8594) {
                            return "rarr";
                        }
                        return null;
                    }
                    if (code == 8596) {
                        return "harr";
                    }
                    return null;
                }
                if (code == 8659) {
                    return "dArr";
                }
                if (code < 8659) {
                    if (code == 8657) {
                        return "uArr";
                    }
                    if (code < 8657) {
                        if (code == 8656) {
                            return "lArr";
                        }
                        return null;
                    }
                    if (code == 8658) {
                        return "rArr";
                    }
                    return null;
                }
                if (code == 8704) {
                    return "forall";
                }
                if (code < 8704) {
                    if (code == 8660) {
                        return "hArr";
                    }
                    return null;
                }
                if (code == 8706) {
                    return "part";
                }
                return null;
            }
            if (code == 8722) {
                return "minus";
            }
            if (code < 8722) {
                if (code == 8713) {
                    return "notin";
                }
                if (code < 8713) {
                    if (code == 8711) {
                        return "nabla";
                    }
                    if (code < 8711) {
                        if (code == 8709) {
                            return "empty";
                        }
                        return null;
                    }
                    if (code == 8712) {
                        return "isin";
                    }
                    return null;
                }
                if (code == 8719) {
                    return "prod";
                }
                if (code < 8719) {
                    if (code == 8715) {
                        return "ni";
                    }
                    return null;
                }
                if (code == 8721) {
                    return "sum";
                }
                return null;
            }
            if (code == 8734) {
                return "infin";
            }
            if (code < 8734) {
                if (code == 8730) {
                    return "radic";
                }
                if (code < 8730) {
                    if (code == 8727) {
                        return "lowast";
                    }
                    return null;
                }
                if (code == 8733) {
                    return "prop";
                }
                return null;
            }
            if (code == 8743) {
                return "and";
            }
            if (code < 8743) {
                if (code == 8736) {
                    return "ang";
                }
                return null;
            }
            if (code == 8744) {
                return "or";
            }
            return null;
        }
        if (code == 8853) {
            return "oplus";
        }
        if (code < 8853) {
            if (code == 8801) {
                return "equiv";
            }
            if (code < 8801) {
                if (code == 8764) {
                    return "sim";
                }
                if (code < 8764) {
                    if (code == 8747) {
                        return "int";
                    }
                    if (code < 8747) {
                        if (code == 8746) {
                            return "cup";
                        }
                        return null;
                    }
                    if (code == 8756) {
                        return "there4";
                    }
                    return null;
                }
                if (code == 8776) {
                    return "asymp";
                }
                if (code < 8776) {
                    if (code == 8773) {
                        return "cong";
                    }
                    return null;
                }
                if (code == 8800) {
                    return "ne";
                }
                return null;
            }
            if (code == 8835) {
                return "sup";
            }
            if (code < 8835) {
                if (code == 8805) {
                    return "ge";
                }
                if (code < 8805) {
                    if (code == 8804) {
                        return "le";
                    }
                    return null;
                }
                if (code == 8834) {
                    return "sub";
                }
                return null;
            }
            if (code == 8838) {
                return "sube";
            }
            if (code < 8838) {
                if (code == 8836) {
                    return "nsub";
                }
                return null;
            }
            if (code == 8839) {
                return "supe";
            }
            return null;
        }
        if (code == 9001) {
            return "lang";
        }
        if (code < 9001) {
            if (code == 8968) {
                return "lceil";
            }
            if (code < 8968) {
                if (code == 8869) {
                    return "perp";
                }
                if (code < 8869) {
                    if (code == 8855) {
                        return "otimes";
                    }
                    return null;
                }
                if (code == 8901) {
                    return "sdot";
                }
                return null;
            }
            if (code == 8970) {
                return "lfloor";
            }
            if (code < 8970) {
                if (code == 8969) {
                    return "rceil";
                }
                return null;
            }
            if (code == 8971) {
                return "rfloor";
            }
            return null;
        }
        if (code == 9827) {
            return "clubs";
        }
        if (code < 9827) {
            if (code == 9674) {
                return "loz";
            }
            if (code < 9674) {
                if (code == 9002) {
                    return "rang";
                }
                return null;
            }
            if (code == 9824) {
                return "spades";
            }
            return null;
        }
        if (code == 9829) {
            return "hearts";
        }
        if (code == 9830) {
            return "diams";
        }
        return null;
    }
}

