/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import javax.annotation.Nullable;

public final class IntHashMap<T> {
    private Entry<T>[] m_table;
    private int m_count;
    private int m_threshold;
    private final float m_loadFactor;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.m_loadFactor = loadFactor;
        this.m_table = new Entry[initialCapacity];
        this.m_threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.m_count;
    }

    public boolean isEmpty() {
        return this.m_count == 0;
    }

    public boolean containsValue(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry<T>[] tab = this.m_table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.m_value.equals(value)) {
                    return true;
                }
                e = e.m_next;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        Entry<T>[] tab = this.m_table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.m_hash == hash) {
                return true;
            }
            e = e.m_next;
        }
        return false;
    }

    @Nullable
    public T get(int key) {
        Entry<T>[] tab = this.m_table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.m_hash == hash) {
                return (T)e.m_value;
            }
            e = e.m_next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.m_table.length;
        Entry<T>[] oldMap = this.m_table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.m_threshold = (int)((float)newCapacity * this.m_loadFactor);
        this.m_table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.m_next;
                int index = (e.m_hash & Integer.MAX_VALUE) % newCapacity;
                e.m_next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    @Nullable
    public T put(int key, T value) {
        Entry<T>[] tab = this.m_table;
        int index = (key & Integer.MAX_VALUE) % tab.length;
        Entry<T> e = tab[index];
        while (e != null) {
            if (e.m_hash == key) {
                Object old = ((Entry)e).m_value;
                ((Entry)e).m_value = value;
                return (T)old;
            }
            e = ((Entry)e).m_next;
        }
        if (this.m_count >= this.m_threshold) {
            this.rehash();
            tab = this.m_table;
            index = (key & Integer.MAX_VALUE) % tab.length;
        }
        e = new Entry<T>(key, value, tab[index]);
        tab[index] = e;
        ++this.m_count;
        return null;
    }

    @Nullable
    public T remove(int key) {
        Entry<T>[] tab = this.m_table;
        int hash = key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.m_hash == hash) {
                if (prev != null) {
                    prev.m_next = e.m_next;
                } else {
                    tab[index] = e.m_next;
                }
                --this.m_count;
                Object oldValue = e.m_value;
                e.m_value = null;
                return (T)oldValue;
            }
            prev = e;
            e = e.m_next;
        }
        return null;
    }

    public void clear() {
        Entry<T>[] tab = this.m_table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.m_count = 0;
    }

    private static final class Entry<T> {
        final int m_hash;
        private T m_value;
        private Entry<T> m_next;

        protected Entry(int hash, T value, Entry<T> next) {
            this.m_hash = hash;
            this.m_value = value;
            this.m_next = next;
        }
    }
}

