/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import javax.annotation.DefaultNonNull;
import javax.annotation.Nullable;
import to.etc.util.FileTool;
import to.etc.util.WrappedException;

@DefaultNonNull
public final class Lorem {
    @Nullable
    private static String m_lorem;
    private static int m_lastIndex;

    private Lorem() {
    }

    private static synchronized String getLorem() {
        String lorem = m_lorem;
        if (null == lorem) {
            try {
                lorem = m_lorem = FileTool.readResourceAsString(Lorem.class, "Lorem.txt", "utf-8");
            }
            catch (Exception x) {
                throw WrappedException.wrap(x);
            }
        }
        return lorem;
    }

    public static String getLorumSentences(int sentences) {
        String lorum = Lorem.getLorem();
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        while (sentences > 0) {
            int epos = lorum.indexOf(46, pos);
            if (epos == -1) {
                pos = 0;
                continue;
            }
            sb.append(lorum, pos, ++epos);
            pos = epos;
            --sentences;
        }
        return sb.toString();
    }

    public static synchronized String getRandomLorumSentences(int sentences) {
        String lorum = Lorem.getLorem();
        StringBuilder sb = new StringBuilder();
        int pos = m_lastIndex;
        while (sentences > 0) {
            int epos = lorum.indexOf(46, pos);
            if (epos == -1) {
                pos = 0;
                continue;
            }
            ++epos;
            while (pos < epos && lorum.charAt(pos) == ' ') {
                ++pos;
            }
            sb.append(lorum, pos, epos);
            pos = epos;
            --sentences;
        }
        m_lastIndex = pos;
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("1: " + Lorem.getLorumSentences(1));
        System.out.println("2: " + Lorem.getLorumSentences(2));
        System.out.println("30: " + Lorem.getLorumSentences(30));
        System.out.println(" ---\n\n");
        for (int i = 0; i < 5; ++i) {
            System.out.println("#" + i + " " + Lorem.getRandomLorumSentences(2));
        }
    }
}

