/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.IOException;
import to.etc.util.ILogSink;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;

public class MemoryLogSink
implements ILogSink {
    private Appendable m_sb;

    public MemoryLogSink(Appendable a) {
        this.m_sb = a;
    }

    @Override
    public void exception(Throwable t, String msg) {
        try {
            this.m_sb.append("Exception: ");
            this.m_sb.append(msg);
            this.m_sb.append("\n");
            this.m_sb.append(": ");
            StringTool.strStacktrace(this.m_sb, t);
        }
        catch (IOException x) {
            throw new WrappedException(x);
        }
    }

    @Override
    public void log(String msg) {
        try {
            this.m_sb.append(msg);
            this.m_sb.append("\n");
        }
        catch (IOException x) {
            throw new WrappedException(x);
        }
    }
}

