/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import to.etc.util.PropData;

class PropReader {
    private String m_line;
    private int m_mode;
    private int m_blankLines;
    private StringBuffer m_cmt;
    private StringBuffer m_lrb;
    protected Map<String, PropData> m_ht = new HashMap<String, PropData>();
    protected List<PropData> m_v = new ArrayList<PropData>();

    PropReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFile(File f) throws Exception {
        LineNumberReader lr = new LineNumberReader(new BufferedReader(new FileReader(f), 1024));
        try {
            this.m_cmt = new StringBuffer();
            this.m_lrb = new StringBuffer();
            this.m_mode = 0;
            this.m_blankLines = 0;
            while (true) {
                this.m_line = lr.readLine();
                if (this.m_line == null) {
                    break;
                }
                if (this.m_line.trim().compareTo("") == 0) {
                    ++this.m_blankLines;
                    continue;
                }
                if (this.m_mode == 0) {
                    this.scanStart();
                    continue;
                }
                this.scanDataLine();
            }
        }
        finally {
            try {
                lr.close();
            }
            catch (Exception exception) {}
        }
    }

    private void scanStart() throws Exception {
        int ix = 0;
        char c = '\u0000';
        while (true) {
            if (ix >= this.m_line.length()) {
                return;
            }
            c = this.m_line.charAt(ix);
            if (!Character.isWhitespace(c)) break;
            ++ix;
        }
        if (c == '#') {
            this.m_cmt.append(this.m_line);
            this.m_cmt.append('\n');
            return;
        }
        this.scanDataLine();
    }

    private boolean scanDataLine() throws Exception {
        int ix = this.m_line.length();
        char c = '\u0000';
        while (ix > 0 && Character.isWhitespace(c = (char)this.m_line.charAt(--ix))) {
        }
        if (c == '\\') {
            this.appendLine(this.m_line.substring(0, ix).trim());
            this.m_mode = 1;
            return true;
        }
        this.appendLine(this.m_line.trim());
        this.addData();
        this.m_blankLines = 0;
        this.m_mode = 0;
        return false;
    }

    private void appendLine(String s) {
        int len = this.m_line.length();
        int ix = 0;
        while (ix < len) {
            char c;
            if ((c = this.m_line.charAt(ix++)) == '\\' && ix < len) {
                c = this.m_line.charAt(ix++);
            }
            this.m_lrb.append(c);
        }
    }

    private void addData() throws Exception {
        String s = this.m_lrb.toString();
        int ix = s.indexOf(61);
        if (ix == -1) {
            throw new Exception("Illegal format: need key = value..");
        }
        String key = s.substring(0, ix).trim();
        String val = s.substring(ix + 1);
        PropData pd = new PropData();
        pd.m_cmt = this.m_cmt.toString();
        this.m_cmt.setLength(0);
        pd.m_key = key;
        pd.m_val = val;
        pd.m_blankLines = this.m_blankLines;
        this.m_lrb.setLength(0);
        this.m_v.add(pd);
        key = key.toLowerCase();
        PropData pd2 = this.m_ht.get(key);
        if (pd2 != null) {
            throw new Exception("Duplicate key " + key);
        }
        this.m_ht.put(key, pd);
    }
}

