/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import to.etc.util.PropData;

class PropWriter {
    protected Map<String, PropData> m_ht = new HashMap<String, PropData>();
    protected List<PropData> m_v = new ArrayList<PropData>();
    protected File m_propFile = null;

    PropWriter() {
    }

    public void init(File propFile, Map<String, PropData> ht, List<PropData> v) {
        this.m_propFile = propFile;
        this.m_ht = ht;
        this.m_v = v;
    }

    public void writePropFile() throws IOException {
        PrintWriter pw = new PrintWriter(new FileOutputStream(this.m_propFile));
        for (PropData pd : this.m_v) {
            if (pd.m_cmt != null && pd.m_cmt.length() != 0) {
                this.writeCmtLine(pw, pd.m_cmt);
            }
            pw.println(pd.m_key + "=" + pd.m_val);
            for (int i = 0; i < pd.m_blankLines; ++i) {
                pw.println("");
            }
        }
        pw.close();
    }

    private void writeCmtLine(PrintWriter pw, String cmt) {
        StringBuffer sb = new StringBuffer(cmt.length());
        boolean chkhash = true;
        for (int i = 0; i < cmt.length(); ++i) {
            char c = cmt.charAt(i);
            if (c == '\n') {
                chkhash = true;
                pw.println(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (c == '#') {
                chkhash = false;
                sb.append(c);
                continue;
            }
            if (chkhash) {
                sb.append('#');
            }
            sb.append(c);
            chkhash = false;
        }
        if (sb.length() > 0) {
            pw.println(sb.toString());
        }
    }
}

