/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

public class RuntimeConversionException
extends RuntimeException {
    private String m_where;
    private String m_message;

    public RuntimeConversionException() {
    }

    public RuntimeConversionException(Object in, String to) {
        this.m_message = "Cannot convert object type " + (in == null ? "(null)" : in.getClass().getName()) + " to " + to + "( value=" + in + ")";
    }

    public RuntimeConversionException(Exception cause, Object in, String to) {
        super(cause);
        this.m_message = "Cannot convert object type " + (in == null ? "(null)" : in.getClass().getName()) + " to " + to + "( value=" + in + ")";
    }

    public RuntimeConversionException(String message) {
        this.m_message = message;
    }

    public RuntimeConversionException(String message, Throwable cause) {
        super(message, cause);
        this.m_message = message;
    }

    public RuntimeConversionException(Throwable cause) {
        super(cause);
    }

    @Override
    public String getMessage() {
        if (this.m_message == null) {
            if (this.m_where == null) {
                return "Unknown conversion error";
            }
            return "Unknown conversion error: " + this.m_where;
        }
        if (this.m_where == null) {
            return this.m_message;
        }
        return this.m_message + " " + this.m_where;
    }

    public void setWhere(String s) {
        this.m_where = s;
    }
}

