/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import to.etc.util.IListable;
import to.etc.util.IMappable;
import to.etc.util.RuntimeConversionException;

public class RuntimeConversions {
    private static final IListable<Object> NO_VALUES = new IListable<Object>(){

        @Override
        public Object get(int ix) throws Exception {
            return null;
        }

        @Override
        public int size() throws Exception {
            return 0;
        }
    };
    private static final IMappable<Object, Object> EMPTY_MAP = new IMappable<Object, Object>(){

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> getKeyIterator() {
            throw new UnsupportedOperationException("empty mappable");
        }

        @Override
        public Iterator<Object> getValueIterator() {
            throw new UnsupportedOperationException("empty mappable");
        }
    };

    private RuntimeConversions() {
    }

    public static int convertToInt(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt(((String)o).trim());
            }
            catch (Exception e) {
                throw new RuntimeConversionException("The string '" + o + "' cannot be converted to an integer");
            }
        }
        throw new RuntimeConversionException("Cannot convert the type \"" + o.getClass() + "\" to an integer.");
    }

    public static long convertToLong(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        if (o instanceof String) {
            try {
                return Long.parseLong(((String)o).trim());
            }
            catch (Exception e) {
                throw new RuntimeConversionException("The string '" + o + "' cannot be converted to a long");
            }
        }
        throw new RuntimeConversionException("Cannot convert the type \"" + o.getClass() + "\" to a long.");
    }

    public static byte convertToByte(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (byte)1 : 0;
        }
        if (o instanceof String) {
            try {
                return Byte.parseByte(((String)o).trim());
            }
            catch (Exception e) {
                throw new RuntimeConversionException("The string '" + o + "' cannot be converted to a byte");
            }
        }
        throw new RuntimeConversionException("Cannot convert the type \"" + o.getClass() + "\" to a byte.");
    }

    public static short convertToShort(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (short)1 : 0;
        }
        if (o instanceof String) {
            try {
                return Short.parseShort(((String)o).trim());
            }
            catch (Exception e) {
                throw new RuntimeConversionException("The string '" + o + "' cannot be converted to a short");
            }
        }
        throw new RuntimeConversionException("Cannot convert the type \"" + o.getClass() + "\" to a short.");
    }

    public static double convertToDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        if (o instanceof String) {
            try {
                return Double.parseDouble(((String)o).trim());
            }
            catch (Exception e) {
                throw new RuntimeConversionException("The string '" + o + "' cannot be converted to a double");
            }
        }
        throw new RuntimeConversionException("Cannot convert the type \"" + o.getClass() + "\" to a double.");
    }

    public static char convertToChar(Object o) {
        if (o == null) {
            return '\u0000';
        }
        if (o instanceof Number) {
            return (char)((Number)o).intValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (char)'t' : 'f';
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.length() == 0) {
                return '\u0000';
            }
            return s.charAt(0);
        }
        throw new RuntimeConversionException("Cannot convert the type \"" + o.getClass() + "\" to a char.");
    }

    public static boolean convertToBool(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() != 0;
        }
        if (o instanceof String) {
            String trimmed = ((String)o).trim();
            if ("Y".equalsIgnoreCase(trimmed)) {
                return true;
            }
            return Boolean.parseBoolean(trimmed);
        }
        throw new RuntimeConversionException("Cannot convert the type \"" + o.getClass() + "\" to a boolean.");
    }

    public static String convertToString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public static BigDecimal convertToBigDecimal(Object in) {
        if (in == null) {
            return BigDecimal.valueOf(0L);
        }
        if (in instanceof BigDecimal) {
            return (BigDecimal)in;
        }
        if (in instanceof BigInteger) {
            return new BigDecimal((BigInteger)in);
        }
        if (in instanceof Number) {
            return new BigDecimal(((Number)in).doubleValue());
        }
        if (in instanceof String) {
            try {
                return RuntimeConversions.convertStringToNumber((String)in, BigDecimal.class);
            }
            catch (Exception e) {
                throw new RuntimeConversionException(e.getLocalizedMessage());
            }
        }
        throw new RuntimeConversionException(in, "BigDecimal");
    }

    private static <T> T convertStringToNumber(String in, Class<T> type) throws ParseException {
        NumberFormat df = NumberFormat.getInstance();
        if (type == BigInteger.class) {
            df.setParseIntegerOnly(true);
            return (T)new BigInteger(df.parse(in).toString());
        }
        if (type == BigDecimal.class) {
            return (T)new BigDecimal(df.parse(in).doubleValue());
        }
        throw new IllegalArgumentException("Not supported type:" + type);
    }

    public static BigInteger convertToBigInteger(Object in) {
        if (in == null) {
            return BigInteger.valueOf(0L);
        }
        if (in instanceof BigInteger) {
            return (BigInteger)in;
        }
        if (in instanceof String) {
            return new BigInteger((String)in);
        }
        if (in instanceof BigDecimal) {
            return ((BigDecimal)in).toBigInteger();
        }
        if (in instanceof Number) {
            return BigInteger.valueOf(((Number)in).longValue());
        }
        if (in instanceof String) {
            try {
                return RuntimeConversions.convertStringToNumber((String)in, BigInteger.class);
            }
            catch (Exception e) {
                throw new RuntimeConversionException(e.getLocalizedMessage());
            }
        }
        throw new RuntimeConversionException(in, "BigInteger");
    }

    public static Double convertToDoubleWrapper(Object in) {
        if (in == null) {
            return 0.0;
        }
        if (in instanceof Double) {
            return (Double)in;
        }
        if (in instanceof Number) {
            return ((Number)in).doubleValue();
        }
        if (in instanceof String) {
            try {
                return Double.valueOf((String)in);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeConversionException(in, "Double");
    }

    public static Long convertToLongWrapper(Object in) {
        if (in == null) {
            return 0L;
        }
        if (in instanceof Long) {
            return (Long)in;
        }
        if (in instanceof Number) {
            return ((Number)in).longValue();
        }
        if (in instanceof String) {
            try {
                return Long.valueOf((String)in);
            }
            catch (Exception x) {
                throw new RuntimeConversionException(x, in, "Long");
            }
        }
        throw new RuntimeConversionException(in, "Long");
    }

    public static Integer convertToIntegerWrapper(Object in) {
        if (in == null) {
            return 0;
        }
        if (in instanceof Integer) {
            return (Integer)in;
        }
        if (in instanceof Number) {
            return ((Number)in).intValue();
        }
        if (in instanceof String) {
            String s = ((String)in).trim();
            if (s.length() == 0) {
                return 0;
            }
            try {
                int val = Integer.parseInt(s);
                return val;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeConversionException(in, "Integer");
    }

    public static Short convertToShortWrapper(Object in) {
        if (in == null) {
            return (short)0;
        }
        if (in instanceof Short) {
            return (Short)in;
        }
        if (in instanceof Number) {
            return ((Number)in).shortValue();
        }
        if (in instanceof String) {
            try {
                return Short.valueOf((String)in);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeConversionException(in, "Short");
    }

    public static Character convertToCharacterWrapper(Object in) {
        if (in == null) {
            return Character.valueOf('\u0000');
        }
        if (in instanceof Character) {
            return (Character)in;
        }
        if (in instanceof Number) {
            return Character.valueOf((char)((Number)in).intValue());
        }
        if (in instanceof String) {
            String s = (String)in;
            if (s.length() == 0) {
                return Character.valueOf('\u0000');
            }
            return Character.valueOf(s.charAt(0));
        }
        throw new RuntimeConversionException(in, "Character");
    }

    public static Byte convertToByteWrapper(Object in) {
        if (in == null) {
            return (byte)0;
        }
        if (in instanceof Byte) {
            return (Byte)in;
        }
        if (in instanceof Number) {
            return ((Number)in).byteValue();
        }
        if (in instanceof String) {
            try {
                return Byte.valueOf((String)in);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeConversionException(in, "Byte");
    }

    public static Boolean convertToBooleanWrapper(Object in) {
        if (in == null) {
            return Boolean.FALSE;
        }
        if (in instanceof Boolean) {
            return (Boolean)in;
        }
        return RuntimeConversions.convertToBool(in);
    }

    public static final <T> T convertTo(Object o, Class<T> to) {
        if (to == Object.class || to == null) {
            return (T)o;
        }
        if (o != null) {
            Class<?> from = o.getClass();
            if (from == to) {
                return (T)o;
            }
            if (to.isAssignableFrom(from)) {
                return (T)o;
            }
        }
        if (to == Integer.class || to == Integer.TYPE) {
            return (T)RuntimeConversions.convertToIntegerWrapper(o);
        }
        if (to == String.class) {
            return (T)RuntimeConversions.convertToString(o);
        }
        if (to == Boolean.class || to == Boolean.TYPE) {
            return (T)RuntimeConversions.convertToBooleanWrapper(o);
        }
        if (to == Long.class || to == Long.TYPE) {
            return (T)RuntimeConversions.convertToLongWrapper(o);
        }
        if (to == Short.class || to == Short.TYPE) {
            return (T)RuntimeConversions.convertToShortWrapper(o);
        }
        if (to == Byte.class || to == Byte.TYPE) {
            return (T)RuntimeConversions.convertToByteWrapper(o);
        }
        if (to == Character.class || to == Character.TYPE) {
            return (T)RuntimeConversions.convertToCharacterWrapper(o);
        }
        if (to == Double.class || to == Double.TYPE) {
            return (T)RuntimeConversions.convertToDoubleWrapper(o);
        }
        if (to == BigInteger.class) {
            return (T)RuntimeConversions.convertToBigInteger(o);
        }
        if (to == BigDecimal.class) {
            return (T)RuntimeConversions.convertToBigDecimal(o);
        }
        if (Enum.class.isAssignableFrom(to)) {
            return (T)RuntimeConversions.convertToEnum(to, o);
        }
        if (o == null && !to.isPrimitive()) {
            return (T)o;
        }
        throw new RuntimeConversionException(o, to.getName());
    }

    public static final <T> T convertToComplex(Object source, Class<T> totype) {
        if (source != null) {
            if (totype.isAssignableFrom(source.getClass())) {
                return (T)source;
            }
            if (totype.isArray()) {
                return RuntimeConversions.convertToArray(totype, source);
            }
            if (totype.isEnum()) {
                return (T)RuntimeConversions.convertToEnum(totype, source);
            }
        }
        return RuntimeConversions.convertTo(source, totype);
    }

    public static <T> T convertToArray(Class<T> totype, Object src) {
        if (totype.isAssignableFrom(src.getClass())) {
            return (T)src;
        }
        Class<?> ccl = totype.getComponentType();
        Class<?> scl = src.getClass();
        if (scl.isArray()) {
            int len = Array.getLength(src);
            Object res = Array.newInstance(ccl, len);
            int i = len;
            while (--i >= 0) {
                Object val = Array.get(src, i);
                Array.set(res, i, RuntimeConversions.convertToComplex(val, ccl));
            }
            return (T)res;
        }
        if (src instanceof Collection) {
            Collection c = (Collection)src;
            Object res = Array.newInstance(ccl, c.size());
            int i = 0;
            for (Object o : c) {
                Array.set(res, i++, RuntimeConversions.convertToComplex(o, ccl));
            }
            return (T)res;
        }
        throw new RuntimeConversionException(src, totype.getName());
    }

    public static Iterator<?> makeIterator(Object val) throws Exception {
        if (val == null) {
            throw new RuntimeConversionException("Cannot convert null to an iterator.");
        }
        if (val instanceof Collection) {
            return ((Collection)val).iterator();
        }
        if (val instanceof Map) {
            return ((Map)val).values().iterator();
        }
        Class<?> acl = val.getClass();
        if (acl.isArray()) {
            return new ArrayIterator(val);
        }
        throw new RuntimeConversionException("Cannot convert a " + acl.getName() + " to an iterator.");
    }

    public static boolean isIterable(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof Collection || val instanceof Map) {
            return true;
        }
        Class<?> cla = val.getClass();
        return cla.isArray();
    }

    public static IListable<?> convertToListable(Object o) {
        if (o == null) {
            return NO_VALUES;
        }
        if (o instanceof IListable) {
            return (IListable)o;
        }
        if (o instanceof List) {
            return new ListableListWrapper((List)o);
        }
        if (o instanceof Collection) {
            Collection col = (Collection)o;
            return new ListableArrayWrapper(col.toArray());
        }
        if (o instanceof Map) {
            return new ListableMapWrapper((Map)o);
        }
        Class<?> acl = o.getClass();
        if (acl.isArray()) {
            if (acl.getComponentType().isPrimitive()) {
                throw new RuntimeConversionException("Cannot convert an array of a primitive type to Listable");
            }
            return new ListableArrayWrapper((Object[])o);
        }
        throw new RuntimeConversionException("Cannot convert a " + acl.getName() + " to a Listable.");
    }

    public static IMappable<?, ?> convertToMappable(Object o) {
        if (o == null) {
            return EMPTY_MAP;
        }
        if (o instanceof IMappable) {
            return (IMappable)o;
        }
        if (o instanceof Map) {
            return new MapWrap((Map)o);
        }
        throw new RuntimeConversionException("Cannot convert a " + o.getClass().getName() + " to a Mappable.");
    }

    public static Date convertToDate(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Calendar) {
            return ((Calendar)o).getTime();
        }
        throw new RuntimeConversionException("Cannot convert a " + o.getClass().getName() + " to a java.util.Date");
    }

    public static Enum<?> convertToEnum(Class<Enum<?>> cl, Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Enum) {
            return (Enum)o;
        }
        if (o instanceof String) {
            String value = (String)o;
            value = value.trim();
            Enum<?>[] ar = cl.getEnumConstants();
            if (ar == null) {
                throw new IllegalStateException("!? No enum constants for enum class " + cl.getCanonicalName());
            }
            for (Enum<?> en : ar) {
                if (!en.name().equalsIgnoreCase(value)) continue;
                return en;
            }
            throw new IllegalStateException("The value '" + value + "' is not a valid enum name for the enum '" + cl.getCanonicalName());
        }
        throw new RuntimeConversionException("Cannot convert a " + o.getClass().getName() + " to a " + cl.getName());
    }

    public static boolean isCollectionType(Class<?> cl) {
        if (cl.isArray()) {
            return true;
        }
        return Collection.class.isAssignableFrom(cl);
    }

    public static Object createConcreteCollection(Class<?> ct) {
        if (ct.isInterface() || Modifier.isAbstract(ct.getModifiers())) {
            if (List.class.isAssignableFrom(ct)) {
                return new ArrayList();
            }
            if (Set.class.isAssignableFrom(ct)) {
                return new HashSet();
            }
            if (Collection.class.isAssignableFrom(ct)) {
                return new ArrayList();
            }
            throw new RuntimeConversionException("Unsupported abstract/interface target class " + ct.getName());
        }
        if (!Collection.class.isAssignableFrom(ct)) {
            throw new RuntimeConversionException("Cannot create a Collection instance from " + ct.getName());
        }
        try {
            return ct.newInstance();
        }
        catch (Exception x) {
            throw new RuntimeConversionException("Error creating an instance of " + ct.getName() + ": " + x, x);
        }
    }

    public static boolean isInt(Class<?> clz) {
        return clz == Integer.class || clz == Integer.TYPE;
    }

    public static boolean isLong(Class<?> clz) {
        return clz == Long.class || clz == Long.TYPE;
    }

    public static boolean isShort(Class<?> clz) {
        return clz == Short.class || clz == Short.TYPE;
    }

    public static boolean isByte(Class<?> clz) {
        return clz == Byte.class || clz == Byte.TYPE;
    }

    public static boolean isCharacter(Class<?> clz) {
        return clz == Character.class || clz == Character.TYPE;
    }

    public static boolean isDouble(Class<?> clz) {
        return clz == Double.class || clz == Double.TYPE;
    }

    public static boolean isFloat(Class<?> clz) {
        return clz == Float.class || clz == Float.TYPE;
    }

    public static boolean isBoolean(Class<?> clz) {
        return clz == Boolean.class || clz == Boolean.TYPE;
    }

    public static boolean isNumeric(Class<?> clz) {
        return Number.class.isAssignableFrom(clz) || RuntimeConversions.isInt(clz) || RuntimeConversions.isLong(clz) || RuntimeConversions.isShort(clz) || RuntimeConversions.isByte(clz) || RuntimeConversions.isDouble(clz) || RuntimeConversions.isFloat(clz);
    }

    public static boolean isSimpleType(Class<?> clz) {
        return clz.isPrimitive() || RuntimeConversions.isNumeric(clz) || clz == String.class || RuntimeConversions.isBoolean(clz);
    }

    public static boolean isEnumType(Class<?> clz) {
        return Enum.class.isAssignableFrom(clz);
    }

    private static class MapWrap
    implements IMappable<Object, Object> {
        private Map<Object, Object> m_map;

        MapWrap(Map<?, ?> m) {
            this.m_map = m;
        }

        @Override
        public Object get(Object key) {
            return this.m_map.get(key);
        }

        @Override
        public int size() {
            return this.m_map.size();
        }

        @Override
        public Iterator<Object> getKeyIterator() {
            return this.m_map.keySet().iterator();
        }

        @Override
        public Iterator<Object> getValueIterator() {
            return this.m_map.values().iterator();
        }
    }

    private static final class ListableListWrapper
    implements IListable<Object> {
        private List<Object> m_val;

        public ListableListWrapper(List<?> val) {
            this.m_val = val;
        }

        @Override
        public Object get(int ix) {
            return this.m_val.get(ix);
        }

        @Override
        public int size() {
            return this.m_val.size();
        }
    }

    private static final class ListableMapWrapper
    extends ListableArrayWrapper
    implements IMappable<Object, Object> {
        private Map<Object, Object> m_map;

        public ListableMapWrapper(Map<?, ?> m) {
            super(m.values().toArray());
            this.m_map = m;
        }

        @Override
        public Object get(Object key) {
            return this.m_map.get(key);
        }

        @Override
        public Iterator<Object> getKeyIterator() {
            return this.m_map.keySet().iterator();
        }

        @Override
        public Iterator<Object> getValueIterator() {
            return this.m_map.values().iterator();
        }
    }

    private static class ListableArrayWrapper
    implements IListable<Object> {
        private Object[] m_val;

        public ListableArrayWrapper(Object[] val) {
            this.m_val = val;
        }

        @Override
        public Object get(int ix) {
            return this.m_val[ix];
        }

        @Override
        public int size() {
            return this.m_val.length;
        }
    }

    private static final class ArrayIterator
    implements Iterator<Object> {
        private Object m_array;
        private int m_len;
        private int m_index;

        public ArrayIterator(Object arr) {
            this.m_array = arr;
            this.m_len = Array.getLength(arr);
        }

        @Override
        public boolean hasNext() {
            return this.m_index < this.m_len;
        }

        @Override
        public Object next() {
            if (this.m_index >= this.m_len) {
                return null;
            }
            return Array.get(this.m_array, this.m_index++);
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Cannot remove items from an array");
        }
    }
}

