/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.Serializable;
import java.util.Arrays;

public class SmallIntSet
implements Serializable {
    private int[] m_data;
    private int m_count;

    public SmallIntSet() {
    }

    public SmallIntSet(int size) {
        this.m_data = new int[size];
    }

    public boolean contains(int val) {
        int i = this.m_count;
        while (--i >= 0) {
            if (this.m_data[i] != val) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SmallIntSet)) {
            return false;
        }
        SmallIntSet o = (SmallIntSet)other;
        if (o.size() != this.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        this.sort();
        o.sort();
        int i = this.m_count;
        while (--i >= 0) {
            if (this.m_data[i] == o.m_data[i]) continue;
            return false;
        }
        return true;
    }

    private void sort() {
        Arrays.sort(this.m_data, 0, this.size());
    }

    public void add(int i) {
        if (this.contains(i)) {
            return;
        }
        if (this.m_data == null || this.m_data.length <= this.m_count) {
            if (this.m_data == null) {
                this.m_data = new int[2];
            } else {
                int[] ar = new int[this.m_count + 2];
                System.arraycopy(this.m_data, 0, ar, 0, this.m_count);
                this.m_data = ar;
            }
        }
        this.m_data[this.m_count++] = i;
    }

    public void clear() {
        this.m_count = 0;
    }

    public int size() {
        return this.m_count;
    }

    public int elementAt(int i) {
        if (i >= this.m_count) {
            throw new IllegalStateException("Index " + i + " is larger than count " + this.m_count);
        }
        return this.m_data[i];
    }

    public String toString() {
        if (this.size() == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        int i = this.size();
        while (--i >= 0) {
            sb.append(this.elementAt(i));
            if (i == 0) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }
}

