/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

public class TextScanner {
    private String m_text;
    private int m_len;
    private int m_ix;
    private long m_lastint;
    private StringBuilder m_sb = null;

    public TextScanner() {
    }

    public TextScanner(String s) {
        this.setString(s);
    }

    public long getLastInt() {
        return this.m_lastint;
    }

    public void setString(String s) {
        this.m_text = s;
        this.m_ix = 0;
        this.m_len = s.length();
        this.clear();
    }

    public void clear() {
        if (this.m_sb != null) {
            this.m_sb.setLength(0);
        }
    }

    public String getCopied() {
        return this.m_sb == null ? "" : this.m_sb.toString();
    }

    public StringBuilder getBuffer() {
        return this.sb();
    }

    public long getInt() {
        return this.m_lastint;
    }

    public boolean skipWS() {
        char c;
        int six = this.m_ix;
        while (this.m_ix < this.m_len && Character.isWhitespace(c = this.m_text.charAt(this.m_ix))) {
            ++this.m_ix;
        }
        return this.m_ix != six;
    }

    public boolean eof() {
        return this.m_ix >= this.m_len;
    }

    public boolean scanInt() {
        char c;
        long res = 0L;
        int ndig = 0;
        while (this.m_ix < this.m_len && Character.isDigit(c = this.m_text.charAt(this.m_ix))) {
            res = res * 10L + (long)(c - 48);
            ++ndig;
            ++this.m_ix;
        }
        if (ndig == 0) {
            return false;
        }
        this.m_lastint = res;
        return true;
    }

    public Double scanDouble() {
        char c;
        this.sb().setLength(0);
        while (this.m_ix < this.m_len && (Character.isDigit(c = this.m_text.charAt(this.m_ix)) || c == '.')) {
            this.copy();
        }
        String s = this.sb().toString();
        if (s.length() == 0) {
            return null;
        }
        return Double.valueOf(s);
    }

    public String scanWord() {
        int six = this.m_ix;
        while (this.m_ix < this.m_len) {
            char c = this.m_text.charAt(this.m_ix);
            if (six == this.m_ix) {
                if (!Character.isLetter(c)) {
                    return null;
                }
            } else if (!Character.isLetterOrDigit(c) && c != '$' && c != '_') break;
            ++this.m_ix;
        }
        return this.m_text.substring(six, this.m_ix);
    }

    public String peekWord() {
        int six = this.m_ix;
        String word = this.scanWord();
        this.m_ix = six;
        return word;
    }

    public String scanDelimited(String delimiters, int quote1, int quote2) {
        int inq = -1;
        if (this.m_ix >= this.m_len) {
            return null;
        }
        int c = this.m_text.charAt(this.m_ix) & 0xFFFF;
        if (c == quote1 || c == quote2) {
            inq = c;
            ++this.m_ix;
        }
        int six = this.m_ix;
        while (this.m_ix < this.m_len) {
            c = this.m_text.charAt(this.m_ix++) & 0xFFFF;
            if (inq != -1) {
                if (c != inq) continue;
                return this.m_text.substring(six, this.m_ix - 1);
            }
            int i = delimiters.length();
            while (--i >= 0) {
                if (delimiters.charAt(i) != c) continue;
                --this.m_ix;
                return this.m_text.substring(six, this.m_ix);
            }
        }
        return this.m_text.substring(six, this.m_ix);
    }

    public String scanLetters() {
        char c;
        int six = this.m_ix;
        while (this.m_ix < this.m_len && (Character.isLetterOrDigit(c = this.m_text.charAt(this.m_ix)) || c == '$' || c == '_')) {
            ++this.m_ix;
        }
        if (six == this.m_ix) {
            return null;
        }
        return this.m_text.substring(six, this.m_ix);
    }

    @Deprecated
    public int nextChar() {
        if (this.m_ix >= this.m_len) {
            return -1;
        }
        return this.m_text.charAt(this.m_ix++) & 0xFFFF;
    }

    @Deprecated
    public boolean skip(char c) {
        if (this.m_ix >= this.m_len) {
            return false;
        }
        if ((c & 0xFFFF) != this.m_text.charAt(this.m_ix)) {
            return false;
        }
        ++this.m_ix;
        return true;
    }

    @Deprecated
    public char currentChar() {
        return this.m_ix >= this.m_len ? (char)'\u0000' : this.m_text.charAt(this.m_ix);
    }

    @Deprecated
    public void inc() {
        ++this.m_ix;
    }

    public int LA() {
        return this.m_ix >= this.m_len ? -1 : 0xFFFF & this.m_text.charAt(this.m_ix);
    }

    public int LA(int x) {
        return this.m_ix + x >= this.m_len ? -1 : 0xFFFF & this.m_text.charAt(this.m_ix + x);
    }

    public void accept() {
        ++this.m_ix;
    }

    public StringBuilder sb() {
        if (this.m_sb == null) {
            this.m_sb = new StringBuilder();
        }
        return this.m_sb;
    }

    public int length() {
        return this.m_len;
    }

    public int index() {
        return this.m_ix;
    }

    public void setIndex(int ix) {
        this.m_ix = ix;
    }

    public void accept(int ct) {
        this.m_ix += ct;
    }

    public void copy() {
        if (this.m_ix < this.m_len) {
            this.sb().append(this.m_text.charAt(this.m_ix++));
        }
    }

    public void copy(StringBuilder sb) {
        if (this.m_ix < this.m_len) {
            sb.append(this.m_text.charAt(this.m_ix++));
        }
    }

    public void copy(int n) {
        while (--n > 0) {
            this.copy();
        }
    }

    public void append(String s) {
        this.sb().append(s);
    }

    public void append(long i) {
        this.sb().append((Object)i);
    }

    public void append(char c) {
        this.sb().append(c);
    }
}

