/*
 * Decompiled with CFR 0.152.
 */
package to.etc.xml;

import java.util.Iterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import to.etc.xml.DOMDecoder;
import to.etc.xml.DOMDecoderBase;

class DOMNodeIterator
implements Iterator<DOMDecoder>,
Iterable<DOMDecoder> {
    private NodeList m_list;
    private int m_listIndex = 0;
    private String m_encodingNamespace;
    private String m_defaultNamespace;
    private String m_filterTag;
    private String m_filterTagNamespace;
    private boolean m_skipText = true;

    DOMNodeIterator() {
    }

    DOMNodeIterator(DOMDecoderBase base, Node root, String tagName, String tagNS, boolean skipText) {
        this.m_defaultNamespace = base.getDefaultNamespace();
        this.m_encodingNamespace = base.getEncodingNamespace();
        this.m_list = root.getChildNodes();
        this.m_listIndex = this.findNextAfter(0);
        this.m_filterTag = tagName;
        this.m_filterTagNamespace = tagNS;
        this.m_skipText = skipText;
    }

    DOMNodeIterator(DOMDecoderBase base, Node root) {
        this(base, root, null, null, true);
    }

    private int findNextAfter(int ix) {
        if (this.m_filterTag == null && !this.m_skipText) {
            return ix + 1;
        }
        while (++ix < this.m_list.getLength()) {
            Node next = this.m_list.item(ix);
            if (this.m_skipText && (next.getNodeType() == 3 || next.getNodeType() == 8 || next.getNodeType() == 7)) continue;
            if (this.m_filterTag == null) {
                return ix;
            }
            if (!next.getNodeName().equals(this.m_filterTag) && !next.getLocalName().equals(this.m_filterTag)) continue;
            if (this.m_filterTagNamespace == null) {
                return ix;
            }
            if (!this.m_filterTagNamespace.equals(next.getNamespaceURI())) continue;
            return ix;
        }
        return ix;
    }

    @Override
    public Iterator<DOMDecoder> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.m_list != null && this.m_listIndex < this.m_list.getLength();
    }

    @Override
    public DOMDecoder next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more elements");
        }
        DOMDecoder sli = new DOMDecoder(this.m_list.item(this.m_listIndex), this.m_defaultNamespace, this.m_encodingNamespace);
        this.m_listIndex = this.findNextAfter(this.m_listIndex);
        return sli;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Remove not allowed");
    }
}

