/*
 * Decompiled with CFR 0.152.
 */
package to.etc.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import to.etc.util.FileTool;
import to.etc.util.StringTool;
import to.etc.xml.DefaultErrorHandler;

public class DomTools {
    public static final java.util.Date OBLIVIAN;
    public static final java.util.Date BIGBANG;
    public static final String DBNULL = "(dbnull)";
    private static final SimpleDateFormat m_dateFormat;

    private DomTools() {
    }

    public static Document getDocument(InputStream is, String ident, ErrorHandler eh, boolean nsaware) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(nsaware);
        DocumentBuilder db = dbf.newDocumentBuilder();
        try {
            db.setErrorHandler(eh);
            InputSource ins = new InputSource(is);
            if (ident != null) {
                ins.setPublicId(ident);
            }
            return db.parse(ins);
        }
        catch (IOException x) {
            throw new IOException("XML Parser IO error on " + ident + ": " + x.toString());
        }
    }

    public static Node getDocumentRoot(String txt, String ident, ErrorHandler eh, boolean nsaware) throws Exception {
        Document doc = DomTools.getDocument(new StringReader(txt), ident, eh, nsaware);
        if (doc != null) {
            return DomTools.getRootElement(doc);
        }
        return null;
    }

    public static Node getDocumentRoot(String txt, String ident, boolean nsaware) throws Exception {
        DefaultErrorHandler deh = new DefaultErrorHandler();
        Node n = DomTools.getDocumentRoot(txt, ident, deh, nsaware);
        if (deh.hasErrors()) {
            throw new Exception(ident + ": xml parse errors: " + deh.getErrors());
        }
        return n;
    }

    public static Document getDocument(Reader is, String ident, ErrorHandler eh, boolean nsaware) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(nsaware);
        DocumentBuilder db = dbf.newDocumentBuilder();
        try {
            db.setErrorHandler(eh);
            InputSource ins = new InputSource(is);
            if (ident != null) {
                ins.setPublicId(ident);
            }
            return db.parse(ins);
        }
        catch (IOException x) {
            throw new IOException("XML Parser IO error on " + ident + ": " + x.toString());
        }
    }

    public static Document getDocument(File inf, ErrorHandler eh, boolean nsaware) throws Exception {
        if (!inf.exists() || !inf.isFile()) {
            throw new IOException(inf + ": file not found.");
        }
        inf = inf.getAbsoluteFile();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(nsaware);
        DocumentBuilder db = dbf.newDocumentBuilder();
        try {
            db.setErrorHandler(eh);
            return db.parse(inf);
        }
        catch (IOException x) {
            throw new IOException("XML Parser IO error on " + inf + ": " + x.toString());
        }
    }

    @Nonnull
    public static Document getDocument(@Nonnull File inf, boolean nsaware) throws Exception {
        DefaultErrorHandler deh = new DefaultErrorHandler();
        Document doc = DomTools.getDocument(inf, deh, nsaware);
        if (deh.hasErrors()) {
            throw new Exception(inf + ": xml parse errors: " + deh.getErrors());
        }
        return doc;
    }

    public static Document getDocument(InputStream is, String ident, boolean nsaware) throws Exception {
        DefaultErrorHandler deh = new DefaultErrorHandler();
        Document doc = DomTools.getDocument(is, ident, (ErrorHandler)deh, nsaware);
        if (deh.hasErrors()) {
            throw new Exception(ident + ": xml parse errors: " + deh.getErrors());
        }
        return doc;
    }

    public static Document getDocument(Reader is, String ident, boolean nsaware) throws Exception {
        DefaultErrorHandler deh = new DefaultErrorHandler();
        Document doc = DomTools.getDocument(is, ident, (ErrorHandler)deh, nsaware);
        if (deh.hasErrors()) {
            throw new Exception(ident + ": xml parse errors: " + deh.getErrors());
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocumentFromZIP(File zipfile, String name, ErrorHandler eh, boolean nsaware) throws Exception {
        InputStream is = null;
        is = FileTool.getZipContent(zipfile, name);
        if (is == null) {
            Document document = null;
            return document;
        }
        Document document = DomTools.getDocument(is, zipfile.toString() + "/" + name, eh, nsaware);
        return document;
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Node nodeFind(Node rn, String name) throws Exception {
        NodeList nl = rn.getChildNodes();
        Node fn = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equalsIgnoreCase(name) && !name.equalsIgnoreCase(n.getLocalName()) || n.getNodeType() != 1) continue;
            if (fn != null) {
                throw new Exception(name + ": duplicate instance within " + rn.getNodeName());
            }
            fn = nl.item(i);
        }
        return fn;
    }

    public static List<Node> nodesFind(Node rn, String name) {
        ArrayList<Node> nnl = new ArrayList<Node>();
        if (rn == null) {
            return nnl;
        }
        NodeList nl = rn.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equalsIgnoreCase(name) && !name.equalsIgnoreCase(n.getLocalName()) || n.getNodeType() != 1) continue;
            nnl.add(nl.item(i));
        }
        return nnl;
    }

    public static String textFrom_untrimmed(Node n) {
        StringBuffer sb = new StringBuffer();
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node cn = nl.item(i);
            String txt = cn.getNodeValue();
            if (txt == null) continue;
            sb.append(txt);
        }
        String s = sb.toString();
        if (DBNULL.equals(s)) {
            return null;
        }
        return s;
    }

    @Nullable
    public static String textFrom(@Nonnull Node n) {
        StringBuffer sb = new StringBuffer();
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node cn = nl.item(i);
            String txt = cn.getNodeValue();
            if (txt == null) continue;
            sb.append(txt.trim());
        }
        String s = sb.toString();
        if (DBNULL.equals(s)) {
            return null;
        }
        return s;
    }

    @Deprecated
    public static String findChildNodeValue(Node rootnode, String name) throws Exception {
        Node n = DomTools.nodeFind(rootnode, name);
        if (n == null) {
            return null;
        }
        return DomTools.textFrom(n);
    }

    public static String stringNode(Node rootnode, String name) throws Exception {
        Node n = DomTools.nodeFind(rootnode, name);
        if (n == null) {
            return null;
        }
        return DomTools.textFrom(n);
    }

    public static String stringNode(Node rootnode, String name, int trunclen) throws Exception {
        String s = DomTools.stringNode(rootnode, name);
        if (s != null && s.length() > trunclen) {
            s = s.substring(0, trunclen);
        }
        return s;
    }

    public static String stringNode(Node rootnode, String name, String deflt) throws Exception {
        Node n = DomTools.nodeFind(rootnode, name);
        if (n == null) {
            return deflt;
        }
        return DomTools.textFrom(n);
    }

    public static String stringNode_untrimmed(Node rootnode, String name) throws Exception {
        Node n = DomTools.nodeFind(rootnode, name);
        if (n == null) {
            return null;
        }
        return DomTools.textFrom_untrimmed(n);
    }

    public static String stringNode_untrimmed(Node rootnode, String name, String deflt) throws Exception {
        Node n = DomTools.nodeFind(rootnode, name);
        if (n == null) {
            return deflt;
        }
        return DomTools.textFrom_untrimmed(n);
    }

    public static java.util.Date dateNode(Node rn, String name) throws Exception {
        String s = DomTools.stringNode(rn, name);
        if (s == null) {
            return null;
        }
        return DomTools.dateDecode(s);
    }

    public static java.util.Date dateNode(Node rn, String name, java.util.Date dflt) throws Exception {
        String s = DomTools.stringNode(rn, name);
        if (s == null) {
            return dflt;
        }
        if (DBNULL.equals(s)) {
            return dflt;
        }
        return DomTools.dateDecode(s);
    }

    private static final void timeError(String v) throws Exception {
        throw new Exception(v + ": must be hh:mm, hh:mm:ss, hhmm or hhmmss.");
    }

    public static int timeNode(Node rn, String name, int dflt) throws Exception {
        char c;
        String v = DomTools.stringNode(rn, name, null);
        if (v == null || v.length() == 0) {
            return dflt;
        }
        int ix = 0;
        int len = v.length();
        int ss = 0;
        int nr = 0;
        if (!Character.isDigit(c = v.charAt(ix++))) {
            DomTools.timeError(v);
        }
        nr = c - 48;
        if (ix >= len) {
            DomTools.timeError(v);
        }
        if (Character.isDigit(c = v.charAt(ix++))) {
            nr = nr * 10 + c - 48;
            if (ix >= len) {
                DomTools.timeError(v);
            }
            if ((c = v.charAt(ix)) == ':') {
                ++ix;
            }
        } else if (c != ':') {
            DomTools.timeError(v);
        }
        int hh = nr;
        if (ix + 2 > len) {
            DomTools.timeError(v);
        }
        if (!Character.isDigit(c = v.charAt(ix++))) {
            DomTools.timeError(v);
        }
        nr = c - 48;
        if (!Character.isDigit(c = v.charAt(ix++))) {
            DomTools.timeError(v);
        }
        int mm = nr = nr * 10 + c - 48;
        if (ix < len) {
            if ((c = v.charAt(ix++)) == ':') {
                if (ix >= len) {
                    DomTools.timeError(v);
                }
                c = v.charAt(ix++);
            }
            if (ix >= len) {
                DomTools.timeError(v);
            }
            if (!Character.isDigit(c)) {
                DomTools.timeError(v);
            }
            nr = c - 48;
            if (!Character.isDigit(c = v.charAt(ix++))) {
                DomTools.timeError(v);
            }
            ss = nr = nr * 10 + c - 48;
        }
        if (hh < 0 || hh > 23 || mm < 0 || mm >= 60 || ss < 0 || ss >= 60) {
            throw new Exception(v + ": invalid time (hours or minutes bad)");
        }
        return hh * 60 * 60 + mm * 60 + ss;
    }

    public static int intNode(Node rootnode, String name) throws Exception {
        String s = DomTools.stringNode(rootnode, name);
        if (s != null && (s = s.trim()).length() >= 0 && !DBNULL.equals(s)) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception ex) {
                throw new Exception(name + ": integer value expected, got '" + s + "'");
            }
        }
        throw new Exception("Missing '" + name + "' node [integer]");
    }

    public static int intNode(Node rootnode, String name, int val) throws Exception {
        String s = DomTools.stringNode(rootnode, name);
        if (s == null) {
            return val;
        }
        if ((s = s.trim()).length() == 0 || DBNULL.equals(s)) {
            return val;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            throw new Exception(name + ": integer value expected, got '" + s + "'");
        }
    }

    public static Long longWrapperNode(Node rootnode, String name) throws Exception {
        String s = DomTools.stringNode(rootnode, name);
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0 || DBNULL.equals(s)) {
            return null;
        }
        try {
            return Long.decode(s);
        }
        catch (Exception ex) {
            throw new Exception(name + ": long value expected, got '" + s + "'");
        }
    }

    public static long longNode(Node rootnode, String name) throws Exception {
        String s = DomTools.stringNode(rootnode, name);
        if (s != null && (s = s.trim()).length() >= 0 && !DBNULL.equals(s)) {
            try {
                return Long.parseLong(s);
            }
            catch (Exception ex) {
                throw new Exception(name + ": long value expected, got '" + s + "'");
            }
        }
        throw new Exception("Missing '" + name + "' node [long]");
    }

    public static long longNode(Node rootnode, String name, long val) throws Exception {
        String s = DomTools.stringNode(rootnode, name);
        if (s == null) {
            return val;
        }
        if ((s = s.trim()).length() == 0 || DBNULL.equals(s)) {
            return val;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Exception ex) {
            throw new Exception(name + ": long value expected, got '" + s + "'");
        }
    }

    public static double doubleNode(Node rootnode, String name, double val) throws Exception {
        String s = DomTools.stringNode(rootnode, name);
        if (s == null) {
            return val;
        }
        if ((s = s.trim()).length() == 0 || DBNULL.equals(s)) {
            return val;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception ex) {
            throw new Exception(name + ": double value expected, got '" + s + "'");
        }
    }

    public static String fileNameNode(Node rootnode, String name) throws Exception {
        Node fn = DomTools.nodeFind(rootnode, name);
        if (fn == null) {
            return null;
        }
        Node fnn = DomTools.nodeFind(fn, "file");
        if (fnn == null) {
            return null;
        }
        String rname = DomTools.textFrom(fnn);
        if (rname == null || rname.length() == 0) {
            System.out.println("DomTools: no name in file node!?");
            return null;
        }
        rname = rname.trim();
        return rname;
    }

    public static boolean boolNode(Node rootnode, String name) throws Exception {
        Node n = DomTools.nodeFind(rootnode, name);
        if (n == null) {
            return false;
        }
        return DomTools.decodeBoolStr(DomTools.textFrom(n), name);
    }

    public static Boolean booleanNode(Node rootnode, String name) throws Exception {
        Node n = DomTools.nodeFind(rootnode, name);
        if (n == null) {
            return null;
        }
        return DomTools.decodeBoolStr(DomTools.textFrom(n), name);
    }

    public static boolean decodeBoolStr(String nt, String name) {
        if (nt == null) {
            return false;
        }
        if ((nt = nt.trim()).length() == 0) {
            return true;
        }
        char c = nt.charAt(0);
        if (c == '0') {
            return false;
        }
        if (Character.isDigit(c)) {
            return true;
        }
        if (c == 't' || c == 'T') {
            return true;
        }
        if (c == 'f' || c == 'F') {
            return false;
        }
        throw new IllegalArgumentException(name + ": node must contain a boolean value");
    }

    public static String getNodeAttribute(@Nonnull Node n, @Nonnull String aname, @Nullable String defval) {
        Node idn;
        if (n.hasAttributes() && (idn = n.getAttributes().getNamedItem(aname)) != null) {
            return idn.getNodeValue();
        }
        return defval;
    }

    public static String strAttr(Node n, String aname, String def) {
        return DomTools.getNodeAttribute(n, aname, def);
    }

    @Nonnull
    public static String strAttr(@Nonnull Node n, @Nonnull String aname) {
        String s = DomTools.getNodeAttribute(n, aname, null);
        if (s == null) {
            throw new IllegalStateException("Missing attribute '" + aname + "' on node '" + n.getNodeName() + "'");
        }
        return s;
    }

    public static int intAttr(Node n, String aname, int defval) throws Exception {
        return DomTools.getNodeAttribute(n, aname, defval);
    }

    public static int intAttr(Node n, String aname) throws Exception {
        String v;
        Node idn;
        if (n.hasAttributes() && (idn = n.getAttributes().getNamedItem(aname)) != null && (v = idn.getNodeValue()) != null && v.length() > 0) {
            try {
                return Integer.parseInt(v.trim());
            }
            catch (Exception ex) {
                throw new Exception("expected integer value for attribute " + aname + ", but got '" + v + "'");
            }
        }
        throw new Exception("Missing mandatory int attribute '" + aname + "' on tag '" + n.getNodeName() + "'");
    }

    public static long longAttr(Node n, String aname) throws Exception {
        String v;
        Node idn;
        if (n.hasAttributes() && (idn = n.getAttributes().getNamedItem(aname)) != null && (v = idn.getNodeValue()) != null && v.length() > 0) {
            try {
                return Long.parseLong(v.trim());
            }
            catch (Exception ex) {
                throw new Exception("expected long value for attribute " + aname + ", but got '" + v + "'");
            }
        }
        throw new Exception("Missing mandatory long attribute '" + aname + "' on tag '" + n.getNodeName() + "'");
    }

    public static Long longAttrWrapped(Node n, String aname) throws Exception {
        return DomTools.longAttr(n, aname);
    }

    public static boolean boolAttr(Node n, String aname) throws Exception {
        Node idn;
        if (n.hasAttributes() && (idn = n.getAttributes().getNamedItem(aname)) != null) {
            String v = idn.getNodeValue();
            return DomTools.decodeBoolStr(v, aname);
        }
        throw new Exception("Missing mandatory boolean attribute '" + aname + "' on tag '" + n.getNodeName() + "'");
    }

    public static boolean boolAttr(Node n, String aname, boolean defval) throws Exception {
        Node idn;
        if (n.hasAttributes() && (idn = n.getAttributes().getNamedItem(aname)) != null) {
            String v = idn.getNodeValue();
            return DomTools.decodeBoolStr(v, aname);
        }
        return defval;
    }

    public static int getNodeAttribute(Node n, String aname, int defval) throws Exception {
        String v;
        Node idn;
        if (n.hasAttributes() && (idn = n.getAttributes().getNamedItem(aname)) != null && (v = idn.getNodeValue()) != null && v.length() > 0) {
            try {
                return Integer.parseInt(v.trim());
            }
            catch (Exception ex) {
                throw new Exception("expected integer value for attribute " + aname + ", but got '" + v + "'");
            }
        }
        return defval;
    }

    public static String dateEncode(java.util.Date dt) {
        if (dt == null) {
            return DBNULL;
        }
        if (dt.equals(OBLIVIAN) || dt.after(OBLIVIAN)) {
            return "oblivian";
        }
        if (dt.equals(BIGBANG) || dt.before(BIGBANG)) {
            return "big-bang";
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(dt);
        TimeZone tz = TimeZone.getDefault();
        StringBuffer sb = new StringBuffer(30);
        sb.append(StringTool.intToStr(c.get(1), 10, 4));
        sb.append('-');
        sb.append(StringTool.intToStr(c.get(2) + 1, 10, 2));
        sb.append('-');
        sb.append(StringTool.intToStr(c.get(5), 10, 2));
        sb.append(' ');
        sb.append(StringTool.intToStr(c.get(11), 10, 2));
        sb.append(':');
        sb.append(StringTool.intToStr(c.get(12), 10, 2));
        sb.append(':');
        sb.append(StringTool.intToStr(c.get(13), 10, 2));
        sb.append('.');
        sb.append(StringTool.intToStr(c.get(14), 10, 4));
        sb.append(' ');
        sb.append(tz.getID());
        return sb.toString();
    }

    public static java.util.Date dateDecode(String s) {
        if ((s = s.trim()).equals(DBNULL)) {
            return null;
        }
        if (s.equals("oblivian")) {
            return OBLIVIAN;
        }
        if (s.equals("big-bang")) {
            return BIGBANG;
        }
        try {
            return m_dateFormat.parse(s);
        }
        catch (Exception exception) {
            try {
                int year = Integer.parseInt(s.substring(0, 4));
                int month = Integer.parseInt(s.substring(5, 7));
                int day = Integer.parseInt(s.substring(8, 10));
                int hour = Integer.parseInt(s.substring(11, 13));
                int min = Integer.parseInt(s.substring(14, 16));
                int sec = Integer.parseInt(s.substring(17, 19));
                int msec = Integer.parseInt(s.substring(20, 24));
                GregorianCalendar c = new GregorianCalendar();
                c.set(1, year);
                c.set(2, month - 1);
                c.set(5, day);
                c.set(11, hour);
                c.set(12, min);
                c.set(13, sec);
                c.set(14, msec);
                java.util.Date dt = c.getTime();
                return dt;
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public static final boolean isOblivian(java.util.Date dt) {
        if (dt == null) {
            return false;
        }
        if (dt instanceof Date) {
            return dt.getTime() >= OBLIVIAN.getTime();
        }
        return dt.equals(OBLIVIAN) || dt.after(OBLIVIAN);
    }

    public static final boolean isBigBang(java.util.Date dt) {
        if (dt == null) {
            return false;
        }
        if (dt instanceof Date) {
            return dt.getTime() <= BIGBANG.getTime();
        }
        return dt.equals(BIGBANG) || dt.before(BIGBANG);
    }

    public static final String[] getStringList(Node inn, String itemname) throws Exception {
        ArrayList<String> al = new ArrayList<String>();
        NodeList nl = inn.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equals("#text")) continue;
            if (n.getNodeName().equalsIgnoreCase(itemname)) {
                al.add(DomTools.textFrom(n));
                continue;
            }
            throw new Exception("xml: unexpected node " + n.getNodeName());
        }
        return al.toArray(new String[al.size()]);
    }

    public static final List<String> getStringList(Node inn, String listname, String itemname) throws Exception {
        Node ln = DomTools.nodeFind(inn, listname);
        if (ln == null) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>();
        NodeList nl = ln.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equals("#text")) continue;
            if (n.getNodeName().equalsIgnoreCase(itemname)) {
                al.add(DomTools.textFrom(n));
                continue;
            }
            throw new Exception("xml: unexpected node " + n.getNodeName());
        }
        return al;
    }

    public static Node getRootElement(Document doc) throws Exception {
        NodeList nl = doc.getChildNodes();
        Node root = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            if (root != null) {
                throw new IllegalStateException("Multiple root nodes in document: " + root.getNodeName() + " and " + n.getNodeName());
            }
            root = n;
        }
        if (root == null) {
            throw new IllegalStateException("No root node in XML document.");
        }
        return root;
    }

    public static boolean isTextOnly(Node inn) {
        NodeList nl = inn.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            short nt = n.getNodeType();
            if (nt == 3 || nt == 7 || nt == 8) continue;
            return false;
        }
        return true;
    }

    public static void saveDocument(File of, Document doc) throws Exception {
        DOMSource s = new DOMSource(doc);
        StreamResult r = new StreamResult(of);
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.transform(s, r);
    }

    public static void saveDocument(Writer of, Document doc) throws Exception {
        DOMSource s = new DOMSource(doc);
        StreamResult r = new StreamResult(of);
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.transform(s, r);
    }

    public static void setAttr(Node elem, String name, String value) {
        Attr n = elem.getOwnerDocument().createAttribute(name);
        n.setNodeValue(value);
        elem.getAttributes().setNamedItem(n);
    }

    public static Node nodeFindXpath(Node node, String xpathQuery) throws Exception {
        String[] nodes = xpathQuery.split("/");
        if (nodes.length == 0) {
            return null;
        }
        Node returnNode = DomTools.nodeFind(node, nodes[0]);
        if (returnNode == null) {
            return null;
        }
        for (int i = 1; i < nodes.length; ++i) {
            if (null != (returnNode = DomTools.nodeFind(returnNode, nodes[i]))) continue;
            return null;
        }
        return returnNode;
    }

    @Nonnull
    public static XMLInputFactory getStreamFactory() {
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        xmlif.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return xmlif;
    }

    static {
        m_dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS z");
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 2);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        BIGBANG = cal.getTime();
        cal.set(1, 3000);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        OBLIVIAN = cal.getTime();
    }
}

