/*
 * Decompiled with CFR 0.152.
 */
package to.etc.xml;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import to.etc.xml.DomTools;

public class NSDomTools {
    public static Node nodeFind(Node rn, String ns, String name) throws Exception {
        NodeList nl = rn.getChildNodes();
        Node fn = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!name.equals(n.getLocalName()) || !ns.equals(n.getNamespaceURI()) || n.getNodeType() != 1) continue;
            if (fn != null) {
                throw new Exception(name + ": duplicate instance within " + rn.getNodeName());
            }
            fn = nl.item(i);
        }
        return fn;
    }

    public static String textFrom_untrimmed(Node n) {
        return DomTools.textFrom_untrimmed(n);
    }

    public static String textFrom(Node n) {
        return DomTools.textFrom(n);
    }

    public static String stringNode(Node rootnode, String ns, String name) throws Exception {
        Node n = NSDomTools.nodeFind(rootnode, ns, name);
        if (n == null) {
            return null;
        }
        return NSDomTools.textFrom(n);
    }

    public static String stringNode(Node rootnode, String ns, String name, int trunclen) throws Exception {
        String s = NSDomTools.stringNode(rootnode, ns, name);
        if (s != null && s.length() > trunclen) {
            s = s.substring(0, trunclen);
        }
        return s;
    }

    public static String stringNode(Node rootnode, String ns, String name, String deflt) throws Exception {
        Node n = NSDomTools.nodeFind(rootnode, ns, name);
        if (n == null) {
            return deflt;
        }
        return NSDomTools.textFrom(n);
    }

    public static String stringNode_untrimmed(Node rootnode, String ns, String name) throws Exception {
        Node n = NSDomTools.nodeFind(rootnode, ns, name);
        if (n == null) {
            return null;
        }
        return NSDomTools.textFrom_untrimmed(n);
    }

    public static String stringNode_untrimmed(Node rootnode, String ns, String name, String deflt) throws Exception {
        Node n = NSDomTools.nodeFind(rootnode, ns, name);
        if (n == null) {
            return deflt;
        }
        return NSDomTools.textFrom_untrimmed(n);
    }

    public static Date dateNode(Node rn, String ns, String name) throws Exception {
        String s = NSDomTools.stringNode(rn, ns, name);
        if (s == null) {
            return null;
        }
        return DomTools.dateDecode(s);
    }

    public static Date dateNode(Node rn, String ns, String name, Date dflt) throws Exception {
        String s = NSDomTools.stringNode(rn, ns, name);
        if (s == null) {
            return dflt;
        }
        if ("(dbnull)".equals(s)) {
            return dflt;
        }
        return DomTools.dateDecode(s);
    }

    private static final void timeError(String v) throws Exception {
        throw new Exception(v + ": must be hh:mm, hh:mm:ss, hhmm or hhmmss.");
    }

    public static int timeNode(Node rn, String ns, String name, int dflt) throws Exception {
        char c;
        String v = NSDomTools.stringNode(rn, ns, name, null);
        if (v == null || v.length() == 0) {
            return dflt;
        }
        int ix = 0;
        int len = v.length();
        int ss = 0;
        int nr = 0;
        if (!Character.isDigit(c = v.charAt(ix++))) {
            NSDomTools.timeError(v);
        }
        nr = c - 48;
        if (ix >= len) {
            NSDomTools.timeError(v);
        }
        if (Character.isDigit(c = v.charAt(ix++))) {
            nr = nr * 10 + c - 48;
            if (ix >= len) {
                NSDomTools.timeError(v);
            }
            if ((c = v.charAt(ix)) == ':') {
                ++ix;
            }
        } else if (c != ':') {
            NSDomTools.timeError(v);
        }
        int hh = nr;
        if (ix + 2 > len) {
            NSDomTools.timeError(v);
        }
        if (!Character.isDigit(c = v.charAt(ix++))) {
            NSDomTools.timeError(v);
        }
        nr = c - 48;
        if (!Character.isDigit(c = v.charAt(ix++))) {
            NSDomTools.timeError(v);
        }
        int mm = nr = nr * 10 + c - 48;
        if (ix < len) {
            if ((c = v.charAt(ix++)) == ':') {
                if (ix >= len) {
                    NSDomTools.timeError(v);
                }
                c = v.charAt(ix++);
            }
            if (ix >= len) {
                NSDomTools.timeError(v);
            }
            if (!Character.isDigit(c)) {
                NSDomTools.timeError(v);
            }
            nr = c - 48;
            if (!Character.isDigit(c = v.charAt(ix++))) {
                NSDomTools.timeError(v);
            }
            ss = nr = nr * 10 + c - 48;
        }
        if (hh < 0 || hh > 23 || mm < 0 || mm >= 60 || ss < 0 || ss >= 60) {
            throw new Exception(v + ": invalid time (hours or minutes bad)");
        }
        return hh * 60 * 60 + mm * 60 + ss;
    }

    public static int intNode(Node rootnode, String ns, String name) throws Exception {
        String s = NSDomTools.stringNode(rootnode, ns, name);
        if (s != null && (s = s.trim()).length() >= 0 && !"(dbnull)".equals(s)) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception ex) {
                throw new Exception(name + ": integer value expected, got '" + s + "'");
            }
        }
        throw new Exception("Missing '" + name + "' node [integer]");
    }

    public static int intNode(Node rootnode, String ns, String name, int val) throws Exception {
        String s = NSDomTools.stringNode(rootnode, ns, name);
        if (s == null) {
            return val;
        }
        if ((s = s.trim()).length() == 0 || "(dbnull)".equals(s)) {
            return val;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            throw new Exception(name + ": integer value expected, got '" + s + "'");
        }
    }

    public static long longNode(Node rootnode, String ns, String name) throws Exception {
        String s = NSDomTools.stringNode(rootnode, ns, name);
        if (s != null && (s = s.trim()).length() >= 0 && !"(dbnull)".equals(s)) {
            try {
                return Long.parseLong(s);
            }
            catch (Exception ex) {
                throw new Exception(name + ": long value expected, got '" + s + "'");
            }
        }
        throw new Exception("Missing '" + name + "' node [long]");
    }

    public static long longNode(Node rootnode, String ns, String name, long val) throws Exception {
        String s = NSDomTools.stringNode(rootnode, ns, name);
        if (s == null) {
            return val;
        }
        if ((s = s.trim()).length() == 0 || "(dbnull)".equals(s)) {
            return val;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Exception ex) {
            throw new Exception(name + ": long value expected, got '" + s + "'");
        }
    }

    public static double doubleNode(Node rootnode, String ns, String name, double val) throws Exception {
        String s = NSDomTools.stringNode(rootnode, ns, name);
        if (s == null) {
            return val;
        }
        if ((s = s.trim()).length() == 0 || "(dbnull)".equals(s)) {
            return val;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception ex) {
            throw new Exception(name + ": double value expected, got '" + s + "'");
        }
    }

    public static boolean boolNode(Node rootnode, String ns, String name) throws Exception {
        Node n = NSDomTools.nodeFind(rootnode, ns, name);
        if (n == null) {
            return false;
        }
        return DomTools.decodeBoolStr(NSDomTools.textFrom(n), name);
    }

    public static String getNodeAttribute(Node n, String ns, String aname, String defval) {
        Node idn;
        if (n.hasAttributes() && (idn = n.getAttributes().getNamedItemNS(ns, aname)) != null) {
            return idn.getNodeValue();
        }
        return defval;
    }

    public static String strAttr(Node n, String ns, String aname, String def) {
        return NSDomTools.getNodeAttribute(n, ns, aname, def);
    }

    public static int intAttr(Node n, String ns, String aname, int defval) throws Exception {
        return NSDomTools.getNodeAttribute(n, ns, aname, defval);
    }

    public static int intAttr(Node n, String ns, String aname) throws Exception {
        String v;
        Node idn;
        if (n.hasAttributes() && (idn = n.getAttributes().getNamedItemNS(ns, aname)) != null && (v = idn.getNodeValue()) != null && v.length() > 0) {
            try {
                return Integer.parseInt(v.trim());
            }
            catch (Exception ex) {
                throw new Exception("expected integer value for attribute " + aname + " in namespace " + ns + ", but got '" + v + "'");
            }
        }
        throw new Exception("Missing mandatory int attribute '" + aname + "' on tag '" + n.getNodeName() + "'");
    }

    public static boolean boolAttr(Node n, String ns, String aname) throws Exception {
        Node idn;
        if (n.hasAttributes() && (idn = n.getAttributes().getNamedItemNS(ns, aname)) != null) {
            String v = idn.getNodeValue();
            return DomTools.decodeBoolStr(v, aname);
        }
        throw new Exception("Missing mandatory boolean attribute '" + aname + "' on tag '" + n.getNodeName() + "'");
    }

    public static boolean boolAttr(Node n, String ns, String aname, boolean defval) throws Exception {
        Node idn;
        if (n.hasAttributes() && (idn = n.getAttributes().getNamedItemNS(ns, aname)) != null) {
            String v = idn.getNodeValue();
            return DomTools.decodeBoolStr(v, aname);
        }
        return defval;
    }

    public static int getNodeAttribute(Node n, String ns, String aname, int defval) throws Exception {
        String v;
        Node idn;
        if (n.hasAttributes() && (idn = n.getAttributes().getNamedItemNS(ns, aname)) != null && (v = idn.getNodeValue()) != null && v.length() > 0) {
            try {
                return Integer.parseInt(v.trim());
            }
            catch (Exception ex) {
                throw new Exception("expected integer value for attribute " + aname + ", but got '" + v + "'");
            }
        }
        return defval;
    }

    public static final String[] getStringList(Node inn, String itemname) throws Exception {
        ArrayList<String> al = new ArrayList<String>();
        NodeList nl = inn.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equals("#text")) continue;
            if (n.getNodeName().equalsIgnoreCase(itemname)) {
                al.add(DomTools.textFrom(n));
                continue;
            }
            throw new Exception("xml: unexpected node " + n.getNodeName());
        }
        return al.toArray(new String[al.size()]);
    }

    public static final List<String> getStringList(Node inn, String listname, String itemname) throws Exception {
        Node ln = DomTools.nodeFind(inn, listname);
        if (ln == null) {
            return null;
        }
        ArrayList<String> al = new ArrayList<String>();
        NodeList nl = ln.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeName().equals("#text")) continue;
            if (n.getNodeName().equalsIgnoreCase(itemname)) {
                al.add(DomTools.textFrom(n));
                continue;
            }
            throw new Exception("xml: unexpected node " + n.getNodeName());
        }
        return al;
    }

    public static Node getRootElement(Document doc) throws Exception {
        return DomTools.getRootElement(doc);
    }
}

