/*
 * Decompiled with CFR 0.152.
 */
package to.etc.xml;

import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import to.etc.util.FileTool;
import to.etc.xml.DefaultErrorHandler;

public class SAXTools {
    public static void parseSAX(@Nonnull Reader r, @Nullable String id, @Nullable ContentHandler ch, @Nullable ErrorHandler eh) throws Exception {
        XMLReader xr = XMLReaderFactory.createXMLReader();
        xr.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        xr.setFeature("http://xml.org/sax/features/namespaces", true);
        xr.setContentHandler(ch);
        xr.setErrorHandler(eh);
        InputSource ips = new InputSource(r);
        ips.setPublicId("incoming:" + id);
        xr.parse(ips);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseSAX(@Nonnull Class<?> base, @Nullable String name, @Nullable ContentHandler ch, @Nullable ErrorHandler eh) throws Exception {
        Reader r = FileTool.getResourceReader(base, name);
        try {
            SAXTools.parseSAX(r, base.getName() + "/" + name, ch, eh);
        }
        finally {
            try {
                r.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void parseSAX(@Nonnull Class<?> base, @Nullable String name, @Nullable ContentHandler ch) throws Exception {
        DefaultErrorHandler deh = new DefaultErrorHandler();
        SAXTools.parseSAX(base, name, ch, (ErrorHandler)deh);
        if (deh.hasErrors()) {
            throw new SAXException("SAX Parse errors: " + deh.getErrors());
        }
    }
}

