/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;

public class BetterSQLException
extends SQLException {
    private static final long serialVersionUID = 3916681942006359065L;

    public BetterSQLException(String sql, SQLException rootcause) {
        super(BetterSQLException.format(sql, rootcause, null, 0));
        this.initCause(rootcause);
    }

    public BetterSQLException(String sql, Object[] par, int ct, SQLException rootcause) {
        super(BetterSQLException.format(sql, rootcause, par, ct));
        this.initCause(rootcause);
    }

    @Override
    public int getErrorCode() {
        if (this.getCause() != null) {
            return ((SQLException)this.getCause()).getErrorCode();
        }
        return 0;
    }

    @Override
    public String getSQLState() {
        if (this.getCause() != null) {
            return ((SQLException)this.getCause()).getSQLState();
        }
        return null;
    }

    private static void fillEmpty(StringBuilder b, int len, String ... s) {
        int l = 0;
        for (String string : s) {
            b.append(string);
            l += string.length();
        }
        for (int i = l; i < len; ++i) {
            b.append(" ");
        }
    }

    private static String oldFformat(String sql, SQLException rootcause, Object[] par, int ct) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(rootcause.toString());
        sb.append("\n\nSQL: ");
        sb.append(sql);
        sb.append('\n');
        if (par != null && ct > 0) {
            sb.append("Parameters:\n");
            for (int i = 0; i < ct; ++i) {
                sb.append("#");
                sb.append(i + 1);
                sb.append(":");
                Object o = par[i];
                if (o == null) {
                    sb.append("[null]\n");
                } else {
                    sb.append(o.getClass().getName());
                    sb.append(":");
                    sb.append(o.toString());
                    sb.append("\n");
                }
                if (sb.length() <= 8192) continue;
                sb.append(".... (truncated)...\n");
                break;
            }
        }
        return sb.toString();
    }

    private static String format(String sql, SQLException rootcause, Object[] par, int ct) {
        try {
            int l;
            int i;
            int nextToken;
            StringBuilder sb = new StringBuilder(128);
            sb.append(rootcause == null ? "" : rootcause.toString());
            sb.append("\n\nSQL: ");
            sb.append(sql);
            sb.append('\n');
            boolean insert = sql.toLowerCase().startsWith("insert");
            StreamTokenizer st = new StreamTokenizer(new StringReader(sql)){

                @Override
                public void parseNumbers() {
                }
            };
            st.wordChars(95, 95);
            st.wordChars(46, 46);
            st.wordChars(45, 45);
            st.wordChars(48, 57);
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            String from = null;
            int brace = 0;
            int open = 0;
            String pt = null;
            boolean needNext = false;
            while ((nextToken = st.nextToken()) != -1) {
                String t = nextToken == -2 ? String.valueOf(st.nval) : (nextToken == -3 ? st.sval : (st.sval != null ? "'" + st.sval + "'" : String.valueOf((char)st.ttype)));
                if (needNext) {
                    values.add(t);
                    needNext = false;
                } else if (t.equals("(")) {
                    ++brace;
                    ++open;
                } else if (t.equals(")")) {
                    --brace;
                } else if (insert && !t.equals(",") && brace != 0) {
                    if (open == 1) {
                        names.add(t);
                    } else if (open == 2) {
                        values.add(t);
                    }
                } else if (t.equals("=")) {
                    names.add(pt);
                    needNext = true;
                }
                if (pt != null && pt.equalsIgnoreCase("from")) {
                    from = t;
                }
                pt = t;
            }
            int c = 0;
            for (int i2 = 0; i2 < names.size(); ++i2) {
                String v = (String)values.get(i2);
                if (v.trim().equals("?")) {
                    if (par[c] != null) {
                        values.set(i2, par[c].toString());
                        types.add(par[c].getClass().getName());
                    } else {
                        values.set(i2, "[null]");
                        types.add("[null]");
                    }
                    ++c;
                    continue;
                }
                types.add(null);
            }
            int maxn = 0;
            int maxt = 0;
            int maxv = 0;
            for (i = 0; i < names.size(); ++i) {
                l = ((String)names.get(i)).length() + 2;
                if (l <= maxn) continue;
                maxn = l;
            }
            for (i = 0; i < values.size(); ++i) {
                l = ((String)values.get(i)).length() + 2;
                if (l <= maxv) continue;
                maxv = l;
            }
            for (i = 0; i < types.size(); ++i) {
                int l2;
                String type = (String)types.get(i);
                if (type == null || (l2 = type.length() + 2) <= maxt) continue;
                maxt = l2;
            }
            if (from != null) {
                sb.append("From : ");
                sb.append(from);
                sb.append("\n");
            }
            sb.append("Parameters:");
            int typec = 0;
            for (int i3 = 0; i3 < names.size(); ++i3) {
                String type = (String)types.get(i3);
                if (type == null) {
                    BetterSQLException.fillEmpty(sb, 5, "\n", "");
                    BetterSQLException.fillEmpty(sb, maxt, "  ", "");
                    sb.append("   ");
                } else {
                    BetterSQLException.fillEmpty(sb, 5, "\n#", String.valueOf(++typec));
                    BetterSQLException.fillEmpty(sb, maxt, ": ", type);
                    sb.append(" : ");
                }
                String name = (String)names.get(i3);
                BetterSQLException.fillEmpty(sb, maxn, name);
                sb.append(" = ");
                sb.append((String)values.get(i3));
                if (sb.length() <= 16384) continue;
                sb.append(".... (truncated)...\n");
                break;
            }
            return sb.toString();
        }
        catch (Exception e) {
            return BetterSQLException.oldFformat(sql, rootcause, par, ct);
        }
    }

    public static String format(Object[] par, int ct) {
        StringBuilder sb = new StringBuilder(128);
        if (par != null && ct > 0) {
            sb.append("Parameters:\n");
            for (int i = 0; i < ct; ++i) {
                sb.append("#");
                sb.append(i + 1);
                sb.append(":");
                Object o = par[i];
                if (o == null) {
                    sb.append("[null]\n");
                } else {
                    sb.append(o.getClass().getName());
                    sb.append(":");
                    sb.append(o.toString());
                    sb.append("\n");
                }
                if (sb.length() <= 8192) continue;
                sb.append(".... (truncated)...\n");
                break;
            }
        }
        return sb.toString();
    }
}

