/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.IConnectionEventListener;
import to.etc.dbpool.IStatisticsListener;
import to.etc.dbpool.ResultSetProxy;
import to.etc.dbpool.StatementProxy;
import to.etc.dbpool.info.BatchEntry;

class CollectingConnectionEventListener
implements IConnectionEventListener {
    private final IStatisticsListener m_listener;
    private Map<StatementProxy, List<String>> m_batchMap = new HashMap<StatementProxy, List<String>>();

    public CollectingConnectionEventListener(@Nonnull IStatisticsListener listener) {
        this.m_listener = listener;
    }

    @Nonnull
    public IStatisticsListener getListener() {
        return this.m_listener;
    }

    @Override
    public void connectionAllocated(ConnectionProxy proxy) {
        this.m_listener.connectionAllocated(proxy);
    }

    @Override
    public void connectionClosed(ConnectionProxy proxy) {
        this.m_listener.connectionClosed(proxy);
    }

    @Override
    public void prepareStatement(@Nonnull StatementProxy sp) {
        sp.m_tsStart = System.nanoTime();
    }

    @Override
    public void prepareStatementEnd(StatementProxy sp) {
        long duration = System.nanoTime() - sp.m_tsStart;
        this.m_listener.statementPrepared(sp, duration);
    }

    @Override
    public void executeQueryStart(StatementProxy sp, ResultSetProxy rsp) {
        rsp.m_ts_allocated = System.nanoTime();
    }

    @Override
    public void executeQueryEnd(StatementProxy sp, SQLException error, ResultSetProxy rs) {
        rs.m_ts_executeEnd = System.nanoTime();
        rs.m_prepared = true;
    }

    @Override
    public void resultSetClosed(StatementProxy sp, ResultSetProxy rsp) {
        long cts = System.nanoTime();
        long executeDuration = rsp.m_ts_executeEnd - rsp.m_ts_allocated;
        long fetchDuration = cts - rsp.m_ts_executeEnd;
        this.m_listener.queryStatementExecuted(sp, executeDuration, fetchDuration, rsp.m_rowCount, rsp.m_prepared);
    }

    @Override
    public void executePreparedQueryStart(StatementProxy sp, ResultSetProxy rsp) {
        rsp.m_ts_allocated = System.nanoTime();
    }

    @Override
    public void executePreparedQueryEnd(StatementProxy sp, SQLException wx, ResultSetProxy rs) {
        rs.m_ts_executeEnd = System.nanoTime();
        rs.m_prepared = true;
    }

    @Override
    public void executeUpdateStart(StatementProxy sp) {
        sp.m_tsStart = System.nanoTime();
    }

    @Override
    public void executeUpdateEnd(StatementProxy sp, SQLException sx, int rowcount) {
        long updateDuration = System.nanoTime() - sp.m_tsStart;
        this.m_listener.executeUpdateExecuted(sp, updateDuration, rowcount);
    }

    @Override
    public void executePreparedUpdateStart(StatementProxy sp) {
        sp.m_tsStart = System.nanoTime();
    }

    @Override
    public void executePreparedUpdateEnd(StatementProxy sp, SQLException error, int rowcount) {
        long updateDuration = System.nanoTime() - sp.m_tsStart;
        this.m_listener.executePreparedUpdateExecuted(sp, updateDuration, rowcount);
    }

    @Override
    public void executeStart(StatementProxy sp) {
        sp.m_tsStart = System.nanoTime();
    }

    @Override
    public void executeEnd(StatementProxy sp, SQLException error, Boolean result) {
        long updateDuration = System.nanoTime() - sp.m_tsStart;
        this.m_listener.executeExecuted(sp, updateDuration, result);
    }

    @Override
    public void addBatch(StatementProxy sp, String sql) {
        List<String> l = this.m_batchMap.get(sp);
        if (null == l) {
            l = new ArrayList<String>();
            this.m_batchMap.put(sp, l);
        }
        l.add(sql);
    }

    @Override
    public void executeBatchStart(StatementProxy sp) {
        sp.m_tsStart = System.nanoTime();
    }

    @Override
    public void executeBatchEnd(StatementProxy sp, SQLException error, int[] rc) {
        long executeDuration = System.nanoTime() - sp.m_tsStart;
        int totalStatements = 0;
        int totalRows = 0;
        HashMap<String, BatchEntry> batchMap = new HashMap<String, BatchEntry>();
        ArrayList<BatchEntry> list = new ArrayList<BatchEntry>();
        List stl = this.m_batchMap.get(sp);
        if (null == stl) {
            stl = Collections.EMPTY_LIST;
        }
        if (null != rc) {
            for (int i = 0; i < rc.length; ++i) {
                int count;
                String stmt = i < stl.size() ? (String)stl.get(i) : "(unknown stmt)";
                BatchEntry be = (BatchEntry)batchMap.get(stmt);
                if (null == be) {
                    be = new BatchEntry(stmt);
                    batchMap.put(stmt, be);
                    list.add(be);
                }
                if ((count = rc[i]) == -2) {
                    ++totalStatements;
                    be.add(1);
                    be.setNoRowCount();
                    ++totalRows;
                    continue;
                }
                if (count < 0) continue;
                ++totalStatements;
                be.add(count);
                totalRows += count;
            }
            Collections.sort(list, new Comparator<BatchEntry>(){

                @Override
                public int compare(BatchEntry a, BatchEntry b) {
                    return b.getRowCount() - a.getRowCount();
                }
            });
        } else {
            totalStatements = stl.size();
        }
        this.m_batchMap.remove(sp);
        this.m_listener.executeBatchExecuted(executeDuration, totalStatements, totalRows, list);
    }
}

