/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.sql.DataSource;
import to.etc.dbpool.ConnState;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.DataSourceImpl;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbpool.DbType;
import to.etc.dbpool.HangCheckState;
import to.etc.dbpool.IConnectionEventListener;
import to.etc.dbpool.PoolConfig;
import to.etc.dbpool.PoolEntry;
import to.etc.dbpool.PoolManager;
import to.etc.dbpool.PoolStats;
import to.etc.dbpool.PreparedStatementProxy;
import to.etc.dbpool.ScanMode;
import to.etc.dbpool.StatementProxy;
import to.etc.dbpool.StringPrinter;
import to.etc.dbpool.ThreadConfig;
import to.etc.dbpool.UnpooledDataSourceImpl;
import to.etc.dbpool.info.IConnectionStatisticsFactory;
import to.etc.dbpool.info.OracleConnectionStatisticsFactory;

public final class ConnectionPool {
    public static final Logger MSG = Logger.getLogger("to.etc.dbpool.msg");
    public static final Logger JAN = Logger.getLogger("to.etc.dbpool.janitor");
    public static final Logger ALLOC = Logger.getLogger("to.etc.dbpool.alloc");
    private final PoolManager m_manager;
    private final String m_id;
    private final PoolConfig m_config;
    private Driver m_driver;
    private boolean m_isPooled;
    private final Properties m_properties = new Properties();
    private boolean m_destroyed;
    private DbType m_dbType = DbType.UNKNOWN;
    private String m_check_calc;
    private ThreadLocal<ThreadConfig> m_threadConfig = new ThreadLocal();
    private Stack<PoolEntry> m_freeList = new Stack();
    private Set<PoolEntry> m_usedSet = new HashSet<PoolEntry>();
    private int m_unpooledAllocatedCount;
    private int m_unpooledMaxUsed;
    private int m_pooledAllocatedCount;
    private int m_pooledUsedCount;
    private int m_pooledMaxUsed;
    private int m_poolAllocationCount;
    private int m_databaseAllocationCount;
    private int m_n_connectionwaits;
    private int m_n_connectionfails;
    private int m_n_hangdisconnects;
    private List<ConnectionProxy> m_currentlyHangingConnections = Collections.EMPTY_LIST;
    private List<ConnectionProxy> m_releasedConnections = Collections.EMPTY_LIST;
    protected int m_n_open_stmt;
    protected int m_peak_open_stmt;
    protected long m_n_open_rs;
    protected long m_statementTotalPrepareCount;
    @Deprecated
    protected long m_n_rows;
    private List<ErrorEntry> m_lastErrorStack = new ArrayList<ErrorEntry>(10);
    private final DataSourceImpl m_pooled_ds = new DataSourceImpl(this);
    private final UnpooledDataSourceImpl m_unpooled_ds = new UnpooledDataSourceImpl(this);
    private final int m_conntime_warning_ms = 8000;
    protected boolean m_dbg_stacktrace = true;
    private int m_entryidgen;
    private volatile int m_forceTimeout;
    private final Map<String, Object> m_attributeMap = new HashMap<String, Object>();
    @Nullable
    private IConnectionStatisticsFactory m_connectionStatisticsFactory;
    @Nonnull
    private List<IPoolEvent> m_poolListeners = Collections.EMPTY_LIST;
    private boolean m_hasPlSqlHandler;
    private final int[] m_usetime_ar = new int[10];
    private static final int[] TIMES = new int[]{10, 20, 50, 100, 250, 500, 1000, 2000, 4000};
    private boolean m_fileLogging;
    private Thread m_logWriterThread;
    private List<byte[]> m_logBufferList = new ArrayList<byte[]>();
    private static final int MAX_LOG_QUEUED = 30;
    private OutputStream m_fileLogStream;
    public static final long STMT_START_MAGIC = -6072317952152117587L;

    public ConnectionPool(PoolManager pm, String id, PoolConfig config) throws SQLException {
        this.m_manager = pm;
        this.m_id = id;
        this.m_config = config;
    }

    public PoolConfig c() {
        return this.m_config;
    }

    public synchronized void addListener(@Nonnull IPoolEvent l) {
        this.m_poolListeners = new ArrayList<IPoolEvent>(this.m_poolListeners);
        this.m_poolListeners.add(l);
    }

    public synchronized void removeListener(@Nonnull IPoolEvent l) {
        this.m_poolListeners = new ArrayList<IPoolEvent>(this.m_poolListeners);
        this.m_poolListeners.remove(l);
    }

    @Nonnull
    private synchronized List<IPoolEvent> getPoolListeners() {
        return this.m_poolListeners;
    }

    private void callAllocatedListeners(@Nonnull Connection dbc) {
        List<IPoolEvent> poolListeners = this.getPoolListeners();
        int i = poolListeners.size();
        while (--i >= 0) {
            try {
                poolListeners.get(i).connectionAllocated(dbc);
            }
            catch (Exception x) {
                System.out.println("Ignored exception in pool event listener " + poolListeners.get(i) + ": " + x);
                x.printStackTrace();
            }
        }
    }

    void callReleasedListeners(@Nonnull Connection dbc) {
        List<IPoolEvent> poolListeners = this.getPoolListeners();
        int i = poolListeners.size();
        while (--i >= 0) {
            try {
                poolListeners.get(i).connectionReleased(dbc);
            }
            catch (Exception x) {
                System.out.println("Ignored exception in pool event listener " + poolListeners.get(i) + ": " + x);
                x.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void checkParameters() throws SQLException {
        String plsqldebug;
        this.usable();
        this.m_properties.setProperty("user", this.c().getUid());
        this.m_properties.setProperty("password", this.c().getPw());
        if (this.c().getUrl() == null) {
            throw new SQLException("Pool " + this.getID() + ": missing 'url' parameter");
        }
        if (this.c().getDriverClassName() == null) {
            throw new SQLException("Pool " + this.getID() + ": missing 'driver' class name parameter");
        }
        if (this.c().getUid() == null) {
            throw new SQLException("Pool " + this.getID() + ": missing 'uid' user name parameter");
        }
        if (this.c().isCollectStatistics()) {
            this.m_manager.setCollectStatistics(true);
        }
        if (this.c().getDriverPath() != null && !this.c().getDriverPath().exists()) {
            throw new SQLException("Pool " + this.getID() + ": driver path '" + this.c().getDriverPath() + "' does not exist");
        }
        if (this.c().getBinaryLogFile() != null) {
            this.setFileLogging(this.c().getBinaryLogFile());
        }
        if (null != (plsqldebug = DbPoolUtil.getPlSqlDebug(this.getID()))) {
            this.addPlSqlDebugHandler(plsqldebug);
        }
        Connection dbc = null;
        try {
            if (this.c().isSetlog()) {
                DriverManager.setLogWriter(new PrintWriter(System.out));
            }
            this.m_driver = DbPoolUtil.loadDriver(this.c().getDriverPath(), this.c().getDriverClassName());
            System.out.println("pool(" + this.m_id + "): defining " + this.c().getDriverClassName() + ", url=" + this.c().getUrl() + ", uid=" + this.c().getUid());
            if (this.c().isPrintExceptions()) {
                System.out.println("  *warning: printExceptions is true");
            }
            dbc = this.getCheckedConnection();
            DatabaseMetaData md = dbc.getMetaData();
            System.out.println("pool(" + this.getID() + "): driver version " + md.getDriverVersion() + ", " + md.getDatabaseProductName());
            this.m_dbType = DbPoolUtil.getDbTypeByDriverName(md.getDriverName());
            OracleConnectionStatisticsFactory connectionStatisticsFactory = null;
            switch (this.m_dbType) {
                default: {
                    break;
                }
                case ORACLE: {
                    connectionStatisticsFactory = new OracleConnectionStatisticsFactory();
                }
            }
            this.m_connectionStatisticsFactory = connectionStatisticsFactory;
            if (!this.c().isCheckConnection()) return;
            if (this.c().getCheckSQL() != null) {
                this.m_check_calc = this.c().getCheckSQL();
                return;
            }
            switch (this.m_dbType) {
                default: {
                    throw new SQLException("pool(" + this.getID() + ")'s type is unknown, it needs a manually-configured 'check' SQL statement");
                }
                case ORACLE: {
                    this.m_check_calc = "select 1 from dual";
                    return;
                }
                case POSTGRES: 
                case MYSQL: {
                    this.m_check_calc = "select 1";
                    return;
                }
            }
        }
        catch (ClassNotFoundException x) {
            throw new SQLException("pool(" + this.m_id + "): driver not found " + this.c().getDriverClassName());
        }
        catch (SQLException x) {
            throw x;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlSqlDebugHandler(@Nonnull String plsqldebug) throws SQLException {
        final DbPoolUtil.HostAndPort hostAndPort = DbPoolUtil.HostAndPort.parse(plsqldebug);
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.m_hasPlSqlHandler) {
                return;
            }
            this.m_hasPlSqlHandler = true;
        }
        this.addListener(new IPoolEvent(){

            @Override
            public void connectionReleased(@Nonnull Connection dbc) throws Exception {
            }

            @Override
            public void connectionAllocated(@Nonnull Connection dbc) throws Exception {
                DbPoolUtil.enableRemoteDebug(dbc, hostAndPort);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLException checkConnection(Connection dbc) {
        SQLException sQLException;
        if (!this.c().isCheckConnection() || this.m_check_calc == null) {
            return null;
        }
        ResultSet rs = null;
        Statement ps = null;
        try {
            String sql = this.getCheckString();
            if (sql.length() == 0) {
                SQLException sQLException2 = null;
                return sQLException2;
            }
            ps = dbc.createStatement();
            rs = ps.executeQuery(sql);
            sQLException = null;
        }
        catch (SQLException ex) {
            SQLException sQLException3 = ex;
            return sQLException3;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
        return sQLException;
    }

    private Connection getCheckedConnection() throws SQLException {
        return this.getCheckedConnection(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getCheckedConnection(String user, String passwd) throws SQLException {
        this.usable();
        int tries = 5;
        SQLException lastx = null;
        while (tries-- > 0) {
            Connection dbc = null;
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                ++this.m_databaseAllocationCount;
            }
            try {
                Properties p = this.m_properties;
                if (user != null) {
                    p = new Properties(this.m_properties);
                    p.setProperty("user", user);
                    p.setProperty("password", passwd);
                }
                dbc = this.m_driver.connect(this.c().getUrl(), p);
            }
            catch (SQLException x) {
                x.printStackTrace();
                MSG.info("Failed to get connection for " + this.getID() + ": " + x.toString());
                lastx = x;
            }
            if (dbc == null) continue;
            lastx = this.checkConnection(dbc);
            if (lastx == null) {
                this.callAllocatedListeners(dbc);
                return dbc;
            }
            try {
                dbc.close();
            }
            catch (Exception exception) {}
        }
        throw new SQLException("Cannot get new connection for user " + user + " from database driver: " + lastx, lastx);
    }

    public synchronized void initialize() throws SQLException {
        this.usable();
        if (this.m_isPooled) {
            return;
        }
        this.m_manager.startExpiredConnectionScanner();
        try {
            System.out.print("pool(" + this.m_id + "): initializing to pooled mode - ");
            for (int i = 0; i < this.c().getMinConns(); ++i) {
                Connection c = this.getCheckedConnection();
                PoolEntry pe = new PoolEntry(c, this, this.m_entryidgen++, this.c().getUid());
                this.m_freeList.add(pe);
                if (this.c().isSqlTraceMode()) {
                    pe.setSqlTraceMode(true);
                }
                ++this.m_pooledAllocatedCount;
            }
            this.m_isPooled = true;
            System.out.println(this.m_pooledAllocatedCount + " connections allocated, okay.");
        }
        catch (SQLException x) {
            System.out.println("FAILED " + x.toString());
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    void destroyPool() {
        Stack<PoolEntry> freelist;
        Set<PoolEntry> usedset;
        if (!this.m_manager.internalRemovePool(this)) {
            return;
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.m_destroyed) {
                return;
            }
            this.m_destroyed = true;
            usedset = this.m_usedSet;
            freelist = this.m_freeList;
            this.m_usedSet = new HashSet<PoolEntry>();
            this.m_freeList = new Stack();
            this.m_statementTotalPrepareCount = 0L;
            this.m_n_open_rs = 0L;
            this.m_n_open_stmt = 0;
            this.m_pooledUsedCount = 0;
            this.m_pooledAllocatedCount = 0;
            this.m_n_rows = 0L;
            this.m_unpooledAllocatedCount = 0;
            this.m_isPooled = false;
            this.m_pooledMaxUsed = 0;
            this.m_peak_open_stmt = 0;
        }
        this.deinitPool(freelist);
        this.deinitPool(usedset);
    }

    private void deinitPool(Collection<PoolEntry> s) {
        List<ConnectionProxy> all = this.getUsedConnections();
        for (ConnectionProxy px : all) {
            try {
                px.forceInvalid();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private synchronized void usable() {
        if (this.m_destroyed) {
            throw new IllegalStateException("This pool(" + this.getID() + ") has been destroyed.");
        }
    }

    private synchronized void dbgAlloc(String what, Connection dbc) {
        ++this.m_poolAllocationCount;
        if (this.c().isLogAllocation() || this.c().isLogAllocationStack()) {
            System.out.println("DEBUG: pool(" + this.m_id + ") ALLOCATED connection " + dbc);
            if (this.c().isLogAllocationStack()) {
                System.out.println(DbPoolUtil.getLocation());
            }
        }
        if (!ALLOC.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("ALLOCATE pool(" + this.m_id + ") " + what + " database[allocated for pool=" + this.m_pooledAllocatedCount + ", allocated unpooled=" + this.m_unpooledAllocatedCount + "] pool[inuse=" + this.m_pooledUsedCount + ", free=" + this.m_freeList.size() + "]");
        sb.append("\nConnection: " + dbc + "\n");
        DbPoolUtil.getThreadAndLocation(sb);
        ALLOC.fine(sb.toString());
    }

    public synchronized void dbgRelease(String what, Connection dbc) {
        if (this.c().isLogAllocation() || this.c().isLogAllocationStack()) {
            System.out.println("DEBUG: pool(" + this.m_id + ") CLOSED connection " + dbc + " (back to pool set)");
            if (this.c().isLogAllocationStack()) {
                System.out.println(DbPoolUtil.getLocation());
            }
        }
        if (!ALLOC.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("RELEASED pool(" + this.m_id + ") " + what + " database[allocated for pool=" + this.m_pooledAllocatedCount + ", allocated unpooled=" + this.m_unpooledAllocatedCount + "] pool[inuse=" + this.m_pooledUsedCount + ", free=" + this.m_freeList.size() + "]");
        if (dbc != null) {
            sb.append("\nConnection: " + dbc + "\n");
        }
        DbPoolUtil.getThreadAndLocation(sb);
        ALLOC.fine(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoolEntry allocateConnectionInner(boolean unpooled) throws SQLException {
        int newid = 0;
        long ets = -1L;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            while (true) {
                this.usable();
                if (!this.m_freeList.isEmpty()) {
                    PoolEntry pe = this.m_freeList.pop();
                    this.m_usedSet.add(pe);
                    pe.setUnpooled(unpooled);
                    if (unpooled) {
                        --this.m_pooledAllocatedCount;
                        ++this.m_unpooledAllocatedCount;
                        if (this.m_unpooledAllocatedCount > this.m_unpooledMaxUsed) {
                            this.m_unpooledMaxUsed = this.m_unpooledAllocatedCount;
                        }
                    } else {
                        ++this.m_pooledUsedCount;
                        if (this.m_pooledUsedCount > this.m_pooledMaxUsed) {
                            this.m_pooledMaxUsed = this.m_pooledUsedCount;
                        }
                    }
                    return pe;
                }
                if (this.m_pooledAllocatedCount < this.c().getMaxConns() || unpooled) {
                    if (!unpooled) {
                        ++this.m_pooledAllocatedCount;
                        ++this.m_pooledUsedCount;
                        if (this.m_pooledUsedCount > this.m_pooledMaxUsed) {
                            this.m_pooledMaxUsed = this.m_pooledUsedCount;
                        }
                    } else {
                        ++this.m_unpooledAllocatedCount;
                        if (this.m_unpooledAllocatedCount > this.m_unpooledMaxUsed) {
                            this.m_unpooledMaxUsed = this.m_unpooledAllocatedCount;
                        }
                    }
                    break;
                }
                ++this.m_n_connectionwaits;
                long cts = System.currentTimeMillis();
                if (ets == -1L) {
                    ets = cts + 10000L;
                } else if (cts >= ets) {
                    return null;
                }
                try {
                    this.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw new SQLException("dbPool " + this.m_id + ": interrupted while waiting for connection to become available");
                }
            }
            newid = this.m_entryidgen++;
        }
        boolean ok = false;
        PoolEntry pe = null;
        try {
            Connection c = this.getCheckedConnection();
            pe = new PoolEntry(c, this, newid, this.c().getUid());
            pe.setUnpooled(unpooled);
            if (this.c().isSqlTraceMode()) {
                pe.setSqlTraceMode(true);
            }
            ok = true;
            PoolEntry poolEntry = pe;
            return poolEntry;
        }
        finally {
            ConnectionPool connectionPool2 = this;
            synchronized (connectionPool2) {
                if (ok) {
                    this.m_usedSet.add(pe);
                } else if (!unpooled) {
                    --this.m_pooledAllocatedCount;
                    --this.m_pooledUsedCount;
                } else {
                    --this.m_unpooledAllocatedCount;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoolEntry allocateConnection(boolean unpooled) throws SQLException {
        PoolEntry pe;
        int ctries = 0;
        while (ctries < 6) {
            String msg;
            StringBuilder sb;
            pe = this.allocateConnectionInner(unpooled);
            if (null != pe) {
                return pe;
            }
            String s = "pool[" + this.getID() + "]: no more connections available on " + ++ctries + " try!?";
            System.out.println(s);
            MSG.warning(s);
            if (ctries == 2) {
                sb = new StringBuilder(0x100000);
                this.dumpUsedConnections(sb);
                msg = sb.toString();
                this.saveError("No more database connections for pool=" + this.getID() + ", try 2..", "....");
                this.m_manager.panic("No more database pool connections for pool " + this.getID(), msg);
            }
            if (ctries > 5) {
                ++this.m_n_connectionfails;
                sb = new StringBuilder(0x100000);
                this.dumpUsedConnections(sb);
                msg = sb.toString();
                this.saveError("No more database connections for pool=" + this.getID() + " - ABORTING REQUEST", msg);
                throw new SQLException("PANIC: Could not obtain a database connection - pool is exhausted!");
            }
            ++this.m_n_connectionwaits;
        }
        this.scanExpiredConnections(120, true);
        pe = this.allocateConnectionInner(unpooled);
        if (null != pe) {
            return pe;
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ++this.m_n_connectionfails;
        }
        throw new SQLException("PANIC: Could not obtain a database connection - pool is exhausted (and no connections can be forcefully released)!");
    }

    private void dumpUsedConnections(StringBuilder sb) {
        List<ConnectionProxy> cpl = this.getUsedConnections();
        StringPrinter sp = new StringPrinter(sb);
        for (ConnectionProxy px : cpl) {
            if (px.getState() != ConnState.OPEN) continue;
            DbPoolUtil.printTracepoints(sp, px, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnToPool(PoolEntry pe, ConnectionProxy pc) throws SQLException {
        this.m_manager.removeThreadConnection(pc);
        boolean ok = false;
        try {
            if (!pe.getConnection().getAutoCommit()) {
                pe.getConnection().rollback();
            }
            pe.getConnection().setAutoCommit(true);
            ok = true;
        }
        catch (SQLException ex) {
            System.out.print("pool(" + this.m_id + "): failed to reinitialize connection; dropped!");
            ex.printStackTrace();
            throw ex;
        }
        finally {
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                boolean unpooled = pe.isUnpooled();
                if (ok && unpooled && (this.m_pooledAllocatedCount >= this.c().getMaxConns() || !pe.getUserID().equals(this.c().getUid()))) {
                    ok = false;
                }
                if (ok) {
                    if (!this.m_usedSet.remove(pe)) {
                        String subj = "pool(" + this.m_id + "): connection not in USED pool??";
                        StringBuilder sb = new StringBuilder(65536);
                        sb.append("Connection not in used pool! Location of release is:\n");
                        DbPoolUtil.getThreadAndLocation(sb);
                        sb.append("\n\nConnection dump:\n");
                        DbPoolUtil.printTracepoints(new StringPrinter(sb), pc, true);
                        String msg = sb.toString();
                        this.saveError(subj, msg);
                        this.m_manager.panic(subj, msg);
                        throw new IllegalStateException(subj);
                    }
                    if (unpooled) {
                        --this.m_unpooledAllocatedCount;
                        ++this.m_pooledAllocatedCount;
                    } else {
                        --this.m_pooledUsedCount;
                    }
                    this.m_freeList.push(pe);
                    pe = null;
                    this.dbgRelease("returned to pool", pc);
                }
                try {
                    this.notify();
                }
                catch (Exception exception) {}
            }
            if (ok) {
                return;
            }
            this.discardEntry(pe);
        }
    }

    synchronized void removeEntryFromPool(PoolEntry pe) {
        boolean unpooled = pe.isUnpooled();
        if (unpooled) {
            --this.m_unpooledAllocatedCount;
        } else {
            --this.m_pooledUsedCount;
            --this.m_pooledAllocatedCount;
        }
        if (!this.m_usedSet.remove(pe)) {
            StringBuilder sb = new StringBuilder(65536);
            sb.append("POOLERR: Connection not in used pool! Location of release is:\n");
            DbPoolUtil.getThreadAndLocation(sb);
            String msg = sb.toString();
            System.out.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardEntry(PoolEntry pe) {
        String subj = null;
        String msg = null;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (!pe.isUnpooled()) {
                --this.m_pooledAllocatedCount;
                --this.m_pooledUsedCount;
            } else {
                --this.m_unpooledAllocatedCount;
            }
            if (!this.m_usedSet.remove(pe)) {
                subj = "pool(" + this.m_id + "): connection not in USED pool??";
                StringBuilder sb = new StringBuilder(65536);
                sb.append("Connection not in used pool! Location of release is:\n");
                DbPoolUtil.getThreadAndLocation(sb);
                msg = sb.toString();
                this.saveError(subj, msg);
            }
            try {
                this.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        pe.closeResources();
        pe.releaseConnection();
        if (subj != null) {
            this.m_manager.panic(subj, msg);
            throw new IllegalStateException(subj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionProxy> getUsedConnections() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ArrayList<ConnectionProxy> res = new ArrayList<ConnectionProxy>(this.m_usedSet.size());
            for (PoolEntry pe : this.m_usedSet) {
                ConnectionProxy px = pe.getProxy();
                if (px == null) {
                    throw new IllegalStateException("POOLERR: proxy is null on USED entry=" + pe);
                }
                res.add(px);
            }
            return res;
        }
    }

    ConnectionProxy getConnection(boolean unpooled) throws SQLException {
        IConnectionEventListener d = this.m_manager.getConnectionEventListener();
        while (true) {
            PoolEntry pe;
            SQLException x;
            if ((x = this.checkConnection((pe = this.allocateConnection(unpooled)).getConnection())) == null) {
                ConnectionProxy dbc = pe.proxyMake();
                this.dbgAlloc("getConnection", dbc);
                if (!unpooled) {
                    PoolManager.getInstance().addThreadConnection(dbc);
                }
                d.connectionAllocated(dbc);
                return dbc;
            }
            MSG.info("Pool " + this.m_id + ": cached connection error, " + x.toString() + "; discarded.");
            this.discardEntry(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getUnpooledConnection(String username, String password) throws SQLException {
        int newid;
        IConnectionEventListener d = this.m_manager.getConnectionEventListener();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            newid = this.m_entryidgen++;
        }
        boolean ok = false;
        PoolEntry pe = null;
        try {
            Connection c = this.getCheckedConnection(username, password);
            pe = new PoolEntry(c, this, newid, username);
            ok = true;
            pe.setUnpooled(true);
            ConnectionProxy dbc = pe.proxyMake();
            this.dbgAlloc("getUnpooledConnection", dbc);
            d.connectionAllocated(dbc);
            ConnectionProxy connectionProxy = dbc;
            return connectionProxy;
        }
        finally {
            ConnectionPool connectionPool2 = this;
            synchronized (connectionPool2) {
                if (ok) {
                    ++this.m_unpooledAllocatedCount;
                    this.m_usedSet.add(pe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scanExpiredConnections(int scanIntervalInSeconds, boolean forcedisconnects) {
        if (this.c().getScanMode() == ScanMode.DISABLED && !forcedisconnects) {
            return false;
        }
        List<ConnectionProxy> proxylist = this.getUsedConnections();
        long ts = System.currentTimeMillis();
        long ets = ts - (long)(scanIntervalInSeconds * 1000);
        HangCheckState hs = new HangCheckState(this.c().getScanMode(), ts, ets, forcedisconnects);
        for (ConnectionProxy cpx : proxylist) {
            cpx.checkHangState(hs);
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            this.m_n_hangdisconnects += hs.getDestroyCount();
            this.m_currentlyHangingConnections = hs.getHangingList();
        }
        String report = hs.getReport();
        if (report.length() > 0) {
            System.out.println("****Database Pool " + this.m_id + " Hanging Connections scan *******");
            System.out.println(report);
            System.out.println("Destroyed " + hs.getDestroyCount() + ", found " + hs.getHangCount() + " hanging pooled and " + hs.getUnpooledHangCount() + " hanging unpooled connections");
        }
        return hs.getDestroyCount() > 0;
    }

    private static int getTimeSlot(long ts) {
        int i = TIMES.length;
        while (--i >= 0) {
            if (ts < (long)TIMES[i]) continue;
            return i + 1;
        }
        return 0;
    }

    public int getConnectionUsedTooLongWarningTimeout() {
        return 8000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleConnectionUsageTime(ConnectionProxy pe, long ut) {
        int slot = ConnectionPool.getTimeSlot(ut);
        int[] nArray = this.m_usetime_ar;
        synchronized (this.m_usetime_ar) {
            int n = slot;
            this.m_usetime_ar[n] = this.m_usetime_ar[n] + 1;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (ut < 8000L) {
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getUseTimeTable() {
        int[] ar = new int[this.m_usetime_ar.length];
        int[] nArray = this.m_usetime_ar;
        synchronized (this.m_usetime_ar) {
            System.arraycopy(this.m_usetime_ar, 0, ar, 0, this.m_usetime_ar.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ar;
        }
    }

    public String getUseTimeTableStr() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("<table class=\"perftbl\">\n");
        sb.append("<tr>\n");
        for (int i = 0; i < TIMES.length; ++i) {
            sb.append("<td class=\"");
            sb.append(i % 2 == 0 ? "perfeven" : "perfodd");
            sb.append(" perfhdr\">");
            sb.append("&lt; ");
            if (TIMES[i] >= 1000) {
                sb.append(Integer.toString(TIMES[i] / 1000));
                sb.append("s");
            } else {
                sb.append(Integer.toString(TIMES[i]));
                sb.append("ms");
            }
            sb.append("</td>");
        }
        sb.append("<td class=\"perfhdr perfmore\">More!</td>");
        sb.append("\n</tr>\n<tr>\n");
        int[] ar = this.getUseTimeTable();
        for (int i = 0; i < ar.length; ++i) {
            sb.append("<td class=\"");
            sb.append(i % 2 == 0 ? "perfeven" : "perfodd");
            sb.append(" perfval\">");
            sb.append(Long.toString(ar[i]));
            sb.append("</td>");
        }
        sb.append("</tr>\n</table>\n");
        return sb.toString();
    }

    public synchronized void setSaveErrors(boolean on) {
        if (on && this.m_lastErrorStack == null) {
            this.m_lastErrorStack = new ArrayList<ErrorEntry>();
        } else if (!on && this.m_lastErrorStack != null) {
            this.m_lastErrorStack = null;
        }
    }

    public synchronized boolean hasSavedErrors() {
        return this.m_lastErrorStack != null && this.m_lastErrorStack.size() > 0;
    }

    public synchronized boolean isSavingErrors() {
        return this.m_lastErrorStack != null;
    }

    public synchronized List<ErrorEntry> getSavedErrorList() {
        if (this.m_lastErrorStack == null) {
            return null;
        }
        return new ArrayList<ErrorEntry>(this.m_lastErrorStack);
    }

    public synchronized void saveError(String subject, String msg) {
        if (this.m_lastErrorStack == null) {
            return;
        }
        this.m_lastErrorStack.add(0, new ErrorEntry(new Date(), subject, msg));
        while (this.m_lastErrorStack.size() > 10) {
            this.m_lastErrorStack.remove(this.m_lastErrorStack.size() - 1);
        }
    }

    void logExecution(StatementProxy sp, byte stmtType) {
        this.logExecution(sp, false, stmtType);
    }

    void logExecution(StatementProxy sp, boolean batch, byte stmtType) {
        PreparedStatementProxy ppx;
        Object[] par;
        this.writeStatement(sp, stmtType);
        if (!this.c().isLogStatements()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("   ");
        sb.append(DbPoolUtil.strTimeOnly(new Date()));
        sb.append(batch ? " dbg batch=" : " dbg sql=");
        sb.append(sp.getSQL());
        sb.append("\n    connection=");
        sb.append(sp._conn().toString());
        sb.append("\n");
        if (sp instanceof PreparedStatementProxy && (par = (ppx = (PreparedStatementProxy)sp).internalGetParameters()) != null) {
            sb.append("    parameters:\n");
            for (int i = 0; i < par.length; ++i) {
                sb.append("     #" + (i + 1) + ":");
                Object val = par[i];
                if (val == null) {
                    sb.append(" null\n");
                } else {
                    sb.append(val.getClass().getName());
                    sb.append(":");
                    sb.append(val.toString());
                    sb.append("\n");
                }
                if (sb.length() < 8192) continue;
                sb.append("    (rest truncated)\n");
                break;
            }
        }
        System.out.println(sb.toString());
    }

    void logAction(ConnectionProxy cp, String action) {
        if (!this.c().isLogStatements()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("   ");
        sb.append(DbPoolUtil.strTimeOnly(new Date()));
        sb.append(' ');
        sb.append(action);
        sb.append(", connection=");
        sb.append(cp.toString());
        System.out.println(sb.toString());
    }

    void logBatch() {
        if (!this.c().isLogStatements()) {
            return;
        }
        System.out.println("    executeBatch()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileLogging() {
        List<byte[]> list = this.m_logBufferList;
        synchronized (list) {
            return this.m_fileLogging;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileLogging(File target) {
        List<byte[]> list = this.m_logBufferList;
        synchronized (list) {
            if (this.m_fileLogging) {
                throw new IllegalArgumentException("File logging is already enabled");
            }
            try {
                this.m_fileLogStream = new FileOutputStream(target, true);
            }
            catch (Exception x) {
                System.out.println("pool(" + this.getID() + ") cannot open logging file " + target + ": " + x);
                return;
            }
            this.m_fileLogging = true;
        }
    }

    private void writeStatement(StatementProxy ls, byte stmtType) {
        byte[] buffer;
        if (!this.isFileLogging()) {
            return;
        }
        try {
            buffer = this.createLogImage(ls, stmtType);
        }
        catch (Exception x) {
            System.out.println("pool(" + this.getID() + ") failed to create statement image, statement ignored: " + x);
            return;
        }
        this.writeLogImage(buffer);
    }

    public void writeSpecial(ConnectionProxy cp, byte stmtType) {
        if (!this.isFileLogging()) {
            return;
        }
        this.writeLogImage(this.createSpecialImage(cp, stmtType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeLogImage(byte[] buffer) {
        List<byte[]> list = this.m_logBufferList;
        synchronized (list) {
            if (null == this.m_logWriterThread) {
                this.m_logWriterThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionPool.this.logWriterWriteLoop();
                    }
                });
                this.m_logWriterThread.setName("dblgwr");
                this.m_logWriterThread.setDaemon(true);
                this.m_logWriterThread.start();
            }
            while (this.m_fileLogging) {
                if (this.m_logBufferList.size() < 30) {
                    this.m_logBufferList.add(buffer);
                    this.m_logBufferList.notifyAll();
                    return;
                }
                try {
                    this.m_logBufferList.wait();
                }
                catch (InterruptedException x) {
                    System.out.println("pool(" + this.getID() + ") interrupted log write- cancelled");
                    return;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logWriterWriteLoop() {
        try {
            try {
                while (true) {
                    byte[] buf = this.waitForBuffer();
                    this.writeBuffer(buf);
                }
            }
            catch (Exception x) {
                System.out.println("pool(" + this.getID() + ") statement log write error " + x + ": logging cancelled");
                x.printStackTrace();
                Thread thread = this.m_logWriterThread;
                synchronized (thread) {
                    this.m_fileLogging = false;
                    this.m_logBufferList.clear();
                    this.m_logBufferList.notifyAll();
                    this.m_logWriterThread = null;
                }
            }
        }
        catch (Throwable throwable) {
            Thread thread = this.m_logWriterThread;
            synchronized (thread) {
                this.m_fileLogging = false;
                this.m_logBufferList.clear();
                this.m_logBufferList.notifyAll();
                this.m_logWriterThread = null;
            }
            throw throwable;
        }
    }

    private void writeBuffer(byte[] buf) throws Exception {
        this.m_fileLogStream.write(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] waitForBuffer() throws InterruptedException {
        while (true) {
            List<byte[]> list = this.m_logBufferList;
            synchronized (list) {
                if (this.m_logBufferList.size() > 0) {
                    byte[] buf = this.m_logBufferList.remove(0);
                    if (this.m_logBufferList.size() == 29) {
                        this.m_logBufferList.notify();
                    }
                    return buf;
                }
                this.m_logBufferList.wait();
            }
        }
    }

    private byte[] createLogImage(StatementProxy ls, byte stmtType) throws IOException {
        ByteArrayOutputStream baos = this.createImageBuilder(ls._conn(), stmtType);
        ConnectionPool.writeString(baos, ls.getSQL());
        if (ls instanceof PreparedStatementProxy) {
            PreparedStatementProxy ps = (PreparedStatementProxy)ls;
            Object[] par = ps.internalGetParameters();
            if (par.length <= 0) {
                ConnectionPool.writeInt(baos, 0);
            } else {
                ConnectionPool.writeInt(baos, par.length);
                for (int i = 0; i < par.length; ++i) {
                    this.writeParameter(baos, par[i]);
                }
            }
        } else {
            ConnectionPool.writeInt(baos, 0);
        }
        return baos.toByteArray();
    }

    private byte[] createSpecialImage(ConnectionProxy cp, byte stmtType) {
        ByteArrayOutputStream baos = this.createImageBuilder(cp, stmtType);
        return baos.toByteArray();
    }

    private ByteArrayOutputStream createImageBuilder(ConnectionProxy cp, byte stmtType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        ConnectionPool.writeLong(baos, -6072317952152117587L);
        baos.write(stmtType);
        long ts = System.currentTimeMillis();
        ConnectionPool.writeLong(baos, ts);
        ConnectionPool.writeInt(baos, cp.getId());
        return baos;
    }

    private void writeParameter(ByteArrayOutputStream baos, Object object) throws IOException {
        if (null == object) {
            baos.write(48);
        } else if (object instanceof Integer) {
            baos.write(105);
            ConnectionPool.writeInt(baos, (Integer)object);
        } else if (object instanceof Long) {
            baos.write(108);
            ConnectionPool.writeLong(baos, (Long)object);
        } else if (object instanceof BigDecimal) {
            baos.write(66);
            ConnectionPool.writeString(baos, ((BigDecimal)object).toString());
        } else if (object instanceof Double) {
            baos.write(100);
            ConnectionPool.writeString(baos, ((Double)object).toString());
        } else if (object instanceof Float) {
            baos.write(102);
            ConnectionPool.writeString(baos, ((Float)object).toString());
        } else if (object instanceof String) {
            baos.write(36);
            ConnectionPool.writeString(baos, (String)object);
        } else if (object instanceof Date) {
            baos.write(84);
            Date ts = (Date)object;
            ConnectionPool.writeLong(baos, ts.getTime());
        } else {
            baos.write(63);
            ConnectionPool.writeString(baos, object.getClass().getName());
        }
    }

    private static void writeInt(ByteArrayOutputStream os, int v) {
        os.write(v >> 24 & 0xFF);
        os.write(v >> 16 & 0xFF);
        os.write(v >> 8 & 0xFF);
        os.write(v & 0xFF);
    }

    private static void writeLong(ByteArrayOutputStream os, long v) {
        ConnectionPool.writeInt(os, (int)(v >> 32));
        ConnectionPool.writeInt(os, (int)v);
    }

    private static void writeString(ByteArrayOutputStream os, String s) throws IOException {
        try {
            byte[] data = s.getBytes("utf-8");
            ConnectionPool.writeInt(os, data.length);
            os.write(data);
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException(x);
        }
    }

    public String getID() {
        return this.m_id;
    }

    public final PoolManager getManager() {
        return this.m_manager;
    }

    private synchronized String getCheckString() throws SQLException {
        return this.m_check_calc;
    }

    public synchronized boolean isPooledMode() {
        return this.m_isPooled;
    }

    public DataSource getUnpooledDataSource() {
        return this.m_unpooled_ds;
    }

    public DataSource getPooledDataSource() {
        return this.m_pooled_ds;
    }

    public void setForceTimeout(int timeout) {
        this.m_forceTimeout = timeout;
    }

    public int getForceTimeout() {
        return this.m_forceTimeout;
    }

    public synchronized boolean dbgIsStackTraceEnabled() {
        return this.m_dbg_stacktrace;
    }

    public synchronized void dbgSetStacktrace(boolean on) {
        this.m_dbg_stacktrace = on;
    }

    public void setCommitDisabled(boolean on) {
        ThreadConfig tc = this.m_threadConfig.get();
        if (tc == null) {
            if (!on) {
                return;
            }
            tc = new ThreadConfig();
            this.m_threadConfig.set(tc);
        }
        tc.setDisableCommit(on);
    }

    public boolean isCommitDisabled() {
        ThreadConfig tc = this.m_threadConfig.get();
        if (tc == null) {
            return false;
        }
        return tc.isDisableCommit();
    }

    public synchronized PoolStats getPoolStatistics() {
        return new PoolStats(this.m_unpooledAllocatedCount, this.m_pooledAllocatedCount, this.m_pooledUsedCount, this.m_pooledMaxUsed, this.m_poolAllocationCount, this.m_n_connectionwaits, this.m_n_connectionfails, this.m_n_hangdisconnects, this.m_n_open_stmt, this.m_peak_open_stmt, this.m_n_open_rs, this.m_statementTotalPrepareCount, this.m_n_rows, new ArrayList<ConnectionProxy>(this.m_currentlyHangingConnections), this.m_databaseAllocationCount, this.m_unpooledMaxUsed);
    }

    synchronized void incOpenStmt() {
        ++this.m_n_open_stmt;
        ++this.m_statementTotalPrepareCount;
        if (this.m_n_open_stmt > this.m_peak_open_stmt) {
            this.m_peak_open_stmt = this.m_n_open_stmt;
        }
    }

    synchronized void decOpenStmt() {
        --this.m_n_open_stmt;
    }

    synchronized void incOpenRS() {
        ++this.m_n_open_rs;
    }

    synchronized void decOpenRS() {
        --this.m_n_open_rs;
    }

    public synchronized void setAttribute(@Nonnull String name, @Nullable Object value) {
        this.m_attributeMap.put(name, value);
    }

    public synchronized Object getAttribute(@Nonnull String name) {
        return this.m_attributeMap.get(name);
    }

    public synchronized <T> T getOrCreateAttribute(@Nonnull String name, @Nonnull Supplier<T> supplier) {
        Object value = this.m_attributeMap.get(name);
        if (null == value) {
            value = supplier.get();
            this.m_attributeMap.put(name, value);
        }
        return (T)value;
    }

    @Nullable
    public IConnectionStatisticsFactory getConnectionStatisticsFactory() {
        return this.m_connectionStatisticsFactory;
    }

    public static class ErrorEntry {
        private final Date m_ts;
        private final String m_msg;
        private final String m_subject;

        public ErrorEntry(Date ts, String subject, String txt) {
            this.m_ts = ts;
            this.m_msg = txt;
            this.m_subject = subject;
        }

        public String getMsg() {
            return this.m_msg;
        }

        public String getSubject() {
            return this.m_subject;
        }

        public Date getTs() {
            return this.m_ts;
        }
    }

    public static interface IPoolEvent {
        public void connectionAllocated(@Nonnull Connection var1) throws Exception;

        public void connectionReleased(@Nonnull Connection var1) throws Exception;
    }
}

