/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.dbpool.ConnState;
import to.etc.dbpool.ConnectionPool;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbpool.HangCheckState;
import to.etc.dbpool.IConnectionEventListener;
import to.etc.dbpool.IDatabaseEventListener;
import to.etc.dbpool.InvalidProxyException;
import to.etc.dbpool.PoolEntry;
import to.etc.dbpool.PoolManager;
import to.etc.dbpool.ScanMode;
import to.etc.dbpool.Tracepoint;

public final class ConnectionProxy
implements Connection {
    private static final int MAX_TRACEDEPTH = 20;
    private final PoolEntry m_pe;
    private final int m_id;
    private final Thread m_ownerThread;
    private final boolean m_unpooled;
    private final boolean m_saveTracePoints;
    private ConnState m_state = ConnState.OPEN;
    private Tracepoint m_closeLocation;
    private Tracepoint m_allocationPoint;
    private final long m_allocationTS;
    @Nullable
    private List<Tracepoint> m_tracePointList;
    private long m_lastUsedTS;
    private int m_expiryWarningCount;
    private boolean m_autocommit;
    private boolean m_unclosable;
    private List<Object> m_infoObjects = Collections.EMPTY_LIST;
    private List<IDatabaseEventListener> m_commitListenerList = Collections.EMPTY_LIST;
    private boolean m_longliving;
    private static long[] WARNINT = new long[]{300000L, 900000L, 3600000L, 0x6DDD00L, 28800000L};

    ConnectionProxy(PoolEntry pe, int id, Thread ownerThread, boolean tracepoints, boolean isunpooled) {
        this.m_pe = pe;
        this.m_autocommit = true;
        this.m_id = id;
        this.m_ownerThread = ownerThread;
        this.m_saveTracePoints = tracepoints;
        this.m_lastUsedTS = this.m_allocationTS = System.currentTimeMillis();
        this.m_allocationPoint = Tracepoint.create(null);
        this.m_unpooled = isunpooled;
    }

    public long getAllocationTime() {
        return this.m_allocationTS;
    }

    public Tracepoint getAllocationPoint() {
        return this.m_allocationPoint;
    }

    public Thread getOwnerThread() {
        return this.m_ownerThread;
    }

    public String getPoolID() {
        return this.m_pe.getPool().getID();
    }

    public int getId() {
        return this.m_id;
    }

    @Nonnull
    protected IConnectionEventListener statsHandler() {
        return this.m_pe.getPool().getManager().getConnectionEventListener();
    }

    public ConnectionPool getPool() {
        return this.m_pe.getPool();
    }

    public final boolean isUnpooled() {
        return this.m_unpooled;
    }

    synchronized void setLongliving(boolean longliving) {
        this.m_longliving = longliving;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("ConnectionProxy[");
        sb.append(this.m_id);
        sb.append(':');
        this.m_pe.appendDesc(sb);
        sb.append(']');
        return sb.toString();
    }

    public synchronized void addOwnerInfo(Object oo) {
        if (this.m_infoObjects == Collections.EMPTY_LIST) {
            this.m_infoObjects = new ArrayList<Object>();
        }
        this.m_infoObjects.add(oo);
    }

    public synchronized ConnState getState() {
        return this.m_state;
    }

    public Connection getRealConnection() {
        return this.check();
    }

    private synchronized Connection check(String sql) {
        if (this.m_state != ConnState.OPEN) {
            throw new InvalidProxyException("Connection " + this + " is closed, it's state is " + (Object)((Object)this.m_state));
        }
        this.saveTracepoint(sql);
        return this.m_pe.getConnection();
    }

    private synchronized Connection checkNoSave() {
        if (this.m_state != ConnState.OPEN) {
            throw new InvalidProxyException("Connection " + this + " is closed, it's state is " + (Object)((Object)this.m_state));
        }
        return this.m_pe.getConnection();
    }

    private synchronized Connection check() {
        return this.check(null);
    }

    private synchronized void usable() {
        if (this.m_state != ConnState.OPEN) {
            throw new InvalidProxyException("Connection " + this + " is closed, it's state is " + (Object)((Object)this.m_state));
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.m_unclosable) {
            this.forceClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceClosed() throws SQLException {
        long duration;
        this.m_pe.getPool().logAction(this, "close()");
        ConnectionProxy connectionProxy = this;
        synchronized (connectionProxy) {
            if (this.m_state != ConnState.OPEN) {
                return;
            }
        }
        for (IDatabaseEventListener icl : this.m_commitListenerList) {
            try {
                icl.onBeforeRelease(this);
            }
            catch (Exception x) {
                PoolManager.getInstance().logUnexpected(x, "Ignoring Exception in onBeforeRelease");
            }
        }
        this.m_commitListenerList = Collections.EMPTY_LIST;
        this.statsHandler().connectionClosed(this);
        this.getPool().writeSpecial(this, (byte)6);
        Tracepoint tp = Tracepoint.create(null);
        ConnectionProxy connectionProxy2 = this;
        synchronized (connectionProxy2) {
            if (this.m_state != ConnState.OPEN) {
                return;
            }
            this.m_state = ConnState.CLOSED;
            this.m_closeLocation = tp;
            duration = tp.getTimestamp() - this.m_allocationTS;
        }
        this.m_pe.release(this);
        this.getPool().handleConnectionUsageTime(this, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceInvalid() throws SQLException {
        Tracepoint tp = Tracepoint.create(null);
        ConnectionProxy connectionProxy = this;
        synchronized (connectionProxy) {
            if (this.m_state != ConnState.OPEN) {
                return;
            }
            this.m_state = ConnState.INVALIDATED;
            this.m_closeLocation = tp;
        }
        this.m_pe.invalidate(this);
        this.m_pe.getPool().logAction(this, "invalidate()");
    }

    @Override
    public void commit() throws SQLException {
        this.m_pe.getPool().logAction(this, "commit()");
        if (!this.getPool().isCommitDisabled()) {
            this.check().commit();
        }
        this.getPool().writeSpecial(this, (byte)4);
        if (this.m_commitListenerList.size() == 0) {
            return;
        }
        for (IDatabaseEventListener icl : this.m_commitListenerList) {
            try {
                icl.onAfterCommit(this);
            }
            catch (Exception x) {
                PoolManager.getInstance().logUnexpected(x, "Ignoring Exception in onAfterCommit");
            }
        }
        this.m_commitListenerList = Collections.EMPTY_LIST;
    }

    private synchronized void saveTracepoint(String sql) {
        if (!this.m_saveTracePoints) {
            return;
        }
        this.m_lastUsedTS = System.currentTimeMillis();
        if (null == this.m_tracePointList) {
            this.m_tracePointList = new ArrayList<Tracepoint>(20);
        }
        if (this.m_tracePointList.size() >= 20) {
            this.m_tracePointList.remove(0);
        }
        this.m_tracePointList.add(Tracepoint.create(sql));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tracepoint> getTraceList() {
        ArrayList<Tracepoint> res = new ArrayList<Tracepoint>();
        if (null != this.m_allocationPoint) {
            res.add(this.m_allocationPoint);
        }
        ConnectionProxy connectionProxy = this;
        synchronized (connectionProxy) {
            if (null != this.m_tracePointList) {
                res.addAll(this.m_tracePointList);
            }
            if (null != this.m_closeLocation) {
                res.add(this.m_closeLocation);
            }
        }
        return res;
    }

    @Nullable
    public Tracepoint getCloseLocation() {
        return this.m_closeLocation;
    }

    public synchronized long getLastUsedTime() {
        return this.m_lastUsedTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkHangState(HangCheckState hs) {
        boolean destroy = false;
        ConnectionProxy connectionProxy = this;
        synchronized (connectionProxy) {
            if (this.m_state != ConnState.OPEN) {
                return;
            }
            if (this.m_longliving) {
                return;
            }
            if (this.isUnpooled()) {
                long ets = hs.getNow() - 600000L;
                if (this.getLastUsedTime() < ets) {
                    hs.incUnpooledHangCount();
                    hs.addHanging(this);
                }
                long dts = this.m_expiryWarningCount < WARNINT.length ? WARNINT[this.m_expiryWarningCount] : (long)((this.m_expiryWarningCount - WARNINT.length + 1) * 24 * 60 * 60 * 1000);
                ets = hs.getNow() - dts;
                if (this.getLastUsedTime() > ets) {
                    return;
                }
                hs.append("***Connection(unpooled) ").append(this.m_id).append(" hangs: allocated ").append(DbPoolUtil.strMilli(hs.getNow(), this.getAllocationTime()) + " ago, last use ").append(DbPoolUtil.strMilli(hs.getNow(), this.getLastUsedTime())).append(" ago\n");
                hs.append("  Allocation point:\n");
                hs.appendTracepoint(this.m_allocationPoint);
                ++this.m_expiryWarningCount;
                return;
            }
            LongRunState lrs = this.calcLongRunState(hs.getExpiryTS());
            if (lrs == LongRunState.CLOSED || lrs == LongRunState.OKAY) {
                return;
            }
            if (lrs == LongRunState.LONGUNUSED) {
                destroy = true;
            } else {
                long gts = hs.getExpiryTS() - (long)(this.getPool().c().getLongRunningGracePeriod() * 1000);
                if (this.getAllocationTime() < gts) {
                    destroy = true;
                }
            }
            if (destroy) {
                hs.incHang();
                if (!hs.isForced() && hs.getMode() != ScanMode.ENABLED) {
                    destroy = false;
                    hs.addHanging(this);
                } else {
                    hs.addReleased(this);
                    this.m_state = ConnState.INVALIDATED;
                    hs.incDestroyed();
                }
            }
            hs.append("***Connection(pooled) ").append(this.m_id).append(" " + (Object)((Object)lrs)).append(": allocated ").append(DbPoolUtil.strMilli(hs.getNow(), this.getAllocationTime()) + " ago, last use ").append(DbPoolUtil.strMilli(hs.getNow(), this.getLastUsedTime())).append(" ago ");
            if (destroy) {
                hs.append(" was DESTROYED\n");
            } else {
                hs.append(" should be destroyed\n");
            }
            if (this.m_expiryWarningCount++ < 2) {
                hs.append("  Allocation point:\n");
                hs.appendTracepoint(this.m_allocationPoint);
            }
            if (!destroy) {
                return;
            }
        }
        this.m_pe.invalidate(this);
    }

    private synchronized LongRunState calcLongRunState(long ets) {
        if (this.m_state != ConnState.OPEN) {
            return LongRunState.CLOSED;
        }
        if (this.m_lastUsedTS < ets) {
            return LongRunState.LONGUNUSED;
        }
        if (this.m_allocationTS < ets) {
            return LongRunState.LONGRUNNING;
        }
        return LongRunState.OKAY;
    }

    void addResource(Object thing) {
        this.m_pe.addResource(thing);
    }

    protected void removeResource(Object o) {
        try {
            this.usable();
            this.m_pe.removeResource(this, o);
        }
        catch (InvalidProxyException x) {
            System.out.println("Ignored: " + x + ", at:\n" + DbPoolUtil.getLocation());
        }
    }

    public void setUncloseable(boolean unclosable) {
        this.m_unclosable = unclosable;
    }

    public void addCommitListener(@Nonnull IDatabaseEventListener c) {
        if (this.m_commitListenerList == Collections.EMPTY_LIST) {
            this.m_commitListenerList = new ArrayList<IDatabaseEventListener>();
        }
        this.m_commitListenerList.add(c);
    }

    public void removeCommitListener(@Nonnull IDatabaseEventListener c) {
        if (this.m_commitListenerList.size() == 0) {
            return;
        }
        this.m_commitListenerList.remove(c);
    }

    int getWarningCount() {
        return this.m_expiryWarningCount;
    }

    void setWarningCount(int c) {
        this.m_expiryWarningCount = c;
    }

    @Override
    public PreparedStatement prepareStatement(String p1) throws SQLException {
        this.check(p1);
        return this.m_pe.proxyPrepareStatement(this, p1);
    }

    @Override
    public PreparedStatement prepareStatement(String p1, int[] p2) throws SQLException {
        this.check(p1);
        return this.m_pe.proxyPrepareStatement(this, p1, p2);
    }

    @Override
    public PreparedStatement prepareStatement(String p1, int p2) throws SQLException {
        this.check(p1);
        return this.m_pe.proxyPrepareStatement(this, p1, p2);
    }

    @Override
    public PreparedStatement prepareStatement(String p1, int p2, int p3) throws SQLException {
        this.check(p1);
        return this.m_pe.proxyPrepareStatement(this, p1, p2, p3);
    }

    @Override
    public PreparedStatement prepareStatement(String p1, int p2, int p3, int p4) throws SQLException {
        this.check(p1);
        return this.m_pe.proxyPrepareStatement(this, p1, p2, p3, p4);
    }

    @Override
    public CallableStatement prepareCall(String name, int a, int b, int c) throws SQLException {
        this.check(name);
        return this.m_pe.proxyPrepareCall(this, name, a, b, c);
    }

    @Override
    public PreparedStatement prepareStatement(String a, String[] ar) throws SQLException {
        this.check(a);
        return this.m_pe.proxyPrepareStatement(this, a, ar);
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.check();
        return this.m_pe.proxyCreateStatement(this);
    }

    @Override
    public Statement createStatement(int p1, int p2) throws SQLException {
        this.check();
        return this.m_pe.proxyCreateStatement(this, p1, p2);
    }

    @Override
    public Statement createStatement(int p1, int p2, int p3) throws SQLException {
        this.check();
        return this.m_pe.proxyCreateStatement(this, p1, p2, p3);
    }

    @Override
    public CallableStatement prepareCall(String p1, int p2, int p3) throws SQLException {
        this.check(p1);
        return this.m_pe.proxyPrepareCall(this, p1, p2, p3);
    }

    @Override
    public CallableStatement prepareCall(String p1) throws SQLException {
        this.check(p1);
        return this.m_pe.proxyPrepareCall(this, p1);
    }

    @Override
    public void setCatalog(String p1) throws SQLException {
        this.check().setCatalog(p1);
    }

    @Override
    public void rollback() throws SQLException {
        this.m_pe.getPool().logAction(this, "rollback()");
        this.check().rollback();
        for (IDatabaseEventListener icl : this.m_commitListenerList) {
            try {
                icl.onAfterRollback(this);
            }
            catch (Exception x) {
                PoolManager.getInstance().logUnexpected(x, "Ignoring Exception in onAfterRollback");
            }
        }
        this.m_commitListenerList = Collections.EMPTY_LIST;
        this.getPool().writeSpecial(this, (byte)5);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.check().clearWarnings();
    }

    public Map getTypeMap() throws SQLException {
        return this.check().getTypeMap();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.check().getTransactionIsolation();
    }

    @Override
    public void setTransactionIsolation(int p1) throws SQLException {
        this.check().setTransactionIsolation(p1);
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.m_state != ConnState.OPEN;
    }

    @Override
    public void setAutoCommit(boolean p1) throws SQLException {
        this.checkNoSave().setAutoCommit(p1);
        this.m_autocommit = p1;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.check().getCatalog();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.check().isReadOnly();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.check().getMetaData();
    }

    @Override
    public void setReadOnly(boolean p1) throws SQLException {
        this.check().setReadOnly(p1);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.check().getAutoCommit();
    }

    @Override
    public String nativeSQL(String p1) throws SQLException {
        return this.check().nativeSQL(p1);
    }

    public void setTypeMap(Map p1) throws SQLException {
        this.check().setTypeMap(p1);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.check().getWarnings();
    }

    @Override
    public void releaseSavepoint(Savepoint sp) throws SQLException {
        this.check().releaseSavepoint(sp);
    }

    @Override
    public void rollback(Savepoint sp) throws SQLException {
        this.check().rollback(sp);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.check().setSavepoint(name);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.check().setSavepoint();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.check().getHoldability();
    }

    @Override
    public void setHoldability(int m) throws SQLException {
        this.check().setHoldability(m);
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        return this.check().createArrayOf(arg0, arg1);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.check().createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.check().createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.check().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.check().createSQLXML();
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        return this.check().createStruct(arg0, arg1);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.check().getClientInfo();
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        return this.check().getClientInfo(arg0);
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        return this.check().isValid(arg0);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        return this.m_pe.getConnection().isWrapperFor(iface);
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        this.check().setClientInfo(arg0);
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        this.check().setClientInfo(arg0, arg1);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.check();
        if (iface.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.m_pe.getConnection().unwrap(iface);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.check().setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.check().getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.check().abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.check().setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.check().getNetworkTimeout();
    }

    private static enum LongRunState {
        CLOSED,
        OKAY,
        LONGRUNNING,
        LONGUNUSED;

    }
}

