/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.DbType;
import to.etc.dbpool.IPrinter;
import to.etc.dbpool.Tracepoint;

public class DbPoolUtil {
    private static final String[] PRESET = new String[]{"xxxto.etc.dbpool.", "xxxxoracle.", "xxxnl.itris.viewpoint.db.hibernate."};
    private static final String[] ENDSET = new String[]{"xxxto.etc.domui.server.", "xxxorg.apache.tomcat"};
    private static final long DAYS = 86400L;
    private static final long HOURS = 3600L;
    private static final long MICROS = 1000L;
    private static final long MILLIS = 1000000L;
    private static final long SECONDS = 1000000000L;
    private static final long MINUTES = 60000000000L;
    private static final long NSHOURS = 3600000000000L;
    private static final long[] TIMESET = new long[]{3600000000000L, 60000000000L, 1000000000L, 1000000L, 1000L, 1L};
    private static final String[] SUFFIXES = new String[]{"H", "m", "s", "ms", "us", "ns"};
    private static final long[] MSTIMESET = new long[]{3600000L, 60000L, 1000L, 1L};
    private static final String[] MSSUFFIXES = new String[]{"H", "m", "s", "ms"};
    public static final String CSS_ALLOC = "h-alloc";
    public static final String CSS_TRACEPT = "h-usepoint";
    public static final String CSS_STACK = "h-stack";
    private static ThreadLocal<DateFormat> m_timedf = new ThreadLocal();

    private DbPoolUtil() {
    }

    private static boolean inSkipSet(String[] set, String name) {
        for (String s : set) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static void strStacktraceFiltered(Appendable sb, Throwable t, String[] skipbefore, String[] skipafter, int linelimit, int indent) {
        StackTraceElement[] se = t.getStackTrace();
        DbPoolUtil.strStacktraceFiltered(sb, se, skipbefore, skipafter, linelimit, indent);
    }

    public static void strStacktraceFiltered(Appendable sb, StackTraceElement[] se, String[] skipbefore, String[] skipafter, int linelimit, int indent) {
        String m;
        String m2;
        int ix;
        int len = se.length;
        for (ix = 0; ix < len && DbPoolUtil.inSkipSet(skipbefore, m2 = se[ix].getClassName()); ++ix) {
        }
        int sx = ix++;
        while (ix < len && !DbPoolUtil.inSkipSet(skipafter, m = se[ix].getClassName())) {
            ++ix;
        }
        int ex = ix;
        if (linelimit > 0 && ex - sx > linelimit) {
            ex = sx + linelimit;
        }
        for (int i = sx; i < ex; ++i) {
            try {
                int j = indent;
                while (--j >= 0) {
                    sb.append(' ');
                }
                sb.append(se[i].toString() + "\n");
                continue;
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    public static void strStacktraceFiltered(StringBuilder sb, StackTraceElement[] se, int linelimit, int indent) {
        DbPoolUtil.strStacktraceFiltered((Appendable)sb, se, PRESET, ENDSET, linelimit, indent);
    }

    public static void strStacktraceFiltered(StringBuilder sb, StackTraceElement[] se) {
        DbPoolUtil.strStacktraceFiltered(sb, se, 50, 4);
    }

    @Deprecated
    public static void getFilteredStacktrace(StringBuilder sb, Throwable t) {
        DbPoolUtil.strStacktraceFiltered((Appendable)sb, t, PRESET, ENDSET, 60, 4);
    }

    public static final void dumpLocation(String msg) {
        try {
            throw new IllegalStateException("duh");
        }
        catch (IllegalStateException x) {
            StringBuilder sb = new StringBuilder();
            sb.append(msg);
            sb.append("\n");
            DbPoolUtil.getFilteredStacktrace(sb, x);
            System.out.println(sb.toString());
            return;
        }
    }

    public static final void getThreadAndLocation(StringBuilder sb) {
        sb.append("At ");
        sb.append(new Date().toString());
        sb.append(" in thread ");
        sb.append(Thread.currentThread().getName());
        sb.append(" (");
        sb.append(Thread.currentThread().toString());
        sb.append("), stack:\n");
        try {
            throw new Exception("Trying to get source location");
        }
        catch (Exception z) {
            DbPoolUtil.getFilteredStacktrace(sb, z);
            return;
        }
    }

    public static final String getLocation() {
        StringBuilder sb = new StringBuilder(1024);
        DbPoolUtil.getThreadAndLocation(sb);
        return sb.toString();
    }

    public static void copyFile(OutputStream os, InputStream is) throws IOException {
        int sz;
        byte[] buf = new byte[8192];
        while (0 < (sz = is.read(buf))) {
            os.write(buf, 0, sz);
        }
    }

    public static void readAsString(StringBuilder sb, Reader r) throws Exception {
        int szread;
        char[] buf = new char[8192];
        while (0 < (szread = r.read(buf))) {
            sb.append(buf, 0, szread);
        }
    }

    public static String strMillisOLD(long dlt) {
        long v;
        StringBuffer sb = new StringBuffer();
        int millis = (int)(dlt % 1000L);
        boolean sp = false;
        if ((dlt /= 1000L) >= 86400L) {
            sb.append(dlt / 86400L);
            sb.append("D");
            dlt %= 86400L;
            sp = true;
        }
        if (dlt >= 3600L) {
            v = dlt / 3600L;
            if (v != 0L) {
                if (sp) {
                    sb.append(' ');
                }
                sb.append(v);
                sb.append("u");
                sp = true;
            }
            dlt %= 3600L;
        }
        if (dlt >= 60L) {
            v = dlt / 60L;
            if (v != 0L) {
                if (sp) {
                    sb.append(' ');
                }
                sb.append(v);
                sb.append("m");
                sp = true;
            }
            dlt %= 60L;
        }
        if (dlt != 0L) {
            if (sp) {
                sb.append(' ');
            }
            sb.append(dlt);
            sb.append("s");
            sp = true;
        }
        if (millis != 0) {
            if (sp) {
                sb.append(' ');
            }
            sb.append(millis);
            sb.append("ms");
        }
        return sb.toString();
    }

    public static String strNanoTime(long ns) {
        if (ns < 1000L) {
            return ns + " ns";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < TIMESET.length; ++i) {
            if (ns < TIMESET[i]) continue;
            long u = ns / TIMESET[i];
            sb.append(Long.toString(u));
            sb.append(SUFFIXES[i]);
            sb.append(' ');
            u = ns % TIMESET[i];
            sb.append(Long.toString(u /= TIMESET[++i]));
            sb.append(SUFFIXES[i]);
            return sb.toString();
        }
        return ns + "ns";
    }

    public static String strNanoTime2(long ns) {
        if (ns < 1000L) {
            return ns + " ns";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < TIMESET.length; ++i) {
            if (ns < TIMESET[i]) continue;
            double u = (double)ns / (double)TIMESET[i];
            sb.append(String.format(Locale.US, "%.1f", u));
            sb.append(SUFFIXES[i]);
            return sb.toString();
        }
        return ns + "ns";
    }

    public static String strMillis(long ns) {
        if (ns < 1000L) {
            return ns + " ms";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < MSTIMESET.length; ++i) {
            if (ns < MSTIMESET[i]) continue;
            long u = ns / MSTIMESET[i];
            sb.append(Long.toString(u));
            sb.append(MSSUFFIXES[i]);
            sb.append(' ');
            u = ns % MSTIMESET[i];
            sb.append(Long.toString(u /= MSTIMESET[++i]));
            sb.append(MSSUFFIXES[i]);
            return sb.toString();
        }
        return ns + "ms";
    }

    public static Driver loadDriver(File driverPath, String driverClassName) throws Exception {
        Class<?> cl = null;
        if (driverPath == null) {
            try {
                cl = Class.forName(driverClassName);
            }
            catch (Exception x) {
                throw new SQLException("The driver class '" + driverClassName + "' could not be loaded: " + x);
            }
        }
        NoLoader loader = new NoLoader(new URL[]{driverPath.toURI().toURL()});
        try {
            cl = loader.loadClass(driverClassName);
        }
        catch (Exception x) {
            throw new SQLException("The driver class '" + driverClassName + "' could not be loaded from " + driverPath + ": " + x);
        }
        try {
            Driver d = (Driver)cl.newInstance();
            System.out.println("load: class=" + d + ", inst=" + d.getMajorVersion() + "." + d.getMinorVersion());
            return d;
        }
        catch (Exception x) {
            throw new SQLException("The driver class '" + driverClassName + "' could not be instantiated: " + x);
        }
    }

    public static DbType getDbTypeByDriverName(String dn) {
        if ((dn = dn.toLowerCase()).indexOf("oracle") != -1) {
            return DbType.ORACLE;
        }
        if (dn.indexOf("mysql") != -1) {
            return DbType.MYSQL;
        }
        if (dn.indexOf("postgresql") != -1) {
            return DbType.POSTGRES;
        }
        if (dn.indexOf("orac") != -1) {
            return DbType.ORACLE;
        }
        return DbType.UNKNOWN;
    }

    public static void printTracepoints(IPrinter p, ConnectionProxy pc, boolean full) {
        List<Tracepoint> list = pc.getTraceList();
        if (list == null || list.size() == 0) {
            p.warning("Connection usage tracing has not been enabled");
            return;
        }
        long cts = System.currentTimeMillis();
        Tracepoint tp = list.get(0);
        long ats = tp.getTimestamp();
        p.header(CSS_ALLOC, "Connection's allocation point");
        p.text("Connection ").text("" + pc.getId()).text(" allocated at ").text(DbPoolUtil.strTime(pc.getAllocationTime()) + " (" + DbPoolUtil.strMilli(cts, ats) + " ago)").text(", used ").text(DbPoolUtil.strMilli(cts, pc.getLastUsedTime())).text(" ago").nl();
        StringBuilder sb = new StringBuilder();
        DbPoolUtil.strStacktraceFiltered(sb, tp.getElements());
        p.pre(CSS_STACK, sb.toString());
        sb.setLength(0);
        if (full) {
            for (int i = 1; i < list.size(); ++i) {
                tp = list.get(i);
                sb.setLength(0);
                sb.append("Trace ").append(i).append(", ").append(DbPoolUtil.strMilli(cts, tp.getTimestamp())).append(" after allocation");
                p.header(CSS_TRACEPT, sb.toString());
                sb.setLength(0);
                DbPoolUtil.strStacktraceFiltered(sb, tp.getElements());
                p.pre(CSS_STACK, sb.toString());
            }
        }
    }

    public static String strMilli(long a, long b) {
        long dt = a > b ? a - b : b - a;
        return DbPoolUtil.strMillis(dt);
    }

    public static String strTime(long ts) {
        Date dt = new Date(ts);
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        return df.format(dt);
    }

    public static String strTime(Date dt) {
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        return df.format(dt);
    }

    public static String strTimeOnly(Date dt) {
        DateFormat df = m_timedf.get();
        if (null == df) {
            df = new SimpleDateFormat("HH:mm:ss.S");
            m_timedf.set(df);
        }
        return df.format(dt);
    }

    public static String strCommad(long val) {
        String v = Long.toString(val);
        StringBuffer sb = new StringBuffer(30);
        int pos = v.length() % 3 + 1;
        if (pos == 0) {
            pos = 3;
        }
        for (int i = 0; i < v.length(); ++i) {
            if (--pos == 0) {
                if (i > 0) {
                    sb.append(',');
                }
                pos = 3;
            }
            sb.append(v.charAt(i));
        }
        return sb.toString();
    }

    public static String strCountDur(long count, long nanotime) {
        if (count == 0L) {
            return "";
        }
        return DbPoolUtil.strCommad(count) + "/" + DbPoolUtil.strNanoTime(nanotime);
    }

    public static String q(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(str.length() + 30);
        int len = str.length();
        block5: for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            switch (c) {
                default: {
                    sb.append(c);
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                }
            }
        }
        return sb.toString();
    }

    public static String getStack(Tracepoint tp) {
        StringBuilder sb = new StringBuilder(8192);
        DbPoolUtil.strStacktraceFiltered(sb, tp.getElements(), 50, 0);
        return sb.toString();
    }

    public static String strSize(long sz) {
        long kb = 1024L;
        long mb = 0x100000L;
        long gb = 0x40000000L;
        long tb = 0x10000000000L;
        long div = 1L;
        String sf = "";
        if (sz >= 0x10000000000L) {
            div = 0x10000000000L;
            sf = "TB";
        } else if (sz >= 0x40000000L) {
            div = 0x40000000L;
            sf = "GB";
        } else if (sz >= 0x100000L) {
            div = 0x100000L;
            sf = "MB";
        } else if (sz >= 1024L) {
            div = 1024L;
            sf = "KB";
        }
        StringBuffer sb = new StringBuffer(15);
        if (div == 1L) {
            return sz + " bytes";
        }
        long v = sz / div;
        long r = sz % div / (div / 10L);
        sb.append(Long.toString(v));
        if (r != 0L) {
            sb.append(".");
            sb.append(Long.toString(r));
        }
        sb.append(" ");
        sb.append(sf);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Properties getDeveloperProperties() {
        String s = System.getProperty("user.home");
        if (s == null) {
            return null;
        }
        File f = new File(new File(s), ".developer.properties");
        if (!f.exists()) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            Properties p = new Properties();
            p.load(is);
            Properties properties = p;
            return properties;
        }
        catch (Exception x) {
            System.out.println("PoolManager: exception while reading " + f + ": " + x);
            Properties properties = null;
            return properties;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    public static String getPlSqlDebug(String poolName) {
        Properties p = DbPoolUtil.getDeveloperProperties();
        if (null == p) {
            return null;
        }
        String val = p.getProperty("pool.plsql.debug");
        if (val != null) {
            return val;
        }
        val = p.getProperty("pool." + poolName.toLowerCase() + ".plsql.debug");
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableRemoteDebug(@Nonnull Connection con, @Nonnull HostAndPort hostAndPort) throws SQLException {
        String cmd = "begin dbms_debug_jdwp.connect_tcp('" + hostAndPort.getHost() + "'," + hostAndPort.getPort() + ");end;";
        PreparedStatement st = con.prepareStatement(cmd);
        try {
            st.execute();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                st.close();
            }
            catch (Exception exception) {}
        }
    }

    private static final class NoLoader
    extends URLClassLoader {
        NoLoader(URL[] u) {
            super(u);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (c == null) {
                    c = super.loadClass(name, resolve);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    public static final class HostAndPort {
        private final int m_port;
        @Nonnull
        private final String m_host;

        private HostAndPort(@Nonnull String host, int port) {
            this.m_host = host;
            this.m_port = port;
        }

        @Nonnull
        public static HostAndPort parse(@Nonnull String hostPort) throws SQLException {
            int pos = hostPort.indexOf(58);
            if (pos != -1) {
                String host = hostPort.substring(0, pos).trim();
                try {
                    int port = Integer.parseInt(hostPort.substring(pos + 1).trim());
                    return new HostAndPort(host, port);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new SQLException("PL/SQL Debug handler: parameter format must be 'hostname:portnumber', it was '" + hostPort + "'. Hostname can be an ip address and is usually 127.0.0.1.");
        }

        public int getPort() {
            return this.m_port;
        }

        @Nonnull
        public String getHost() {
            return this.m_host;
        }
    }
}

