/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.util.ArrayList;
import java.util.List;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbpool.ScanMode;
import to.etc.dbpool.Tracepoint;

final class HangCheckState {
    private long m_now;
    private long m_expiryTS;
    private StringBuilder m_sb = new StringBuilder(8192);
    private ScanMode m_mode;
    private boolean m_forced;
    private int m_hangCount;
    private int m_unpooledHangCount;
    private int m_destroyCount;
    private List<ConnectionProxy> m_hangingList = new ArrayList<ConnectionProxy>();
    private List<ConnectionProxy> m_releasedList = new ArrayList<ConnectionProxy>();

    HangCheckState(ScanMode mode, long ts, long ets, boolean forced) {
        this.m_now = ts;
        this.m_expiryTS = ets;
        this.m_mode = mode;
        this.m_forced = forced;
    }

    public ScanMode getMode() {
        return this.m_mode;
    }

    public long getExpiryTS() {
        return this.m_expiryTS;
    }

    public long getNow() {
        return this.m_now;
    }

    public boolean isForced() {
        return this.m_forced;
    }

    public int getHangCount() {
        return this.m_hangCount;
    }

    public int getDestroyCount() {
        return this.m_destroyCount;
    }

    public int getUnpooledHangCount() {
        return this.m_unpooledHangCount;
    }

    public void incUnpooledHangCount() {
        ++this.m_unpooledHangCount;
    }

    public void incHang() {
        ++this.m_hangCount;
    }

    public void incDestroyed() {
        ++this.m_destroyCount;
    }

    public List<ConnectionProxy> getHangingList() {
        return this.m_hangingList;
    }

    public List<ConnectionProxy> getReleasedList() {
        return this.m_releasedList;
    }

    public void addReleased(ConnectionProxy p) {
        this.m_releasedList.add(p);
    }

    public void addHanging(ConnectionProxy p) {
        this.m_hangingList.add(p);
    }

    public HangCheckState append(String s) {
        this.m_sb.append(s);
        return this;
    }

    public HangCheckState append(char c) {
        this.m_sb.append(c);
        return this;
    }

    public HangCheckState append(int i) {
        this.m_sb.append(i);
        return this;
    }

    public void appendTracepoint(Tracepoint allocationPoint) {
        DbPoolUtil.strStacktraceFiltered(this.m_sb, allocationPoint.getElements());
    }

    public String getReport() {
        return this.m_sb.toString();
    }
}

