/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.File;
import java.sql.SQLException;
import to.etc.dbpool.PoolConfigSource;
import to.etc.dbpool.ScanMode;

public final class PoolConfig {
    private final int m_max_conns;
    private final int m_min_conns;
    private final String m_url;
    private final String m_driverClassName;
    private final String m_uid;
    private final String m_pw;
    private File m_driverPath;
    private String m_checkSQL;
    private boolean m_checkConnection;
    private boolean m_setlog;
    private boolean m_printExceptions;
    private boolean m_logAllocation;
    private boolean m_logAllocationStack;
    private boolean m_logStatements;
    private boolean m_ignoreUnclosed;
    private boolean m_logResultSetLocations;
    private boolean m_sqlTraceMode;
    private boolean m_collectStatistics;
    private ScanMode m_scanMode = ScanMode.ENABLED;
    private File m_binaryLogFile;

    PoolConfig(String driver, String url, String userid, String passwd, String driverpath) throws SQLException {
        this.m_url = url;
        this.m_driverClassName = driver;
        this.m_uid = userid;
        this.m_pw = passwd;
        this.m_checkConnection = false;
        this.m_max_conns = 20;
        this.m_min_conns = 5;
        if (driverpath != null) {
            this.m_driverPath = new File(driverpath);
        }
    }

    public PoolConfig(Template tpl) {
        this.m_binaryLogFile = tpl.m_binaryLogFile;
        this.m_checkConnection = tpl.m_checkConnection;
        this.m_checkSQL = tpl.m_checkSQL;
        this.m_collectStatistics = tpl.m_collectStatistics;
        this.m_driverClassName = tpl.m_driverClassName;
        this.m_driverPath = tpl.m_driverPath;
        this.m_ignoreUnclosed = tpl.m_ignoreUnclosed;
        this.m_logAllocation = tpl.m_logAllocation;
        this.m_logAllocationStack = tpl.m_logAllocationStack;
        this.m_logResultSetLocations = tpl.m_logResultSetLocations;
        this.m_logStatements = tpl.m_logStatements;
        this.m_max_conns = tpl.m_max_conns;
        this.m_min_conns = tpl.m_min_conns;
        this.m_printExceptions = tpl.m_printExceptions;
        this.m_pw = tpl.m_pw;
        this.m_scanMode = tpl.m_scanMode;
        this.m_setlog = tpl.m_setlog;
        this.m_sqlTraceMode = tpl.m_sqlTraceMode;
        this.m_uid = tpl.m_uid;
        this.m_url = tpl.m_url;
    }

    PoolConfig(String id, PoolConfigSource cs) {
        try {
            String bf;
            this.m_url = cs.getProperty(id, "url");
            if (this.m_url == null) {
                throw new SQLException("Undefined Pool '" + id + "' in config " + cs);
            }
            this.m_driverClassName = cs.getProperty(id, "driver");
            this.m_uid = cs.getProperty(id, "userid");
            this.m_pw = cs.getProperty(id, "password");
            this.m_checkSQL = cs.getProperty("checksql", null);
            this.m_checkConnection = cs.getBool(id, "check", false);
            this.m_setlog = cs.getBool(id, "logstream", false);
            this.m_sqlTraceMode = cs.getBool(id, "sqltrace", false);
            int maxc = cs.getInt(id, "maxconn", 20);
            int minc = cs.getInt(id, "minconn", 5);
            if (minc < 1) {
                minc = 1;
            }
            if (maxc < minc) {
                maxc = minc + 5;
            }
            this.m_min_conns = minc;
            this.m_max_conns = maxc;
            this.m_printExceptions = cs.getBool(id, "printexceptions", false);
            String dp = cs.getProperty(id, "scan");
            if (dp == null) {
                this.m_scanMode = ScanMode.ENABLED;
            } else if ("enabled".equalsIgnoreCase(dp) || "on".equalsIgnoreCase(dp)) {
                this.m_scanMode = ScanMode.ENABLED;
            } else if ("disabled".equalsIgnoreCase(dp) || "off".equalsIgnoreCase(dp)) {
                this.m_scanMode = ScanMode.DISABLED;
            } else if ("warning".equalsIgnoreCase(dp) || "warn".equalsIgnoreCase(dp)) {
                this.m_scanMode = ScanMode.WARNING;
                this.m_logResultSetLocations = true;
                this.m_ignoreUnclosed = false;
            } else {
                throw new IllegalStateException("Invalid 'scan' mode: must be enabled, disabled or warn.");
            }
            this.m_logResultSetLocations = cs.getBool(id, "logrslocations", this.m_logResultSetLocations);
            this.m_ignoreUnclosed = cs.getBool(id, "ignoreunclosed", this.m_ignoreUnclosed);
            this.m_collectStatistics = cs.getBool(id, "statistics", false);
            this.m_logStatements = cs.getBool(id, "logstatements", false);
            this.m_logAllocation = cs.getBool(id, "logallocation", false);
            this.m_logAllocationStack = cs.getBool(id, "logallocationstack", false);
            dp = cs.getProperty(id, "driverpath");
            if (dp != null) {
                File f = new File(dp);
                if (!f.exists() && !(f = new File(System.getProperty("user.home"), dp)).exists()) {
                    throw new SQLException("The driver path '" + dp + "' does not point to an existing file or directory");
                }
                this.m_driverPath = f;
            }
            if (null != (bf = cs.getProperty(id, "binaryLog"))) {
                this.m_binaryLogFile = new File(bf);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new RuntimeException("Pool " + id + " parameter error: " + x, x);
        }
    }

    public boolean equals(Object b) {
        if (!(b instanceof PoolConfig)) {
            return false;
        }
        PoolConfig p = (PoolConfig)b;
        if (!this.m_uid.equalsIgnoreCase(p.m_uid)) {
            return false;
        }
        if (!this.m_url.equalsIgnoreCase(p.m_url)) {
            return false;
        }
        if (!this.m_driverClassName.equals(p.m_driverClassName)) {
            return false;
        }
        return this.m_pw.equals(p.m_pw);
    }

    public int getMaxConns() {
        return this.m_max_conns;
    }

    public int getMinConns() {
        return this.m_min_conns;
    }

    public String getUrl() {
        return this.m_url;
    }

    public String getDriverClassName() {
        return this.m_driverClassName;
    }

    public String getUid() {
        return this.m_uid;
    }

    public String getPw() {
        return this.m_pw;
    }

    public File getDriverPath() {
        return this.m_driverPath;
    }

    public String getCheckSQL() {
        return this.m_checkSQL;
    }

    public boolean isCheckConnection() {
        return this.m_checkConnection;
    }

    public boolean isSetlog() {
        return this.m_setlog;
    }

    public boolean isPrintExceptions() {
        return this.m_printExceptions;
    }

    public boolean isLogAllocation() {
        return this.m_logAllocation;
    }

    public boolean isLogAllocationStack() {
        return this.m_logAllocationStack;
    }

    public synchronized boolean isLogStatements() {
        return this.m_logStatements;
    }

    public boolean isIgnoreUnclosed() {
        return this.m_ignoreUnclosed;
    }

    public boolean isLogResultSetLocations() {
        return this.m_logResultSetLocations;
    }

    public boolean isSqlTraceMode() {
        return this.m_sqlTraceMode;
    }

    public boolean isCollectStatistics() {
        return this.m_collectStatistics;
    }

    public ScanMode getScanMode() {
        return this.m_scanMode;
    }

    public File getBinaryLogFile() {
        return this.m_binaryLogFile;
    }

    public int getLongRunningGracePeriod() {
        return 300;
    }

    public synchronized void setLogStatements(boolean logStatements) {
        this.m_logStatements = logStatements;
    }

    public static class Template {
        private int m_max_conns;
        private int m_min_conns;
        private String m_url;
        private String m_driverClassName;
        private String m_uid;
        private String m_pw;
        private File m_driverPath;
        private String m_checkSQL;
        private boolean m_checkConnection;
        private boolean m_setlog;
        private boolean m_printExceptions;
        private boolean m_logAllocation;
        private boolean m_logAllocationStack;
        private boolean m_logStatements;
        private boolean m_ignoreUnclosed;
        private boolean m_logResultSetLocations;
        private boolean m_sqlTraceMode;
        private boolean m_collectStatistics;
        private ScanMode m_scanMode = ScanMode.ENABLED;
        private File m_binaryLogFile;

        public void setDriverPath(File driverPath) {
            this.m_driverPath = driverPath;
        }

        public void setCheckSQL(String checkSQL) {
            this.m_checkSQL = checkSQL;
        }

        public void setCheckConnection(boolean checkConnection) {
            this.m_checkConnection = checkConnection;
        }

        public void setSetlog(boolean setlog) {
            this.m_setlog = setlog;
        }

        public void setPrintExceptions(boolean printExceptions) {
            this.m_printExceptions = printExceptions;
        }

        public void setLogAllocation(boolean logAllocation) {
            this.m_logAllocation = logAllocation;
        }

        public void setLogAllocationStack(boolean logAllocationStack) {
            this.m_logAllocationStack = logAllocationStack;
        }

        public void setLogStatements(boolean logStatements) {
            this.m_logStatements = logStatements;
        }

        public void setIgnoreUnclosed(boolean ignoreUnclosed) {
            this.m_ignoreUnclosed = ignoreUnclosed;
        }

        public void setLogResultSetLocations(boolean logResultSetLocations) {
            this.m_logResultSetLocations = logResultSetLocations;
        }

        public void setSqlTraceMode(boolean sqlTraceMode) {
            this.m_sqlTraceMode = sqlTraceMode;
        }

        public void setCollectStatistics(boolean collectStatistics) {
            this.m_collectStatistics = collectStatistics;
        }

        public void setScanMode(ScanMode scanMode) {
            this.m_scanMode = scanMode;
        }

        public void setBinaryLogFile(File binaryLogFile) {
            this.m_binaryLogFile = binaryLogFile;
        }

        public void setUrl(String url) {
            this.m_url = url;
        }

        public void setDriverClassName(String driverClassName) {
            this.m_driverClassName = driverClassName;
        }

        public void setUid(String uid) {
            this.m_uid = uid;
        }

        public void setPw(String pw) {
            this.m_pw = pw;
        }

        public void setMaxConns(int max_conns) {
            this.m_max_conns = max_conns;
        }

        public void setMinConns(int min_conns) {
            this.m_min_conns = min_conns;
        }
    }
}

