/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.File;
import to.etc.dbpool.PropertiesSource;
import to.etc.dbpool.XmlSource;

public abstract class PoolConfigSource {
    private File m_src;
    private File m_backupSrc;

    PoolConfigSource() {
    }

    public PoolConfigSource(File src, File back) {
        this.m_src = src;
        this.m_backupSrc = back;
    }

    public File getBackupSrc() {
        return this.m_backupSrc;
    }

    public File getSrc() {
        return this.m_src;
    }

    public abstract String getProperty(String var1, String var2) throws Exception;

    public boolean getBool(String sec, String name, boolean def) throws Exception {
        String v = this.getProperty(sec, name);
        if (v == null) {
            return def;
        }
        if ((v = v.trim().toLowerCase()).length() == 0) {
            return def;
        }
        return v.startsWith("1") || v.startsWith("y") || v.startsWith("t");
    }

    public int getInt(String sec, String name, int def) throws Exception {
        String v = this.getProperty(sec, name);
        if (v == null) {
            return def;
        }
        if ((v = v.trim()).length() == 0) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception x) {
            throw new IllegalArgumentException("The parameter " + sec + "." + name + " cannot be converted to integer (value=" + v + ")");
        }
    }

    public String toString() {
        if (this.m_backupSrc != null) {
            return this.m_src + " (" + this.m_backupSrc + ")";
        }
        if (this.m_src == null) {
            return "(parameters)";
        }
        return this.m_src.toString();
    }

    static PoolConfigSource create(File f) {
        String name = f.getName().toLowerCase();
        if (name.endsWith(".xml")) {
            return new XmlSource(f, new File(f.toString() + ".local"));
        }
        return new PropertiesSource(f, new File(f.toString() + ".local"));
    }
}

