/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import javax.annotation.concurrent.GuardedBy;
import to.etc.dbpool.CallableStatementProxy;
import to.etc.dbpool.ConnState;
import to.etc.dbpool.ConnectionPool;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbpool.PoolManager;
import to.etc.dbpool.PreparedStatementProxy;
import to.etc.dbpool.ResultSetProxy;
import to.etc.dbpool.StatementProxy;

final class PoolEntry {
    private final ConnectionPool m_pool;
    private final int m_id;
    private final String m_userID;
    private final Connection m_cx;
    private boolean m_unpooled;
    private boolean m_sqlTrace;
    private ConnectionProxy m_proxy;
    private int m_timeout;
    @GuardedBy(value="m_pool")
    private ConnState m_state = ConnState.OPEN;
    @GuardedBy(value="m_pool")
    private HashSet<Object> m_use_set = new HashSet();

    PoolEntry(Connection cx, ConnectionPool pool, int idnr, String userid) throws SQLException {
        this.m_pool = pool;
        this.m_cx = cx;
        this.m_id = idnr;
        this.m_userID = userid;
        this.m_timeout = pool.getForceTimeout();
    }

    public int getID() {
        return this.m_id;
    }

    public ConnectionPool getPool() {
        return this.m_pool;
    }

    public PoolManager getManager() {
        return this.getPool().getManager();
    }

    public String getUserID() {
        return this.m_userID;
    }

    public Connection getConnection() {
        return this.m_cx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usable() {
        ConnectionPool connectionPool = this.m_pool;
        synchronized (connectionPool) {
            if (this.m_state != ConnState.OPEN) {
                throw new IllegalStateException("PoolEntry was " + (Object)((Object)this.m_state));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="m_pool")
    void setUnpooled(boolean unpooled) {
        ConnectionPool connectionPool = this.m_pool;
        synchronized (connectionPool) {
            this.m_unpooled = unpooled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="m_pool")
    boolean isUnpooled() {
        ConnectionPool connectionPool = this.m_pool;
        synchronized (connectionPool) {
            return this.m_unpooled;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Poolentry[");
        sb.append(this.m_pool.toString());
        sb.append(',');
        sb.append(this.m_id);
        sb.append(",type=");
        sb.append(this.m_unpooled ? "unpooled" : "pooled");
        sb.append("]");
        return sb.toString();
    }

    public void appendDesc(StringBuilder sb) {
        sb.append(this.m_pool.toString());
        sb.append(',');
        sb.append(this.m_id);
        sb.append(',');
        sb.append(this.m_unpooled ? "unpooled" : "pooled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="m_pool")
    ConnectionProxy getProxy() {
        ConnectionPool connectionPool = this.m_pool;
        synchronized (connectionPool) {
            return this.m_proxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionProxy proxyMake() {
        int id = PoolManager.nextConnID();
        ConnectionProxy px = new ConnectionProxy(this, id, Thread.currentThread(), this.m_pool.dbgIsStackTraceEnabled(), this.isUnpooled());
        ConnectionPool connectionPool = this.m_pool;
        synchronized (connectionPool) {
            this.usable();
            if (this.m_proxy != null) {
                ConnectionPool.MSG.info("Attempted to create 2nd proxy?");
                throw new IllegalStateException("Attempt to create 2nd proxy for used connection");
            }
            this.m_proxy = px;
        }
        return px;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(ConnectionProxy pc) throws SQLException {
        String panictext = null;
        Object object = this.m_pool;
        synchronized (object) {
            if (pc != this.m_proxy) {
                panictext = "DB Proxy closed but entry is not owning it??";
            } else {
                this.m_proxy = null;
            }
        }
        if (null != panictext) {
            StringBuilder sb = new StringBuilder(8192);
            sb.append("Current location:\n");
            DbPoolUtil.getThreadAndLocation(sb);
            sb.append("\nEntry stack\n");
            this.getManager().panic("DB Proxy closed but entry is not owning it??", sb.toString());
            throw new IllegalStateException("kickjal: valid proxy close but entry's not owning it??");
        }
        this.closeResources();
        object = this;
        synchronized (object) {
            if (this.m_proxy != null) {
                throw new IllegalStateException("kickjal: proxy still active??");
            }
        }
        this.m_pool.returnToPool(this, pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidate(ConnectionProxy pc) {
        String panictext = null;
        Object object = this.m_pool;
        synchronized (object) {
            if (this.m_state != ConnState.OPEN) {
                return;
            }
            if (pc != this.m_proxy) {
                panictext = "DB Proxy closed but entry is not owning it??";
            } else {
                this.m_proxy = null;
                this.m_state = ConnState.INVALIDATED;
                this.m_pool.removeEntryFromPool(this);
            }
        }
        this.m_pool.getManager().removeThreadConnection(pc);
        this.closeResources();
        this.releaseConnection();
        if (null != panictext) {
            StringBuilder sb = new StringBuilder(8192);
            sb.append("Current location:\n");
            DbPoolUtil.getThreadAndLocation(sb);
            sb.append("\nEntry stack\n");
            this.getManager().panic("DB Proxy closed but entry is not owning it??", sb.toString());
            throw new IllegalStateException("kickjal: valid proxy close but entry's not owning it??");
        }
        object = this;
        synchronized (object) {
            if (this.m_proxy != null) {
                throw new IllegalStateException("kickjal: proxy still active??");
            }
        }
    }

    void releaseConnection() {
        try {
            this.m_cx.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_pool.callReleasedListeners(this.m_cx);
            this.m_cx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSqlTraceMode(boolean on) throws SQLException {
        if (on == this.m_sqlTrace) {
            return;
        }
        Statement ps = null;
        try {
            ps = this.m_cx.prepareStatement("alter session set sql_trace = " + (on ? "true" : "false"));
            ps.executeUpdate();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResource(Object o) {
        ConnectionPool connectionPool = this.m_pool;
        synchronized (connectionPool) {
            if (this.m_state == ConnState.OPEN) {
                this.m_use_set.add(o);
                return;
            }
        }
        try {
            this._closeResource(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeResource(ConnectionProxy pc, Object o) {
        ConnectionPool connectionPool = this.m_pool;
        synchronized (connectionPool) {
            if (this.m_state != ConnState.OPEN) {
                return;
            }
            if (!this.m_use_set.remove(o)) {
                ConnectionPool.MSG.info("to.etc.Removing element without it ever being added");
                return;
            }
        }
        if (o instanceof ResultSetProxy) {
            this.m_pool.decOpenRS();
        } else {
            this.m_pool.decOpenStmt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeResources() {
        HashSet<Object> todo;
        ConnectionPool connectionPool = this.m_pool;
        synchronized (connectionPool) {
            todo = this.m_use_set;
            this.m_use_set = new HashSet();
        }
        int nclosed = 0;
        for (Object e : todo) {
            this._closeResource(e);
            if (e instanceof ResultSetProxy) {
                this.m_pool.decOpenRS();
            } else {
                this.m_pool.decOpenStmt();
            }
            ++nclosed;
        }
    }

    private void _closeResource(Object o) {
        block6: {
            try {
                if (o instanceof StatementProxy) {
                    ((StatementProxy)o).closedByConnection();
                    break block6;
                }
                if (o instanceof PreparedStatementProxy) {
                    ((PreparedStatementProxy)o).closedByConnection();
                    break block6;
                }
                if (o instanceof CallableStatementProxy) {
                    ((CallableStatementProxy)o).closedByConnection();
                    break block6;
                }
                if (o instanceof ResultSetProxy) {
                    ((ResultSetProxy)o).closedByConnection();
                    break block6;
                }
                System.out.println("POOLERR: Unknown element added to tracked database resources?");
                throw new RuntimeException("Unknown element added to tracked database resources?");
            }
            catch (Exception x) {
                if (this.getPool().c().isIgnoreUnclosed()) break block6;
                x.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement proxyPrepareStatement(ConnectionProxy pc, String p1) throws SQLException {
        PreparedStatementProxy ps = new PreparedStatementProxy(pc, p1);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().prepareStatement(p1));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement proxyPrepareStatement(ConnectionProxy pc, String p1, int p2, int p3) throws SQLException {
        PreparedStatementProxy ps = new PreparedStatementProxy(pc, p1);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().prepareStatement(p1, p2, p3));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement proxyPrepareStatement(ConnectionProxy pc, String p1, int[] p2) throws SQLException {
        PreparedStatementProxy ps = new PreparedStatementProxy(pc, p1);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().prepareStatement(p1, p2));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement proxyPrepareStatement(ConnectionProxy pc, String p1, int p2, int p3, int p4) throws SQLException {
        PreparedStatementProxy ps = new PreparedStatementProxy(pc, p1);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().prepareStatement(p1, p2, p3, p4));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement proxyPrepareStatement(ConnectionProxy pc, String p1, int p2) throws SQLException {
        PreparedStatementProxy ps = new PreparedStatementProxy(pc, p1);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().prepareStatement(p1, p2));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreparedStatement proxyPrepareStatement(ConnectionProxy pc, String p1, String[] ar) throws SQLException {
        PreparedStatementProxy ps = new PreparedStatementProxy(pc, p1);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().prepareStatement(p1, ar));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    protected Statement proxyCreateStatement(ConnectionProxy pc) throws SQLException {
        StatementProxy ps = new StatementProxy(pc, null);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().createStatement());
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement proxyCreateStatement(ConnectionProxy pc, int p1, int p2) throws SQLException {
        StatementProxy ps = new StatementProxy(pc, null);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().createStatement(p1, p2));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement proxyCreateStatement(ConnectionProxy pc, String a, String[] b) throws SQLException {
        StatementProxy ps = new StatementProxy(pc, a);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().prepareStatement(a, b));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement proxyCreateStatement(ConnectionProxy pc, int p1, int p2, int p3) throws SQLException {
        StatementProxy ps = new StatementProxy(pc, null);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().createStatement(p1, p2, p3));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CallableStatement proxyPrepareCall(ConnectionProxy pc, String p1, int p2, int p3) throws SQLException {
        CallableStatementProxy ps = new CallableStatementProxy(pc, p1);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().prepareCall(p1, p2, p3));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CallableStatement proxyPrepareCall(ConnectionProxy pc, String p1, int p2, int p3, int p4) throws SQLException {
        CallableStatementProxy ps = new CallableStatementProxy(pc, p1);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().prepareCall(p1, p2, p3, p4));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CallableStatement proxyPrepareCall(ConnectionProxy pc, String p1) throws SQLException {
        CallableStatementProxy ps = new CallableStatementProxy(pc, p1);
        try {
            pc.statsHandler().prepareStatement(ps);
            ps.associate(this.getConnection().prepareCall(p1));
        }
        finally {
            pc.statsHandler().prepareStatementEnd(ps);
        }
        this.addResource(ps);
        this.m_pool.incOpenStmt();
        return ps;
    }
}

