/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.sql.DataSource;
import to.etc.dbpool.CollectingConnectionEventListener;
import to.etc.dbpool.ConnState;
import to.etc.dbpool.ConnectionPool;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.DataSourceImpl;
import to.etc.dbpool.DummyConnectionEventListener;
import to.etc.dbpool.IConnectionEventListener;
import to.etc.dbpool.IDatabaseEventListener;
import to.etc.dbpool.IPoolMessageHandler;
import to.etc.dbpool.IStatisticsListener;
import to.etc.dbpool.PoolConfig;
import to.etc.dbpool.PoolConfigSource;
import to.etc.dbpool.StatisticsListenerMultiplexer;
import to.etc.dbpool.UnpooledDataSourceImpl;

public final class PoolManager {
    @GuardedBy(value="this")
    private final Map<String, ConnectionPool> m_poolMap = new HashMap<String, ConnectionPool>();
    @GuardedBy(value="this")
    private List<IPoolMessageHandler> m_listenerList = new ArrayList<IPoolMessageHandler>();
    private static final Object m_connidlock = new Object();
    @GuardedBy(value="m_connidlock")
    private static int m_nextconnid;
    private volatile boolean m_collectStatistics;
    private final ThreadLocal<IConnectionEventListener> m_connectionEventListener = new ThreadLocal();
    private static final PoolManager m_instance;
    private final int m_dbpool_scaninterval = 120;
    private Thread m_scanthread;
    private boolean m_checkCloseConnections;
    private final ThreadLocal<Set<ConnectionProxy>> m_threadConnections = new ThreadLocal();
    private static final boolean DEBUG = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int nextConnID() {
        Object object = m_connidlock;
        synchronized (object) {
            return ++m_nextconnid;
        }
    }

    public static PoolManager getInstance() {
        return m_instance;
    }

    public void panic(String shortdesc, String body) {
        this.sendPanic(shortdesc, body);
    }

    public void logUnexpected(Exception t, String s) {
        this.sendLogUnexpected(t, s);
    }

    public void logUnexpected(String s) {
        this.sendLogUnexpected(null, s);
    }

    public synchronized void addMessageListener(IPoolMessageHandler pmh) {
        this.m_listenerList = new ArrayList<IPoolMessageHandler>(this.m_listenerList);
        this.m_listenerList.add(pmh);
    }

    public synchronized void removeMessageListener(IPoolMessageHandler pmh) {
        this.m_listenerList = new ArrayList<IPoolMessageHandler>(this.m_listenerList);
        this.m_listenerList.remove(pmh);
    }

    private synchronized List<IPoolMessageHandler> getListeners() {
        return this.m_listenerList;
    }

    public void sendLogUnexpected(Exception t, String s) {
        for (IPoolMessageHandler pmh : this.getListeners()) {
            try {
                pmh.sendLogUnexpected(t, s);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendPanic(String shortdesc, String body) {
        for (IPoolMessageHandler pmh : this.getListeners()) {
            try {
                pmh.sendPanic(shortdesc, body);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized int getPoolCount() {
        return this.m_poolMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ConnectionPool getPool(@Nonnull String id) throws SQLException {
        if (id == null) {
            throw new IllegalArgumentException("The pool ID cannot be null");
        }
        PoolManager poolManager = this;
        synchronized (poolManager) {
            ConnectionPool pool = this.m_poolMap.get(id);
            if (pool == null) {
                throw new SQLException("PoolManager: pool with ID " + id + " not found.");
            }
            return pool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPool[] getPoolList() {
        PoolManager poolManager = this;
        synchronized (poolManager) {
            return this.m_poolMap.values().toArray(new ConnectionPool[this.m_poolMap.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionPool addPool(ConnectionPool newpool) throws SQLException {
        PoolManager poolManager = this;
        synchronized (poolManager) {
            ConnectionPool cp = this.m_poolMap.get(newpool.getID());
            if (cp != null) {
                if (!cp.c().equals(newpool.c())) {
                    throw new SQLException("PoolManager: database pool with duplicate id " + newpool.getID() + " is being defined with DIFFERENT parameters as the original.");
                }
                return cp;
            }
            this.m_poolMap.put(newpool.getID(), newpool);
            return newpool;
        }
    }

    public ConnectionPool definePool(String id, PoolConfig pc) throws SQLException {
        ConnectionPool newpool = new ConnectionPool(this, id, pc);
        newpool.checkParameters();
        return this.addPool(newpool);
    }

    public ConnectionPool definePool(PoolConfigSource cs, String id) throws SQLException {
        PoolConfig pc = new PoolConfig(id, cs);
        return this.definePool(id, pc);
    }

    public ConnectionPool definePool(String id, String driver, String url, String userid, String password, String driverpath) throws SQLException {
        PoolConfig pc = new PoolConfig(driver, url, userid, password, driverpath);
        return this.definePool(id, pc);
    }

    public ConnectionPool definePool(File poolfile, String id) throws Exception {
        PoolConfigSource cs = PoolConfigSource.create(poolfile);
        return this.definePool(cs, id);
    }

    public ConnectionPool definePool(String id) throws Exception {
        String uh = System.getProperty("user.home");
        if (uh != null) {
            File xf = new File(uh, ".dbpool.xml");
            if (xf.exists()) {
                return this.definePool(xf, id);
            }
            File pf = new File(uh, ".dbpool.properties");
            if (pf.exists()) {
                return this.definePool(pf, id);
            }
        }
        throw new IllegalStateException("No default '.dbpool.properties' file found in your home directory (" + uh + ")");
    }

    public ConnectionPool initializePool(String id) throws Exception {
        ConnectionPool pool = this.definePool(id);
        pool.initialize();
        return pool;
    }

    public ConnectionPool initializePool(PoolConfigSource cs, String id) throws SQLException {
        ConnectionPool p = this.definePool(cs, id);
        p.initialize();
        return p;
    }

    public ConnectionPool initializePool(File poolfile, String id) throws Exception {
        PoolConfigSource cs = PoolConfigSource.create(poolfile);
        return this.initializePool(cs, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAll() {
        ArrayList<ConnectionPool> l;
        PoolManager poolManager = this;
        synchronized (poolManager) {
            l = new ArrayList<ConnectionPool>(this.m_poolMap.values());
            this.m_poolMap.clear();
        }
        for (ConnectionPool p : l) {
            try {
                p.destroyPool();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public void destroyPool(String poolid) throws SQLException {
        ConnectionPool pool = this.getPool(poolid);
        pool.destroyPool();
    }

    @GuardedBy(value="this")
    synchronized boolean internalRemovePool(ConnectionPool cp) {
        ConnectionPool xp = this.m_poolMap.get(cp.getID());
        if (null == xp) {
            return false;
        }
        if (xp != cp) {
            return false;
        }
        this.m_poolMap.remove(cp.getID());
        return true;
    }

    protected synchronized void startExpiredConnectionScanner() {
        if (this.m_scanthread != null) {
            return;
        }
        try {
            this.m_scanthread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PoolManager.this.expiredConnectionScannerLoop();
                }
            });
            this.m_scanthread.setDaemon(true);
            this.m_scanthread.setName("DbPoolScanner");
            this.m_scanthread.start();
        }
        catch (Exception x) {
            x.printStackTrace();
            this.logUnexpected(x, "in starting dbpool scanner");
        }
    }

    void expiredConnectionScannerLoop() {
        while (true) {
            try {
                while (true) {
                    this.scanExpiredConnectionsOnce(120);
                    Thread.sleep(60000L);
                }
            }
            catch (Exception x) {
                this.logUnexpected(x, "In scanning for expired connections");
                continue;
            }
            break;
        }
    }

    private void scanExpiredConnectionsOnce(int scaninterval_in_secs) {
        ConnectionPool[] ar;
        for (ConnectionPool p : ar = this.getPoolList()) {
            p.scanExpiredConnections(scaninterval_in_secs, false);
        }
    }

    @Nonnull
    IConnectionEventListener getConnectionEventListener() {
        IConnectionEventListener ih = this.m_connectionEventListener.get();
        if (ih == null) {
            ih = DummyConnectionEventListener.INSTANCE;
            this.m_connectionEventListener.set(ih);
        }
        return ih;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startCollecting(String key, IStatisticsListener collector) {
        PoolManager poolManager = this;
        synchronized (poolManager) {
            if (!this.m_collectStatistics) {
                return false;
            }
        }
        IConnectionEventListener ih = this.m_connectionEventListener.get();
        if (ih == null || ih instanceof DummyConnectionEventListener) {
            ih = new CollectingConnectionEventListener(new StatisticsListenerMultiplexer());
            this.m_connectionEventListener.set(ih);
        }
        CollectingConnectionEventListener cih = (CollectingConnectionEventListener)ih;
        StatisticsListenerMultiplexer sink = (StatisticsListenerMultiplexer)cih.getListener();
        sink.addCollector(key, collector);
        return true;
    }

    public IStatisticsListener stopCollecting(String key) {
        IConnectionEventListener ih = this.m_connectionEventListener.get();
        if (ih == null || !(ih instanceof CollectingConnectionEventListener)) {
            return null;
        }
        CollectingConnectionEventListener cih = (CollectingConnectionEventListener)ih;
        StatisticsListenerMultiplexer sink = (StatisticsListenerMultiplexer)cih.getListener();
        IStatisticsListener ic = sink.removeCollector(key);
        if (null != ic) {
            ic.finish();
        }
        return ic;
    }

    public void setCollectStatistics(boolean on) {
        this.m_collectStatistics = on;
    }

    public boolean isCollectStatistics() {
        return this.m_collectStatistics;
    }

    public static void addListener(@Nonnull Connection dbc, @Nonnull IDatabaseEventListener el) {
        if (!(dbc instanceof ConnectionProxy)) {
            throw new IllegalArgumentException("The connection passed MUST have been allocated by this pool manager (it is a " + dbc + ")");
        }
        ((ConnectionProxy)dbc).addCommitListener(el);
    }

    public static void removeListener(@Nonnull Connection dbc, @Nonnull IDatabaseEventListener el) {
        if (!(dbc instanceof ConnectionProxy)) {
            throw new IllegalArgumentException("The connection passed MUST have been allocated by this pool manager (it is a " + dbc + ")");
        }
        ((ConnectionProxy)dbc).removeCommitListener(el);
    }

    public synchronized boolean isCheckCloseConnections() {
        return this.m_checkCloseConnections;
    }

    public synchronized void setCheckCloseConnections(boolean checkCloseConnections) {
        this.m_checkCloseConnections = checkCloseConnections;
    }

    void addThreadConnection(ConnectionProxy cx) {
        if (!this.isCheckCloseConnections()) {
            return;
        }
        Set<ConnectionProxy> cs = this.m_threadConnections.get();
        if (null == cs) {
            cs = new HashSet<ConnectionProxy>();
            this.m_threadConnections.set(cs);
        }
        cs.add(cx);
    }

    void removeThreadConnection(ConnectionProxy cx) {
        if (!this.isCheckCloseConnections()) {
            return;
        }
        Set<ConnectionProxy> cs = this.m_threadConnections.get();
        if (null == cs) {
            return;
        }
        cs.remove(cx);
    }

    public List<ConnectionProxy> getThreadConnections() {
        if (!this.isCheckCloseConnections()) {
            return Collections.EMPTY_LIST;
        }
        Set<ConnectionProxy> cs = this.m_threadConnections.get();
        if (null == cs) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ConnectionProxy> res = new ArrayList<ConnectionProxy>(cs.size());
        for (ConnectionProxy cp : cs) {
            if (cp.getState() != ConnState.OPEN) continue;
            res.add(cp);
        }
        return res;
    }

    public void clearThreadConnections() {
        if (!this.isCheckCloseConnections()) {
            return;
        }
        this.m_threadConnections.set(null);
    }

    public static void setLongLiving(@Nonnull Connection dbc) throws SQLException {
        ConnectionProxy proxy = dbc.unwrap(ConnectionProxy.class);
        proxy.setLongliving(true);
    }

    @Nullable
    public static ConnectionPool getPoolFrom(@Nonnull DataSource ds) {
        if (ds instanceof DataSourceImpl) {
            return ((DataSourceImpl)ds).getPool();
        }
        if (ds instanceof UnpooledDataSourceImpl) {
            UnpooledDataSourceImpl udi = (UnpooledDataSourceImpl)ds;
            return udi.getPool();
        }
        return null;
    }

    @Nonnull
    public static DataSource getUnpooledFrom(@Nonnull DataSource ds) {
        ConnectionPool cp = PoolManager.getPoolFrom(ds);
        if (null == cp) {
            return ds;
        }
        return cp.getUnpooledDataSource();
    }

    static {
        m_instance = new PoolManager();
    }
}

